/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.miroi;

import com.ge.med.cse.cvf.miroi.AbstractGraphObject;
import com.ge.med.cse.cvf.miroi.GraphConstants;
import com.ge.med.cse.cvf.miroi.HistogramDataset;
import com.ge.med.cse.cvf.miroi.HistogramSeries;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.roi.XpRoiEvent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.Series;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class XpStatisticsRoiGraphObject
extends AbstractGraphObject
implements PropertyChangeListener {
    private HashMap<String, Series> gSeriesMap = new HashMap();
    HashMap<String, String> legendMap = new HashMap();
    private XYDataset data = null;
    private GraphConstants.DataElement xaxis = null;
    private GraphConstants.DataElement yaxis = null;
    private List<XpStatisticsRoi> roiList = new ArrayList<XpStatisticsRoi>();
    private String goname = "";
    private XpMedicalImage[] images = null;
    private boolean absolute = false;
    private GraphConstants.PlotType ptype = GraphConstants.PlotType.LINE;
    private int numberOfBins = 20;
    private Color[] colorlist = new Color[]{Color.GRAY, Color.YELLOW, Color.PINK, Color.RED, Color.GREEN};
    private static final int FREE = 1;
    private static final int IN_USE = 0;
    private int[] colorfreelist = new int[5];
    private static final int MAX_CURVE = 5;
    public static final String CONTENT_UPDATED = "CONTENT_UPDATED";
    private Capable cap_ = null;
    private XpRoiEventListener relistener = new XpRoiEventListener(){

        @Override
        public void imageChanged(XpRoiEvent re) {
            RoiActor roi = re.getRoi();
            if (roi.getImage() == null) {
                XpStatisticsRoiGraphObject.this.removeGraphData((XpStatisticsRoi)roi);
                XpStatisticsRoiGraphObject.this.firePropertyChange("UPDATE_DATASET", null, XpStatisticsRoiGraphObject.this.data);
            }
        }

        @Override
        public void roiDragged(XpRoiEvent re) {
            RoiActor roi = re.getRoi();
            if (roi instanceof XpStatisticsRoi) {
                XpStatisticsRoiGraphObject.this.updateGraphData((XpStatisticsRoi)roi);
                XpStatisticsRoiGraphObject.this.firePropertyChange("UPDATE_DATASET", null, XpStatisticsRoiGraphObject.this.data);
            }
        }

        @Override
        public void roiPressed(XpRoiEvent re) {
        }

        @Override
        public void roiReleased(XpRoiEvent re) {
        }
    };

    public XpStatisticsRoiGraphObject(XpStatisticsRoi[] rois, Capable cap) {
        this.xaxis = GraphConstants.DataElement.TIME;
        this.yaxis = GraphConstants.DataElement.MEAN;
        this.cap_ = cap;
        if (rois != null) {
            for (XpStatisticsRoi roi : rois) {
                this.roiList.add(roi);
                roi.addRoiEventListener(this.relistener);
            }
        }
        if (this.cap_ != null && this.cap_ instanceof FrameCapable) {
            int num = ((FrameCapable)((Object)cap)).getNumFrames();
            this.images = new XpMedicalImage[num];
            for (int i = 0; i < num; ++i) {
                this.images[i] = (XpMedicalImage)((FrameCapable)((Object)cap)).getFrame(i);
            }
        }
        this.initColorFreeList();
        this.addPropertyChangeListener(this);
    }

    public XpStatisticsRoiGraphObject(Capable cap) {
        this.xaxis = GraphConstants.DataElement.TIME;
        this.yaxis = GraphConstants.DataElement.MEAN;
        this.cap_ = cap;
        if (this.cap_ != null) {
            if (cap instanceof ROICapable) {
                this.roiList = ((ROICapable)cap).getRois();
                for (XpStatisticsRoi roi : this.roiList) {
                    roi.addRoiEventListener(this.relistener);
                }
            }
            if (this.cap_ instanceof FrameCapable) {
                int num = ((FrameCapable)((Object)cap)).getNumFrames();
                this.images = new XpMedicalImage[num];
                for (int i = 0; i < num; ++i) {
                    this.images[i] = (XpMedicalImage)((FrameCapable)((Object)cap)).getFrame(i);
                }
                this.cap_.addPropertyChangeListener(this);
            }
        }
        this.initColorFreeList();
    }

    public XpStatisticsRoiGraphObject(XpStatisticsRoi[] rois, XpMedicalImage[] imgs) {
        this.xaxis = GraphConstants.DataElement.TIME;
        this.yaxis = GraphConstants.DataElement.MEAN;
        for (XpStatisticsRoi roi : rois) {
            this.roiList.add(roi);
            roi.addRoiEventListener(this.relistener);
        }
        this.images = imgs != null ? Arrays.copyOf(imgs, imgs.length) : null;
        this.initColorFreeList();
        this.addPropertyChangeListener(this);
    }

    public XpStatisticsRoiGraphObject(List<XpStatisticsRoi> rois, XpMedicalImage[] imgs) {
        this.xaxis = GraphConstants.DataElement.TIME;
        this.yaxis = GraphConstants.DataElement.MEAN;
        if (rois != null) {
            for (RoiActor roiActor : rois) {
                this.roiList.add((XpStatisticsRoi)roiActor);
                roiActor.addRoiEventListener(this.relistener);
            }
        }
        this.images = imgs != null ? Arrays.copyOf(imgs, imgs.length) : null;
        this.initColorFreeList();
        this.addPropertyChangeListener(this);
    }

    private void initColorFreeList() {
        for (int i = 0; i < this.colorfreelist.length; ++i) {
            this.colorfreelist[i] = 1;
        }
    }

    public Dataset getDataset() {
        return this.data;
    }

    public XYSeries getGraphSeries(String roilabel) {
        if (roilabel != null) {
            return (XYSeries)this.gSeriesMap.get("ID:" + roilabel);
        }
        return null;
    }

    public String getName() {
        return this.goname;
    }

    public String getUnits(int series) {
        return null;
    }

    public GraphConstants.DataElement getXAxisElement() {
        return this.xaxis;
    }

    public GraphConstants.DataElement getYAxisElement() {
        return this.yaxis;
    }

    public void setXAxisElement(GraphConstants.DataElement xgd) {
        this.xaxis = xgd;
    }

    public void setYAxisElement(GraphConstants.DataElement ygd) {
        this.yaxis = ygd;
    }

    @Override
    public Dataset getGraphDataset(GraphConstants.PlotType pt) {
        this.ptype = pt;
        switch (pt) {
            case HISTOGRAM: {
                return this.getHistogramDataset();
            }
            case LINE_BAR: {
                return this.getXYIntervalDataset();
            }
        }
        return this.getXYDataset();
    }

    private XYDataset getXYDataset() {
        if (this.data == null) {
            this.initDataset();
            this.data = new XYSeriesCollection();
            int i = 0;
            Iterator<XpStatisticsRoi> iterator = this.roiList.iterator();
            while (iterator.hasNext() && i < 5) {
                XpStatisticsRoi roi = iterator.next();
                String name = "ID:" + roi.getRoiId();
                XYSeries series = (XYSeries)this.createNewSeries(roi);
                ((XYSeriesCollection)this.data).addSeries(series);
                this.colorfreelist[i] = 0;
                this.gSeriesMap.put(name, (Series)series);
            }
        }
        return this.data;
    }

    private XYDataset getXYIntervalDataset() {
        if (this.data == null) {
            this.initDataset();
            this.data = new XYIntervalSeriesCollection();
            int i = 0;
            Iterator<XpStatisticsRoi> iterator = this.roiList.iterator();
            while (iterator.hasNext() && i < 5) {
                XpStatisticsRoi roi = iterator.next();
                double[] xdata = this.getDataItems(roi, this.xaxis, !this.absolute);
                double[] ydata = this.getDataItems(roi, this.yaxis, !this.absolute);
                for (int j = 0; j < xdata.length; ++j) {
                    System.out.println(xdata[j] + ", " + ydata[j]);
                }
                XYIntervalSeries[] series = new XYIntervalSeries[this.roiList.size()];
                String name = "ID:" + roi.getRoiId();
                series[i] = new XYIntervalSeries((Comparable)((Object)name));
                for (int j = 0; j < xdata.length; ++j) {
                    series[i].add(xdata[j], 0.0, 0.0, ydata[j], 0.0, 0.0);
                }
                this.gSeriesMap.put(name, (Series)series[i]);
                this.colorfreelist[i] = 0;
                ((XYIntervalSeriesCollection)this.data).addSeries(series[i++]);
            }
        }
        return this.data;
    }

    private IntervalXYDataset getHistogramDataset() {
        if (this.data == null) {
            this.initDataset();
            this.data = new HistogramDataset();
            int i = 0;
            for (XpStatisticsRoi roi : this.roiList) {
                String name = "ID:" + roi.getRoiId();
                HistogramSeries series = (HistogramSeries)this.createNewSeries(roi);
                ((HistogramDataset)this.data).addSeries(series);
                this.colorfreelist[i] = 0;
                this.gSeriesMap.put(name, series);
            }
        }
        return (IntervalXYDataset)this.data;
    }

    private CategoryDataset getCategoryDataset() {
        if (this.data == null) {
            this.initDataset();
            this.data = new XYSeriesCollection();
            int i = 0;
            for (XpStatisticsRoi roi : this.roiList) {
                double[] xdata = this.getDataItems(roi, this.xaxis, !this.absolute);
                double[] ydata = this.getDataItems(roi, this.yaxis, !this.absolute);
                XYSeries[] series = new XYSeries[this.roiList.size()];
                String name = "ID:" + roi.getRoiId();
                series[i] = new XYSeries((Comparable)((Object)name));
                for (int j = 0; j < xdata.length; ++j) {
                    series[i].add(xdata[j], ydata[j]);
                }
                this.gSeriesMap.put(name, (Series)series[i]);
                ((XYSeriesCollection)this.data).addSeries(series[i++]);
            }
        }
        return (CategoryDataset)this.data;
    }

    private Dataset addGraphData(XpStatisticsRoi roi) {
        if (this.data != null) {
            String name = "ID:" + roi.getRoiId();
            if (this.gSeriesMap.get(name) == null) {
                this.roiList.add(roi);
                roi.addRoiEventListener(this.relistener);
                Series s = this.createNewSeries(roi);
                this.gSeriesMap.put(name, s);
                switch (this.ptype) {
                    case HISTOGRAM: {
                        ((HistogramDataset)this.data).addSeries((HistogramSeries)s);
                        break;
                    }
                    case LINE_BAR: {
                        ((XYIntervalSeriesCollection)this.data).addSeries((XYIntervalSeries)s);
                        break;
                    }
                    default: {
                        ((XYSeriesCollection)this.data).addSeries((XYSeries)s);
                    }
                }
            }
            return this.data;
        }
        return this.getGraphDataset(this.ptype);
    }

    private Dataset removeGraphData(XpStatisticsRoi roi) {
        if (this.data != null) {
            if (this.gSeriesMap.get("ID:" + roi.getRoiId()) != null) {
                roi.removeRoiEventListener(this.relistener);
                String name = "ID:" + roi.getRoiId();
                System.out.println("Removing Series=" + name);
                if (this.data instanceof XYSeriesCollection) {
                    ((XYSeriesCollection)this.data).removeSeries((XYSeries)this.gSeriesMap.get(name));
                } else if (this.data instanceof XYIntervalSeriesCollection) {
                    ((XYIntervalSeriesCollection)this.data).removeSeries((XYIntervalSeries)this.gSeriesMap.get(name));
                } else if (this.data instanceof HistogramDataset) {
                    ((HistogramDataset)this.data).removeSeries((HistogramSeries)this.gSeriesMap.get(name));
                }
                this.roiList.remove(roi);
                this.gSeriesMap.remove("ID:" + roi.getRoiId());
            }
            return this.data;
        }
        return this.getGraphDataset(this.ptype);
    }

    private Dataset removeAllGraphData() {
        if (this.data != null) {
            for (XpStatisticsRoi roi : this.roiList) {
                this.removeGraphData(roi);
            }
            this.roiList.clear();
            this.data = null;
        }
        return this.data;
    }

    private Dataset updateGraphData(XpStatisticsRoi roi) {
        if (this.data != null) {
            String name = "ID:" + roi.getRoiId();
            if (this.gSeriesMap.get(name) != null) {
                Series s = this.createNewSeries(roi);
                switch (this.ptype) {
                    case HISTOGRAM: {
                        ((HistogramDataset)this.data).removeSeries((Comparable)((Object)name));
                        ((HistogramDataset)this.data).addSeries((HistogramSeries)s);
                        this.gSeriesMap.put(name, s);
                        break;
                    }
                    case LINE_BAR: {
                        ((XYIntervalSeriesCollection)this.data).removeSeries((XYIntervalSeries)this.gSeriesMap.get(name));
                        ((XYIntervalSeriesCollection)this.data).addSeries((XYIntervalSeries)s);
                        this.gSeriesMap.put(name, s);
                        break;
                    }
                    default: {
                        ((XYSeriesCollection)this.data).removeSeries((XYSeries)this.gSeriesMap.get(name));
                        ((XYSeriesCollection)this.data).addSeries((XYSeries)s);
                        this.gSeriesMap.put(name, s);
                    }
                }
            }
            return this.data;
        }
        return this.getGraphDataset(this.ptype);
    }

    public void setName(String name) {
        this.goname = name;
    }

    protected Number getXData(String roiid, int index) {
        if (!this.ptype.equals((Object)GraphConstants.PlotType.HISTOGRAM)) {
            return roiid != null ? (Number)((XYSeries)this.gSeriesMap.get(roiid)).getX(index) : (Number)null;
        }
        return roiid != null ? (Number)((XYIntervalSeries)this.gSeriesMap.get(roiid)).getX(index) : (Number)null;
    }

    protected Number getYData(String roiid, int index) {
        if (!this.ptype.equals((Object)GraphConstants.PlotType.HISTOGRAM)) {
            return roiid != null ? (Number)((XYSeries)this.gSeriesMap.get(roiid)).getY(index) : (Number)null;
        }
        return roiid != null ? Double.valueOf(((XYIntervalSeries)this.gSeriesMap.get(roiid)).getYValue(index)) : null;
    }

    protected Number getXData(int series, int index) {
        return this.data != null && series >= 0 ? (Number)this.data.getX(series, index) : (Number)null;
    }

    protected Number getYData(int series, int index) {
        return this.data != null && series >= 0 ? (Number)this.data.getY(series, index) : (Number)null;
    }

    private double[] getDataItems(XpStatisticsRoi roi, GraphConstants.DataElement gdt, boolean relative) {
        switch (gdt) {
            case MEAN: 
            case AREA: 
            case STANDARD_DEVIATION: 
            case MAX: 
            case MIN: {
                return this.getStatsData(roi, gdt, relative);
            }
            case PIXEL: {
                return this.getPixelData(relative);
            }
            case TIME: {
                return this.getTimeData(relative);
            }
            case LOCATION: {
                return this.getLocationData(relative);
            }
        }
        return null;
    }

    private double[] getTimeData(boolean relative) {
        double[] titem = new double[this.images.length];
        XpDicomElement tvalue = new XpDicomElement(25, 4132);
        double firstValue = 0.0;
        if (relative) {
            this.images[0].getValue(tvalue);
            firstValue = tvalue.getDoubleValue();
        }
        for (int i = 0; i < this.images.length; ++i) {
            this.images[i].getValue(tvalue);
            titem[i] = Math.abs(tvalue.getDoubleValue() - firstValue);
        }
        return titem;
    }

    private double[] getLocationData(boolean relative) {
        double[] litem = new double[this.images.length];
        XpDicomElement lvalue = new XpDicomElement(32, 4161);
        double firstValue = 0.0;
        if (relative) {
            this.images[0].getValue(lvalue);
            firstValue = lvalue.getDoubleValue();
        }
        for (int i = 0; i < this.images.length; ++i) {
            this.images[i].getValue(lvalue);
            litem[i] = Math.abs(lvalue.getDoubleValue() - firstValue);
        }
        return litem;
    }

    private double[] getStatsData(XpStatisticsRoi roi, GraphConstants.DataElement gdt, boolean relative) {
        double[] sitem = new double[this.images.length];
        BufferedImage buffimg = roi.getBitmap();
        double firstvalue = 0.0;
        XpPixelStatistics stats = null;
        double svalue = 0.0;
        if (buffimg != null) {
            if (relative) {
                stats = new XpPixelStatistics((XpImage)this.images[0], buffimg);
                firstvalue = this.getStatsValue(gdt, stats);
            }
            for (int i = 0; i < this.images.length; ++i) {
                stats = new XpPixelStatistics((XpImage)this.images[i], buffimg);
                svalue = this.getStatsValue(gdt, stats);
                sitem[i] = Math.abs(svalue - firstvalue);
            }
        }
        return sitem;
    }

    private double getStatsValue(GraphConstants.DataElement gdt, XpPixelStatistics ps) {
        switch (gdt) {
            case MEAN: {
                return ps.getMean();
            }
            case AREA: {
                return ps.getSum();
            }
            case STANDARD_DEVIATION: {
                return ps.getStdDev();
            }
            case MAX: {
                return ps.getMax();
            }
            case MIN: {
                return ps.getMin();
            }
        }
        return 0.0;
    }

    private double[] getPixelData(boolean relative) {
        double[] pitem = new double[this.images.length];
        return pitem;
    }

    @Override
    public void setAbsolute(boolean a) {
        this.absolute = a;
    }

    @Override
    public Dataset addSeries(Series s) {
        if (this.data instanceof XYSeriesCollection) {
            ((XYSeriesCollection)this.data).addSeries((XYSeries)s);
        } else if (this.data instanceof XYIntervalSeriesCollection) {
            ((XYIntervalSeriesCollection)this.data).addSeries((XYIntervalSeries)s);
        }
        return this.data;
    }

    @Override
    public Dataset removeSeries(Series s) {
        if (this.data instanceof XYSeriesCollection) {
            ((XYSeriesCollection)this.data).removeSeries((XYSeries)s);
        } else if (this.data instanceof XYIntervalSeriesCollection) {
            ((XYIntervalSeriesCollection)this.data).removeSeries((XYIntervalSeries)s);
        }
        return this.data;
    }

    @Override
    public void setCurverColor(int series, Color c) {
        if (series <= 5) {
            this.colorlist[series - 1] = c;
        }
    }

    @Override
    public Color getCurveColor(int series) {
        if (series <= 5) {
            return this.colorlist[series - 1];
        }
        return null;
    }

    @Override
    public HashMap<String, Series> getSeriesMap() {
        return this.gSeriesMap;
    }

    private void initDataset() {
        this.data = null;
        this.initColorFreeList();
    }

    private Series createNewSeries(XpStatisticsRoi roi) {
        Object s = null;
        if (roi != null) {
            double[] xdata = this.getDataItems(roi, this.xaxis, !this.absolute);
            double[] ydata = this.getDataItems(roi, this.yaxis, !this.absolute);
            String name = "ID:" + roi.getRoiId();
            switch (this.ptype) {
                case HISTOGRAM: {
                    double min = this.getMinimum(ydata);
                    double max = this.getMaximum(ydata);
                    s = new HistogramSeries((Comparable)((Object)name), ydata, this.numberOfBins, min, max);
                    break;
                }
                case LINE_BAR: {
                    s = new XYSeries((Comparable)((Object)name));
                    for (int i = 0; i < xdata.length; ++i) {
                        s.add(xdata[i], ydata[i]);
                    }
                    break;
                }
                default: {
                    s = new XYSeries((Comparable)((Object)name));
                    for (int i = 0; i < xdata.length; ++i) {
                        s.add(xdata[i], ydata[i]);
                    }
                }
            }
        }
        return s;
    }

    private double getMinimum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double min = Double.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    private double getMaximum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double max = -1.7976931348623157E308;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(CONTENT_UPDATED)) {
            if (this.cap_ instanceof FrameCapable) {
                int num = ((FrameCapable)((Object)this.cap_)).getNumFrames();
                XpMedicalImage[] img = new XpMedicalImage[num];
                for (int i = 0; i < num; ++i) {
                    img[i] = (XpMedicalImage)((FrameCapable)((Object)this.cap_)).getFrame(i);
                }
                this.images = img;
            }
            for (int i = 0; i < this.roiList.size(); ++i) {
                XpStatisticsRoi staticroi = this.roiList.get(i);
                this.updateGraphData(staticroi);
            }
            this.firePropertyChange("UPDATE_DATASET", null, this.data);
        }
    }

    @Override
    public HashMap<String, String> getLegendItemMap() {
        this.legendMap.clear();
        for (XpStatisticsRoi roi : this.roiList) {
            this.legendMap.put("ID:" + roi.getRoiLabel(), "ID:" + roi.getRoiId());
        }
        return this.legendMap;
    }
}

