/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.miroi;

import com.ge.med.cse.cvf.cpanels.SubTitlePanel;
import com.ge.med.cse.cvf.miroi.ChartpanelMouseListener;
import com.ge.med.cse.cvf.miroi.CvMiroiChartPanel;
import com.ge.med.cse.cvf.miroi.CvMiroiGraphPlotter;
import com.ge.med.cse.cvf.miroi.CvMiroiLegendPanel;
import com.ge.med.cse.cvf.miroi.GraphConstants;
import com.ge.med.cse.cvf.miroi.GraphObject;
import com.ge.med.cse.cvf.miroi.GraphPlotter;
import com.ge.med.cse.cvf.miroi.GroupMarker;
import com.ge.med.cse.cvf.miroi.XpMiroiControlPanel;
import com.ge.med.cse.cvf.miroi.XpMiroiGraphPanel;
import com.ge.med.cse.cvf.miroi.XpMiroiPrepCalcPanel;
import com.ge.med.cse.cvf.miroi.XpStatisticsRoiGraphObject;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;

public class XpMiroiPanel
extends XPcaAutoControlPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -3097717127634653800L;
    protected XpMiroiControlPanel ctrlPanel;
    protected XpMiroiPrepCalcPanel outpanel;
    protected SubTitlePanel container;
    protected XpMiroiGraphPanel graph;
    private CardLayout crdLayout;
    private final transient Logger logger = Logger.getLogger(this.getClass().getName());
    private transient GraphObject gobject = null;
    private transient GraphPlotter plotter = null;

    public XpMiroiPanel() {
        this.initChildComponents();
        this.initUI();
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        screen.addPropertyChangeListener(this);
        this.ctrlPanel.setScreen(screen);
    }

    protected void initUI() {
        try {
            this.setName(CvUtils.getResourceBundle().getString("XP_MIROI_NAME"));
            this.setBackground(null);
            this.setLayout(new BorderLayout());
            this.add((Component)this.container, "Center");
            this.crdLayout = new CardLayout();
            this.container.setLayout(this.crdLayout);
            this.container.add((Component)this.ctrlPanel, "miroi_control");
            this.container.add((Component)this.outpanel, "miroi_display");
            this.crdLayout.show(this.container, "miroi_control");
            this.container.setTitle("MIROI");
            this.addListeners();
            this.logger.log(Level.FINER, "MIROI Panel created sucessfully");
        }
        catch (Exception exp) {
            TransactionLogName tln_excep = new TransactionLogName("TID=MIROI_Exception");
            Object[] objArry = new Object[]{tln_excep, exp.getMessage()};
            this.logger.log(Level.INFO, "{0} SEV5 Error in creation MIROI Panel {1}", objArry);
        }
    }

    protected void initChildComponents() {
        try {
            this.ctrlPanel = new XpMiroiControlPanel();
            this.outpanel = new XpMiroiPrepCalcPanel();
            this.container = new SubTitlePanel();
            this.graph = new XpMiroiGraphPanel();
            this.logger.log(Level.FINER, "MIROI Panlels child components created sucessfully");
        }
        catch (Exception exp) {
            this.logger.log(Level.INFO, "MIROI_Exception: SEV5 Error in creation MIROI Panel Child componenets ", exp.getMessage());
        }
    }

    protected void addListeners() {
        this.ctrlPanel.addPropertyChangeListener(this);
        this.outpanel.addPropertyChangeListener(this);
        this.addPropertyChangeListener(this);
    }

    protected void setDataToGraph() {
        try {
            this.graph.setSession(CvUtils.getDMSystem().getLocalDB());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ROICapable roiCapablePort = this.getROIPort();
        if (roiCapablePort == null) {
            TransactionLogName tln_excep = new TransactionLogName("TID=MIROI_Error");
            this.logger.log(Level.INFO, "{0} SEV5 Selected Port is not ROI Capable", tln_excep);
            return;
        }
        List rois = roiCapablePort.getRois();
        if (rois != null && rois.size() == 0) {
            this.showControlPanel();
            this.logger.log(Level.FINER, "Zero Rois are placed so cant plot MIROI Graph");
            return;
        }
        this.showAnnotation(false);
        XpMedicalImage[] images = this.getImagesToPlot();
        if (images == null) {
            this.logger.log(Level.FINER, "Zero Images are loaded in port to plot MIROI Graph");
            return;
        }
        if (rois != null) {
            this.gobject = new XpStatisticsRoiGraphObject((Capable)((Object)this.getScreen().getSelectedPort()));
            ((XpStatisticsRoiGraphObject)this.gobject).setXAxisElement(GraphConstants.DataElement.TIME);
            ((XpStatisticsRoiGraphObject)this.gobject).setYAxisElement(GraphConstants.DataElement.MEAN);
            ((XpStatisticsRoiGraphObject)this.gobject).setAbsolute(this.ctrlPanel.getIsAbsolute());
            this.getScreen().removePropertyChangeListener("ROI_ADDED", (XpStatisticsRoiGraphObject)this.gobject);
            this.getScreen().addPropertyChangeListener("ROI_ADDED", (XpStatisticsRoiGraphObject)this.gobject);
            this.getScreen().removePropertyChangeListener("ROI_REMOVED", (XpStatisticsRoiGraphObject)this.gobject);
            this.getScreen().addPropertyChangeListener("ROI_REMOVED", (XpStatisticsRoiGraphObject)this.gobject);
            this.plotter = new CvMiroiGraphPlotter(this.gobject, GraphConstants.PlotType.LINE, new String[]{""}, "Time Elapsed (sec)", "Relative Hu");
            this.plotter.setAnnotationColor(Color.WHITE);
            this.plotter.setGraphTitle(this.getGraphTitle(images));
            GroupMarker marker = new GroupMarker(0, 140.0, 145.0);
            double H = 60.0;
            double S2 = 0.9;
            double B = 0.9;
            int rgb = Color.HSBtoRGB((float)H, (float)S2, (float)B);
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            Color color = new Color(red, green, blue, 10);
            this.plotter.setXAxisMarkerColor(0, color);
            this.plotter.setXAxisMarker(0, (Marker)marker);
            GroupMarker marker1 = new GroupMarker(1, 150.0, 165.0);
            double H1 = 60.0;
            double S1 = 90.0;
            double B1 = 450.0;
            int rgb1 = Color.HSBtoRGB((float)H1, (float)S1, (float)B1);
            int red1 = rgb1 >> 16 & 0xFF;
            int green1 = rgb1 >> 8 & 0xFF;
            int blue1 = rgb & 0xFF;
            Color color1 = new Color(red1, green1, blue1, 10);
            this.plotter.setXAxisMarkerColor(1, color1);
            this.plotter.setXAxisMarker(1, (Marker)marker1);
            ChartPanel cpanel = this.plotter.getChartPanel();
            ChartpanelMouseListener mouseListener = new ChartpanelMouseListener((CvMiroiChartPanel)this.plotter.getChartPanel());
            cpanel.addChartMouseListener((ChartMouseListener)mouseListener);
            cpanel.addMouseListener((MouseListener)mouseListener);
            cpanel.getChart().getXYPlot().setRangeTickBandPaint((Paint)Color.LIGHT_GRAY);
            cpanel.addPropertyChangeListener((PropertyChangeListener)this);
            this.graph.setChartPanel(cpanel);
            CvMiroiLegendPanel lpanel = new CvMiroiLegendPanel(this.plotter);
            this.graph.setLegendPanel(lpanel);
            if (this.plotter.getXAxisMarker(0) != null && this.plotter.getXAxisMarker(0) instanceof ValueMarker) {
                this.outpanel.setPeakDelayValue(((IntervalMarker)this.plotter.getXAxisMarker(0)).getStartValue());
            }
            if (this.plotter.getYAxisMarker(0) != null && this.plotter.getYAxisMarker(0) instanceof ValueMarker) {
                this.outpanel.setThresholdValue(((ValueMarker)this.plotter.getYAxisMarker(0)).getValue());
            }
            this.showPrepCalcPanel();
        }
    }

    private String[] getGraphTitle(XpMedicalImage[] imgsx) {
        String PAD = "                         ";
        XpMedicalImage img = imgsx[0];
        StringBuffer strfirstLine = new StringBuffer("MIROI E");
        XpDicomElement Exam_no = new XpDicomElement(32, 16);
        XpDicomElement Series_no = new XpDicomElement(32, 17);
        XpDicomElement Img_no = new XpDicomElement(32, 19);
        XpDicomElement PID = new XpDicomElement(16, 32);
        XpDicomElement P_Name = new XpDicomElement(16, 16);
        img.getValue(Exam_no);
        img.getValue(Series_no);
        img.getValue(PID);
        img.getValue(P_Name);
        img.getValue(Img_no);
        if (Exam_no != null) {
            strfirstLine.append(Exam_no.getIntValue()).append("  S");
        } else {
            strfirstLine.append("0  S");
        }
        if (Series_no != null) {
            strfirstLine.append(Series_no.getIntValue()).append("  I");
        } else {
            strfirstLine.append("0  I");
        }
        if (Img_no != null) {
            strfirstLine.append(" ").append(Img_no.getIntValue());
            imgsx[imgsx.length - 1].getValue(Img_no);
            strfirstLine.append("-").append(Img_no.getIntValue());
        }
        strfirstLine.toString();
        StringBuffer strsecondLine = new StringBuffer();
        if (P_Name != null) {
            strsecondLine.append(P_Name.getStringValue() == null ? "" : P_Name.getStringValue()).append("  ");
        } else {
            strsecondLine.append("0  I");
        }
        if (PID != null) {
            strsecondLine.append(", ID:").append(PID.getStringValue());
        } else {
            strsecondLine.append("");
        }
        String[] subtitle = new String[]{PAD + strfirstLine.toString(), PAD + strsecondLine.toString()};
        return subtitle;
    }

    @Override
    public JComponent getSelectedPort() {
        JComponent c = this.getScreen().getSelectedPort();
        while (c != null && c instanceof XPscreen) {
            c = ((XPscreen)c).getSelectedPort();
        }
        return c;
    }

    private void showControlPanel() {
        this.crdLayout.show(this.container, "miroi_control");
        this.container.setTitle(CvUtils.getResourceBundle().getString("XP_MIROI_NAME"));
    }

    private void showPrepCalcPanel() {
        this.crdLayout.show(this.container, "miroi_display");
        this.container.setTitle("MIROI Prep Delay");
    }

    private XpMedicalImage[] getImagesToPlot() {
        XpMedicalImage[] images = null;
        if (this.getScreen().getSelectedPort() instanceof FrameCapable) {
            FrameCapable frmCapablePort = (FrameCapable)((Object)this.getScreen().getSelectedPort());
            int start = 0;
            int end = frmCapablePort.getNumFrames();
            if (this.ctrlPanel != null && !this.ctrlPanel.getIsAllImagesPlot()) {
                start = this.ctrlPanel.getImagesFrom() - 1;
                end = this.ctrlPanel.getImagesTo();
            }
            if (start >= end) {
                return null;
            }
            images = new XpMedicalImage[Math.abs(end - start)];
            int w = start;
            int i = 0;
            while (w < end) {
                images[i] = (XpMedicalImage)frmCapablePort.getFrame(w);
                ++w;
                ++i;
            }
            return images;
        }
        this.logger.log(Level.FINER, "Selected Port is not a instance of FrameCapable");
        return null;
    }

    private void showAnnotation(boolean value) {
        RowColCapable cap = (RowColCapable)this.getCapable(RowColCapable.class.getName());
        JComponent comp = this.getSelectedPort();
        if (cap != null && comp != null) {
            if (cap.getRows() > 1 || cap.getCols() > 1) {
                if (comp instanceof SelectionCapable) {
                    comp = ((SelectionCapable)((Object)comp)).getViewportComponent(1);
                }
            } else if (comp instanceof SelectionCapable) {
                comp = ((SelectionCapable)((Object)comp)).getViewportComponent(((SelectionCapable)((Object)comp)).getComponentSelection());
            }
            if (comp instanceof XpFrameVisualizer) {
                XpFrameVisualizer port = (XpFrameVisualizer)comp;
                port.getContentPane().setLayout(new BorderLayout());
                if (value) {
                    port.getMedicalImageVc().getAnnotationVc().setVisible(true);
                    if (this.graph != null) {
                        port.getContentPane().remove(this.graph);
                    }
                } else {
                    this.graph.setFrameVisualizerParent(port);
                    port.getContentPane().add(this.graph);
                    port.getMedicalImageVc().getAnnotationVc().setVisible(false);
                }
                port.validate();
                port.repaint();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equalsIgnoreCase("plot_graph")) {
            this.setDataToGraph();
        } else if (propName.equalsIgnoreCase("xaxis_marker_position")) {
            if (evt.getNewValue() instanceof GroupMarker) {
                GroupMarker marker = (GroupMarker)((Object)evt.getNewValue());
                Marker[] xmarkers = this.plotter.getAllxaxisMarkers();
                this.plotter.clearAllXAxisMarkers();
                for (int i = 0; i < xmarkers.length; ++i) {
                    if (marker.getIndex() == i) {
                        this.plotter.setXAxisMarker(i, (Marker)marker);
                        continue;
                    }
                    this.plotter.setXAxisMarker(i, xmarkers[i]);
                }
                this.outpanel.setPeakDelayValue(marker.getEndValue());
            }
        } else if (propName.equalsIgnoreCase("yaxis_marker_position")) {
            double value = (Double)evt.getNewValue();
            this.plotter.setYAxisMarker(0, (Marker)new ValueMarker(value));
            this.outpanel.setThresholdValue(value);
        } else if (propName.equalsIgnoreCase("hide_graph")) {
            this.showAnnotation(true);
            this.showControlPanel();
        } else if (propName.equalsIgnoreCase("cancel")) {
            this.showAnnotation(true);
            this.showControlPanel();
        } else if (propName.equalsIgnoreCase("accept_delay")) {
            // empty if block
        }
    }
}

