/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.miroi;

import com.ge.hc.cse.commons.formatters.PatNameFormatter;
import com.ge.med.cse.cvf.util.ScreenSaveUtil;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYSeriesCollection;

public class XpMiroiGraphPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -9000130062372942996L;
    public static final String HIDE_GRAPH = "hide_graph";
    public static final int SCR_SAVE_WIDTH = 512;
    public static final int SCR_SAVE_HEIGHT = 512;
    protected JFreeChart chart = null;
    XYSeriesCollection series = null;
    protected PatNameFormatter nameFormatter = new PatNameFormatter();
    private static final String HIDE = "hide";
    private static final String SCREEN_SAVE = "screen_save";
    private DMSession session = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private JPopupMenu menu = new JPopupMenu("Graph Operations");
    private JMenuItem show = new JMenuItem("HIDE");
    private JMenuItem ScrnSave = new JMenuItem("Screen Save");
    protected XpFrameVisualizer parentComp = null;

    public XpMiroiGraphPanel() {
        this.initUI();
    }

    protected void initUI() {
        try {
            this.setLayout(new BorderLayout());
            this.menu.add(this.show);
            this.menu.add(this.ScrnSave);
            this.show.addActionListener(this);
            this.ScrnSave.addActionListener(this);
            this.show.setActionCommand(HIDE);
            this.ScrnSave.setActionCommand(SCREEN_SAVE);
            this.logger.log(Level.FINER, "Graph Panel created sucessfully");
        }
        catch (Exception exp) {
            TransactionLogName tln_excep = new TransactionLogName("TID=MIROI_Exception");
            Object[] objArry = new Object[]{tln_excep, exp.getMessage()};
            this.logger.log(Level.SEVERE, "{0} Error in creation Graph Panel {1}", objArry);
        }
    }

    public void setSession(DMSession sess) {
        this.session = sess;
    }

    public DMSession getSession() {
        return this.session;
    }

    public void setChartPanel(ChartPanel cpanel) {
        cpanel.setMouseZoomable(false);
        cpanel.setDomainZoomable(false);
        cpanel.setPopupMenu(this.menu);
        cpanel.setPreferredSize(new Dimension(512, 512));
        this.removeAll();
        this.add((Component)cpanel);
        this.validate();
    }

    public void setLegendPanel(JPanel lpanel) {
        this.add((Component)lpanel, "South");
    }

    protected void screenSaveGraph() {
        if (this.session == null) {
            return;
        }
        DMImage imgs = null;
        DMObject[] dmo = null;
        try {
            XpMedicalDmImage firstimg = (XpMedicalDmImage)this.parentComp.getImageAt(0);
            imgs = firstimg.getDMImage();
            String examid = (String)imgs.getValue(new DMTag(32, 16));
            String examuid = (String)imgs.getValue(new DMTag(32, 13));
            StringBuffer buffer = new StringBuffer();
            if (examuid != null) {
                buffer.append("(0x0020, 0x000D) = ");
                buffer.append(examuid.trim());
            }
            if (examid != null && examid.trim().length() > 0) {
                buffer.append(" AND (0x0020, 0x0010) = ");
                buffer.append(examid.trim());
            }
            if (buffer.toString().trim().length() == 0) {
                return;
            }
            this.logger.log(Level.INFO, "MIROI_Query: Query fired for the DMObject is ", buffer);
            dmo = this.session.getRelated("study", new DMQuery(buffer.toString().trim()));
        }
        catch (Exception exp) {
            this.logger.log(Level.SEVERE, "MIROI_Exception: Error in getting the DMSession ", exp.getMessage());
            exp.printStackTrace(System.err);
            return;
        }
        if (dmo != null && dmo.length > 0) {
            try {
                if (this.chart != null) {
                    try {
                        ChartPanel comp = new ChartPanel((JFreeChart)this.chart.clone());
                        comp.setSize(new Dimension(512, 512));
                        this.session.install(ScreenSaveUtil.getScreenCapture(dmo[0], (JComponent)comp, 512, 512, null));
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException exp) {
                this.logger.log(Level.SEVERE, "MIROI_Exception: Error in installing the screen save to DB {1}", exp.getMessage());
                exp.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String strActionCmd = e.getActionCommand();
        if (strActionCmd != null && strActionCmd.equalsIgnoreCase(HIDE)) {
            this.firePropertyChange(HIDE_GRAPH, false, true);
            if (this.parentComp != null) {
                this.parentComp.getContentPane().remove(this);
                if (!this.parentComp.getMedicalImageVc().getAnnotationVc().isVisible()) {
                    this.parentComp.getMedicalImageVc().getAnnotationVc().setVisible(true);
                }
            }
        } else if (strActionCmd != null && strActionCmd.equalsIgnoreCase(SCREEN_SAVE)) {
            this.screenSaveGraph();
        }
    }

    public void setFrameVisualizerParent(XpFrameVisualizer parent) {
        this.parentComp = null;
        this.parentComp = parent;
    }
}

