/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.miroi;

import com.ge.med.cse.cvf.action.XpEllipseROIAction;
import com.ge.med.cse.cvf.action.XpPolygonROIAction;
import com.ge.med.cse.cvf.action.XpRectangularROIAction;
import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class XpMiroiControlPanel
extends JPanel {
    private static final long serialVersionUID = 3063166393166851501L;
    public static final String CONTROL = "miroi_control";
    public static final String PLOT_GRAPH = "plot_graph";
    public static final String ELLIPSE_ROI = "ellipse";
    public static final String RECTANGULAR_ROI = "rectangle";
    public static final String POLYGON_ROI = "polygon";
    public static final String ROI_DATA_CHANGED = "roi_Data_Changed";
    public static final String TITLE_NAME = "MIROI";
    public static final String IMAGE_LIST_UPDATED = "image_list_updated";
    private JLabel defLabel = new JLabel("Define Region", 2);
    private JButton rectROI = new JButton("", CvUtils.getIcon("XP_RECTANGULAR_ROI_ICON"));
    private JButton polyROI = new JButton("", CvUtils.getIcon("XP_POLYGON_ROI_ICON"));
    private JButton ellipseROI = new JButton("", CvUtils.getIcon("XP_ELLIPSE_ROI_ICON"));
    private ButtonGroup roiGroup = new ButtonGroup();
    private JPanel roipanel = new JPanel(false);
    private JLabel scaleForHu = new JLabel("Scale For HU");
    private JRadioButton absolute = new JRadioButton("Absolute");
    private JRadioButton relative = new JRadioButton("Relative");
    private ButtonGroup graphType = new ButtonGroup();
    private JPanel graphtypePanel = new JPanel(false);
    private JRadioButton all = new JRadioButton("All images");
    private JRadioButton range = new JRadioButton("Image Range");
    private ButtonGroup rangeGrp = new ButtonGroup();
    private JPanel imgRangePanel = new JPanel();
    private JPanel thres = new JPanel(false);
    private JLabel thresLabl = new JLabel("Threshold");
    private JTextField input = new JTextField();
    private JButton plot = new JButton("Plot");
    private JPanel plotPanel = new JPanel(false);
    private final int NO_OF_ROIS;
    private Vector roicontainer = new Vector();
    private transient ActionListener plotListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            XpMiroiControlPanel.this.firePropertyChange(XpMiroiControlPanel.PLOT_GRAPH, false, true);
        }
    };
    private XPscreen screenRef = null;
    SpinnerModel imageRangeFrom = new SpinnerNumberModel(1, 1, 1, 1);
    SpinnerModel imageRangeTo = new SpinnerNumberModel(1, 1, 1, 1);
    private JSpinner from = new JSpinner(this.imageRangeFrom);
    private JSpinner to = new JSpinner(this.imageRangeTo);
    private JLabel fromLbl = new JLabel("From");
    private JLabel toLbl = new JLabel("To");
    private JPanel spinnerPanel = new JPanel(false);
    private Dimension spinnerDimension = new Dimension(80, 20);
    private final transient Logger logger = Logger.getLogger(this.getClass().getName());
    private transient ActionListener roiActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseAction bact = null;
            if (e.getActionCommand().equalsIgnoreCase(XpMiroiControlPanel.ELLIPSE_ROI)) {
                bact = new XpEllipseROIAction();
                bact.setCapable(XpMiroiControlPanel.this.screenRef);
                bact.actionPerformed(e);
            } else if (e.getActionCommand().equalsIgnoreCase(XpMiroiControlPanel.RECTANGULAR_ROI)) {
                bact = new XpRectangularROIAction();
                bact.setCapable(XpMiroiControlPanel.this.screenRef);
                bact.actionPerformed(e);
            } else if (e.getActionCommand().equalsIgnoreCase(XpMiroiControlPanel.POLYGON_ROI)) {
                bact = new XpPolygonROIAction();
                bact.setCapable(XpMiroiControlPanel.this.screenRef);
                bact.actionPerformed(e);
            }
        }
    };
    private transient ActionListener rangeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton source = (JRadioButton)e.getSource();
            if (source.getName().equalsIgnoreCase("range")) {
                XpMiroiControlPanel.this.spinnerPanel.setEnabled(true);
                XpMiroiControlPanel.this.fromLbl.setEnabled(true);
                XpMiroiControlPanel.this.from.setEnabled(true);
                XpMiroiControlPanel.this.toLbl.setEnabled(true);
                XpMiroiControlPanel.this.to.setEnabled(true);
                XpMiroiControlPanel.this.resetSpinnerRanges();
            } else {
                XpMiroiControlPanel.this.spinnerPanel.setEnabled(false);
                XpMiroiControlPanel.this.fromLbl.setEnabled(false);
                XpMiroiControlPanel.this.from.setEnabled(false);
                XpMiroiControlPanel.this.toLbl.setEnabled(false);
                XpMiroiControlPanel.this.to.setEnabled(false);
            }
        }
    };
    private transient PropertyChangeListener viewPortSelectionListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            ROICapable roiCapablePort = XpMiroiControlPanel.this.getROICapablePort();
            if (roiCapablePort == null) {
                XpMiroiControlPanel.this.logger.log(Level.INFO, "Selected port is not ROI Capable");
                return;
            }
            if (evt.getPropertyName().equalsIgnoreCase("ComponentSelection")) {
                XpMiroiControlPanel.this.roicontainer.clear();
                List rois = roiCapablePort.getRois();
                if (rois != null) {
                    for (int i = 0; i < rois.size(); ++i) {
                        XpMiroiControlPanel.this.roicontainer.add(rois.get(i));
                    }
                }
                if (XpMiroiControlPanel.this.roicontainer.size() >= XpMiroiControlPanel.this.NO_OF_ROIS) {
                    XpMiroiControlPanel.this.setROIButtonsEnabled(false);
                } else {
                    XpMiroiControlPanel.this.setROIButtonsEnabled(true);
                }
            } else if (propertyName.equalsIgnoreCase("ROI_ADDED")) {
                List rois = roiCapablePort.getRois();
                if (rois.size() < XpMiroiControlPanel.this.NO_OF_ROIS) {
                    XpMiroiControlPanel.this.setROIButtonsEnabled(true);
                } else {
                    XpMiroiControlPanel.this.setROIButtonsEnabled(false);
                }
            } else if (propertyName.equalsIgnoreCase("ROI_REMOVED")) {
                List rois = roiCapablePort.getRois();
                if (rois.size() > XpMiroiControlPanel.this.NO_OF_ROIS) {
                    XpMiroiControlPanel.this.setROIButtonsEnabled(false);
                } else {
                    XpMiroiControlPanel.this.setROIButtonsEnabled(true);
                }
            } else if (evt.getPropertyName().equalsIgnoreCase("DATA_CHANGE")) {
                XpMiroiControlPanel.this.resetSpinnerRanges();
            } else if (evt.getPropertyName().equalsIgnoreCase("CONTENT_CHANGED")) {
                XpMiroiControlPanel.this.resetSpinnerRanges();
            }
        }
    };

    public XpMiroiControlPanel() {
        this.NO_OF_ROIS = Integer.valueOf(System.getProperty("MIROI_ROI_COUNT", "5"));
        this.initUI();
    }

    protected void initUI() {
        try {
            this.setLayout(new GridBagLayout());
            this.roipanel.setLayout(new GridBagLayout());
            this.ellipseROI.setPreferredSize(new Dimension(55, 45));
            this.rectROI.setPreferredSize(new Dimension(55, 45));
            this.polyROI.setPreferredSize(new Dimension(55, 45));
            this.ellipseROI.setActionCommand(ELLIPSE_ROI);
            this.rectROI.setActionCommand(RECTANGULAR_ROI);
            this.polyROI.setActionCommand(POLYGON_ROI);
            this.ellipseROI.addActionListener(this.roiActionListener);
            this.rectROI.addActionListener(this.roiActionListener);
            this.polyROI.addActionListener(this.roiActionListener);
            this.roipanel.add((Component)this.defLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.roipanel.add((Component)this.ellipseROI, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.roipanel.add((Component)this.rectROI, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.roipanel.add((Component)this.polyROI, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.roiGroup.add(this.ellipseROI);
            this.roiGroup.add(this.rectROI);
            this.roiGroup.add(this.polyROI);
            this.absolute.setFocusable(false);
            this.relative.setFocusable(false);
            this.graphtypePanel.setLayout(new GridBagLayout());
            this.graphtypePanel.add((Component)this.scaleForHu, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.graphtypePanel.add((Component)this.absolute, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.graphtypePanel.add((Component)this.relative, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.graphType.add(this.absolute);
            this.graphType.add(this.relative);
            this.relative.setSelected(true);
            this.all.setFocusable(false);
            this.all.setActionCommand("all");
            this.all.setName("all");
            this.all.addActionListener(this.rangeListener);
            this.all.setSelected(true);
            this.range.setFocusable(false);
            this.range.setActionCommand("range");
            this.range.setName("range");
            this.range.addActionListener(this.rangeListener);
            this.rangeGrp.add(this.all);
            this.rangeGrp.add(this.range);
            this.fromLbl.setEnabled(false);
            this.from.setEnabled(false);
            this.toLbl.setEnabled(false);
            this.to.setEnabled(false);
            this.to.setPreferredSize(this.spinnerDimension);
            this.from.setPreferredSize(this.spinnerDimension);
            this.imgRangePanel.setLayout(new GridBagLayout());
            this.imgRangePanel.add((Component)this.fromLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.imgRangePanel.add((Component)this.from, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.imgRangePanel.add((Component)this.toLbl, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.imgRangePanel.add((Component)this.to, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.thres.add(this.thresLabl);
            this.thres.add(this.input);
            this.input.setPreferredSize(new Dimension(80, 25));
            this.plot.setPreferredSize(new Dimension(60, 30));
            this.plot.addActionListener(this.plotListener);
            this.plotPanel.add(this.plot);
            this.add((Component)this.roipanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 10, 5, 0), 0, 0));
            this.add((Component)this.graphtypePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this.all, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this.range, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this.imgRangePanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 10, 5, 0), 0, 0));
            this.add((Component)this.plotPanel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 11, 2, new Insets(20, 0, 0, 0), 0, 0));
            this.revalidate();
            this.all.doClick();
        }
        catch (Exception exp) {
            this.logger.log(Level.SEVERE, "MIROI_Exception: Error in creation MIROI Control Panel " + exp.getMessage());
        }
    }

    public void setScreen(XPscreen screen) {
        System.out.println("setting screen with=" + screen);
        this.screenRef = screen;
        if (this.screenRef != null) {
            this.screenRef.removePropertyChangeListener(this.viewPortSelectionListener);
            this.screenRef.addPropertyChangeListener(this.viewPortSelectionListener);
            this.resetSpinnerRanges();
        }
    }

    private void setROIButtonsEnabled(boolean value) {
        this.ellipseROI.setEnabled(value);
        this.rectROI.setEnabled(value);
        this.polyROI.setEnabled(value);
    }

    public void resetSpinnerRanges() {
        FrameCapable fpc = (FrameCapable)((Object)((XpViewport)this.screenRef.getSelectedPort()).getCapable(FrameCapable.class.getName()));
        int max = 1;
        try {
            if (fpc != null) {
                max = fpc.getNumFrames();
            }
            this.imageRangeFrom = new SpinnerNumberModel(1, 1, max, 1);
            this.imageRangeTo = new SpinnerNumberModel(max, 1, max, 1);
            this.from.setModel(this.imageRangeFrom);
            this.to.setModel(this.imageRangeTo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getImagesFrom() {
        Number value = (Number)this.from.getValue();
        return value.intValue();
    }

    public int getImagesTo() {
        Number value = (Number)this.to.getValue();
        return value.intValue();
    }

    public boolean getIsAbsolute() {
        return this.absolute.isSelected();
    }

    public boolean getIsAllImagesPlot() {
        return this.all.isSelected();
    }

    public ROICapable getROICapablePort() {
        JComponent selectedPort = this.screenRef.getSelectedPort();
        if (selectedPort instanceof ROICapable) {
            return (ROICapable)((Object)selectedPort);
        }
        return null;
    }
}

