/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.miroi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jfree.data.general.Series;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.util.ObjectUtilities;

public class HistogramSeries
extends Series {
    private boolean retainValues = false;
    private double[] values;
    private double minimum;
    private double maximum;
    private int numberOfBins;
    private int numberOfValues;
    private List binList;

    public HistogramSeries(Comparable key, double[] values, int bins, double minimum, double maximum) {
        this(key, "", values, bins, minimum, maximum, false);
    }

    public HistogramSeries(Comparable key, String description, double[] values, int bins, double minimum, double maximum) {
        this(key, "", values, bins, minimum, maximum, false);
    }

    public HistogramSeries(Comparable key, double[] values, int bins, double minimum, double maximum, boolean retainValues) {
        this(key, "", values, bins, minimum, maximum, retainValues);
    }

    public HistogramSeries(Comparable key, String description, double[] values, int bins, double minimum, double maximum, boolean retainValues) {
        super(key, description);
        if (retainValues) {
            this.values = (double[])(values != null ? Arrays.copyOf(values, values.length) : null);
        }
        this.numberOfValues = values != null ? values.length : 0;
        this.numberOfBins = bins;
        this.minimum = minimum;
        this.maximum = maximum;
        this.binList = this.generateHistogramBinList(values, bins, minimum, maximum);
        this.fireSeriesChanged();
    }

    public void updateSeries(double[] values, int bins, double minimum, double maximum) {
        if (this.retainValues) {
            this.values = (double[])(values != null ? Arrays.copyOf(values, values.length) : null);
        }
        this.numberOfValues = values != null ? values.length : 0;
        this.numberOfBins = bins;
        this.minimum = minimum;
        this.maximum = maximum;
        this.binList = this.generateHistogramBinList(values, bins, minimum, maximum);
        this.fireSeriesChanged();
    }

    double getBinWidth() {
        return (this.maximum - this.minimum) / (double)this.numberOfBins;
    }

    List getBins() {
        return this.binList;
    }

    public int getItemCount() {
        return this.getBins().size();
    }

    int getTotal() {
        return this.numberOfValues;
    }

    public Object clone() throws CloneNotSupportedException {
        HistogramSeries clone = (HistogramSeries)((Object)super.clone());
        clone.retainValues = this.retainValues;
        clone.minimum = this.minimum;
        clone.maximum = this.maximum;
        clone.numberOfBins = this.numberOfBins;
        clone.numberOfValues = this.numberOfValues;
        if (this.retainValues) {
            clone.values = (double[])this.values.clone();
        }
        clone.binList = (List)ObjectUtilities.deepClone((Collection)this.binList);
        return clone;
    }

    private List generateHistogramBinList(double[] values, int bins, double minimum, double maximum) {
        int i;
        if (values == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        if (bins < 1) {
            throw new IllegalArgumentException("The 'bins' value must be at least 1.");
        }
        double binWidth = (maximum - minimum) / (double)bins;
        double lower = minimum;
        ArrayList<HistogramBin> binList = new ArrayList<HistogramBin>(bins);
        for (i = 0; i < bins; ++i) {
            HistogramBin bin;
            if (i == bins - 1) {
                bin = new HistogramBin(lower, maximum);
            } else {
                double upper = minimum + (double)(i + 1) * binWidth;
                bin = new HistogramBin(lower, upper);
                lower = upper;
            }
            binList.add(bin);
        }
        for (i = 0; i < values.length; ++i) {
            int binIndex = bins - 1;
            if (values[i] < maximum) {
                double fraction = (values[i] - minimum) / (maximum - minimum);
                if (fraction < 0.0) {
                    fraction = 0.0;
                }
                if ((binIndex = (int)(fraction * (double)bins)) >= bins) {
                    binIndex = bins - 1;
                }
            }
            HistogramBin bin = (HistogramBin)binList.get(binIndex);
            bin.incrementCount();
        }
        return binList;
    }

    private double getMinimum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double min = Double.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    private double getMaximum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double max = -1.7976931348623157E308;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }
}

