/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.miroi;

import com.ge.med.cse.cvf.miroi.HistogramSeries;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class HistogramDataset
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -6341668077370231153L;
    private List<HistogramSeries> list = new ArrayList<HistogramSeries>();
    private HistogramType type = HistogramType.FREQUENCY;

    public HistogramType getType() {
        return this.type;
    }

    public void setType(HistogramType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null 'type' argument");
        }
        this.type = type;
        this.notifyListeners(new DatasetChangeEvent((Object)this, (Dataset)this));
    }

    public void addSeries(Comparable key, double[] values, int bins) {
        double minimum = this.getMinimum(values);
        double maximum = this.getMaximum(values);
        this.addSeries(key, values, bins, minimum, maximum);
    }

    public void addSeries(Comparable key, double[] values, int bins, double minimum, double maximum) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        HistogramSeries series = new HistogramSeries(key, values, bins, minimum, maximum);
        this.list.add(series);
        this.fireDatasetChanged();
    }

    public void addSeries(HistogramSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null Series argument.");
        }
        this.list.add(series);
        this.fireDatasetChanged();
    }

    public void removeSeries(HistogramSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null Series argument.");
        }
        this.list.remove((Object)series);
        this.fireDatasetChanged();
    }

    public void updateSeries(Comparable key, double[] values, int bins) {
        double minimum = this.getMinimum(values);
        double maximum = this.getMaximum(values);
        this.updateSeries(key, values, bins, minimum, maximum);
    }

    public void updateSeries(Comparable key, double[] values, int bins, double minimum, double maximum) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        HistogramSeries series = this.list.get(this.getSeriesIndex(key));
        if (series != null) {
            series.updateSeries(values, bins, minimum, maximum);
            this.fireDatasetChanged();
        }
    }

    private double getMinimum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double min = Double.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    private double getMaximum(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double max = -1.7976931348623157E308;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    List getBins(int series) {
        HistogramSeries histSeries = this.list.get(series);
        return histSeries.getBins();
    }

    private int getTotal(int series) {
        HistogramSeries histSeries = this.list.get(series);
        return histSeries.getTotal();
    }

    private double getBinWidth(int series) {
        HistogramSeries histSeries = this.list.get(series);
        return histSeries.getBinWidth();
    }

    public int getSeriesCount() {
        return this.list.size();
    }

    public Comparable getSeriesKey(int series) {
        HistogramSeries histSeries = this.list.get(series);
        return histSeries.getKey();
    }

    public int getItemCount(int series) {
        HistogramSeries histSeries = this.list.get(series);
        return histSeries.getItemCount();
    }

    public Number getX(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        double x = (bin.getStartBoundary() + bin.getEndBoundary()) / 2.0;
        return new Double(x);
    }

    public Number getY(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        double total = this.getTotal(series);
        double binWidth = this.getBinWidth(series);
        if (this.type == HistogramType.FREQUENCY) {
            return new Double(bin.getCount());
        }
        if (this.type == HistogramType.RELATIVE_FREQUENCY) {
            return new Double((double)bin.getCount() / total);
        }
        if (this.type == HistogramType.SCALE_AREA_TO_1) {
            return new Double((double)bin.getCount() / (binWidth * total));
        }
        throw new IllegalStateException();
    }

    public Number getStartX(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        return new Double(bin.getStartBoundary());
    }

    public Number getEndX(int series, int item) {
        List bins = this.getBins(series);
        HistogramBin bin = (HistogramBin)bins.get(item);
        return new Double(bin.getEndBoundary());
    }

    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HistogramDataset)) {
            return false;
        }
        HistogramDataset that = (HistogramDataset)obj;
        if (!ObjectUtilities.equal((Object)this.type, (Object)that.type)) {
            return false;
        }
        return ObjectUtilities.equal(this.list, that.list);
    }

    public int hashCode() {
        int result = 0;
        if (this.list != null) {
            Iterator<HistogramSeries> listIter = this.list.iterator();
            while (listIter.hasNext()) {
                result += listIter.next() != null ? listIter.next().hashCode() : 0;
            }
        }
        return result += this.type != null ? this.type.hashCode() : 0;
    }

    public Object clone() throws CloneNotSupportedException {
        HistogramDataset clone = (HistogramDataset)super.clone();
        int seriesCount = this.getSeriesCount();
        clone.list = new ArrayList<HistogramSeries>(seriesCount);
        for (int i = 0; i < seriesCount; ++i) {
            clone.list.add((HistogramSeries)((Object)this.list.get(i).clone()));
        }
        return clone;
    }

    public Object removeSeries(int series) {
        HistogramSeries success = this.list.remove(series);
        if (success != null) {
            this.fireDatasetChanged();
        }
        return success;
    }

    public boolean removeSeries(Comparable key) {
        int seriesToRemove = this.getSeriesIndex(key);
        if (seriesToRemove != -1) {
            this.removeSeries(seriesToRemove);
            return true;
        }
        return false;
    }

    private int getSeriesIndex(Comparable key) {
        int index = -1;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            HistogramSeries series = this.list.get(i);
            if (!series.getKey().equals(key)) continue;
            index = i;
            break;
        }
        return index;
    }

    public HistogramSeries getSeries(Comparable key) {
        return this.getSeries(this.getSeriesIndex(key));
    }

    public HistogramSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return this.list.get(series);
    }
}

