/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.miroi;

import com.ge.med.cse.cvf.miroi.AbstractGraphPlotter;
import com.ge.med.cse.cvf.miroi.GraphPlotter;
import com.ge.med.cse.cvf.miroi.HistogramDataset;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class CvMiroiLegendPanel
extends JPanel
implements PropertyChangeListener {
    private List<JCheckBox> jcbList = new ArrayList<JCheckBox>();
    private transient GraphPlotter plotter = null;
    private HashMap<String, String> legendItemMap = null;
    private transient ItemListener jcblistener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean state = true;
            state = e.getStateChange() != 2;
            String name = ((JCheckBox)e.getSource()).getText();
            XYDataset dset = CvMiroiLegendPanel.this.plotter.getChart().getXYPlot().getDataset();
            int index = -1;
            if (dset instanceof HistogramDataset) {
                index = ((HistogramDataset)dset).indexOf((Comparable)CvMiroiLegendPanel.this.legendItemMap.get(name));
            } else if (dset instanceof XYSeriesCollection) {
                index = ((XYSeriesCollection)dset).indexOf((Comparable)CvMiroiLegendPanel.this.legendItemMap.get(name));
            } else if (dset instanceof IntervalXYDataset) {
                index = ((IntervalXYDataset)dset).indexOf((Comparable)CvMiroiLegendPanel.this.legendItemMap.get(name));
            }
            if (index != -1) {
                CvMiroiLegendPanel.this.plotter.getChart().getXYPlot().getRenderer().setSeriesVisible(index, Boolean.valueOf(state));
            }
        }
    };

    public CvMiroiLegendPanel(GraphPlotter p) {
        this.plotter = p;
        this.setLayout(new FlowLayout());
        ((AbstractGraphPlotter)this.plotter).addPropertyChangeListener(this);
        this.initLegendPanel();
    }

    private void initLegendPanel() {
        this.legendItemMap = this.plotter.getGraphObject().getLegendItemMap();
        Set<String> keySet = this.legendItemMap.keySet();
        for (String name : keySet) {
            JCheckBox jcb = new JCheckBox(name);
            jcb.setFocusable(false);
            jcb.setBackground(Color.BLACK);
            jcb.setForeground(Color.WHITE);
            jcb.setSelected(true);
            jcb.addItemListener(this.jcblistener);
            this.add(jcb);
            this.jcbList.add(jcb);
        }
    }

    private void clearLegendPanel() {
        for (JCheckBox type : this.jcbList) {
            type.removeItemListener(this.jcblistener);
        }
        this.removeAll();
        this.jcbList.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("UPDATE_LEGEND")) {
            this.clearLegendPanel();
            this.initLegendPanel();
        }
    }
}

