/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.miroi;

import com.ge.med.cse.cvf.miroi.AbstractGraphObject;
import com.ge.med.cse.cvf.miroi.AbstractGraphPlotter;
import com.ge.med.cse.cvf.miroi.CvMiroiChartPanel;
import com.ge.med.cse.cvf.miroi.GraphConstants;
import com.ge.med.cse.cvf.miroi.GraphObject;
import com.ge.med.cse.cvf.miroi.GroupMarker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;

public class CvMiroiGraphPlotter
extends AbstractGraphPlotter
implements PropertyChangeListener {
    private ChartPanel cpanel = null;

    public CvMiroiGraphPlotter() {
        this(null, GraphConstants.PlotType.LINE, null, "", "", PlotOrientation.VERTICAL);
    }

    public CvMiroiGraphPlotter(GraphConstants.PlotType pt) {
        this(null, pt, null, "", "", PlotOrientation.VERTICAL);
    }

    public CvMiroiGraphPlotter(GraphObject obj, GraphConstants.PlotType pt) {
        this(obj, pt, null, "", "", PlotOrientation.VERTICAL);
    }

    public CvMiroiGraphPlotter(GraphObject obj, GraphConstants.PlotType pt, String[] title) {
        this(obj, pt, title, "", "", PlotOrientation.VERTICAL);
    }

    public CvMiroiGraphPlotter(GraphObject obj, GraphConstants.PlotType pt, String[] title, String xaxistitle, String yaxistitle) {
        this(obj, pt, title, xaxistitle, yaxistitle, PlotOrientation.VERTICAL);
    }

    public CvMiroiGraphPlotter(GraphObject obj, GraphConstants.PlotType pt, String[] title, String xaxistitle, String yaxistitle, PlotOrientation o) {
        super(obj, pt, title, xaxistitle, yaxistitle, o);
        if (obj != null) {
            ((AbstractGraphObject)obj).addPropertyChangeListener(this);
        }
        this.cpanel = new CvMiroiChartPanel(this.getChart());
    }

    public void setGraphObject(GraphObject go) {
        if (go != null) {
            ((AbstractGraphObject)go).addPropertyChangeListener(this);
            this.setDataset(go.getGraphDataset(this.plottype));
        }
    }

    @Override
    public ChartPanel getChartPanel() {
        return this.cpanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("UPDATE_DATASET")) {
            this.getChart().getXYPlot().getRenderer().setBaseSeriesVisible(true);
            Marker[] xmarkers = this.getAllxaxisMarkers();
            for (int i = 0; i < xmarkers.length; ++i) {
                Marker xmarker = xmarkers[i];
                if (xmarker instanceof ValueMarker) {
                    double oldval;
                    double xval = oldval = ((ValueMarker)xmarker).getValue();
                    double xmax = this.getChart().getXYPlot().getDomainAxis().getUpperBound();
                    double xmin = this.getChart().getXYPlot().getDomainAxis().getLowerBound();
                    if (xval > xmax) {
                        xval = xmax - xmax * 0.025;
                    }
                    if (xval < xmin) {
                        xval = xmin + xmin * 0.025;
                    }
                    if (xval == oldval) continue;
                    ValueMarker marker = new ValueMarker(xval);
                    this.setXAxisMarker(i, (Marker)marker);
                    continue;
                }
                if (!(xmarker instanceof GroupMarker)) continue;
            }
            Marker[] ymarkers = this.getAllyaxisMarkers();
            for (int i = 0; i < ymarkers.length; ++i) {
                double oldval;
                Marker ymarker = ymarkers[i];
                double yval = oldval = ((ValueMarker)ymarker).getValue();
                double ymax = this.getChart().getXYPlot().getRangeAxis().getUpperBound();
                double ymin = this.getChart().getXYPlot().getRangeAxis().getLowerBound();
                if (yval > ymax) {
                    yval = ymax - ymax * 0.025;
                }
                if (yval < ymin) {
                    yval = ymin + ymin * 0.025;
                }
                if (yval == oldval) continue;
                this.setYAxisMarker(i, (Marker)new ValueMarker(yval));
                this.firePropertyChange("xaxis_marker_position", oldval, yval);
            }
            this.firePropertyChange("UPDATE_LEGEND", null, null);
        }
    }
}

