/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.miroi;

import com.ge.med.cse.cvf.miroi.CvMiroiChartPanel;
import com.ge.med.cse.cvf.miroi.GroupMarker;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.ui.Layer;

public class ChartpanelMouseListener
implements ChartMouseListener,
MouseListener {
    private CvMiroiChartPanel chartPanel = null;
    private boolean startmarker = false;
    private GroupMarker currentmarMarker = null;
    private boolean endmarker = false;

    public ChartpanelMouseListener(CvMiroiChartPanel panel) {
        this.chartPanel = panel;
    }

    public void chartMouseClicked(ChartMouseEvent arg0) {
    }

    public void chartMouseMoved(ChartMouseEvent arg) {
        this.setEResizeCursor(arg);
        this.setNResizeCursor(arg);
    }

    protected void setEResizeCursor(ChartMouseEvent evt) {
        if (this.chartPanel != null) {
            Collection col;
            this.startmarker = false;
            this.endmarker = false;
            if (evt.getSource() instanceof Marker) {
                // empty if block
            }
            if ((col = this.chartPanel.getChart().getXYPlot().getDomainMarkers(Layer.BACKGROUND)) == null) {
                return;
            }
            for (Object tmpObject : col) {
                double scrnLocation;
                GroupMarker marker = null;
                if (!(tmpObject instanceof GroupMarker)) {
                    return;
                }
                marker = (GroupMarker)((Object)tmpObject);
                double startmarkerValue = marker.getStartValue();
                double endmarkerValue = marker.getEndValue();
                double minLocation = scrnLocation = this.getGraphXPointForMouse(evt.getTrigger());
                double maxlocation = scrnLocation + 1.0;
                if (startmarkerValue <= maxlocation && startmarkerValue >= minLocation) {
                    this.startmarker = true;
                    this.currentmarMarker = marker;
                    this.chartPanel.setCursor(Cursor.getPredefinedCursor(11));
                    return;
                }
                if (endmarkerValue <= maxlocation && endmarkerValue >= minLocation) {
                    this.endmarker = true;
                    this.currentmarMarker = marker;
                    this.chartPanel.setCursor(Cursor.getPredefinedCursor(11));
                    return;
                }
                this.chartPanel.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    protected void setNResizeCursor(ChartMouseEvent evt) {
        if (this.chartPanel != null) {
            Collection col = this.chartPanel.getChart().getXYPlot().getRangeMarkers(Layer.FOREGROUND);
            if (col == null) {
                return;
            }
            Object tmpObject = col.iterator().next();
            ValueMarker marker = null;
            if (!(tmpObject instanceof ValueMarker)) {
                return;
            }
            marker = (ValueMarker)tmpObject;
            double markerValue = marker.getValue();
            double scrnLocation = this.getGraphYPointForMouse(evt.getTrigger());
            double delta = scrnLocation / 50.0;
            double minLocation = scrnLocation - delta;
            double maxlocation = scrnLocation + delta;
            if (markerValue <= maxlocation && markerValue >= minLocation) {
                this.chartPanel.setCursor(Cursor.getPredefinedCursor(8));
            }
        }
    }

    protected double getGraphXPointForMouse(MouseEvent e) {
        double toReturn = 0.0;
        ValueAxis axis = this.chartPanel.getChart().getXYPlot().getDomainAxis();
        toReturn = axis.java2DToValue((double)e.getX(), this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea(), this.chartPanel.getChart().getXYPlot().getDomainAxisEdge());
        return toReturn;
    }

    protected double getGraphYPointForMouse(MouseEvent e) {
        double toReturn = 0.0;
        ValueAxis axis = this.chartPanel.getChart().getXYPlot().getRangeAxis();
        toReturn = axis.java2DToValue((double)e.getY(), this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea(), this.chartPanel.getChart().getXYPlot().getRangeAxisEdge());
        return toReturn;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.chartPanel != null && !e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e) && this.chartPanel.contains(new Point(e.getX(), e.getY()))) {
            if (Cursor.getPredefinedCursor(11) == this.chartPanel.getCursor()) {
                this.updateXMarker(e);
            } else if (Cursor.getPredefinedCursor(8) == this.chartPanel.getCursor()) {
                this.updateYmarker(e);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void updateYmarker(MouseEvent e) {
        double yy = this.getGraphYPointForMouse(e);
        if (yy > this.getYMinimum() && yy < this.getYMaximum()) {
            this.chartPanel.fireProperty("yaxis_marker_position", "", new Double(yy));
        }
    }

    public void updateXMarker(MouseEvent e) {
        if (this.currentmarMarker != null) {
            GroupMarker marker = this.currentmarMarker;
            double xx = this.getGraphXPointForMouse(e);
            double startvalue = marker.getStartValue();
            double endvalue = marker.getEndValue();
            if (this.startmarker) {
                this.startmarker = false;
                if (xx < startvalue) {
                    startvalue = xx;
                } else if (xx > startvalue && xx < endvalue) {
                    startvalue = xx;
                } else if (xx > endvalue) {
                    startvalue = endvalue;
                    endvalue = xx;
                }
                GroupMarker intervalmarker = new GroupMarker(marker.getIndex(), startvalue, endvalue);
                if (xx > this.getXMinimum() && xx < this.getXMaximum()) {
                    this.chartPanel.fireProperty("xaxis_marker_position", "", (Object)intervalmarker);
                }
            } else if (this.endmarker) {
                this.endmarker = false;
                if (xx > endvalue) {
                    endvalue = xx;
                } else if (xx > startvalue && xx < endvalue) {
                    endvalue = xx;
                } else if (xx < startvalue) {
                    endvalue = startvalue;
                    startvalue = xx;
                }
                GroupMarker intervalmarker = new GroupMarker(marker.getIndex(), startvalue, endvalue);
                if (xx > this.getXMinimum() && xx < this.getXMaximum()) {
                    this.chartPanel.fireProperty("xaxis_marker_position", "", (Object)intervalmarker);
                }
            }
        }
    }

    private double getXMinimum() {
        return this.chartPanel.getChart().getXYPlot().getDomainAxis().getRange().getLowerBound();
    }

    private double getXMaximum() {
        return this.chartPanel.getChart().getXYPlot().getDomainAxis().getRange().getUpperBound();
    }

    private double getYMinimum() {
        return this.chartPanel.getChart().getXYPlot().getRangeAxis().getRange().getLowerBound();
    }

    private double getYMaximum() {
        return this.chartPanel.getChart().getXYPlot().getRangeAxis().getRange().getUpperBound();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

