/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.miroi;

import com.ge.med.cse.cvf.miroi.GraphConstants;
import com.ge.med.cse.cvf.miroi.GraphObject;
import com.ge.med.cse.cvf.miroi.GraphPlotter;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.Layer;

public abstract class AbstractGraphPlotter
implements GraphPlotter {
    public static final String XAXIS_MARKER_POSITION = "xaxis_marker_position";
    public static final String YAXIS_MARKER_POSITION = "yaxis_marker_position";
    private JFreeChart chart = null;
    protected GraphConstants.PlotType plottype = GraphConstants.PlotType.LINE;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private GraphObject gobj = null;
    private Dataset dataset = null;
    private String[] gtitle = null;
    private String xAxisLabel = "";
    private String yAxisLabel = "";
    private Color annotationcolor = Color.WHITE;
    private HashMap xmarkers = new HashMap();
    private HashMap ymarkers = new HashMap();
    private Color titlecolor = Color.WHITE;
    private HashMap xmarkercolors = new HashMap();
    private HashMap ymarkercolors = new HashMap();
    private Stroke markerstroke = null;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public AbstractGraphPlotter() {
        this(null, GraphConstants.PlotType.LINE, null, "", "", PlotOrientation.VERTICAL);
    }

    public AbstractGraphPlotter(GraphConstants.PlotType pt) {
        this(null, pt, null, "", "", PlotOrientation.VERTICAL);
    }

    public AbstractGraphPlotter(GraphObject obj, GraphConstants.PlotType pt) {
        this(obj, pt, null, "", "", PlotOrientation.VERTICAL);
    }

    public AbstractGraphPlotter(GraphObject obj, GraphConstants.PlotType pt, String[] title) {
        this(obj, pt, title, "", "", PlotOrientation.VERTICAL);
    }

    public AbstractGraphPlotter(GraphObject obj, GraphConstants.PlotType pt, String[] title, String xaxistitle, String yaxistitle) {
        this(obj, pt, title, xaxistitle, yaxistitle, PlotOrientation.VERTICAL);
    }

    public AbstractGraphPlotter(GraphObject obj, GraphConstants.PlotType pt, String[] title, String xaxistitle, String yaxistitle, PlotOrientation o) {
        this.gobj = obj;
        this.plottype = pt;
        this.xAxisLabel = xaxistitle;
        this.yAxisLabel = yaxistitle;
        this.orientation = o;
        this.plotGraph(this.plottype, this.gobj);
        this.setGraphTitle(title);
    }

    @Override
    public void plotGraph(GraphConstants.PlotType pt, GraphObject gob) {
        if (pt != null) {
            switch (pt) {
                case LINE: {
                    this.chart = ChartFactory.createXYLineChart((String)"", (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)((XYDataset)this.dataset), (PlotOrientation)this.orientation, (boolean)false, (boolean)false, (boolean)false);
                    break;
                }
                case HISTOGRAM: {
                    this.chart = ChartFactory.createHistogram((String)"", null, null, (IntervalXYDataset)((IntervalXYDataset)this.dataset), (PlotOrientation)this.orientation, (boolean)false, (boolean)false, (boolean)false);
                    break;
                }
                case SCATTER: {
                    this.chart = ChartFactory.createScatterPlot((String)"", (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)((XYDataset)this.dataset), (PlotOrientation)this.orientation, (boolean)false, (boolean)false, (boolean)false);
                    break;
                }
                case LINE_BAR: {
                    this.chart = ChartFactory.createXYBarChart((String)"", (String)this.xAxisLabel, (boolean)false, (String)this.yAxisLabel, (IntervalXYDataset)((IntervalXYDataset)this.dataset), (PlotOrientation)this.orientation, (boolean)false, (boolean)false, (boolean)false);
                    break;
                }
                case AREA: {
                    this.chart = ChartFactory.createXYAreaChart((String)"", (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)((XYDataset)this.dataset), (PlotOrientation)this.orientation, (boolean)false, (boolean)false, (boolean)false);
                    break;
                }
            }
            if (gob != null) {
                this.setDataset(gob.getGraphDataset(pt));
            }
            this.resetGraphAnnotationColor();
            this.resetCurveColors();
        }
    }

    @Override
    public void setGraphTitle(String[] title) {
        this.gtitle = title != null ? Arrays.copyOf(title, title.length) : null;
        if (this.gtitle != null && this.chart != null) {
            for (int i = 0; i < this.gtitle.length; ++i) {
                TextTitle t = new TextTitle(this.gtitle[i]);
                t.setPaint((Paint)this.annotationcolor);
                this.chart.addSubtitle((Title)t);
            }
        }
    }

    @Override
    public void setAnnotationColor(Color c) {
        this.annotationcolor = c;
        this.resetGraphAnnotationColor();
    }

    private void resetTitleAnnotationColor() {
        JFreeChart chrt = this.getChart();
        if (chrt != null && this.gtitle != null) {
            chrt.getTitle().setPaint((Paint)this.annotationcolor);
            for (int i = 0; i < this.gtitle.length; ++i) {
                TextTitle t = new TextTitle(this.gtitle[i]);
                t.setPaint((Paint)this.annotationcolor);
                chrt.addSubtitle((Title)t);
            }
        }
    }

    private void resetXAxisAnnotationColor() {
        JFreeChart chrt = this.getChart();
        if (chrt != null) {
            chrt.getXYPlot().getDomainAxis().setLabelPaint((Paint)this.annotationcolor);
            chrt.getXYPlot().getDomainAxis().setTickLabelPaint((Paint)this.annotationcolor);
        }
    }

    private void resetYAxisAnnotationColor() {
        JFreeChart chrt = this.getChart();
        if (chrt != null) {
            chrt.getXYPlot().getRangeAxis().setLabelPaint((Paint)this.annotationcolor);
            chrt.getXYPlot().getRangeAxis().setTickLabelPaint((Paint)this.annotationcolor);
        }
    }

    private void resetGraphAnnotationColor() {
        this.resetTitleAnnotationColor();
        this.resetXAxisAnnotationColor();
        this.resetYAxisAnnotationColor();
    }

    private void resetCurveColors() {
        JFreeChart chrt = this.getChart();
        GraphObject go = this.getGraphObject();
        if (chrt != null && go != null) {
            int count = chrt.getXYPlot().getSeriesCount();
            for (int i = 0; i < count; ++i) {
                chrt.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)go.getCurveColor(i + 1));
            }
        }
    }

    public void setDataset(Dataset datas) {
        this.dataset = datas;
        if (datas instanceof XYDataset) {
            this.getChart().getXYPlot().setDataset((XYDataset)this.dataset);
        } else if (datas instanceof IntervalXYDataset) {
            this.getChart().getXYPlot().setDataset((XYDataset)this.dataset);
        }
    }

    @Override
    public String[] getGraphTitle() {
        return this.gtitle;
    }

    @Override
    public JFreeChart getChart() {
        return this.chart;
    }

    @Override
    public GraphObject getGraphObject() {
        return this.gobj;
    }

    @Override
    public void setGraphXAxisLabel(String label) {
        this.xAxisLabel = label;
        JFreeChart c = this.getChart();
        if (c != null) {
            c.getXYPlot().getDomainAxis().setLabel(label);
            c.getXYPlot().getDomainAxis().setLabelPaint((Paint)this.titlecolor);
        }
    }

    @Override
    public void setGraphYAxisLabel(String label) {
        this.yAxisLabel = label;
        JFreeChart c = this.getChart();
        if (c != null) {
            c.getXYPlot().getRangeAxis().setLabel(label);
            c.getXYPlot().getRangeAxis().setLabelPaint((Paint)this.titlecolor);
        }
    }

    @Override
    public String getGraphXAxisLabel() {
        return this.xAxisLabel;
    }

    @Override
    public String getGraphYAxisLabel() {
        return this.yAxisLabel;
    }

    @Override
    public void setGraphOrientation(PlotOrientation o) {
        this.orientation = o;
        this.getChart().getXYPlot().setOrientation(this.orientation);
    }

    @Override
    public void setXAxisMarker(int index, Marker m) {
        this.xmarkers.put(index, m);
        if (this.xmarkercolors.get(index) != null) {
            Color markercolor = (Color)this.xmarkercolors.get(index);
            m.setPaint((Paint)markercolor);
        }
        if (this.markerstroke != null) {
            m.setStroke(this.markerstroke);
        }
        if (this.getChart() != null) {
            this.getChart().getXYPlot().addDomainMarker(m, Layer.BACKGROUND);
        }
    }

    @Override
    public void setYAxisMarker(int index, Marker m) {
        this.ymarkers.put(index, m);
        if (this.ymarkercolors.get(index) != null) {
            Color markercolor = (Color)this.ymarkercolors.get(index);
            m.setPaint((Paint)markercolor);
        }
        if (this.markerstroke != null) {
            m.setStroke(this.markerstroke);
        }
        if (this.getChart() != null) {
            this.getChart().getXYPlot().addRangeMarker(m, Layer.BACKGROUND);
        }
    }

    @Override
    public Marker getXAxisMarker(int index) {
        return (Marker)this.xmarkers.get(index);
    }

    @Override
    public Marker[] getAllxaxisMarkers() {
        Marker[] allxmarkers = new Marker[this.xmarkers.size()];
        for (int i = 0; i < this.xmarkers.size(); ++i) {
            allxmarkers[i] = (Marker)this.xmarkers.get(i);
        }
        return allxmarkers;
    }

    public Marker[] getAllyaxisMarkers() {
        Marker[] allymarkers = new Marker[this.ymarkers.size()];
        for (int i = 0; i < this.ymarkers.size(); ++i) {
            allymarkers[i] = (Marker)this.ymarkers.get(i);
        }
        return allymarkers;
    }

    @Override
    public Marker getYAxisMarker(int index) {
        return (Marker)this.ymarkers.get(index);
    }

    @Override
    public void setXAxisMarkerColor(int index, Color c) {
        this.xmarkercolors.put(index, c);
        if (this.xmarkers.get(index) != null) {
            Marker xmarker = (Marker)this.xmarkers.get(index);
            xmarker.setPaint((Paint)c);
        }
    }

    @Override
    public void setYAxisMarkerColor(int index, Color c) {
        this.ymarkercolors.put(index, c);
        if (this.ymarkers.get(index) != null) {
            Marker ymarker = (Marker)this.ymarkers.get(index);
            ymarker.setPaint((Paint)c);
        }
    }

    @Override
    public void clearAllYAxisMarkers() {
        if (this.getChart() != null) {
            this.getChart().getXYPlot().clearRangeMarkers();
        }
        this.ymarkers.clear();
    }

    @Override
    public void clearAllXAxisMarkers() {
        if (this.getChart() != null) {
            this.getChart().getXYPlot().clearDomainMarkers();
        }
        this.xmarkers.clear();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GraphObject Type: ");
        buffer.append(this.getClass().getSimpleName());
        return buffer.toString();
    }

    public final void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    public final void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public final void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }
}

