/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.laf.hds;

import com.ge.med.cse.cvf.laf.AbstractNumberedThumSliderUI;
import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class HDSSliderUI
extends BasicSliderUI
implements AbstractNumberedThumSliderUI {
    private JSlider sliderComp = null;
    private boolean cineSlider = false;

    public HDSSliderUI(JSlider slider) {
        super(slider);
        this.sliderComp = slider;
    }

    @Override
    public void enableCineSlider(boolean cineSldr) {
        this.cineSlider = cineSldr;
    }

    public boolean isCineSlider() {
        return this.cineSlider;
    }

    @Override
    public Rectangle getThumbRect() {
        return this.thumbRect;
    }

    @Override
    public Rectangle getTrackRect() {
        return this.trackRect;
    }

    @Override
    public int xPositionForValue(int v) {
        return super.xPositionForValue(v);
    }

    @Override
    public int yPositionForValue(int v) {
        return super.yPositionForValue(v);
    }

    @Override
    public void paintThumb(Graphics g) {
        super.paintThumb(g);
        if (!this.isCineSlider()) {
            Graphics2D g2 = (Graphics2D)g;
            Rectangle knobBounds = this.getThumbRect();
            int w = knobBounds.width;
            int h = knobBounds.height;
            g2.translate(knobBounds.x, knobBounds.y);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int max = this.sliderComp.getMaximum();
            int val = max > 0 ? max - this.sliderComp.getValue() + 1 : max;
            String valString = "" + val;
            Font defFont = LookAndFeelFactory.getFont(null, "Slider.font");
            if (defFont != null) {
                g2.setFont(defFont);
                FontRenderContext frc = g2.getFontRenderContext();
                Rectangle2D bounds = defFont.getStringBounds(valString, frc);
                float x = (float)((double)w - bounds.getWidth()) / 2.0f;
                float y = (float)((double)h + bounds.getHeight()) / 2.0f;
                g2.drawString(valString, x - 2.0f, y - 4.0f);
            }
        }
    }

    @Override
    public int getTrackWidth() {
        double kIdealTrackWidth = 7.0;
        double kIdealThumbHeight = 16.0;
        double kWidthScalar = 0.4375;
        if (this.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)this.thumbRect.height);
        }
        return (int)(0.4375 * (double)this.thumbRect.width);
    }

    @Override
    public Dimension getThumbSize() {
        if (!this.isCineSlider()) {
            Dimension size = new Dimension();
            if (this.slider.getOrientation() == 1) {
                size.width = 35;
                size.height = 22;
            } else {
                size.width = 40;
                size.height = 20;
            }
            return size;
        }
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 0) {
            size.width = 15;
            size.height = 12;
        }
        return size;
    }
}

