/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.laf;

import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;

public class RowColumnListUI
extends ListUI {
    static final int CELL_SIZE = 20;

    public static ComponentUI createUI(JComponent c) {
        return new RowColumnListUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = ((ListDataModel)((JList)c).getModel()).getDimension();
        return new Dimension(20 * dim.width, 20 * dim.height);
    }

    public Rectangle getCellBounds(JList list, int index1, int index2) {
        ListDataModel model = (ListDataModel)list.getModel();
        Dimension shown = model.getDimension();
        Dimension s = list.getSize();
        Insets i = list.getInsets();
        int index = Math.max(index1, index2);
        int r = index / shown.width;
        int c = index % shown.width;
        return new Rectangle(Math.round(c * 20), Math.round(r * 20), Math.round((c + 1) * 20), Math.round((r + 1) * 20));
    }

    public Point indexToLocation(JList list, int index) {
        return this.getCellBounds(list, index, index).getLocation();
    }

    public int locationToIndex(JList list, Point location) {
        ListDataModel model = (ListDataModel)list.getModel();
        Dimension shown = model.getDimension();
        Dimension s = list.getSize();
        Insets i = list.getInsets();
        double[] cellSize = new double[]{(double)(s.width - (i.left + i.right)) / (double)shown.width, (double)(s.height - (i.top + i.bottom)) / (double)shown.height};
        int c = (int)Math.floor((double)(location.x - i.left) / cellSize[0]);
        int r = (int)Math.floor((double)(location.y - i.top) / cellSize[1]);
        return r * shown.width + c;
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        super.paint(g, component);
        JList list = (JList)component;
        ListDataModel model = (ListDataModel)list.getModel();
        Dimension shown = model.getDimension();
        Dimension actual = model.getSelected();
        Dimension s = list.getSize();
        Insets i = list.getInsets();
        double[] cellSize = new double[]{(double)(s.width - (i.left + i.right)) / (double)shown.width, (double)(s.height - (i.top + i.bottom)) / (double)shown.height};
        for (int r = 0; r < shown.height; ++r) {
            for (int c = 0; c < shown.width; ++c) {
                Color color;
                Color color2 = color = r < actual.height && c < actual.width ? LookAndFeelFactory.getColor("ListUI.selection.color", "P9") : LookAndFeelFactory.getColor("ListUI.color", "P2");
                if (color != null) {
                    g.setColor(color);
                }
                g.fillRect((int)Math.round((double)c * cellSize[0]), (int)Math.round((double)r * cellSize[1]), (int)Math.round((double)(c + 1) * cellSize[0]), (int)Math.round((double)(r + 1) * cellSize[1]));
                g.setColor(LookAndFeelFactory.getColor("ListUI.cellSeparator.color", "P3"));
                g.drawRect((int)Math.round((double)c * cellSize[0]), (int)Math.round((double)r * cellSize[1]), (int)Math.round((double)(c + 1) * cellSize[0]), (int)Math.round((double)(r + 1) * cellSize[1]));
            }
        }
    }

    public static class ListDataModel
    implements ListModel {
        protected Dimension selected_ = new Dimension(1, 1);
        protected Dimension dimension_ = new Dimension(2, 2);
        protected List listeners_ = new ArrayList();

        public ListDataModel(Dimension dimension) {
            this.selected_ = new Dimension(dimension.width, dimension.height);
            this.dimension_ = new Dimension(dimension.width, dimension.height);
        }

        public ListDataModel() {
            this(new Dimension(1, 1));
        }

        public Dimension getSelected() {
            return this.selected_;
        }

        public void setSelected(Dimension selected) {
            this.selected_ = new Dimension(selected.width, selected.height);
            if (this.selected_.width > this.dimension_.width || this.selected_.height > this.dimension_.height) {
                this.dimension_ = new Dimension(Math.max(this.selected_.width, this.dimension_.width), Math.max(this.selected_.height, this.dimension_.height));
            }
            this.fireListDataChanged();
        }

        public Dimension getDimension() {
            return this.dimension_;
        }

        public void setDimension(Dimension dimension) {
            this.dimension_ = new Dimension(dimension.width, dimension.height);
            if (this.selected_.width > this.dimension_.width || this.selected_.height > this.dimension_.height) {
                this.selected_ = new Dimension(Math.min(this.selected_.width, this.dimension_.width), Math.min(this.selected_.height, this.dimension_.height));
            }
            this.fireListDataChanged();
        }

        protected void fireListDataChanged() {
            ListDataEvent event = new ListDataEvent(this, 0, 0, this.getSize() - 1);
            Iterator i = this.listeners_.iterator();
            while (i.hasNext()) {
                ((ListDataListener)i.next()).contentsChanged(event);
            }
        }

        @Override
        public int getSize() {
            return this.dimension_.width * this.dimension_.height;
        }

        public Object getElementAt(int index) {
            return new Dimension(index % this.dimension_.width + 1, index / this.dimension_.width + 1);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners_.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners_.remove(l);
        }
    }
}

