/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.laf;

import com.ge.med.cse.cvf.util.CvUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class LookAndFeelFactory {
    private static Map<String, Map<String, String>> LOOK_AND_FEEL_MAP = new HashMap<String, Map<String, String>>();
    private static String DEFAULT_PROP_FILE = "Default_LNFProps.properties";
    private static String LNFNAMELOOKUP_FILE = "LNFNameLookUp.properties";
    private static String DEFAULT_LNF_NAME = "defaultLNF";
    private static String LNF_EXT_PROP_FILE = "cvf.LookAndFeel.File";

    private static String getLnfClass() {
        if (null != UIManager.getLookAndFeel().getClass().getSimpleName()) {
            return UIManager.getLookAndFeel().getClass().getSimpleName();
        }
        return DEFAULT_LNF_NAME;
    }

    private static void loadProperties() {
        String propFileName = LookAndFeelFactory.getPropFileName();
        Properties LnFprops = new Properties();
        LookAndFeelFactory.loadDefaultProperties(propFileName, LnFprops);
        LookAndFeelFactory.loadLnfExtPropFileProps(LnFprops);
        LookAndFeelFactory.populateLNFMap(LnFprops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDefaultProperties(String propFileName, Properties LnFprops) {
        if (null != propFileName) {
            InputStream in = null;
            try {
                in = LookAndFeelFactory.class.getResourceAsStream(propFileName);
                if (null != in) {
                    LnFprops.load(in);
                } else {
                    in = LookAndFeelFactory.class.getResourceAsStream(DEFAULT_PROP_FILE);
                    if (null != in) {
                        LnFprops.load(in);
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void loadProperties(Properties propToLoad) {
        if (propToLoad == null) {
            return;
        }
        try {
            Properties LnFprops = new Properties();
            LnFprops.putAll((Map<?, ?>)propToLoad);
            LookAndFeelFactory.populateLNFMap(LnFprops);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void loadPropertyValues(InputStream lnfFileStream) {
        if (lnfFileStream == null) {
            return;
        }
        try {
            Properties LnFprops = new Properties();
            LnFprops.load(lnfFileStream);
            LookAndFeelFactory.populateLNFMap(LnFprops);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void loadAndPopulate_LNFExtPropFile_Properties() {
        String LnFFileLoc = System.getProperty(LNF_EXT_PROP_FILE);
        if (null == LnFFileLoc) {
            return;
        }
        Properties LnFprops = new Properties();
        LookAndFeelFactory.loadLnfExtPropFileProps(LnFprops);
        LookAndFeelFactory.populateLNFMap(LnFprops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLnfExtPropFileProps(Properties LnFprops) {
        if (LnFprops == null) {
            return;
        }
        String LnFFileLoc = System.getProperty(LNF_EXT_PROP_FILE);
        if (null != LnFFileLoc) {
            File LnfFile = new File(LnFFileLoc);
            FileInputStream lnfFileStream = null;
            if (LnfFile.exists()) {
                try {
                    lnfFileStream = new FileInputStream(LnfFile);
                    LnFprops.load(lnfFileStream);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (lnfFileStream != null) {
                            ((InputStream)lnfFileStream).close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void populateLNFMap(Properties LnFprops) {
        if (null != LnFprops && LnFprops.size() > 0) {
            HashMap<Object, Object> LnFMap = new HashMap<Object, Object>();
            LnFMap.putAll(LnFprops);
            if (LookAndFeelFactory.getLnfClass() != null) {
                if (LOOK_AND_FEEL_MAP.get(LookAndFeelFactory.getLnfClass()) != null) {
                    Map<String, String> lnf_existingPropsValue = LOOK_AND_FEEL_MAP.get(LookAndFeelFactory.getLnfClass());
                    lnf_existingPropsValue.putAll(LnFMap);
                    LOOK_AND_FEEL_MAP.put(LookAndFeelFactory.getLnfClass(), lnf_existingPropsValue);
                } else {
                    LOOK_AND_FEEL_MAP.put(LookAndFeelFactory.getLnfClass(), LnFMap);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPropFileName() {
        String lnfClass = LookAndFeelFactory.getLnfClass();
        String lnfClassName = null;
        Properties lnfFileNameMap = new Properties();
        InputStream in = LookAndFeelFactory.class.getResourceAsStream(LNFNAMELOOKUP_FILE);
        if (null != in) {
            try {
                lnfFileNameMap.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (lnfFileNameMap.size() > 0) {
            lnfClassName = (String)lnfFileNameMap.get(lnfClass);
        }
        if (null != lnfClassName) {
            String lnfClassPropFileName = lnfClassName + "_props.properties";
            return lnfClassPropFileName;
        }
        return DEFAULT_PROP_FILE;
    }

    public static boolean setupLAFclass(String className) {
        try {
            Class.forName(className);
            UIManager.setLookAndFeel(className);
            LookAndFeelFactory.loadProperties();
            return true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Class getClass(String compName) {
        String propClassName = LookAndFeelFactory.getPropertyValue(compName);
        Class propClass = null;
        if (propClassName != null) {
            try {
                propClass = CvUtils.getClass(propClassName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return propClass;
        }
        return null;
    }

    public static String getPropertyValue(String compName) {
        if (null != compName) {
            if (LOOK_AND_FEEL_MAP.size() <= 0 || !LOOK_AND_FEEL_MAP.containsKey(LookAndFeelFactory.getLnfClass())) {
                LookAndFeelFactory.loadProperties();
            }
            Map<String, String> LnFPropMap = null;
            LnFPropMap = LOOK_AND_FEEL_MAP.get(LookAndFeelFactory.getLnfClass());
            if (null != LnFPropMap) {
                String propClass = LnFPropMap.get(compName);
                return propClass;
            }
        }
        return null;
    }

    public static Border getBorder(String compName, String defaultName) {
        String propClass = LookAndFeelFactory.getPropertyValue(compName);
        Border border = null;
        if (propClass != null) {
            if (propClass.equalsIgnoreCase("null")) {
                return null;
            }
            try {
                Class compClass = CvUtils.getClass(propClass);
                border = (Border)compClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return border;
        }
        if (null != defaultName) {
            Border b = UIManager.getBorder(defaultName);
            return b;
        }
        return null;
    }

    public static JButton getButton(String compName) {
        String propClass = LookAndFeelFactory.getPropertyValue(compName);
        JButton button = null;
        if (propClass != null) {
            try {
                Class compClass = CvUtils.getClass(propClass);
                button = (JButton)compClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return button;
        }
        return null;
    }

    public static Font getFont(String propName, String defaultName) {
        String fontName = LookAndFeelFactory.getPropertyValue(propName);
        String regx = "*,*,*";
        if (null != fontName) {
            ArrayList<String> FontSpecifics = new ArrayList<String>();
            if (fontName.matches(regx)) {
                StringTokenizer st = new StringTokenizer(fontName, ",", false);
                int style = -1;
                int size = -1;
                while (st.hasMoreTokens()) {
                    FontSpecifics.add(st.nextToken());
                }
                style = Integer.parseInt((String)FontSpecifics.get(1));
                size = Integer.parseInt((String)FontSpecifics.get(2));
                FontUIResource f = new FontUIResource((String)FontSpecifics.get(0), style, size);
                return f;
            }
        } else if (null != defaultName) {
            Font f = (Font)UIManager.get(defaultName);
            return f;
        }
        return null;
    }

    public static Insets getInsets(String propName, String defaultName) {
        String insetName = LookAndFeelFactory.getPropertyValue(propName);
        if (null != insetName) {
            List<String> insetDimList = Arrays.asList(insetName.split(","));
            if (insetDimList.size() == 4) {
                int top = Integer.parseInt(insetDimList.get(0));
                int left = Integer.parseInt(insetDimList.get(1));
                int bottom = Integer.parseInt(insetDimList.get(2));
                int right = Integer.parseInt(insetDimList.get(3));
                InsetsUIResource inset = new InsetsUIResource(top, left, bottom, right);
                return inset;
            }
        } else if (null != defaultName) {
            Insets f = (Insets)UIManager.get(defaultName);
            return f;
        }
        return null;
    }

    public static Color getColor(String propName, String defaultName) {
        String propValue = LookAndFeelFactory.getPropertyValue(propName);
        Color compColor = null;
        if (propValue != null) {
            if (propValue.equalsIgnoreCase("null")) {
                return null;
            }
            compColor = Color.decode(propValue);
            return compColor;
        }
        if (null != defaultName) {
            Color b = UIManager.getColor(defaultName);
            return b;
        }
        return null;
    }

    static {
        LookAndFeelFactory.loadProperties();
    }
}

