/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnQuaternion;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.logging.Level;

public class VavRotateBatchModel
extends VavBatchModel {
    public static final String CENTER_POINT_PROPERTY = "CENTER_POINT_PROPERTY";
    public static final String INITIAL_NORMAL_PROPERTY = "INITIAL_NORMAL_VECTOR_PROPERTY";
    public static final String ROTATE_DIRECTION_PROPERTY = "ROTATE_DIRECTION_PROPERTY";
    public static final String ANGLE_BETWEEN_VIEWS_PROPERTY = "ANGLE_BETWEEN_VIEWS_PROPERTY";
    protected XjVolumeGeometry targetVolume = null;
    protected XjVolumeModel targetVolumeModel = null;
    protected T3DViewport targetViewport = null;
    protected boolean initalized_ = false;
    protected JnVector3d rasOrig = new JnVector3d();
    protected JnVector3d rside = new JnVector3d();
    protected JnVector3d aside = new JnVector3d();
    protected JnVector3d sside = new JnVector3d();
    protected CPoint volCenter = new CPoint(2);
    protected CTransform vox2ras = new CTransform();
    protected CTransform ras2vox = new CTransform();
    protected double tilt = 0.0;
    protected String initialImagePlane = null;
    protected CPoint initialUpVec = null;
    protected JnVector3d rightVec = new JnVector3d();
    protected JnVector3d rotateDirectionVec = new JnVector3d();
    protected JnVector3d rotateAxisVec = new JnVector3d();
    protected JnQuaternion rotateQuat = new JnQuaternion();
    protected int numImages = 0;
    protected CPoint center = null;
    protected CPoint initialNormal = null;
    protected double angle = 18.0;
    protected String rotateDirection = "right";
    protected boolean rotate3DMode = false;
    protected boolean alignedToVolume = true;
    protected String refViewPlane = null;
    protected boolean updateDirty = true;
    private final boolean useImageDims = CvPropertiesManager.getBoolean("vav.pixeldim.useinputimagedim", false);
    public static final double MAX_THICKNESS_FACTOR = 32.0;
    private VVBatchProtocol cachedProtocol = null;
    private PropertyChangeListener renderStyleListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VavRotateBatchModel.this.isPortMode3D()) {
                VavRotateBatchModel.this.set3DRotationMode(true);
                VavRotateBatchModel.this.setRenderStyle(VavRotateBatchModel.this.targetViewport.getRenderStyle());
            } else {
                VavRotateBatchModel.this.set3DRotationMode(false);
                VavRotateBatchModel.this.setRenderStyle(VavRotateBatchModel.this.renderStyle);
            }
        }
    };
    private PropertyChangeListener viewTypeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ViewTypeCapable vcap;
            if (VavRotateBatchModel.this.isPortMode3D() && (vcap = (ViewTypeCapable)VavRotateBatchModel.this.targetViewport.getCapable(ViewTypeCapable.class.getName())) != null) {
                boolean link = vcap.getViewType(vcap.getViewType()).isViewLinkable();
                VavRotateBatchModel.this.detachListeners();
                if (link) {
                    VavRotateBatchModel.this.attachListeners();
                }
            }
        }
    };
    private PropertyChangeListener fovListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VavRotateBatchModel.this.isPortMode3D()) {
                VavRotateBatchModel.this.setFov(VavRotateBatchModel.this.targetViewport.getViewHeight());
            }
        }
    };
    private PropertyChangeListener upVecListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VavRotateBatchModel.this.isPortMode3D()) {
                VavRotateBatchModel.this.applyContrainingVolumeFor3DMode();
            }
        }
    };
    private PropertyChangeListener lookPtListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VavRotateBatchModel.this.isPortMode3D()) {
                VavRotateBatchModel.this.applyContrainingVolumeFor3DMode();
            }
        }
    };
    private PropertyChangeListener eyePtListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VavRotateBatchModel.this.isPortMode3D()) {
                VavRotateBatchModel.this.applyContrainingVolumeFor3DMode();
            }
        }
    };
    PropertyChangeListener cameraListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VavRotateBatchModel.this.targetViewport instanceof J3DViewport && ((J3DViewport)VavRotateBatchModel.this.targetViewport).getViewType().equalsIgnoreCase("3D")) {
                double[] look = VavRotateBatchModel.this.targetViewport.getLookPoint(null);
                double[] eye = VavRotateBatchModel.this.targetViewport.getEyePoint(null);
                VavRotateBatchModel.this.setCenter(new CPoint(look, 2));
                VavRotateBatchModel.this.setInitialNormal(new CPoint(eye[0] - look[0], eye[1] - look[1], eye[2] - look[2], 2));
            }
        }
    };
    private CPoint normalVec = new CPoint();
    private JnVector3d upVec = new JnVector3d();

    public VavRotateBatchModel() {
    }

    public VavRotateBatchModel(ROTATION_MODE mode) {
        if (null == mode) {
            mode = ROTATION_MODE.ROTATE_FAN;
        }
        switch (mode) {
            case ROTATE_FAN: {
                this.set3DRotationMode(false);
                this.logger.log(Level.INFO, "RotateBatchModel initialized in Rotate(fan) mode");
                break;
            }
            case ROTATE_3D: {
                this.set3DRotationMode(true);
                this.logger.log(Level.INFO, "RotateBatchModel initialized in 3D mode");
            }
        }
    }

    public VavRotateBatchModel(CPoint center, CPoint initialNormal, String rotateDirection, double fov, int numImages) {
        String msg;
        if (fov < 0.0) {
            msg = "Attempting to set invalid fov (" + fov + "). FOV must be greater than zero. Converting to a positive value.";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            fov = -fov;
        }
        this.fov = fov;
        if (numImages < -1) {
            msg = "Attempting to set invalid number of images (" + numImages + "). Number of images must be greater than one. Converting to a positive value.";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            numImages = -numImages;
        }
        this.numImages = numImages;
        this.center = center;
        this.initialNormal = initialNormal;
        this.rotateDirection = rotateDirection;
    }

    public VavRotateBatchModel(VVBatchProtocol protocol) {
        this.loadFromProtocol(protocol);
    }

    @Override
    public void loadFromProtocol(VVBatchProtocol protocol) {
        if (!"fan".equals(protocol.model) && !"Rotation".equals(protocol.model)) {
            String msg = "Trying to load Rotate model with a protocol of type " + protocol.model + ".";
            this.logger.log(Level.INFO, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            return;
        }
        if (protocol.viewName == null && this.targetViewport == null) {
            String msg = "Trying to load Rotate model with a protocol with no reference view";
            this.logger.log(Level.INFO, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
        }
        if (this.isPortMode3D() || !this.isTargetSet() && "3D".equals(protocol.viewName)) {
            this.logger.log(Level.INFO, "Protocol loading in 3D mode");
            this.set3DRotationMode(true);
        } else {
            this.logger.log(Level.INFO, "Protocol loading in Fan mode");
            this.set3DRotationMode(false);
        }
        this.seriesDescription = protocol.name;
        this.fov = protocol.fieldOfView * 10.0;
        if (this.fov < 0.0) {
            this.fov = -this.fov;
        }
        this.thickness = protocol.thickness;
        if (protocol.voxelSize > 0.0) {
            this.thickness *= protocol.voxelSize;
        }
        this.numImages = protocol.numberOfViews;
        if (this.numImages < 0) {
            this.numImages = -this.numImages;
        }
        if (protocol.autoFilming != null && protocol.autoFilming.equalsIgnoreCase("On") || protocol.autoFilming == null || protocol.autoFilming.equalsIgnoreCase("Off")) {
            // empty if block
        }
        if (this.center == null) {
            this.center = new CPoint();
        }
        this.center.setPoint(protocol.centerX, protocol.centerY, 0.0, (byte)3);
        if (this.initialUpVec == null) {
            this.initialUpVec = new CPoint();
        }
        this.initialUpVec.setPoint(protocol.vectorX, protocol.vectorY, 0.0, (byte)1);
        this.initialNormal = null;
        this.initialImagePlane = null;
        boolean reverse = protocol.rotation < 0.0;
        this.angle = Math.abs(protocol.rotation);
        this.rotateDirection = this.is3DRotationMode() ? protocol.rotateDirection : (reverse ? "down" : "up");
        this.renderStyle = protocol.getT3DRenderStyle();
        if (protocol.autoFilming != null && protocol.autoFilming.equals("On") || protocol.autoFilming == null || protocol.autoFilming.equals("Off")) {
            // empty if block
        }
        if (this.targetViewport == null) {
            if (protocol.viewName != null && protocol.viewName.toLowerCase(Locale.ENGLISH).contains("Coronal".toLowerCase(Locale.ENGLISH))) {
                this.refViewPlane = "OB_CORONAL";
            } else if (protocol.viewName != null && protocol.viewName.toLowerCase(Locale.ENGLISH).contains("Sagittal".toLowerCase(Locale.ENGLISH))) {
                this.refViewPlane = "OB_SAGITTAL";
            } else if (protocol.viewName != null && protocol.viewName.toLowerCase(Locale.ENGLISH).contains("Axial".toLowerCase(Locale.ENGLISH))) {
                this.refViewPlane = "OB_AXIAL";
            }
        }
        this.cachedProtocol = null;
        System.err.println("Protocol loaded with vaules\nDescription: " + protocol.name + "\n" + "View Name: " + protocol.viewName + "\n" + "Model: " + protocol.model + "\n" + "Rotation: " + protocol.rotation + "\n" + "NumberOfViews: " + protocol.numberOfViews + "\n" + "FieldOfView: " + protocol.fieldOfView + "\n" + "spacing: " + protocol.spacing + "\n" + "thickness: " + protocol.thickness + "\n" + "CenterX: " + protocol.centerX + "\n" + "centerY: " + protocol.centerY + "\n" + "vectorX: " + protocol.vectorX + "\n" + "vectorY: " + protocol.vectorY + "\n" + "voxelSize: " + protocol.voxelSize + "\n" + "renderMode: " + protocol.renderMode + "\n" + "End of Protocol");
        this.applyContrainingVolume();
    }

    @Override
    public void saveToProtocol(VVBatchProtocol protocol) {
        protocol.model = this.is3DRotationMode() ? "Rotation" : "fan";
        protocol.rotation = !this.is3DRotationMode() && this.getRotateDirection().equals("down") ? -this.getAngleBetweenViews() : this.getAngleBetweenViews();
        protocol.numberOfViews = this.getNumImages();
        protocol.thickness = this.getThickness();
        protocol.fieldOfView = this.getFov() / 10.0;
        protocol.name = this.getSeriesDescription();
        protocol.voxelSize = 1.0;
        protocol.viewName = "";
        if (this.targetViewport != null) {
            ViewTypeCapable vtcap = (ViewTypeCapable)this.targetViewport.getCapable(ViewTypeCapable.class.getName());
            if (vtcap != null) {
                String vname = vtcap.getViewType();
                if (vname.contains("AXIAL")) {
                    protocol.viewName = "Axial";
                } else if (vname.contains("CORONAL")) {
                    protocol.viewName = "Coronal";
                } else if (vname.contains("SAGITTAL")) {
                    protocol.viewName = "Sagittal";
                } else if (vname.contains("3D")) {
                    protocol.viewName = "3D";
                }
            }
            CPoint center = this.getCenter();
            CPoint up = new CPoint(this.initialUpVec);
            up.add(center);
            this.targetViewport.getT3DComponent().getTransform((byte)2, (byte)1).transform(up);
            this.targetViewport.getT3DComponent().getTransform((byte)2, (byte)1).transform(center);
            up.sub(center);
            up.normalize();
            protocol.centerX = center.x / (double)this.targetViewport.getWidth();
            protocol.centerY = center.y / (double)this.targetViewport.getHeight();
            protocol.vectorX = up.x;
            protocol.vectorY = up.y;
        } else if (this.refViewPlane != null && this.targetVolume != null) {
            CTransform disp2ras = this.getDispToRASTransform();
            CTransform ras2Disp = disp2ras.inverse();
            String vname = this.refViewPlane;
            if (vname != null) {
                if (vname.contains("AXIAL")) {
                    protocol.viewName = "Axial";
                } else if (vname.contains("CORONAL")) {
                    protocol.viewName = "Coronal";
                } else if (vname.contains("SAGITTAL")) {
                    protocol.viewName = "Sagittal";
                } else if (vname.contains("3D")) {
                    protocol.viewName = "3D";
                }
            }
            CPoint center = this.getCenter();
            CPoint up = new CPoint(this.initialUpVec);
            up.add(center);
            ras2Disp.transform(up);
            ras2Disp.transform(center);
            up.sub(center);
            up.normalize();
            protocol.centerX = center.x / 512.0;
            protocol.centerY = center.y / 512.0;
            protocol.vectorX = up.x;
            protocol.vectorY = up.y;
        }
        System.err.println("VavRectPrismBatchModel.SaveToProtocol. Protocol Saved with vaules\nDescription: " + protocol.name + "\n" + "View Name: " + protocol.viewName + "\n" + "Model: " + protocol.model + "\n" + "Rotation: " + protocol.rotation + "\n" + "NumberOfViews: " + protocol.numberOfViews + "\n" + "FieldOfView: " + protocol.fieldOfView + "\n" + "spacing: " + protocol.spacing + "\n" + "thickness: " + protocol.thickness + "\n" + "CenterX: " + protocol.centerX + "\n" + "centerY: " + protocol.centerY + "\n" + "vectorX: " + protocol.vectorX + "\n" + "vectorY: " + protocol.vectorY + "\n" + "voxelSize: " + protocol.voxelSize + "\n" + "renderMode: " + protocol.renderMode + "\n" + "End of Protocol");
        protocol.rotateDirection = this.getRotateDirection();
        protocol.renderMode = this.getProtocolRenderStyle();
    }

    public synchronized CPoint getCenter() {
        return new CPoint(this.center);
    }

    public synchronized CPoint getInitialNormal() {
        return new CPoint(this.initialNormal);
    }

    public synchronized String getRotateDirection() {
        return this.rotateDirection;
    }

    public synchronized double getAngleBetweenViews() {
        return this.angle;
    }

    @Override
    public synchronized int getNumImages() {
        return this.numImages;
    }

    @Override
    public String getBatchType() {
        return "Rotate";
    }

    public boolean is3DRotationMode() {
        return this.rotate3DMode;
    }

    public void set3DRotationMode(boolean rotate3D) {
        if (this.rotate3DMode != rotate3D) {
            this.rotate3DMode = rotate3D;
            this.applyContrainingVolume();
        }
    }

    @Override
    public void setRenderStyle(String renderStyle) {
        String style = this.checkRenderStyle(renderStyle);
        if (!renderStyle.equals(style)) {
            this.logger.log(Level.WARNING, "Invalid render style " + renderStyle + " , Changed it to " + style);
        }
        super.setRenderStyle(style);
    }

    private String checkRenderStyle(String renderStyle) {
        boolean cubic;
        if (!this.initalized_) {
            return renderStyle;
        }
        if (this.rotate3DMode) {
            if (this.isPortMode3D()) {
                return this.targetViewport.getRenderStyle();
            }
            if ("VOLUME".equals(renderStyle) || "FULLBODY_MINIP".equals(renderStyle) || "FULLBODY_MIP".equals(renderStyle)) {
                return renderStyle;
            }
            if ("MAJOR_AXIS_MIP".equals(renderStyle) || "MIP".equals(renderStyle)) {
                return "FULLBODY_MIP";
            }
            if ("MAJOR_AXIS_MINIP".equals(renderStyle) || "MINIP".equals(renderStyle)) {
                return "FULLBODY_MINIP";
            }
            if ("MAJOR_AXIS_AVERAGE".equals(renderStyle) || "AVERAGE".equals(renderStyle) || "FULLBODY_AVERAGE".equals(renderStyle)) {
                return "FULLBODY_MIP";
            }
            return "FULLBODY_MIP";
        }
        boolean bl = cubic = VVBatchProtocol.defaultRenderingQuality() == 2;
        if ("FULLBODY_MIP".equals(renderStyle) || "VOLUME".equals(renderStyle)) {
            return cubic ? "MAJOR_AXIS_MIP" : "MIP";
        }
        if ("FULLBODY_MINIP".equals(renderStyle)) {
            return cubic ? "MAJOR_AXIS_MINIP" : "MINIP";
        }
        if ("FULLBODY_AVERAGE".equals(renderStyle)) {
            return cubic ? "MAJOR_AXIS_AVERAGE" : "AVERAGE";
        }
        return renderStyle;
    }

    public synchronized void setCenter(CPoint center) {
        CPoint oldcenter;
        CPoint cPoint = oldcenter = this.center == null ? null : new CPoint(this.center);
        if (this.center == null) {
            this.center = new CPoint();
        }
        if (this.initalized_) {
            if (this.is3DRotationMode()) {
                if (this.isPortMode3D()) {
                    double[] look = this.targetViewport.getLookPoint(null);
                    this.center.setPoint(look[0], look[1], look[2], (byte)2);
                } else {
                    this.center.setPoint(this.volCenter);
                }
            } else if (this.getCenterOnVolume() || this.getFitToVolume()) {
                this.center.setPoint(this.volCenter);
            } else {
                this.center.setPoint(center);
            }
        } else {
            this.center.setPoint(center);
        }
        if (this.initalized_ && !this.is3DRotationMode()) {
            int[] dims = this.targetVolume.getVolumeDimensions(null);
            if (!J3DGeomUtils.isInVolume(this.center.generateArray(), dims, this.ras2vox)) {
                CPoint newCenter = oldcenter == null ? this.volCenter : oldcenter;
                this.center.setPoint(newCenter);
            }
        }
        if (!this.center.equals(oldcenter)) {
            this.pcs.firePropertyChange(CENTER_POINT_PROPERTY, oldcenter, new CPoint(this.center));
        }
    }

    @Override
    public synchronized void setCenterOnVolume(boolean center) {
        super.setCenterOnVolume(center);
        if (this.getCenterOnVolume()) {
            this.setCenter(this.getCenter());
        }
    }

    public synchronized void setInitialNormal(CPoint initialNormal) {
        if (!this.initialNormal.equals(initialNormal)) {
            this.initialNormal.setPoint(initialNormal);
            this.initialUpVec = null;
            this.initialImagePlane = null;
            this.refViewPlane = null;
            this.applyContrainingVolume();
            this.pcs.firePropertyChange(INITIAL_NORMAL_PROPERTY, initialNormal, this.initialNormal);
        }
    }

    @Override
    public synchronized void setFov(double fov) {
        if (this.initalized_) {
            if (this.is3DRotationMode() && this.isPortMode3D()) {
                if (fov <= 0.0) {
                    this.fov = this.targetViewport.getViewHeight();
                }
            } else {
                double[] eye = new double[]{this.center.x + this.initialNormal.x, this.center.y + this.initialNormal.y, this.center.z + this.initialNormal.z};
                double[] dfov = J3DGeomUtils.getBestFitDfov(this.targetVolume, this.center.toArray(), this.initialUpVec.toArray(), eye);
                double maxdfov = Math.max(dfov[0], dfov[1]);
                if (this.is3DRotationMode() && (fov <= 0.0 || fov > maxdfov)) {
                    fov = maxdfov;
                } else if (fov <= 0.0 || this.getFitFovToVolume() || this.getFitToVolume()) {
                    fov = maxdfov;
                }
            }
        }
        super.setFov(fov);
    }

    @Override
    public synchronized void setFitFovToVolume(boolean fitFov) {
        super.setFitFovToVolume(fitFov);
        if (this.getFitFovToVolume()) {
            this.setFov(this.getFov());
        }
    }

    @Override
    public synchronized void setFitToVolume(boolean fit2vol) {
        super.setFitToVolume(fit2vol);
        if (this.getFitToVolume()) {
            this.setCenter(this.getCenter());
            this.setFov(this.getFov());
        }
    }

    public synchronized void setRotateDirection(String rotateDirection) {
        if (!this.getRotateDirection().equals(rotateDirection)) {
            if (!this.is3DRotationMode() && ("left".equals(rotateDirection) || "right".equals(rotateDirection))) {
                return;
            }
            this.rotateDirection = rotateDirection;
            this.applyContrainingVolume();
            this.pcs.firePropertyChange(ROTATE_DIRECTION_PROPERTY, null, this.rotateDirection);
        }
    }

    public synchronized double setAngleBetweenViews(double angle) {
        return this.setAngleBetweenViews(angle, true);
    }

    public synchronized double setAngleBetweenViews(double angle, boolean updateImages) {
        boolean reverse = false;
        if (this.angle != angle) {
            if (angle == 0.0) {
                angle = 1.0;
            } else if (angle < 0.0) {
                reverse = true;
                angle = Math.abs(angle);
            }
            if (angle > 180.0) {
                angle = 180.0;
            }
            if (!this.is3DRotationMode()) {
                this.rotateDirection = reverse ? "down" : "up";
            }
            double oldAngle = this.angle;
            this.angle = angle;
            this.pcs.firePropertyChange(ANGLE_BETWEEN_VIEWS_PROPERTY, oldAngle, this.angle);
            if (updateImages) {
                if (this.numImages > 0) {
                    double totalAngle = oldAngle * (double)(this.getNumImages() - 1);
                    int numImages = (int)Math.round(totalAngle / this.angle) + 1;
                    numImages = (int)Math.min((double)Math.max(numImages, 2), Math.abs(180.0 / angle));
                    this.setNumImages(numImages, false);
                } else {
                    int numImgs = (int)(180.0 / this.angle);
                    this.setNumImages(numImgs, false);
                }
            }
        }
        return this.angle;
    }

    public synchronized int setNumImages(int numImages) {
        return this.setNumImages(numImages, true);
    }

    public synchronized int setNumImages(int numImages, boolean updateAngle) {
        if (numImages != this.getNumImages() || numImages < 2 || numImages > 180) {
            if (numImages < 2) {
                numImages = 2;
            } else if (numImages > 180) {
                numImages = 180;
            }
            int oldNumImages = this.numImages;
            this.numImages = numImages;
            if (oldNumImages > 0) {
                if (updateAngle) {
                    double totalAngle = (double)(oldNumImages - 1) * this.getAngleBetweenViews();
                    double newAngle = totalAngle / (double)(numImages - 1);
                    this.setAngleBetweenViews(newAngle, false);
                }
            } else if (updateAngle) {
                this.angle = 180.0 / (double)numImages;
                this.setAngleBetweenViews(this.angle, false);
            }
            this.pcs.firePropertyChange("NUM_IMAGES_PROPERTY", oldNumImages, this.numImages);
        }
        return numImages;
    }

    public synchronized void setInitialImagePlane(String initialPlane) {
        if (initialPlane == null) {
            initialPlane = "";
        }
        if (!initialPlane.equals(this.initialImagePlane)) {
            this.initialImagePlane = initialPlane;
            this.initialNormal = null;
            this.initialUpVec = null;
            this.refViewPlane = null;
            this.applyContrainingVolume();
        }
    }

    @Override
    public boolean isTargetSet() {
        return this.initalized_;
    }

    @Override
    public void setTarget(XjVolumeGeometry volume) {
        if (this.initalized_) {
            if (this.cachedProtocol == null) {
                this.cachedProtocol = new VVBatchProtocol();
            }
            this.saveToProtocol(this.cachedProtocol);
        }
        if (this.targetViewport != null) {
            this.detachListeners();
            this.targetViewport.removePropertyChangeListener("viewType", this.viewTypeListener);
        }
        if (volume != this.targetVolume) {
            this.targetVolume = volume;
            this.targetVolumeModel = null;
            this.targetViewport = null;
            this.rasOrig.set(0.0, 0.0, 0.0);
            this.rside.set(0.0, 0.0, 0.0);
            this.aside.set(0.0, 0.0, 0.0);
            this.sside.set(0.0, 0.0, 0.0);
            this.volCenter.set(0.0, 0.0, 0.0);
            this.vox2ras.loadIdentity();
            this.ras2vox.loadIdentity();
            this.initalized_ = false;
            if (this.targetVolume != null) {
                this.init();
                this.initalized_ = true;
                if (this.cachedProtocol != null) {
                    this.loadFromProtocol(this.cachedProtocol);
                } else {
                    this.applyContrainingVolume();
                }
            }
        }
    }

    private void attachListeners() {
        if (this.targetViewport != null) {
            this.targetViewport.addPropertyChangeListener("camera", this.viewTypeListener);
            this.targetViewport.addPropertyChangeListener("renderStyle", this.renderStyleListener);
            this.targetViewport.addPropertyChangeListener("viewHeight", this.fovListener);
            this.targetViewport.addPropertyChangeListener("up", this.upVecListener);
            this.targetViewport.addPropertyChangeListener("eyePoint", this.eyePtListener);
            this.targetViewport.addPropertyChangeListener("lookPoint", this.lookPtListener);
        }
    }

    private void detachListeners() {
        if (this.targetViewport != null) {
            this.targetViewport.removePropertyChangeListener("camera", this.viewTypeListener);
            this.targetViewport.removePropertyChangeListener("renderStyle", this.renderStyleListener);
            this.targetViewport.removePropertyChangeListener("viewHeight", this.fovListener);
            this.targetViewport.removePropertyChangeListener("up", this.upVecListener);
            this.targetViewport.removePropertyChangeListener("eyePoint", this.eyePtListener);
            this.targetViewport.removePropertyChangeListener("lookPoint", this.lookPtListener);
        }
    }

    @Override
    public void setTarget(T3DViewport port) {
        if (this.initalized_) {
            if (this.cachedProtocol == null) {
                this.cachedProtocol = new VVBatchProtocol();
            }
            this.saveToProtocol(this.cachedProtocol);
        }
        if (this.targetViewport != null) {
            this.detachListeners();
            this.targetViewport.removePropertyChangeListener("viewType", this.viewTypeListener);
        }
        if (port.getVolume() != this.targetVolume) {
            this.targetViewport = port;
            this.targetVolume = port.getVolume();
            this.targetVolumeModel = port.getVolumeModel();
            this.rasOrig.set(0.0, 0.0, 0.0);
            this.rside.set(0.0, 0.0, 0.0);
            this.aside.set(0.0, 0.0, 0.0);
            this.sside.set(0.0, 0.0, 0.0);
            this.volCenter.set(0.0, 0.0, 0.0);
            this.vox2ras.loadIdentity();
            this.ras2vox.loadIdentity();
            this.init();
            this.initalized_ = true;
        } else if (port != this.targetViewport) {
            this.targetViewport = port;
            this.targetVolumeModel = port.getVolumeModel();
            this.targetVolume = port.getVolume();
            this.initalized_ = true;
            System.out.println("added 2");
        }
        this.refViewPlane = null;
        this.attachListeners();
        this.targetViewport.addPropertyChangeListener("viewType", this.viewTypeListener);
        if (this.isPortMode3D()) {
            this.renderStyle = this.targetViewport.getRenderStyle();
            this.set3DRotationMode(true);
        } else {
            this.set3DRotationMode(false);
        }
        if (this.cachedProtocol != null) {
            this.loadFromProtocol(this.cachedProtocol);
        } else {
            this.applyContrainingVolume();
        }
    }

    @Override
    public T3DViewport getTargetPort() {
        return this.targetViewport;
    }

    @Override
    public XjVolumeGeometry getTargetVolume() {
        return this.targetVolume;
    }

    @Override
    public void setTarget(XjVolumeModel volumeModel) {
        if (this.initalized_) {
            if (this.cachedProtocol == null) {
                this.cachedProtocol = new VVBatchProtocol();
            }
            this.saveToProtocol(this.cachedProtocol);
        }
        if (this.targetViewport != null) {
            this.detachListeners();
            this.targetViewport.removePropertyChangeListener("viewType", this.viewTypeListener);
        }
        if (volumeModel != this.targetVolumeModel) {
            this.targetVolumeModel = volumeModel;
            this.targetVolume = volumeModel.getVolume();
            this.targetViewport = null;
            this.rasOrig.set(0.0, 0.0, 0.0);
            this.rside.set(0.0, 0.0, 0.0);
            this.aside.set(0.0, 0.0, 0.0);
            this.sside.set(0.0, 0.0, 0.0);
            this.volCenter.set(0.0, 0.0, 0.0);
            this.initalized_ = true;
            if (this.cachedProtocol != null) {
                this.loadFromProtocol(this.cachedProtocol);
            } else {
                this.applyContrainingVolume();
            }
        }
    }

    @Override
    public XjVolumeModel getTargetVolumeModel() {
        return this.targetVolumeModel;
    }

    private void init() {
        XjVolumeGeometry constraint;
        XjVolumeGeometry xjVolumeGeometry = this.targetVolume != null ? this.targetVolume : (this.targetViewport != null ? this.targetViewport.getVolume() : (constraint = this.targetVolumeModel != null ? this.targetVolumeModel.getVolume() : null));
        if (constraint != null) {
            J3DGeomUtils.calculateVoxelRASTransforms(constraint, this.vox2ras, this.ras2vox);
            J3DGeomUtils.alignVolumeToRAS(constraint, this.rasOrig, this.rside, this.aside, this.sside);
            this.tilt = XjVolumeUtils.calculateTilt(constraint);
            double[] center = XjVolumeUtils.getVolumeCenterRAS(constraint.getRASOfOrigin(null), constraint.getXDirectionRAS(null), constraint.getYDirectionRAS(null), constraint.getZDirectionRAS(null), constraint.getVolumeDimensions(null), null);
            this.volCenter.set(center);
        }
    }

    public synchronized void setTarget(JnVector3d parallelepipedOrigin, JnVector3d parallelepipedVector0, JnVector3d parallelepipedVector1, JnVector3d parallelepipedVector2) {
        if (this.targetViewport != null) {
            this.detachListeners();
            this.targetViewport.removePropertyChangeListener("viewType", this.viewTypeListener);
        }
        this.targetVolume = new J3DGeomUtils.dummyVolume(parallelepipedOrigin.toArray(), parallelepipedVector0.toArray(), parallelepipedVector1.toArray(), parallelepipedVector2.toArray());
        this.targetViewport = null;
        this.targetVolumeModel = null;
        this.init();
        this.initalized_ = true;
        this.applyContrainingVolume();
    }

    private synchronized void applyContrainingVolume() {
        if (!this.initalized_) {
            return;
        }
        int[] dims = this.targetVolume.getVolumeDimensions(null);
        if (this.useImageDims) {
            this.setPixelDimension(new Dimension(dims[0], dims[1]));
        }
        if (this.targetViewport == null && ("VOLUME".equals(this.renderStyle) || "FULLBODY_AVERAGE".equals(this.renderStyle) || "FULLBODY_MINIP".equals(this.renderStyle) || "FULLBODY_MIP".equals(this.renderStyle))) {
            this.rotate3DMode = true;
        }
        if (this.is3DRotationMode()) {
            this.applyContrainingVolumeFor3DMode();
            return;
        }
        if (this.center == null || this.getCenterOnVolume() || this.getFitToVolume()) {
            if (this.center == null) {
                this.center = new CPoint();
            }
            this.center.setPoint(this.volCenter);
        }
        if (this.center.csystem != 2) {
            this.convertPointToRAS(this.center);
        }
        if (this.center.csystem != 2) {
            this.logger.log(Level.WARNING, "Center Conversion to RAS failed. Setting center to Volume Center.");
            this.center.setPoint(this.volCenter);
        }
        if (!J3DGeomUtils.isInVolume(this.center.generateArray(), dims, this.ras2vox)) {
            if (this.targetViewport == null) {
                this.center.setPoint(this.volCenter);
            } else {
                CPoint vpCenter = new CPoint((double)this.targetViewport.getWidth() * 0.5, (double)this.targetViewport.getHeight() * 0.5, 0.0, 1);
                CPoint vpCenterRAS = this.targetViewport.getT3DComponent().transform(vpCenter, (byte)2);
                this.center.setPoint(vpCenterRAS);
            }
        }
        if ((this.refViewPlane == null || "".equals(this.refViewPlane)) && (this.initialImagePlane == null || "".equals(this.initialImagePlane))) {
            if (this.initialNormal == null && this.initialUpVec == null) {
                this.initialImagePlane = "OB_CORONAL";
            } else if (this.initialNormal == null || this.initialUpVec == null) {
                this.refViewPlane = "OB_CORONAL";
            }
        }
        if (this.initialUpVec != null && this.initialUpVec.csystem != 2) {
            this.initialUpVec.normalize();
            this.convertVectorToRAS(this.initialUpVec);
            this.initialUpVec.normalize();
        }
        if (this.initialNormal == null) {
            this.initialNormal = new CPoint();
            if (this.initialUpVec != null) {
                this.calculateInitialNormalFromInitialUp();
            } else {
                double[] initialNorm = this.calculateInitialNormal();
                if (initialNorm != null) {
                    this.initialNormal.setPoint(initialNorm[0], initialNorm[1], initialNorm[2], (byte)2);
                }
            }
        }
        this.initialNormal.normalize();
        if (this.initialNormal.csystem != 2) {
            this.initialNormal.normalize();
            this.convertVectorToRAS(this.initialNormal);
        }
        this.initialNormal.normalize();
        if (this.initialUpVec == null) {
            this.calculateSliceUpVector();
        }
        this.initialUpVec.normalize();
        if (this.numImages == 0) {
            this.numImages = (int)Math.floor(180.0 / this.angle);
        }
        this.numImages = (int)Math.min((double)Math.max(this.numImages, 2), Math.abs(180.0 / this.angle));
        this.thickness = this.checkThickness(this.thickness);
        double[] eye = new double[]{this.center.x + this.initialNormal.x, this.center.y + this.initialNormal.y, this.center.z + this.initialNormal.z};
        double[] dfov = J3DGeomUtils.getBestFitDfov(this.targetVolume, this.center.toArray(), this.initialUpVec.toArray(), eye);
        if (this.fov <= 0.0 || (this.getFitFovToVolume() || this.getFitToVolume()) && this.fov != Math.max(dfov[0], dfov[1])) {
            this.fov = Math.max(dfov[0], dfov[1]);
        }
        this.calculateRotateDirection();
        this.renderStyle = this.checkRenderStyle(this.renderStyle);
        this.pcs.firePropertyChange("BATCHMODEL_UPDATED_PROPERTY", false, true);
    }

    private double checkThickness(double thk) {
        double minThk = J3DGeomUtils.getMinSliceThickness(this.targetVolume, this.initialNormal);
        double maxThk = J3DGeomUtils.getMaxSliceThickness(this.targetVolume, new JnVector3d(this.center.toArray()), new JnVector3d(this.initialNormal.toArray()));
        if (thk < minThk) {
            return minThk;
        }
        if (thk > maxThk) {
            return maxThk;
        }
        return thk;
    }

    public void printBatchParams() {
        System.out.println(" Ref View plane " + this.refViewPlane);
        System.out.println(" initial View plane " + this.initialImagePlane);
        System.out.println(" num images  " + this.numImages);
        System.out.println(" center " + this.center.x + " " + this.center.y + " " + this.center.z);
        System.out.println(" Rotation angle and dir " + this.getRotateDirection() + " angle " + this.angle);
        System.out.println(" Render style " + this.renderStyle);
        System.out.println(" Up vector " + this.initialUpVec.x + " " + this.initialUpVec.y + " " + this.initialUpVec.z);
        System.out.println(" Normal vector " + this.initialNormal.x + " " + this.initialNormal.y + " " + this.initialNormal.z);
        System.out.println(" thickness " + this.thickness);
        System.out.println(" dfov " + this.fov);
        double[] eye = null;
        double[] look = null;
        double[] up = null;
        for (int i = 0; i < this.numImages; ++i) {
            eye = new double[3];
            this.getSliceEyePoint(i, eye);
            System.out.println(" eye for slice : " + i + " " + eye[0] + " " + eye[1] + " " + eye[2]);
            look = new double[3];
            this.getSliceLookPoint(i, look);
            System.out.println(" look for slice : " + i + " " + look[0] + " " + look[1] + " " + look[2]);
            up = new double[3];
            this.getSliceUp(i, up);
            System.out.println(" up for slice : " + i + " " + up[0] + " " + up[1] + " " + up[2]);
        }
    }

    private synchronized void applyContrainingVolumeFor3DMode() {
        if (this.isPortMode3D()) {
            if (this.center == null) {
                this.center = new CPoint();
            }
            double[] eye = this.targetViewport.getEyePoint(null);
            double[] look = this.targetViewport.getLookPoint(null);
            this.center.setPoint(look[0], look[1], look[2], (byte)2);
            if (this.initialNormal == null) {
                this.initialNormal = new CPoint();
            }
            JnVector3d normalVect = new JnVector3d();
            normalVect.set(eye[0] - look[0], eye[1] - look[1], eye[2] - look[2]);
            this.initialNormal.set(normalVect);
            this.initialNormal.csystem = (byte)2;
            this.initialNormal.normalize();
            if (this.initialUpVec == null) {
                this.initialUpVec = new CPoint();
            }
            double[] upvect = new double[3];
            this.targetViewport.getUp(upvect);
            this.initialUpVec.set(upvect);
            this.initialUpVec.csystem = (byte)2;
            this.initialUpVec.normalize();
            JnVector3d.cross(this.initialUpVec, this.initialNormal, this.rightVec);
            this.rightVec.normalize();
            this.thickness = 0.0;
            if (this.numImages == 0) {
                this.numImages = (int)Math.floor(180.0 / this.angle);
            }
            this.numImages = (int)Math.min((double)Math.max(this.numImages, 2), Math.abs(180.0 / this.angle));
            if (this.fov <= 0.0) {
                this.fov = this.targetViewport.getViewHeight();
            }
        } else {
            if (this.center == null) {
                this.center = new CPoint();
            }
            this.center.setPoint(this.volCenter);
            if (this.initialImagePlane == null || "".equals(this.initialImagePlane)) {
                this.initialImagePlane = "OB_CORONAL";
            }
            this.refViewPlane = null;
            this.initialUpVec = null;
            this.initialNormal = null;
            if (this.initialNormal == null) {
                this.initialNormal = new CPoint();
                if (this.initialUpVec != null) {
                    this.calculateInitialNormalFromInitialUp();
                } else {
                    double[] initialNorm = this.calculateInitialNormal();
                    if (initialNorm != null) {
                        this.initialNormal.setPoint(initialNorm[0], initialNorm[1], initialNorm[2], (byte)2);
                    }
                }
            }
            this.initialNormal.normalize();
            if (this.initialUpVec == null) {
                this.calculateSliceUpVector();
            }
            if (this.numImages == 0) {
                this.numImages = (int)Math.floor(180.0 / this.angle);
            }
            this.numImages = (int)Math.min((double)Math.max(this.numImages, 2), Math.abs(180.0 / this.angle));
            if (this.thickness != 0.0) {
                this.thickness = 0.0;
            }
            double[] eye = new double[]{this.center.x + this.initialNormal.x, this.center.y + this.initialNormal.y, this.center.z + this.initialNormal.z};
            double[] dfov = J3DGeomUtils.getBestFitDfov(this.targetVolume, this.center.toArray(), this.initialUpVec.toArray(), eye);
            if (this.fov <= 0.0 || this.fov > Math.max(dfov[0], dfov[1])) {
                this.fov = Math.max(dfov[0], dfov[1]);
            }
        }
        this.calculateRotateDirection();
        this.renderStyle = this.checkRenderStyle(this.renderStyle);
        this.pcs.firePropertyChange("BATCHMODEL_UPDATED_PROPERTY", false, true);
    }

    private void calculateSliceUpVector() {
        if (this.initialUpVec == null) {
            this.initialUpVec = new CPoint(2);
        }
        if (this.targetViewport != null) {
            double[] eye = this.targetViewport.getEyePoint(null);
            double[] look = this.targetViewport.getLookPoint(null);
            this.rightVec.set(eye[0] - look[0], eye[1] - look[1], eye[2] - look[2]);
        } else if (this.refViewPlane != null) {
            CPoint normal = new CPoint(2);
            CPoint up = new CPoint(2);
            CPoint right = new CPoint(2);
            this.calculateSliceXYZVectors(this.refViewPlane, normal, up, right);
            this.rightVec.set(normal);
        } else if (this.initialImagePlane != null) {
            CPoint normal = new CPoint(2);
            CPoint up = new CPoint(2);
            CPoint right = new CPoint(2);
            this.calculateSliceXYZVectors(this.initialImagePlane, normal, up, right);
            this.rightVec.set(right);
        }
        this.rightVec.normalize();
        JnVector3d.cross(this.initialNormal, this.rightVec, this.initialUpVec);
        JnVector3d.cross(this.initialUpVec, this.initialNormal, this.rightVec);
        this.rightVec.normalize();
        this.initialNormal.normalize();
        this.initialUpVec.normalize();
    }

    private void calculateInitialNormalFromInitialUp() {
        this.initialUpVec.normalize();
        if (this.initialUpVec.csystem != 2) {
            this.convertVectorToRAS(this.initialUpVec);
        }
        this.initialUpVec.normalize();
        if (this.targetViewport != null) {
            double[] eye = this.targetViewport.getEyePoint(null);
            double[] look = this.targetViewport.getLookPoint(null);
            this.rightVec.set(eye[0] - look[0], eye[1] - look[1], eye[2] - look[2]);
        } else if (this.refViewPlane != null) {
            CPoint normal = new CPoint(2);
            CPoint up = new CPoint(2);
            CPoint right = new CPoint(2);
            this.calculateSliceXYZVectors(this.refViewPlane, normal, up, right);
            this.rightVec.set(normal);
        } else if (this.initialImagePlane != null) {
            CPoint normal = new CPoint(2);
            CPoint up = new CPoint(2);
            CPoint right = new CPoint(2);
            this.calculateSliceXYZVectors(this.initialImagePlane, normal, up, right);
            this.rightVec.set(right);
        }
        this.rightVec.normalize();
        JnVector3d.cross(this.rightVec, this.initialUpVec, this.initialNormal);
        JnVector3d.cross(this.initialUpVec, this.initialNormal, this.rightVec);
        this.initialUpVec.normalize();
        this.initialNormal.normalize();
        this.rightVec.normalize();
    }

    private void calculateRotateDirection() {
        String rotateDir = this.getRotateDirection();
        if (!this.is3DRotationMode() && ("left".equals(rotateDir) || "right".equals(rotateDir))) {
            this.setRotateDirection("up");
        }
        if ("up".equals(rotateDir = this.getRotateDirection())) {
            this.rotateDirectionVec.set(this.initialUpVec);
        } else if ("down".equals(rotateDir)) {
            this.rotateDirectionVec.set(this.initialUpVec);
            this.rotateDirectionVec.multiplyBy(-1.0);
        } else if ("right".equals(rotateDir)) {
            this.rotateDirectionVec.set(this.rightVec);
        } else if ("left".equals(rotateDir)) {
            this.rotateDirectionVec.set(this.rightVec);
            this.rotateDirectionVec.multiplyBy(-1.0);
        } else if (this.is3DRotationMode()) {
            this.logger.log(Level.WARNING, "Invalid rotateDirection property.  Found: \"" + rotateDir + "\". Setting rotateDir to ROTATE_DIRECTION_RIGHT.");
            this.setRotateDirection("right");
            this.rotateDirectionVec.set(this.rightVec);
        } else {
            this.logger.log(Level.WARNING, "Invalid rotateDirection property.  Found: \"" + rotateDir + "\". Setting rotateDir to ROTATE_DIRECTION_UP.");
            this.setRotateDirection("up");
            this.rotateDirectionVec.set(this.initialUpVec);
        }
        JnVector3d.cross(this.initialNormal, this.rotateDirectionVec, this.rotateAxisVec);
        this.rotateDirectionVec.normalize();
        this.rotateAxisVec.normalize();
    }

    private double[] calculateInitialNormal() {
        double[] normal = null;
        if (this.isPortMode3D()) {
            double[] look = this.targetViewport.getLookPoint(null);
            double[] eye = this.targetViewport.getEyePoint(null);
            this.setCenter(new CPoint(look, 2));
            normal = new CPoint(eye[0] - look[0], eye[1] - look[1], eye[2] - look[2], 2).toArray();
            this.targetViewport.removePropertyChangeListener("camera", this.cameraListener);
            this.targetViewport.addPropertyChangeListener("camera", this.cameraListener);
        } else {
            String initialPlane = this.initialImagePlane;
            if (initialPlane != null && !initialPlane.equals("")) {
                CPoint normal_ = new CPoint(0, 0, 0, 2);
                if (initialPlane.equals("AXIAL")) {
                    this.alignedToVolume = false;
                    normal_.set(0.0, 0.0, -1.0);
                } else if (initialPlane.equals("CORONAL")) {
                    this.alignedToVolume = false;
                    normal_.set(0.0, 1.0, 0.0);
                } else if (initialPlane.equals("SAGITTAL")) {
                    this.alignedToVolume = false;
                    normal_.set(-1.0, 0.0, 0.0);
                } else if (initialPlane.equals("OB_AXIAL")) {
                    normal_.set(this.sside);
                    normal_.scale(-1.0);
                } else if (initialPlane.equals("OB_CORONAL")) {
                    normal_.set(this.aside);
                } else if (initialPlane.equals("OB_SAGITTAL")) {
                    normal_.set(this.rside);
                    normal_.scale(-1.0);
                } else {
                    this.logger.log(Level.WARNING, "Invalid initialImagePlane property.  Found: \"" + initialPlane + "\". Setting initialImagePlane to IMAGE_PLANE_OB_CORONAL.");
                    normal_.set(this.aside);
                }
                normal = normal_.toArray();
            }
        }
        return normal;
    }

    private void convertPointToRAS(CPoint point) {
        if (!this.isTargetSet()) {
            return;
        }
        if (point.csystem != 2) {
            if (this.targetViewport != null) {
                if (point.csystem == 3) {
                    point.x *= (double)this.targetViewport.getWidth();
                    point.y *= (double)this.targetViewport.getHeight();
                    point.z = 0.0;
                    point.csystem = 1;
                }
                CPoint newPoint = this.targetViewport.getT3DComponent().transform(point, (byte)2);
                point.setPoint(newPoint);
                point.csystem = (byte)2;
            } else if (this.refViewPlane != null) {
                if (5 == point.csystem) {
                    CPoint pointras = new CPoint(2);
                    this.vox2ras.transform(point, pointras);
                    point.setPoint(pointras);
                } else if (1 == point.csystem || 3 == point.csystem) {
                    if (point.csystem == 3) {
                        point.x *= 512.0;
                        point.y *= 512.0;
                        point.z = 0.0;
                        point.csystem = 1;
                    }
                    CTransform disp2ras = this.getDispToRASTransform();
                    disp2ras.transform(point);
                    point.csystem = (byte)2;
                }
            }
        }
    }

    private void convertVectorToRAS(CPoint vector) {
        if (!this.isTargetSet()) {
            return;
        }
        if (vector.csystem != 2) {
            if (this.targetViewport != null) {
                System.err.println(">>>>>>>>>>>>>>>>> " + Math.toDegrees(Math.atan2(vector.y, vector.x)));
                CPoint c = new CPoint((double)this.targetViewport.getWidth() * 0.5, (double)this.targetViewport.getHeight() * 0.5, 0.0, 1);
                CPoint cras = this.targetViewport.getT3DComponent().transform(c, (byte)2);
                CPoint cvec = this.targetViewport.getT3DComponent().transform(c, vector.csystem);
                cvec.add(vector);
                CPoint cras2 = this.targetViewport.getT3DComponent().transform(cvec, (byte)2);
                vector.setPoint(cras2);
                vector.sub(cras);
                vector.csystem = (byte)2;
            } else if (5 == vector.csystem) {
                this.vox2ras.transform(vector);
                vector.csystem = (byte)2;
            } else if ((1 == vector.csystem || 3 == vector.csystem) && this.refViewPlane != null) {
                CTransform disp2ras = this.getDispToRASTransform();
                CPoint c = new CPoint(256, 256, 0, 1);
                CPoint v = new CPoint(vector.x, vector.y, 0.0, 1);
                v.add(c);
                disp2ras.transform(v);
                disp2ras.transform(c);
                v.sub(c);
                v.normalize();
                vector.set(v);
                vector.csystem = (byte)2;
            }
        }
    }

    private CTransform getDispToRASTransform() {
        CPoint normal = new CPoint(2);
        CPoint up = new CPoint(2);
        CPoint right = new CPoint(2);
        this.calculateSliceXYZVectors(this.refViewPlane, normal, up, right);
        JnVector3d view = new JnVector3d(-normal.x, -normal.y, -normal.z);
        double[] eye = new double[]{this.volCenter.x + normal.x, this.volCenter.y + normal.y, this.volCenter.z + normal.z};
        double[] dfov = J3DGeomUtils.getBestFitDfov(this.targetVolume, this.volCenter.toArray(), up.toArray(), eye);
        double refViewFov = Math.max(dfov[0], dfov[1]);
        JnVector3d down = new JnVector3d(-up.x, -up.y, -up.z);
        JnVector3d.cross(down, view, right);
        CTransform disp2ras = J3DGeomUtils.calculateDispToRASTransform(this.targetVolume, this.volCenter.toArray(), view, down, right, refViewFov, 512, 512, this.ras2vox);
        return disp2ras;
    }

    private void calculateSliceXYZVectors(String refViewPlane, CPoint normal, CPoint up, CPoint right) {
        if (normal == null || up == null || right == null) {
            return;
        }
        if ("AXIAL".equals(refViewPlane)) {
            normal.set(0.0, 0.0, -1.0);
            up.set(0.0, 1.0, 0.0);
        } else if ("OB_AXIAL".equals(refViewPlane)) {
            normal.set(-this.sside.x, -this.sside.y, -this.sside.z);
            up.set(this.aside.x, this.aside.y, this.aside.z);
        } else if ("CORONAL".equals(refViewPlane)) {
            normal.set(0.0, 1.0, 0.0);
            up.set(0.0, 0.0, 1.0);
        } else if ("OB_CORONAL".equals(refViewPlane)) {
            normal.set(this.aside.x, this.aside.y, this.aside.z);
            up.set(this.sside.x, this.sside.y, this.sside.z);
        } else if ("SAGITTAL".equals(refViewPlane)) {
            normal.set(-1.0, 0.0, 0.0);
            up.set(0.0, 0.0, 1.0);
        } else if ("OB_SAGITTAL".equals(refViewPlane)) {
            normal.set(-this.rside.x, -this.rside.y, -this.rside.z);
            up.set(this.sside.x, this.sside.y, this.sside.z);
        }
        normal.normalize();
        JnVector3d.cross(up, normal, right);
        JnVector3d.cross(normal, right, up);
        up.normalize();
        right.normalize();
    }

    @Override
    public synchronized double getFov() {
        return super.getFov();
    }

    @Override
    public synchronized double[] getSliceEyePoint(int i, double[] eye_pt) {
        if (i >= 0 && i < this.getNumImages()) {
            eye_pt = this.getSliceLookPoint(i, eye_pt);
            this.rotateQuat.set(this.rotateAxisVec, Math.toRadians(this.angle * (double)i));
            this.rotateQuat.build3dRotationMatrix().transform(this.initialNormal, this.normalVec);
            eye_pt[0] = eye_pt[0] + this.normalVec.x;
            eye_pt[1] = eye_pt[1] + this.normalVec.y;
            eye_pt[2] = eye_pt[2] + this.normalVec.z;
            return eye_pt;
        }
        return null;
    }

    @Override
    public synchronized double[] getSliceLookPoint(int i, double[] look_pt) {
        if (i >= 0 && i < this.getNumImages()) {
            if (look_pt == null) {
                look_pt = new double[]{this.center.x, this.center.y, this.center.z};
            }
            return look_pt;
        }
        return null;
    }

    @Override
    public synchronized double[] getSliceUp(int i, double[] up_vect) {
        if (i >= 0 && i < this.getNumImages()) {
            if (up_vect == null) {
                up_vect = new double[3];
            }
            if (this.is3DRotationMode()) {
                this.rotateQuat.set(this.rotateAxisVec, Math.toRadians(this.angle * (double)i));
                this.rotateQuat.build3dRotationMatrix().transform(this.initialUpVec, this.upVec);
            } else {
                this.rotateQuat.set(this.rotateAxisVec, Math.toRadians(this.angle * (double)i));
                this.rotateQuat.build3dRotationMatrix().transform(this.initialNormal, this.normalVec);
                this.normalVec.normalize();
                short rfmtPlane = J3DGeomUtils.getPlaneType(this.normalVec);
                if (rfmtPlane == 2 || rfmtPlane == 18) {
                    if (this.alignedToVolume) {
                        this.upVec.set(this.aside);
                    } else {
                        this.upVec.set(0.0, 1.0, 0.0);
                    }
                } else if (rfmtPlane == 8 || rfmtPlane == 4 || rfmtPlane == 24 || rfmtPlane == 20) {
                    if (this.alignedToVolume) {
                        this.upVec.set(this.sside);
                    } else {
                        this.upVec.set(0.0, 0.0, 1.0);
                    }
                }
                JnVector3d.cross(this.upVec, this.normalVec, this.rightVec);
                JnVector3d.cross(this.normalVec, this.rightVec, this.upVec);
                this.upVec.normalize();
                this.rightVec.normalize();
            }
            up_vect[0] = this.upVec.x;
            up_vect[1] = this.upVec.y;
            up_vect[2] = this.upVec.z;
            return up_vect;
        }
        return null;
    }

    private boolean isPortMode3D() {
        String rstyle;
        return this.targetViewport != null && ("FULLBODY_MIP".equals(rstyle = this.targetViewport.getRenderStyle()) || "FULLBODY_MINIP".equals(rstyle) || "FULLBODY_AVERAGE".equals(rstyle) || "VOLUME".equals(rstyle));
    }

    @Override
    public synchronized void setThickness(double thickness) {
        if (this.is3DRotationMode()) {
            return;
        }
        if (this.initalized_) {
            thickness = this.checkThickness(thickness);
        }
        super.setThickness(thickness);
    }

    public static enum ROTATION_MODE {
        ROTATE_FAN,
        ROTATE_3D;

    }
}

