/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.ViewCalculator;
import com.ge.med.cse.cvf.j3d.vav.FixedPointViewCalculator;
import com.ge.med.cse.cvf.j3d.vav.LoopMode;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.j3d.T3DViewport;

public class VavLoopModel
extends VavBatchModel {
    private FixedPointViewCalculator vc = new FixedPointViewCalculator(null);
    private double[] eye_pt = new double[3];
    private double[] look_pt = new double[3];
    private double[] up_vect = new double[3];
    protected JnVector3d rightVec = null;
    protected JnVector3d upVec = null;
    private boolean initalized_ = false;
    private XjVolumeInfo targetVolume = null;
    private T3DViewport targetViewport = null;
    public static final String SPACING_PROPERTY = "SPACING_PROPERTY";
    public static final String ANGLE_BETWEEN_VIEWS_PROPERTY = "ANGLE_BETWEEN_VIEWS_PROPERTY";
    private LoopMode mode = LoopMode.NONE;
    private CPoint ul = new CPoint(2);
    private CPoint ur = new CPoint(2);
    private CPoint br = new CPoint(2);

    @Override
    public String getBatchType() {
        return "Loop";
    }

    public void setNumImages(int num) {
        this.vc.setNumberOfImages(num);
        this.pcs.firePropertyChange("NUM_IMAGES_PROPERTY", null, (Object)this.vc.getNumFrames());
    }

    @Override
    public int getNumImages() {
        return this.vc.getNumFrames();
    }

    public void setSpacing(double spacing) {
        this.vc.setStrideMM(spacing);
        this.pcs.firePropertyChange(SPACING_PROPERTY, null, new Double(this.vc.getStrideMM()));
    }

    public double getSpacing() {
        return this.vc.getStrideMM();
    }

    public void setAngleBetweenViews(double angle) {
        this.vc.setAngleStepDegrees(angle);
        this.pcs.firePropertyChange(ANGLE_BETWEEN_VIEWS_PROPERTY, null, new Double(this.vc.getAngleStepDegrees()));
    }

    public double getAngleBetweenViews() {
        return this.vc.getAngleStepDegrees();
    }

    @Override
    public XpSlice getSlice(int i) {
        this.vc.getView(i, this.eye_pt, this.look_pt, this.up_vect);
        double[] tmpview = new double[3];
        JnVector3d.sub(this.look_pt, this.eye_pt, tmpview);
        JnVector3d viewV = new JnVector3d(tmpview);
        this.rightVec = new JnVector3d();
        this.upVec = new JnVector3d(this.up_vect);
        JnVector3d.cross(viewV, this.upVec, this.rightVec);
        this.upVec.normalize();
        this.rightVec.normalize();
        int pw = this.getPixelWidth();
        int ph = this.getPixelHeight();
        double viewHeight = this.getFov();
        double[] lookPoint = this.getSliceLookPoint(i, null);
        double aratio = pw / ph;
        double viewWidth = viewHeight * aratio;
        double spx = viewWidth / (double)pw;
        double spy = viewHeight / (double)ph;
        this.ul.x = lookPoint[0] - (double)(pw - 1) * 0.5 * this.rightVec.x * spx + (double)(ph - 1) * 0.5 * this.upVec.x * spy;
        this.ul.y = lookPoint[1] - (double)(pw - 1) * 0.5 * this.rightVec.y * spx + (double)(ph - 1) * 0.5 * this.upVec.y * spy;
        this.ul.z = lookPoint[2] - (double)(pw - 1) * 0.5 * this.rightVec.z * spx + (double)(ph - 1) * 0.5 * this.upVec.z * spy;
        this.ur.x = lookPoint[0] + (double)(pw - 1) * 0.5 * this.rightVec.x * spx + (double)(ph - 1) * 0.5 * this.upVec.x * spy;
        this.ur.y = lookPoint[1] + (double)(pw - 1) * 0.5 * this.rightVec.y * spx + (double)(ph - 1) * 0.5 * this.upVec.y * spy;
        this.ur.z = lookPoint[2] + (double)(pw - 1) * 0.5 * this.rightVec.z * spx + (double)(ph - 1) * 0.5 * this.upVec.z * spy;
        this.br.x = lookPoint[0] + (double)(pw - 1) * 0.5 * this.rightVec.x * spx - (double)(ph - 1) * 0.5 * this.upVec.x * spy;
        this.br.y = lookPoint[1] + (double)(pw - 1) * 0.5 * this.rightVec.y * spx - (double)(ph - 1) * 0.5 * this.upVec.y * spy;
        this.br.z = lookPoint[2] + (double)(pw - 1) * 0.5 * this.rightVec.z * spx - (double)(ph - 1) * 0.5 * this.upVec.z * spy;
        return new XpSlice(this.ul, this.ur, this.br, pw, ph);
    }

    @Override
    public double[] getSliceEyePoint(int i, double[] eye_pt) {
        if (eye_pt == null) {
            eye_pt = this.eye_pt;
        }
        this.vc.getView(i, eye_pt, this.look_pt, this.up_vect);
        return eye_pt;
    }

    @Override
    public double[] getSliceLookPoint(int i, double[] look_pt) {
        if (look_pt == null) {
            look_pt = this.look_pt;
        }
        this.vc.getView(i, this.eye_pt, look_pt, this.up_vect);
        return look_pt;
    }

    @Override
    public double[] getSliceUp(int i, double[] up_vect) {
        if (up_vect == null) {
            up_vect = this.up_vect;
        }
        this.vc.getView(i, this.eye_pt, this.look_pt, up_vect);
        return up_vect;
    }

    @Override
    public T3DViewport getTargetPort() {
        return this.targetViewport;
    }

    @Override
    public XjVolumeInfo getTargetVolume() {
        return this.targetVolume;
    }

    @Override
    public boolean isTargetSet() {
        return this.initalized_;
    }

    @Override
    public void loadFromProtocol(VVBatchProtocol protocol) {
    }

    @Override
    public void saveToProtocol(VVBatchProtocol protocol) {
    }

    public void setTarget(XjVolumeInfo volume) {
        if (volume != this.targetVolume) {
            this.targetVolume = volume;
            this.initalized_ = true;
            this.vc.setVolume(volume);
        }
    }

    @Override
    public void setTarget(T3DViewport port) {
        if (port != null) {
            this.targetViewport = port;
            this.initalized_ = true;
            this.vc.setT3DCapable(port);
            this.setTarget(port.getVolume());
        }
    }

    @Override
    public double getThickness() {
        if (this.targetViewport != null && super.getThickness() == 0.0) {
            double[] viewClip = new double[2];
            this.targetViewport.getViewClip(viewClip);
            return Math.abs(viewClip[0] - viewClip[1]);
        }
        return super.getThickness();
    }

    @Override
    public double getFov() {
        if (this.targetViewport != null && super.getFov() == 0.0) {
            return this.targetViewport.getViewHeight();
        }
        return super.getFov();
    }

    @Override
    public String getRenderStyle() {
        if (this.targetViewport != null && super.getRenderStyle() == "MAJOR_AXIS_AVERAGE" || super.getRenderStyle() == "AVERAGE") {
            return this.targetViewport.getRenderStyle();
        }
        return super.getRenderStyle();
    }

    public void setStart() {
        this.vc.setStart();
    }

    public void setEnd() {
        this.vc.setEnd();
    }

    public void setMode(LoopMode mode) {
        this.mode = mode;
        this.vc.setMode(mode);
    }

    public LoopMode getMode() {
        return this.mode;
    }

    public void startFromFirstSlice() {
        if (this.targetViewport instanceof ViewTypeCapable) {
            ViewTypeCapable.ViewTypeActor vtActor = ((ViewTypeCapable)((Object)this.targetViewport)).getViewType(((ViewTypeCapable)((Object)this.targetViewport)).getViewType());
            ViewCalculator viewCalc = vtActor.getViewCalculator();
            double[] eyept = new double[3];
            double[] lookpt = new double[3];
            double[] up = new double[3];
            viewCalc.getView(0, eyept, lookpt, up);
            this.vc.startFromSlice(eyept, lookpt, up);
        }
    }

    public void endToLastSlice() {
        if (this.targetViewport instanceof ViewTypeCapable) {
            ViewTypeCapable.ViewTypeActor vtActor = ((ViewTypeCapable)((Object)this.targetViewport)).getViewType(((ViewTypeCapable)((Object)this.targetViewport)).getViewType());
            ViewCalculator viewCalc = vtActor.getViewCalculator();
            double[] eyept = new double[3];
            double[] lookpt = new double[3];
            double[] up = new double[3];
            viewCalc.getView(viewCalc.getNumFrames() - 1, eyept, lookpt, up);
            this.vc.endToSlice(eyept, lookpt, up);
        }
    }

    @Override
    public void setTarget(XjVolumeModel volumeModel) {
    }

    @Override
    public XjVolumeModel getTargetVolumeModel() {
        return null;
    }

    @Override
    public void setTarget(XjVolumeGeometry volume) {
    }
}

