/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.dataloader.DatasetValidator;
import com.ge.med.cse.cvf.dataloader.DefaultVolumeDataSetValidator;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.utils.VavMemoryResourceCalculator;
import com.ge.med.cse.cvf.j3d.vav.BatchParallelTaskManager;
import com.ge.med.cse.cvf.j3d.vav.BatchTask;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchEngine;
import com.ge.med.cse.cvf.j3d.vav.VavBatchJob;
import com.ge.med.cse.cvf.j3d.vav.VavBatchJobContainer;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.j3d.vav.VavException;
import com.ge.med.cse.cvf.j3d.vav.jrl.JRL3DModel;
import com.ge.med.cse.cvf.util.BackgroundThread;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.beans.ExceptionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VavBatchSession
implements VavBatchJobContainer {
    public static final String SESSION_STARTED_PROPERTY = "session_started_property";
    public static final String SESSION_COMPLETED_PROPERTY = "session_completed_property";
    public static final String SESSION_ABORTED_PROPERTY = "session_aborted_property";
    public static final String SESSION_ERROR_PROPERTY = "session_error_property";
    public static final String SESSION_CONFIRMED_PROPERTY = "session_confirmed_property";
    public static final String SESSION_START_ERROR = "session_start_error";
    private String id_ = null;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ArrayList<VavBatchJob> jobs = new ArrayList();
    private ArrayList<TaskMonitor> monitors = new ArrayList();
    private XjVolumeInfo volInfo = null;
    private XjVolumeModel volModel = null;
    private XjVolumeGeometry autoEdgeBoundingBox = null;
    private String reserveSpaceHandle = null;
    private final int STATE_IDLE = 1;
    private final int STATE_STARTED = 2;
    private final int STATE_COMPLETE = 4;
    private final int STATE_ABORTED = 8;
    private final int STATE_ERROR = 16;
    private final int STATE_CONFIRMED = 32;
    private int sessionState = 1;
    private int jobsDone = 0;
    private int jobsFailed = 0;
    private int reconfirmAttempts = 0;
    private VavException.VavErrorCodes startError = null;
    private static final String vavOutputSession = System.getProperty("cvf.vav.outputDMSession");
    private static final int reconfirmMaxAttemps = Integer.parseInt(CvPropertiesManager.getProperty("cvf.vav.vavbatchsession.reconfirmMaxAttempts", "5"));
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private VavMemoryResourceCalculator.DefaultMemoryResourceCalculator memCalculator = new VavMemoryResourceCalculator.DefaultMemoryResourceCalculator();
    private DatasetValidator volValidator = new DefaultVolumeDataSetValidator();
    private TaskMonitor jobMonitor = new TaskMonitor(){

        @Override
        public void taskProgress(String taskName, int units) {
        }

        @Override
        public void taskFailed(String taskName, String reason, Exception e) {
            VavBatchSession.this.logger.log(Level.WARNING, "VavBatchSession " + VavBatchSession.this.getID() + " :: taskFailed " + taskName + " , reason : " + reason + " , Exception : " + e.toString());
            ++VavBatchSession.this.jobsFailed;
        }

        @Override
        public void taskDone(String taskName) {
            VavBatchSession.this.logger.log(Level.INFO, "VavBatchSession " + VavBatchSession.this.getID() + " :: taskDone " + taskName);
            for (VavBatchJob job : VavBatchSession.this.jobs) {
                if (!job.getName().equals(taskName)) continue;
                job.removePropertyChangeListener(VavBatchSession.this.jobLsnr);
                job.removeTaskMonitor(VavBatchSession.this.jobMonitor);
            }
            VavBatchSession.this.jobsDone++;
            if (VavBatchSession.this.jobsDone + VavBatchSession.this.jobsFailed == VavBatchSession.this.getNumBatchJobs()) {
                VavBatchSession.this.complete();
            }
        }

        @Override
        public void taskBegin(String taskName, int totalWork) {
            VavBatchSession.this.logger.log(Level.INFO, "VavBatchSession " + VavBatchSession.this.getID() + " :: taskBegin " + taskName + " , totalWork = " + totalWork);
            if (VavBatchSession.this.sessionState != 2) {
                VavBatchSession.this.sessionState = 2;
                VavBatchSession.this.pcs.firePropertyChange(VavBatchSession.SESSION_STARTED_PROPERTY, false, true);
            }
        }
    };
    private PropertyChangeListener jobLsnr = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    };

    public VavBatchSession() {
    }

    public VavBatchSession(String id) {
        this.id_ = id;
    }

    public String getID() {
        if (this.id_ == null) {
            return "VavBatchSession_" + this.hashCode();
        }
        return this.id_;
    }

    public void start(BatchParallelTaskManager taskMgr) {
        if (this.sessionState != 32) {
            return;
        }
        if (this.volInfo == null || this.jobs.size() == 0) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " :: cannot start .. no volume or jobs available");
            return;
        }
        if (this.volModel == null && !this.isMemoryAvailable()) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " :: start error VAV_VOLUME_SIZE_TOO_BIG");
            this.sessionState = 16;
            this.startError = VavException.VavErrorCodes.VAV_VOLUME_SIZE_TOO_BIG;
            this.pcs.firePropertyChange(SESSION_START_ERROR, (Object)-1, (Object)this.startError);
            return;
        }
        if (this.reserveSpace() == null) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " :: start error VAV_RESERVE_SPACE_FAILED");
            this.sessionState = 16;
            this.startError = VavException.VavErrorCodes.VAV_RESERVE_SPACE_FAILED;
            this.pcs.firePropertyChange(SESSION_START_ERROR, (Object)-1, (Object)this.startError);
            return;
        }
        try {
            this.loadVolume();
        }
        catch (Exception ex) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " :: start error VAV_LOAD_VOLUME_FAILED, Exception : " + ex.toString());
            this.shutdown();
            this.sessionState = 16;
            this.startError = VavException.VavErrorCodes.VAV_LOAD_VOLUME_FAILED;
            this.pcs.firePropertyChange(SESSION_START_ERROR, (Object)-1, (Object)this.startError);
            return;
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " :: started");
        this.sessionState = 2;
        this.startError = null;
        this.pcs.firePropertyChange(SESSION_STARTED_PROPERTY, false, true);
        this.startBatchProcessing(taskMgr);
    }

    private boolean isMemoryAvailable() {
        int volMemory = 0;
        if (this.volInfo != null) {
            volMemory = this.memCalculator.calRequiredMemUnits(this.volInfo);
        }
        volMemory = Math.max(VavMemoryResourceCalculator.memoryUsageMin, volMemory);
        int availJVMHeapMemory = 0;
        try {
            System.gc();
            Thread.sleep(100L);
            long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            availJVMHeapMemory = (int)(Runtime.getRuntime().maxMemory() - used >> 20);
        }
        catch (Exception ex) {
            this.logger.log(Level.INFO, "VavBatchSession.isMemoryAvailable()..failed to calculate availableJVM heap size, " + ex.toString());
        }
        if (availJVMHeapMemory > volMemory) {
            return true;
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " isMemoryAvailable()..insufficient heap available, volSize=" + volMemory + " | availableJVMheap=" + availJVMHeapMemory + " MB");
        return false;
    }

    public void abort() {
        if (this.sessionState == 4 || this.sessionState == 8) {
            return;
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " aborted");
        for (VavBatchJob job : this.jobs) {
            if (job.isComplete()) continue;
            job.abortJob();
        }
        this.shutdown();
        this.sessionState = 8;
        this.pcs.firePropertyChange(SESSION_ABORTED_PROPERTY, false, true);
    }

    public void pause() {
        if (this.sessionState == 4 || this.sessionState == 8) {
            return;
        }
        if (this.sessionState == 2) {
            for (VavBatchJob job : this.jobs) {
                if (job.isComplete() && job.isAborted()) continue;
                job.pauseJob();
            }
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " paused");
        }
    }

    public void resume() {
        if (this.sessionState == 4 || this.sessionState == 8) {
            return;
        }
        if (this.sessionState == 2) {
            for (VavBatchJob job : this.jobs) {
                if (!job.isPaused()) continue;
                job.resumeJob();
            }
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " resumed");
        }
    }

    protected void complete() {
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " completed");
        this.shutdown();
        this.sessionState = 4;
        this.pcs.firePropertyChange(SESSION_COMPLETED_PROPERTY, false, true);
    }

    protected void shutdown() {
        this.releaseSpace();
        if (this.volModel != null && this.volModel instanceof JRL3DModel) {
            ((JRL3DModel)this.volModel).disconnect();
        }
        this.volModel = null;
    }

    protected void loadVolume() throws Exception {
        BackgroundThread setVolumeThread = BackgroundThread.getBackgroundThread("VavBatchSession " + this.getID() + " Load Volume Thread");
        Runnable job = new Runnable(){

            @Override
            public void run() {
                try {
                    VavBatchEngine batchEngine = new VavBatchEngine();
                    if (VavBatchSession.this.volModel == null) {
                        batchEngine.setVolume(VavBatchSession.this.volInfo);
                    } else {
                        batchEngine.setVolumeModel(VavBatchSession.this.volModel);
                    }
                    VavBatchSession.this.volModel = batchEngine.getVolumeModel();
                    VavBatchSession.this.autoEdgeBoundingBox = batchEngine.getEdgeReducedBoundingBox();
                }
                catch (Exception ex) {
                    throw ex;
                }
                catch (Error er) {
                    throw new RuntimeException(er);
                }
            }
        };
        VolumeLoadExceptionListener exlsnr = new VolumeLoadExceptionListener();
        setVolumeThread.submit(job, exlsnr);
        try {
            setVolumeThread.waitForJob(job);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (exlsnr.ex != null) {
            throw exlsnr.ex;
        }
    }

    protected void startBatchProcessing(BatchParallelTaskManager taskMgr) {
        for (VavBatchJob job : this.jobs) {
            job.addTaskMonitor(this.jobMonitor);
            job.addPropertyChangeListener(this.jobLsnr);
            BatchTask task = new BatchTask(job, this.volModel, this.autoEdgeBoundingBox);
            if (job.getModel().isAutoRun()) {
                taskMgr.addBatchTask(task);
                continue;
            }
            taskMgr.addManualTask(task);
        }
    }

    public void setVolume(String seriesUID, int startImgNum, int endImgNum) throws VavException {
        String status;
        if (this.sessionState == 2 || this.sessionState == 32 || this.sessionState == 4) {
            return;
        }
        if (CvUtils.getDMSystem() == null || seriesUID == null) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " setVolume() ..... either DMSystem is null or no input series UID found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        DMObject[] sers = CvUtils.getDMSystem().getLocalDB().getRelated("series", new DMQuery("(0x0020, 0x000e) = " + seriesUID));
        if (sers == null || sers.length == 0) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " setVolume() ..... series not found ");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        DMTagValueInterface[] imgs = sers[0].getComposites();
        if (startImgNum >= 0 || endImgNum >= 0) {
            ArrayList<DMTagValueInterface> comps = new ArrayList<DMTagValueInterface>();
            XpDicomElement imNumElem = new XpDicomElement(32, 19);
            for (DMTagValueInterface dc : imgs) {
                imNumElem.value = ((DMComposite)dc).getValue(imNumElem.group, imNumElem.element);
                int imN = imNumElem.getIntValue();
                if (startImgNum >= 0 && imN < startImgNum || endImgNum >= 0 && imN > endImgNum) continue;
                comps.add(dc);
            }
            imgs = comps.toArray(new DMComposite[comps.size()]);
        }
        if (!"DATA_VALID".equals(status = this.volValidator.validateImages(imgs))) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " setVolume() ..... DATA INVALID " + status);
            if ("INVALID_MODALITY".equals(status) || "INVALID_IMAGETYPE".equals(status) || "INVALID_PHOTOMETRIC_INTERPRETATION".equals(status)) {
                throw new VavException(status, VavException.VavErrorCodes.VAV_UNSUPPORTED_DATA_TYPE);
            }
            if ("EXCEEEDS_SIZE".equals(status)) {
                throw new VavException(VavException.VavErrorCodes.VAV_VOLUME_SIZE_TOO_BIG);
            }
            throw new VavException(status, VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        this.volInfo = J3DGeomUtils.getVolume(imgs, null);
        this.volModel = null;
        String volume_serUID = (String)this.volInfo.getVSliceValue(0, 32, 14);
        if (!volume_serUID.equals(seriesUID)) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " setVolume() ..... VAV_LOADED_INCORRECT_VOLUME expectedSUID=" + seriesUID + " volumeSUID=" + volume_serUID);
            throw new VavException(VavException.VavErrorCodes.VAV_LOADED_INCORRECT_VOLUME);
        }
        for (VavBatchJob job : this.jobs) {
            job.getModel().setTarget(this.volInfo);
        }
    }

    public void setVolume(XjVolumeInfo vol) {
        if (this.sessionState == 2 || this.sessionState == 32 || this.sessionState == 4) {
            return;
        }
        this.volInfo = vol;
        this.volModel = null;
        for (VavBatchJob job : this.jobs) {
            job.getModel().setTarget(this.volInfo);
        }
    }

    public void setVolume(XjVolumeModel vol) {
        if (this.sessionState == 2 || this.sessionState == 32 || this.sessionState == 4) {
            return;
        }
        this.volModel = vol;
        this.volInfo = vol != null ? vol.getVolume() : null;
        for (VavBatchJob job : this.jobs) {
            job.getModel().setTarget(this.volInfo);
        }
    }

    protected String reserveSpace() {
        if (this.sessionState != 32) {
            return this.reserveSpaceHandle;
        }
        if (this.volInfo == null) {
            return this.reserveSpaceHandle;
        }
        if (this.jobs.size() == 0) {
            return this.reserveSpaceHandle;
        }
        long spaceRequired = 0L;
        for (VavBatchJob job : this.jobs) {
            long imgSize = job.getModel().getPixelWidth() * job.getModel().getPixelHeight() * 2;
            spaceRequired = (long)((double)spaceRequired + (double)job.getModel().getNumImages() * ((double)imgSize + 0.1 * (double)imgSize));
        }
        this.reserveSpaceHandle = CvUtils.getDMSystem().send("RESERVE_SPACE|DMPR|" + spaceRequired + "|B|T");
        return this.reserveSpaceHandle;
    }

    protected void releaseSpace() {
        if (this.sessionState == 2) {
            return;
        }
        if (this.reserveSpaceHandle != null && CvUtils.getDMSystem() != null) {
            CvUtils.getDMSystem().send("RELEASE_SPACE|" + this.reserveSpaceHandle + "|DMPR");
        }
        this.reserveSpaceHandle = null;
    }

    public void addTaskMonitor(TaskMonitor monitor) {
        this.monitors.add(monitor);
    }

    public void removeTaskMonitor(TaskMonitor monitor) {
        this.monitors.remove(monitor);
    }

    public VavBatchJob addBatchJob(VavBatchModel batchModel, String outputSeriesUID) {
        if (this.sessionState == 2 || this.sessionState == 32 || this.sessionState == 4) {
            return null;
        }
        if (batchModel == null) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJobs() ..... no valid batchModels found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJob() ..... create jobs begin");
        VavBatchJob job = VavBatchSession.createJob(batchModel, outputSeriesUID);
        if (job != null && this.volInfo != null) {
            job.getModel().setTarget(this.volInfo);
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJob() .....create jobs end");
        this.jobs.add(job);
        this.pcs.firePropertyChange("BATCH_JOB_LIST_CHANGED_PROPERTY", false, true);
        return job;
    }

    public VavBatchJob addBatchJob(String batchFile, String outputSeriesUID, boolean auto) throws VavException {
        if (this.sessionState == 2 || this.sessionState == 32 || this.sessionState == 4) {
            return null;
        }
        if (batchFile == null) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJobs() ..... no valid protocol file found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        List<VVBatchProtocol> protocols = VavBatchSession.getBatchProtocols(new String[]{batchFile}, auto);
        if (protocols.size() == 0) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJob() ..... no protcol file not found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJob() ..... create batch jobs begin");
        VavBatchJob job = VavBatchSession.createJob(protocols.get(0), outputSeriesUID);
        if (job != null) {
            job.getModel().setAutoRun(auto);
            if (this.volInfo != null) {
                job.getModel().setTarget(this.volInfo);
            }
            job.getModel().setSaving(true);
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJob() ..... create jobs end");
        this.jobs.add(job);
        this.pcs.firePropertyChange("BATCH_JOB_LIST_CHANGED_PROPERTY", false, true);
        return job;
    }

    public synchronized VavBatchJob[] addBatchJobs(String[] batchFiles, String[] outputSeriesUIDs, boolean autoBatch) throws VavException {
        if (this.sessionState == 2 || this.sessionState == 32 || this.sessionState == 4) {
            return null;
        }
        if (batchFiles == null || batchFiles.length == 0) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJobs() ..... no valid protocol file found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        List<VVBatchProtocol> protocols = VavBatchSession.getBatchProtocols(batchFiles, autoBatch);
        if (protocols.size() == 0) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJobs() ..... no valid protocol file found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJobs() ..... create batch jobs begin");
        ArrayList<VavBatchJob> bjobs = new ArrayList<VavBatchJob>();
        for (int i = 0; i < protocols.size(); ++i) {
            String suid = outputSeriesUIDs != null && i < outputSeriesUIDs.length ? outputSeriesUIDs[i] : null;
            VavBatchJob job = VavBatchSession.createJob(protocols.get(i), suid);
            if (job == null) continue;
            job.getModel().setAutoRun(autoBatch);
            if (this.volInfo != null) {
                job.getModel().setTarget(this.volInfo);
            }
            job.getModel().setSaving(true);
            bjobs.add(job);
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJobs() ..... create jobs end");
        this.jobs.addAll(bjobs);
        this.pcs.firePropertyChange("BATCH_JOB_LIST_CHANGED_PROPERTY", false, true);
        return bjobs.toArray(new VavBatchJob[bjobs.size()]);
    }

    public synchronized VavBatchJob[] addBatchJobs(VavBatchModel[] batchModels, String[] outputSeriesUIDs) {
        if (this.sessionState == 2 || this.sessionState == 32 || this.sessionState == 4) {
            return null;
        }
        if (batchModels == null || batchModels.length == 0) {
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJobs() ..... no valid batchModels found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJobs() ..... create jobs begin");
        ArrayList<VavBatchJob> bjobs = new ArrayList<VavBatchJob>();
        this.logger.log(Level.INFO, "create jobs begin");
        for (int i = 0; i < batchModels.length; ++i) {
            String suid = outputSeriesUIDs != null && i < outputSeriesUIDs.length ? outputSeriesUIDs[i] : null;
            VavBatchJob job = VavBatchSession.createJob(batchModels[i], suid);
            if (job == null) continue;
            if (this.volInfo != null) {
                job.getModel().setTarget(this.volInfo);
            }
            bjobs.add(job);
        }
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " addBatchJobs() ..... create jobs end");
        this.jobs.addAll(bjobs);
        this.pcs.firePropertyChange("BATCH_JOB_LIST_CHANGED_PROPERTY", false, true);
        return bjobs.toArray(new VavBatchJob[bjobs.size()]);
    }

    public void removeBatchJob(VavBatchJob job) {
        if (job.isStarted()) {
            return;
        }
        if (this.jobs.contains(job)) {
            job.abortJob();
            this.jobs.remove(job);
            this.pcs.firePropertyChange("BATCH_JOB_LIST_CHANGED_PROPERTY", false, true);
        }
    }

    public boolean isSessioIdle() {
        return this.sessionState == 1;
    }

    public boolean isSessioConfirmed() {
        return this.sessionState == 32;
    }

    public boolean isSessioStarted() {
        return this.sessionState == 2;
    }

    public boolean isSessionComplete() {
        return this.sessionState == 4;
    }

    public boolean isSessionAborted() {
        return this.sessionState == 8;
    }

    public boolean isSessionError() {
        return this.sessionState == 16;
    }

    public int getState() {
        return this.sessionState;
    }

    public int getNumJobsComplete() {
        return this.jobsDone;
    }

    public int getNumJobsFailed() {
        return this.jobsFailed;
    }

    private static XjVolumeInfo createVolume(String inputSeriesUID, int startImgNum, int endImgNum) {
        int status;
        DMObject[] sers = CvUtils.getDMSystem().getLocalDB().getRelated("series", new DMQuery("(0x0020, 0x000e) = " + inputSeriesUID));
        if (sers == null || sers.length == 0) {
            return null;
        }
        DMTagValueInterface[] imgs = sers[0].getComposites();
        if (startImgNum >= 0 || endImgNum >= 0) {
            ArrayList<DMTagValueInterface> comps = new ArrayList<DMTagValueInterface>();
            XpDicomElement imNumElem = new XpDicomElement(32, 19);
            for (DMTagValueInterface dc : imgs) {
                imNumElem.value = ((DMComposite)dc).getValue(imNumElem.group, imNumElem.element);
                int imN = imNumElem.getIntValue();
                if (startImgNum >= 0 && imN < startImgNum || endImgNum >= 0 && imN > endImgNum) continue;
                comps.add(dc);
            }
            imgs = comps.toArray(new DMComposite[comps.size()]);
        }
        if ((status = J3DGeomUtils.validateInputVolume(imgs)) != 0) {
            return null;
        }
        XjVolumeInfo vol = J3DGeomUtils.getVolume(imgs, null);
        return vol;
    }

    private static VavBatchJob createJob(VVBatchProtocol protocol, String seriesUID) {
        VavBatchModel model = VavBatchModel.createBatchModel(protocol);
        return VavBatchSession.createJob(model, seriesUID);
    }

    private static VavBatchJob createJob(VavBatchModel model, String seriesUID) {
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        if (vavOutputSession != null) {
            try {
                String[] sessargs = vavOutputSession.split(",");
                osession = new DMSession(sessargs);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        VavBatchJob job = new VavBatchJob(model);
        job.setOutputSession(osession);
        job.setSeriesUID(seriesUID);
        return job;
    }

    public static List<VVBatchProtocol> getBatchProtocols(String[] batchFiles, boolean autoBatch) {
        ArrayList<VVBatchProtocol> protocols = new ArrayList<VVBatchProtocol>();
        for (String protocol : batchFiles) {
            String view;
            VVBatchProtocol vvproto = null;
            try {
                vvproto = VVBatchProtocol.getBatchProtocol(protocol);
            }
            catch (FileNotFoundException fnf) {
            }
            catch (IOException e) {
                // empty catch block
            }
            if (vvproto == null || autoBatch && ((view = vvproto.viewName) == null || !view.toLowerCase(Locale.ENGLISH).startsWith("Axial".toLowerCase(Locale.ENGLISH)) && !view.toLowerCase(Locale.ENGLISH).startsWith("Coronal".toLowerCase(Locale.ENGLISH)) && !view.toLowerCase(Locale.ENGLISH).startsWith("Sagittal".toLowerCase(Locale.ENGLISH)))) continue;
            protocols.add(vvproto);
        }
        return protocols;
    }

    @Override
    public int getNumBatchJobs() {
        return this.jobs.size();
    }

    @Override
    public VavBatchJob getBatchJob(int index) {
        if (index < 0 || index >= this.jobs.size()) {
            return null;
        }
        return this.jobs.get(index);
    }

    @Override
    public boolean confirm() {
        if (this.sessionState == 1) {
            if (this.volInfo == null || this.jobs.size() == 0) {
                return false;
            }
            this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " confirm");
            for (VavBatchJob job : this.jobs) {
                job.confirmJob();
            }
            this.sessionState = 32;
            this.pcs.firePropertyChange(SESSION_CONFIRMED_PROPERTY, false, true);
            return true;
        }
        return false;
    }

    public boolean reconfirm() {
        this.logger.log(Level.INFO, "VavBatchSession " + this.getID() + " re-confirm");
        if (this.sessionState == 1) {
            this.confirm();
        } else if (this.sessionState == 16) {
            if (this.volInfo == null || this.jobs.size() == 0) {
                return false;
            }
            ++this.reconfirmAttempts;
            if (this.reconfirmAttempts > reconfirmMaxAttemps) {
                this.logger.log(Level.WARNING, "VavBatchSession " + this.getID() + " reconfirm Max attempts exceeded");
                this.sessionState = 16;
                if (this.startError == null) {
                    this.startError = VavException.VavErrorCodes.VAV_LOAD_VOLUME_FAILED;
                }
                this.pcs.firePropertyChange(SESSION_ERROR_PROPERTY, (Object)-1, (Object)this.startError);
                return false;
            }
            this.startError = null;
            this.sessionState = 32;
            this.pcs.firePropertyChange(SESSION_CONFIRMED_PROPERTY, false, true);
            return true;
        }
        return false;
    }

    @Override
    public VavBatchJob[] getBatchJobs() {
        return this.jobs.toArray(new VavBatchJob[this.jobs.size()]);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(prop, l);
    }

    private class VolumeLoadExceptionListener
    implements ExceptionListener {
        public Exception ex = null;

        private VolumeLoadExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            this.ex = e;
        }
    }
}

