/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.j3d.vav.BatchParallelTaskManager;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchJob;
import com.ge.med.cse.cvf.j3d.vav.VavBatchJobContainer;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.j3d.vav.VavBatchSession;
import com.ge.med.cse.cvf.j3d.vav.VavException;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VavBatchManager {
    protected static final Logger logger = Logger.getLogger(VavBatchManager.class.getName());
    private BatchParallelTaskManager taskManager = new BatchParallelTaskManager();
    private boolean processing_ = false;
    private boolean processingPaused_ = false;
    private String appIdentifier_ = null;
    private List<VavBatchSession> batchSessions = Collections.synchronizedList(new ArrayList());
    private List<VavBatchSession> activebatchSessions = Collections.synchronizedList(new ArrayList());
    private static VavBatchManager self = null;
    private PropertyChangeListener sessionLsnr = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            VavBatchSession session = (VavBatchSession)evt.getSource();
            if ("session_aborted_property".equals(evt.getPropertyName()) || "session_completed_property".equals(evt.getPropertyName())) {
                logger.log(Level.INFO, "Batch Session [" + session.getID() + "] complete or aborted");
                session.removePropertyChangeListener(this);
                VavBatchManager.this.activebatchSessions.remove(session);
            } else if ("session_started_property".equals(evt.getPropertyName())) {
                logger.log(Level.INFO, "Batch Session [" + session.getID() + "] started");
            } else if ("session_start_error".equals(evt.getPropertyName())) {
                VavException.VavErrorCodes error = (VavException.VavErrorCodes)((Object)evt.getNewValue());
                logger.log(Level.INFO, "Batch Session [" + session.getID() + "] start error : " + error.getMessage());
                VavBatchManager.this.activebatchSessions.remove(session);
                if (VavException.VavErrorCodes.VAV_RESERVE_SPACE_FAILED.equals((Object)error) || VavException.VavErrorCodes.VAV_LOAD_VOLUME_FAILED.equals((Object)error) || VavException.VavErrorCodes.VAV_VOLUME_SIZE_TOO_BIG.equals((Object)error)) {
                    session.removePropertyChangeListener(this);
                    if (session.reconfirm()) {
                        VavBatchManager.this.batchSessions.add(session);
                    }
                }
            } else if ("session_error_property".equals(evt.getPropertyName())) {
                VavBatchManager.this.activebatchSessions.remove(session);
                VavException.VavErrorCodes error = (VavException.VavErrorCodes)((Object)evt.getNewValue());
                logger.log(Level.WARNING, "Batch Session [" + session.getID() + "] error : " + error.getMessage());
            }
        }
    };
    private Object lock = new Object();

    public VavBatchManager(String appIdentifier) {
        this.appIdentifier_ = appIdentifier;
    }

    public static synchronized VavBatchManager getInstance(String appIdentifier) {
        if (self == null) {
            self = new VavBatchManager(appIdentifier);
        }
        return self;
    }

    public String getName() {
        return this.appIdentifier_;
    }

    public synchronized int getNumPendingSessions() {
        return this.batchSessions.size() + this.activebatchSessions.size();
    }

    public synchronized void startProcessing() {
        if (this.taskManager == null) {
            return;
        }
        if (!this.processing_) {
            this.processing_ = true;
            this.startNextSessionThread();
        }
    }

    public synchronized void shutdown() {
        if (this.processing_) {
            for (int i = 0; i < this.activebatchSessions.size(); ++i) {
                VavBatchSession session = this.activebatchSessions.get(i);
                session.abort();
                session.removePropertyChangeListener(this.sessionLsnr);
            }
            this.activebatchSessions.clear();
            for (VavBatchSession session : this.batchSessions) {
                session.abort();
            }
            this.batchSessions.clear();
            this.processing_ = false;
            this.processingPaused_ = false;
            this.taskManager.shutdown();
            this.taskManager = null;
        }
    }

    public synchronized void pauseProcessing() {
        if (this.processing_ && !this.processingPaused_) {
            this.taskManager.pause();
            this.processingPaused_ = true;
            for (int i = 0; i < this.activebatchSessions.size(); ++i) {
                VavBatchSession session = this.activebatchSessions.get(i);
                session.pause();
            }
        }
    }

    public synchronized void resumeProcessing() {
        if (this.processing_ && this.processingPaused_) {
            this.taskManager.resume();
            this.processingPaused_ = false;
            for (int i = 0; i < this.activebatchSessions.size(); ++i) {
                VavBatchSession session = this.activebatchSessions.get(i);
                session.resume();
            }
        }
    }

    private void startNextSessionThread() {
        Thread th = new Thread(){

            @Override
            public void run() {
                System.err.println("============ startNextSessionThread");
                logger.log(Level.INFO, "VavBatchManager.startNextSessionThread() ..... started");
                VavBatchManager.this.nextSession();
                logger.log(Level.INFO, "VavBatchManager.startNextSessionThread() ..... exiting");
            }
        };
        th.setName("VavBatchManager[" + this.appIdentifier_ + "]_nextSessionThread");
        th.start();
    }

    private synchronized boolean isProcessingPaused() {
        return this.processingPaused_;
    }

    private synchronized boolean isProcessingStarted() {
        return this.processing_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextSession() {
        logger.log(Level.INFO, "VavBatchManager.nextSession() ..... begin");
        while (this.isProcessingStarted()) {
            Object object = this.lock;
            synchronized (object) {
                while (this.isProcessingStarted() && (this.isProcessingPaused() || this.batchSessions.isEmpty())) {
                    try {
                        this.lock.wait(100L);
                    }
                    catch (InterruptedException ex) {}
                }
            }
            if (!this.processing_) break;
            logger.log(Level.FINE, "VavBatchManager.nextSession() ..... processing batch session - begin");
            VavBatchSession session = null;
            ListIterator<VavBatchSession> it = this.batchSessions.listIterator();
            while (it.hasNext()) {
                VavBatchSession sess = it.next();
                if (!sess.isSessioConfirmed()) continue;
                session = sess;
                break;
            }
            if (session != null) {
                System.err.println("============ nextSession processing batch session - " + session.getID());
                logger.log(Level.INFO, "VavBatchManager.nextSession() ..... nextSession processing batch session - " + session.getID());
                this.batchSessions.remove(session);
                session.addPropertyChangeListener(this.sessionLsnr);
                this.activebatchSessions.add(session);
                session.start(this.taskManager);
                logger.log(Level.INFO, "VavBatchManager.nextSession() ..... session start triggered");
                Object object2 = this.lock;
                synchronized (object2) {
                    try {
                        this.lock.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                System.err.println("============ nextSession processing batch session - session state " + session.getState());
                logger.log(Level.INFO, "VavBatchManager.nextSession() ..... session state " + session.getState());
            }
            logger.log(Level.FINE, "VavBatchManager.nextSession() ..... next session loop");
        }
        logger.log(Level.INFO, "VavBatchManager.nextSession() ..... end");
    }

    public synchronized VavBatchJobContainer addBatchJobs(String[] batchFiles, String[] outputSeriesUIDs, boolean autoBatch, String inputSeriesUID, int startImgNum, int endImgNum) throws VavException {
        if (batchFiles == null || batchFiles.length == 0) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid protocol file found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputSeriesUID == null) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input series UID found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputSeriesUID, startImgNum, endImgNum);
        session.addBatchJobs(batchFiles, outputSeriesUIDs, autoBatch);
        logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(String[] batchFiles, String[] outputSeriesUIDs, boolean autoBatch, XjVolumeInfo inputVolInfo) throws VavException {
        if (batchFiles == null || batchFiles.length == 0) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid protocol file found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputVolInfo == null) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input Volume Info found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputVolInfo);
        session.addBatchJobs(batchFiles, outputSeriesUIDs, autoBatch);
        logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(String[] batchFiles, String[] outputSeriesUIDs, boolean autoBatch, XjVolumeModel inputVolModel) throws VavException {
        if (batchFiles == null || batchFiles.length == 0) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid protocol file found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputVolModel == null) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input Volume Model found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputVolModel);
        session.addBatchJobs(batchFiles, outputSeriesUIDs, autoBatch);
        logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(String[] batchFiles, String[] outputSeriesUIDs, boolean autoBatch, T3DViewport port) throws VavException {
        VavBatchJob[] jobs;
        if (batchFiles == null || batchFiles.length == 0) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid protocol file found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (port == null) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... 3D port not found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(port.getVolumeModel());
        for (VavBatchJob job : jobs = session.addBatchJobs(batchFiles, outputSeriesUIDs, autoBatch)) {
            job.getModel().setTarget(port);
        }
        logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(VavBatchModel[] batchModels, String[] outputSeriesUIDs, String inputSeriesUID, int startImgNum, int endImgNum) throws VavException {
        if (batchModels == null || batchModels.length == 0) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid batch model found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputSeriesUID == null) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input series UID found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputSeriesUID, startImgNum, endImgNum);
        session.addBatchJobs(batchModels, outputSeriesUIDs);
        logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(VavBatchModel[] batchModels, String[] outputSeriesUIDs, XjVolumeInfo inputVolInfo) throws VavException {
        if (batchModels == null || batchModels.length == 0) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid batch model found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputVolInfo == null) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input Volume Info found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputVolInfo);
        session.addBatchJobs(batchModels, outputSeriesUIDs);
        logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(VavBatchModel[] batchModels, String[] outputSeriesUIDs, XjVolumeModel inputVolModel) {
        if (batchModels == null || batchModels.length == 0) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid batch model found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputVolModel == null) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input Volume Modwl found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputVolModel);
        session.addBatchJobs(batchModels, outputSeriesUIDs);
        logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(VavBatchModel[] batchModels, String[] outputSeriesUIDs, T3DViewport port) {
        VavBatchJob[] jobs;
        if (batchModels == null || batchModels.length == 0) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid batch model found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (port == null) {
            logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no 3D port found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(port.getVolumeModel());
        for (VavBatchJob job : jobs = session.addBatchJobs(batchModels, outputSeriesUIDs)) {
            job.getModel().setTarget(port);
        }
        logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public static String[] getDefaultBatchProtocols() {
        return VVBatchProtocol.getBatchProtocolFileList();
    }
}

