/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.j3d.vav.VavException;
import com.ge.med.cse.cvf.j3d.vav.VavImageGenerationMonitor;
import com.ge.med.cse.cvf.j3d.vav.VavLoopModel;
import com.ge.med.cse.cvf.j3d.vav.VavRectPrismBatchModel;
import com.ge.med.cse.cvf.j3d.vav.ui.ObliqueBatchVc;
import com.ge.med.cse.cvf.j3d.vav.ui.RotateBatchVc;
import com.ge.med.cse.cvf.j3d.vav.ui.Rotation3DVc;
import com.ge.med.cse.cvf.saveimage.XpSaveImage;
import com.ge.med.cse.cvf.saveimage.XpSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveUtil;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.GrayScaleCapable;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class VavBatchJob
implements PropertyChangeListener {
    protected final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.j3d.vav");
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROCESSING_ERROR_PROPERTY = "PROCESSING_ERROR_PROPERTY";
    private DMSession outputSession = null;
    protected JnVector3d inputSliceI = null;
    protected JnVector3d inputSliceJ = null;
    protected JnVector3d inputSliceN = null;
    protected String seriesUID = null;
    protected int seriesNum = -1;
    protected String seriesDesc = null;
    protected long seriesDate = -1L;
    protected int startImageNum;
    protected int imageNum = this.startImageNum = 1;
    private DicomComposite refComp = null;
    private VavBatchModel model = null;
    private BatchFrame[] batchFrames = null;
    private DicomComposite refFrame = null;
    protected int nextFrameIndex = -1;
    private XpSaveParameters vpParams = null;
    private List<TaskMonitor> taskMonitors = new ArrayList<TaskMonitor>();
    protected int numImagesProcessed = 0;
    protected int numErrors = 0;
    protected String taskName = "VAV Batch Processing";
    private double[] tempEye = new double[3];
    private double[] tempLook = new double[3];
    private double[] tempUp = new double[3];
    private double[] tempViewClip = new double[2];
    private boolean started = false;
    private boolean complete = false;
    private boolean aborted = false;
    private static boolean debugTrace = CvPropertiesManager.getProperty("vav.debug_trace") != null;
    private static final boolean referenceFrame = CvPropertiesManager.getBoolean("vav.referenceframe", false);
    private boolean generateRefFrame = referenceFrame;
    private static boolean exitONsaveFrameFailure = CvPropertiesManager.getBoolean("vav.batchJob.exitOnSaveFrameFailure", false);
    private static int saveFrameRetryCount = Integer.parseInt(CvPropertiesManager.getProperty("vav.batchJob.saveFrameRetryCount", "3"));
    private boolean applyAutoEdge = false;
    private VavBatchModel savedModel = null;
    private boolean paused = false;
    private boolean confirmed = false;
    private static final double mfactor = 1.2;
    private int reserveSpaceHandle = -1;

    public VavBatchJob() {
        this(new VavRectPrismBatchModel());
    }

    public VavBatchJob(VavBatchModel model) {
        this.model = model;
    }

    public String getName() {
        return this.taskName;
    }

    public synchronized void setSeriesUID(String seriesUID) {
        if (this.started || this.aborted || this.complete) {
            this.logger.log(Level.INFO, "Cannot set series UID, Batch Job already started");
            return;
        }
        this.seriesUID = seriesUID;
    }

    public String getSeriesUID() {
        return this.seriesUID;
    }

    public synchronized void setSeriesNumber(int seriesNum) {
        if (this.started || this.aborted || this.complete) {
            this.logger.log(Level.INFO, "Cannot set series number, Batch Job already started");
            return;
        }
        this.seriesNum = seriesNum;
    }

    public int getSeriesNumber() {
        return this.seriesNum;
    }

    public synchronized void setStartFrameNumber(int frameNumber) {
        if (this.started || this.aborted || this.complete) {
            this.logger.log(Level.INFO, "Cannot set start frame number, Batch Job already started");
            return;
        }
        if (frameNumber > 0) {
            this.startImageNum = frameNumber;
        }
    }

    public synchronized int getStartFrameNumber() {
        return this.startImageNum;
    }

    public synchronized void setModel(VavBatchModel model) {
        if (this.started || this.aborted || this.complete || this.confirmed) {
            this.logger.log(Level.INFO, "Cannot set batch model, Batch Job already started/confirmed");
            return;
        }
        if (!model.equals(this.model)) {
            if (this.model != null) {
                this.logger.log(Level.WARNING, "Overriding model in batch job.  Information associated with previous model will be lost.");
            }
            this.model = model;
            this.batchFrames = null;
            this.nextFrameIndex = -1;
        }
    }

    public synchronized VavBatchModel getModel() {
        return this.model;
    }

    public void setOutputSession(DMSession session) {
        if (this.started || this.aborted || this.complete) {
            this.logger.log(Level.INFO, "Cannot set ouput session, Batch Job already started");
            return;
        }
        this.outputSession = session;
    }

    public DMSession getOutputSession() {
        return this.outputSession;
    }

    public void setReferenceFrame(boolean refFrameOn) {
        if (this.started || this.aborted || this.complete || this.confirmed) {
            return;
        }
        this.generateRefFrame = refFrameOn;
    }

    public boolean isReferenceFrameOn() {
        return this.generateRefFrame;
    }

    public final synchronized BatchFrame nextFrame() {
        if (this.isAborted()) {
            this.logger.log(Level.INFO, "VavBatchJob.nextFrame() Job already aborted");
            return null;
        }
        if (!this.isConfirmed()) {
            this.logger.log(Level.INFO, "VavBatchJob.nextFrame() Job not confirmed yet");
            return null;
        }
        if (this.batchFrames == null) {
            this.logger.log(Level.INFO, "VavBatchJob.nextFrame() no batch frames for processing");
            return null;
        }
        if (!this.isStarted()) {
            this.started = true;
            this.imageNum = this.startImageNum;
            this.nextFrameIndex = 0;
            this.logger.log(Level.INFO, "TID=VAV_INVOKE_LATER task begin");
            SwingUtilities.invokeLater(new TaskBeginRunnable(this.taskName, this.batchFrames.length));
        }
        if (this.nextFrameIndex >= 0 && this.nextFrameIndex < this.batchFrames.length && !this.batchFrames[this.nextFrameIndex].isProcessed()) {
            return this.batchFrames[this.nextFrameIndex++];
        }
        for (int i = 0; i < this.batchFrames.length; ++i) {
            if (this.batchFrames[i].isProcessed()) continue;
            this.nextFrameIndex = i;
            return this.batchFrames[this.nextFrameIndex++];
        }
        return null;
    }

    public void addTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.add(tm);
    }

    public void removeTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.remove(tm);
    }

    protected void notifyTaskBegin(String taskName, int totalWork) {
        this.logger.log(Level.FINE, "TID=VAV_BATCH_JOB: model = " + this.model);
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = this.taskMonitors.get(i);
            tm.taskBegin(taskName, totalWork);
        }
    }

    protected void notifyTaskProgress(String taskName, int units, XpBufferedImage image) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = this.taskMonitors.get(i);
            if (tm instanceof VavImageGenerationMonitor) {
                ((VavImageGenerationMonitor)tm).taskProgress(taskName, units, this, image);
                continue;
            }
            tm.taskProgress(taskName, units);
        }
    }

    protected void notifyTaskDone(String taskName) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = this.taskMonitors.get(i);
            tm.taskDone(taskName);
        }
    }

    protected void notifyTaskFailed(String taskName, String reason, Exception e) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = this.taskMonitors.get(i);
            tm.taskFailed(taskName, reason, e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("PROCESSING_COMPLETE_PROPERTY")) {
            ++this.numImagesProcessed;
            XpBufferedImage image = (XpBufferedImage)evt.getNewValue();
            SwingUtilities.invokeLater(new TaskProgressRunnable(this.taskName, this.numImagesProcessed, image));
            if (this.numImagesProcessed + this.numErrors == this.batchFrames.length) {
                this.complete = true;
                if (!this.aborted) {
                    SwingUtilities.invokeLater(new TaskDoneRunnable(this.taskName));
                }
            }
        }
        if (evt.getPropertyName().equals(PROCESSING_ERROR_PROPERTY)) {
            ++this.numErrors;
            SwingUtilities.invokeLater(new FireErrorRunnable(evt.getOldValue(), evt.getNewValue()));
            if (exitONsaveFrameFailure && this.aborted) {
                VavException.VavErrorCodes errorcode = (VavException.VavErrorCodes)((Object)evt.getNewValue());
                SwingUtilities.invokeLater(new TaskFailedRunnable(this.taskName, errorcode.getMessage(), new VavException(errorcode)));
            }
            if (this.numImagesProcessed + this.numErrors == this.batchFrames.length) {
                this.complete = true;
                if (!this.aborted) {
                    SwingUtilities.invokeLater(new TaskDoneRunnable(this.taskName));
                }
            }
        }
    }

    public synchronized int getNumFrames() {
        if (this.batchFrames == null) {
            return 0;
        }
        return this.batchFrames.length;
    }

    public int getNumFramesProcessed() {
        return this.numImagesProcessed;
    }

    public boolean abortJob() {
        if (!this.isComplete() && !this.isAborted()) {
            this.aborted = true;
            if (this.batchFrames == null) {
                SwingUtilities.invokeLater(new TaskBeginRunnable(this.taskName, this.model != null ? this.model.getNumImages() : 1));
            }
            SwingUtilities.invokeLater(new TaskDoneRunnable(this.taskName));
            return true;
        }
        return false;
    }

    public void pauseJob() {
        if (this.isStarted() && !this.isAborted() && !this.isComplete()) {
            this.paused = true;
        }
    }

    public void resumeJob() {
        if (this.isStarted() && this.paused) {
            this.paused = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmJob() {
        XjVolumeInfo volInfo;
        if (this.isStarted() || this.isAborted() || this.isComplete()) {
            return;
        }
        if (this.model == null) {
            this.logger.log(Level.INFO, "VavBatchJob.confirmJob() ....aborted model not set, job cannot be confirmed");
            return;
        }
        if (this.model instanceof VavRectPrismBatchModel && this.model.getFitToVolume() && this.model.isAutoEdgeEnabled()) {
            this.logger.log(Level.INFO, " VavBatchJob confirmJob : Enable Auto edge ");
            this.applyAutoEdge = true;
            VavRectPrismBatchModel batchModel = (VavRectPrismBatchModel)this.model;
            if (this.savedModel == null) {
                this.savedModel = new VavRectPrismBatchModel();
            }
            batchModel.copyModelParams((VavRectPrismBatchModel)this.savedModel);
        }
        this.createBatchFramesFromModel(this.model);
        T3DViewport port = this.getModel().getTargetPort();
        if (port != null) {
            this.vpParams = new XpSaveParameters();
            double max = this.getModel().getTargetPort().getWinMax();
            double min = this.getModel().getTargetPort().getWinMin();
            this.vpParams.defaultWindowWidthLevel = new double[2];
            this.vpParams.defaultWindowWidthLevel[0] = max - min;
            this.vpParams.defaultWindowWidthLevel[1] = (max + min) / 2.0;
            XpSaveParameters refParams = new XpSaveParameters();
            double[] viewClip = new double[2];
            port.getViewClip(viewClip);
            double thickness = Math.abs(viewClip[0] - viewClip[1]);
            String renderStyle = port.getRenderStyle();
            double minThickness = Math.abs(J3DGeomUtils.getMinSliceThickness(port.getVolume(), port.getLookPoint(null), port.getEyePoint(null), false));
            if (thickness - minThickness < 1.0E-4) {
                thickness = minThickness;
                if (!("REFORMAT".equals(renderStyle) || "REFORMAT.TC".equals(renderStyle) || "REFORMAT.NN".equals(renderStyle))) {
                    renderStyle = "REFORMAT.TC";
                }
            }
            refParams.imageThickness = thickness;
            refParams.renderStyle = renderStyle;
            refParams.defaultWindowWidthLevel = new double[2];
            refParams.defaultWindowWidthLevel[0] = this.vpParams.defaultWindowWidthLevel[0];
            refParams.defaultWindowWidthLevel[1] = this.vpParams.defaultWindowWidthLevel[1];
            refParams.sliceSpacing = -1.0;
            BufferedImage img = (BufferedImage)((XpBufferedImage)port.getFrame()).getPixelData();
            BufferedImage batchvc_img = new BufferedImage(img.getWidth(), img.getHeight(), 11);
            Graphics g = batchvc_img.getGraphics();
            XpVisualComponent batchvc = this.getBatchVC(port.getT3DComponent());
            if (batchvc != null) {
                if (batchvc instanceof GrayScaleCapable) {
                    ((GrayScaleCapable)((Object)batchvc)).setGrayScaleMode(true);
                }
                batchvc.paint(g);
                if (batchvc instanceof GrayScaleCapable) {
                    ((GrayScaleCapable)((Object)batchvc)).setGrayScaleMode(false);
                }
            }
            short[] imglayer = null;
            short[] imglayer_stored = null;
            try {
                imglayer = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
                imglayer_stored = new short[imglayer.length];
                for (int j = 0; j < imglayer.length; ++j) {
                    imglayer_stored[j] = imglayer[j];
                }
                short[] gxlayer = ((DataBufferUShort)batchvc_img.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < imglayer.length; ++i) {
                    int pixval = gxlayer[i] & 0xFFFF;
                    double w = (double)pixval / 65536.0;
                    if (!(w > 0.0)) continue;
                    imglayer[i] = Short.MAX_VALUE;
                    int curL = i + img.getWidth();
                    if (curL <= imglayer.length) {
                        imglayer[i + img.getWidth()] = Short.MIN_VALUE;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                String msg = "Exception during Reference image creation. \n " + ex.getMessage();
                this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            }
            refParams.image = port.getFrame();
            this.refFrame = XpSaveUtil.createComposite(port, refParams);
            for (int j = 0; j < imglayer.length; ++j) {
                imglayer[j] = imglayer_stored[j];
            }
        }
        if (this.refComp == null && (volInfo = (XjVolumeInfo)this.model.getTargetVolume()) != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(volInfo.getRelatedComposite());
                this.refComp = new DicomComposite();
                this.refComp.read(fis);
            }
            catch (DMException ex) {
                this.logger.log(Level.WARNING, "Exception while reading the reference composite", ex);
                ex.printStackTrace();
            }
            catch (FileNotFoundException e) {
                this.logger.log(Level.WARNING, "Exception while reading the reference composite", e);
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        this.logger.log(Level.INFO, "Exception while closing the reference composite file", e);
                        e.printStackTrace();
                    }
                }
            }
        }
        this.confirmed = true;
    }

    private void createBatchFramesFromModel(VavBatchModel batchmodel) {
        double frameThk = batchmodel.getThickness();
        String rstyle = batchmodel.getRenderStyle();
        double ww = batchmodel.getWindowWidth();
        double wl = batchmodel.getWindowLevel();
        this.batchFrames = new BatchFrame[batchmodel.getNumImages()];
        for (int i = 0; i < this.batchFrames.length; ++i) {
            this.batchFrames[i] = new BatchFrame();
            this.batchFrames[i].setCamera(batchmodel.getSliceEyePoint(i, this.tempEye), batchmodel.getSliceLookPoint(i, this.tempLook), batchmodel.getSliceUp(i, this.tempUp));
            if (batchmodel instanceof VavRectPrismBatchModel) {
                this.batchFrames[i].setActualLookPoint(((VavRectPrismBatchModel)batchmodel).getActualSliceLookPoint(i, this.tempLook));
                this.batchFrames[i].setSpacing(((VavRectPrismBatchModel)batchmodel).getSpacing());
            } else if (batchmodel instanceof VavLoopModel) {
                this.batchFrames[i].setSpacing(((VavLoopModel)batchmodel).getSpacing());
            }
            if (i == 0) {
                boolean is3drfmt = "FULLBODY_AVERAGE".equals(rstyle) || "FULLBODY_MINIP".equals(rstyle) || "FULLBODY_MIP".equals(rstyle);
                XjVolumeGeometry volGeom = batchmodel.getTargetVolume();
                if (is3drfmt) {
                    frameThk = J3DGeomUtils.getMaxSliceThickness(volGeom, this.batchFrames[i].getLookPoint(null), this.batchFrames[i].getEyePoint(null));
                    System.out.println("Image thickness " + frameThk);
                } else {
                    double minThk = J3DGeomUtils.getMinSliceThickness(volGeom, this.batchFrames[i].getLookPoint(null), this.batchFrames[i].getEyePoint(null));
                    if (frameThk - minThk < 1.0E-4 || rstyle.startsWith("REFORMAT")) {
                        frameThk = minThk;
                        if (!"REFORMAT".equals(rstyle) && !"REFORMAT.TC".equals(rstyle)) {
                            rstyle = VVBatchProtocol.defaultRenderingQuality() == 2 ? "REFORMAT.TC" : "REFORMAT";
                        }
                    }
                    System.out.println("Image thickness " + frameThk);
                    System.out.println("Image render style " + rstyle);
                }
            }
            this.batchFrames[i].setViewHeight(batchmodel.getFov());
            double halfThickness = frameThk / 2.0;
            this.tempViewClip[0] = -halfThickness;
            this.tempViewClip[1] = halfThickness;
            this.batchFrames[i].setViewClip(this.tempViewClip);
            this.batchFrames[i].setInverted(batchmodel.isInverted());
            this.batchFrames[i].setWidth(batchmodel.getPixelDimension().width);
            this.batchFrames[i].setHeight(batchmodel.getPixelDimension().height);
            this.batchFrames[i].setRenderStyle(rstyle);
            this.batchFrames[i].setInverted(batchmodel.inverted);
            if (ww > 0.0) {
                this.batchFrames[i].setWindowing(ww, wl);
            }
            this.batchFrames[i].addPropertyChangeListener("PROCESSING_COMPLETE_PROPERTY", this);
            this.batchFrames[i].addPropertyChangeListener(PROCESSING_ERROR_PROPERTY, this);
        }
        this.seriesDesc = batchmodel.getSeriesDescription() == null ? "Reformatted" : batchmodel.getSeriesDescription();
        this.taskName = "VAV " + this.seriesDesc;
    }

    protected void setVolumeBoundingBox(XjVolumeModel volModel, XjVolumeGeometry boundingBox) {
        if (boundingBox == null) {
            return;
        }
        if (this.isStarted() || this.isAborted() || this.isComplete()) {
            this.logger.log(Level.INFO, "VavBatchJob: Job is already processed or aborted, so cannot apply bounding box");
            return;
        }
        if (!this.isConfirmed() && this.model != null && this.model instanceof VavRectPrismBatchModel) {
            this.logger.log(Level.INFO, "VavBatchJob.setVolumeBoundingBox() .... job not confirmed yet");
            VavRectPrismBatchModel batchModel = (VavRectPrismBatchModel)this.model;
            this.logger.log(Level.INFO, "VavBatchJob.setVolumeBoundingBox() ....Before Bounding box constraint applied  : Model values are \nDescription: " + batchModel.getSeriesDescription() + "\n" + "Fit to Volume " + batchModel.getFitToVolume() + "\n" + "Auto Edge : " + batchModel.isAutoEdgeEnabled() + "\n" + "NumberOfViews: " + batchModel.getNumImages() + "\n" + "FieldOfView: " + batchModel.getFov() + "\n" + "spacing: " + batchModel.getSpacing() + "\n" + "thickness: " + batchModel.getThickness() + "\n" + "Center : " + batchModel.getCenter() + "\n" + "vectorX: " + batchModel.getNormal() + "\n" + "renderMode: " + batchModel.getRenderStyle() + "\n");
            batchModel.setBoundingBox(boundingBox);
            this.logger.log(Level.INFO, "VavBatchJob.setVolumeBoundingBox() ....After Bounding box constraint applied  : Model values are \nDescription: " + batchModel.getSeriesDescription() + "\n" + "Fit to Volume " + batchModel.getFitToVolume() + "\n" + "Auto Edge : " + batchModel.isAutoEdgeEnabled() + "\n" + "NumberOfViews: " + batchModel.getNumImages() + "\n" + "FieldOfView: " + batchModel.getFov() + "\n" + "spacing: " + batchModel.getSpacing() + "\n" + "thickness: " + batchModel.getThickness() + "\n" + "Center : " + batchModel.getCenter() + "\n" + "vectorX: " + batchModel.getNormal() + "\n" + "renderMode: " + batchModel.getRenderStyle() + "\n");
        } else if (this.applyAutoEdge && this.savedModel != null && this.savedModel instanceof VavRectPrismBatchModel && volModel != null) {
            this.logger.log(Level.INFO, "VavBatchJob.setVolumeBoundingBox() ....job confirmed, need to apply auto edge and update job batch frames");
            VavRectPrismBatchModel batchModel = (VavRectPrismBatchModel)this.savedModel;
            batchModel.setTarget(volModel);
            this.logger.log(Level.INFO, "VavBatchJob.updateJobAndReConfirm() ....Before bounding box constraint applied  : Model values are \nDescription: " + batchModel.getSeriesDescription() + "\n" + "Fit to Volume " + batchModel.getFitToVolume() + "\n" + "Auto Edge : " + batchModel.isAutoEdgeEnabled() + "\n" + "NumberOfViews: " + batchModel.getNumImages() + "\n" + "FieldOfView: " + batchModel.getFov() + "\n" + "spacing: " + batchModel.getSpacing() + "\n" + "thickness: " + batchModel.getThickness() + "\n" + "Center : " + batchModel.getCenter() + "\n" + "vectorX: " + batchModel.getNormal() + "\n" + "renderMode: " + batchModel.getRenderStyle() + "\n");
            batchModel.setBoundingBox(boundingBox);
            this.logger.log(Level.INFO, "VavBatchJob.updateJobAndReConfirm() ....After bounding box constraint applied  : Model values are \nDescription: " + batchModel.getSeriesDescription() + "\n" + "Fit to Volume " + batchModel.getFitToVolume() + "\n" + "Auto Edge : " + batchModel.isAutoEdgeEnabled() + "\n" + "NumberOfViews: " + batchModel.getNumImages() + "\n" + "FieldOfView: " + batchModel.getFov() + "\n" + "spacing: " + batchModel.getSpacing() + "\n" + "thickness: " + batchModel.getThickness() + "\n" + "Center : " + batchModel.getCenter() + "\n" + "vectorX: " + batchModel.getNormal() + "\n" + "renderMode: " + batchModel.getRenderStyle() + "\n");
            this.createBatchFramesFromModel(batchModel);
            this.model = batchModel;
        }
    }

    private XpVisualComponent getBatchVC(Container comp) {
        Component[] children = comp.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof ObliqueBatchVc) && !(children[i] instanceof RotateBatchVc) && !(children[i] instanceof Rotation3DVc)) continue;
            return (XpVisualComponent)children[i];
        }
        return null;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void reserveSpace() {
        if (this.isStarted()) {
            return;
        }
        if (this.getModel() != null && this.getModel().isTargetSet()) {
            int imgSize = this.getModel().getPixelWidth() * this.getModel().getPixelHeight() * 2;
            int spaceRequired = (int)((double)(this.getNumFrames() * imgSize) * 1.2);
            this.reserveSpaceHandle = CvUtils.getDMSystem().spaceReserve(spaceRequired);
        }
    }

    public void releaseSpace() {
        if (this.reserveSpaceHandle != -1) {
            CvUtils.getDMSystem().spaceRelease(this.reserveSpaceHandle);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(prop, l);
    }

    public boolean isSavingToDB() {
        return this.model.isSaving();
    }

    public static void main(String[] args) {
    }

    public class BatchFrame
    implements T3DCapable {
        private double[] actuallookPoint = null;
        private double[] lookPoint = new double[3];
        private double[] eyePoint = new double[3];
        private double[] upVector = new double[3];
        private double fov = 0.0;
        private double[] clipOffsets = new double[2];
        private int pixWidth = 512;
        private int pixHeight = 512;
        private boolean inverted = false;
        private String renderStyle = VVBatchProtocol.defaultRenderingQuality() == 2 ? "REFORMAT.TC" : "REFORMAT";
        private double spacing = 0.0;
        private double[] wwwl = new double[2];
        private Map valueMap = new HashMap();
        private String wlKey = "40,4176";
        private String wwKey = "40,4177";
        private boolean processed = false;
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        public static final String PROCESSING_COMPLETE_PROPERTY = "PROCESSING_COMPLETE_PROPERTY";
        public static final String PROCESSING_ERROR_PROPERTY = "PROCESSING_ERROR_PROPERTY";

        public boolean isProcessed() {
            return this.processed;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void saveFrame(XpBufferedImage image, XjVolumeModel volModel) {
            VavBatchJob.this.logger.finer("Saving frame: " + VavBatchJob.this.seriesDesc + " (" + VavBatchJob.this.batchFrames.length + ")");
            this.processed = true;
            try {
                String modality_;
                XpSaveParameters params;
                block25: {
                    block26: {
                        block24: {
                            XjVolumeInfo volinfo = volModel.getVolume();
                            params = new XpSaveParameters();
                            params.image = image;
                            params.imageThickness = Math.abs(this.clipOffsets[1] - this.clipOffsets[0]);
                            params.sliceSpacing = this.getSpacing();
                            params.renderStyle = this.getRenderStyle();
                            modality_ = null;
                            if (volinfo != null) {
                                modality_ = volinfo.getValue(8, 96).toString();
                            }
                            double[] wwwl = this.getWindowing();
                            if (this.getWindowing() == null || !(wwwl[0] > 0.0)) break block24;
                            params.defaultWindowWidthLevel = new double[2];
                            params.defaultWindowWidthLevel[0] = wwwl[0];
                            params.defaultWindowWidthLevel[1] = wwwl[1];
                            break block25;
                        }
                        if (VavBatchJob.this.getModel().getTargetPort() != null || modality_ == null || modality_.equals("")) break block26;
                        if (modality_.equalsIgnoreCase("CT")) {
                            if (volModel instanceof J3DVolumeModel) {
                                params.defaultWindowWidthLevel = new double[2];
                                params.defaultWindowWidthLevel[0] = ((J3DVolumeModel)volModel).j_vol.initWW;
                                params.defaultWindowWidthLevel[1] = ((J3DVolumeModel)volModel).j_vol.initWL;
                            }
                            break block25;
                        } else if (modality_.equalsIgnoreCase("MR")) {
                            params.defaultWindowWidthLevel = null;
                        }
                        break block25;
                    }
                    params.defaultWindowWidthLevel = new double[2];
                    params.defaultWindowWidthLevel[0] = ((VavBatchJob)VavBatchJob.this).vpParams.defaultWindowWidthLevel[0];
                    params.defaultWindowWidthLevel[1] = ((VavBatchJob)VavBatchJob.this).vpParams.defaultWindowWidthLevel[1];
                }
                params.grayScaleInverted = this.isInverted();
                if (VavBatchJob.this.seriesNum < 0) {
                    XjVolumeInfo dicomRef = volModel.getVolume();
                    VavBatchJob.this.seriesNum = modality_.equalsIgnoreCase("CT") ? XpSaveUtil.nextSeriesNumberCT(dicomRef, VavBatchJob.this.outputSession) : XpSaveUtil.nextSeriesNumber(dicomRef, VavBatchJob.this.outputSession);
                }
                params.seriesNum = VavBatchJob.this.seriesNum;
                params.seriesDescription = VavBatchJob.this.seriesDesc;
                params.imageNum = VavBatchJob.this.imageNum++;
                params.seriesUID = VavBatchJob.this.seriesUID = VavBatchJob.this.seriesUID == null ? XpSaveUtil.newInstanceUid() : VavBatchJob.this.seriesUID;
                if (VavBatchJob.this.generateRefFrame && VavBatchJob.this.refFrame != null) {
                    int group = 8;
                    int element = 4158;
                    VavBatchJob.this.refFrame.setValue(group, element, params.seriesDescription);
                    group = 32;
                    element = 14;
                    VavBatchJob.this.refFrame.setValue(group, element, params.seriesUID);
                    group = 32;
                    element = 17;
                    VavBatchJob.this.refFrame.setValue(group, element, params.seriesNum);
                    group = 32;
                    element = 19;
                    VavBatchJob.this.refFrame.setValue(group, element, params.imageNum);
                    group = 64;
                    element = 595;
                    VavBatchJob.this.refFrame.setValue(group, element, "" + params.seriesNum);
                    group = 8;
                    element = 4369;
                    tagValue[] tvs = new tagValue[]{new tagValue(8, 4437)};
                    tvs[0].value = params.seriesUID + ".1";
                    XpSaveUtil.updateSequence(VavBatchJob.this.refFrame, group, element, 0, tvs);
                    if (VavBatchJob.this.isSavingToDB()) {
                        if (VavBatchJob.this.outputSession == null) {
                            String msg = "Error during image save (output repository session is null).";
                            VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, "TID=VAV_BATCH_SAVE");
                            this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, null);
                            return;
                        }
                        XpSaveImage save = new XpSaveImage();
                        save.setOutputSession(VavBatchJob.this.outputSession);
                        save.setReferenceDicomComposite(VavBatchJob.this.refComp);
                        XpSaveImage.SaveType stype = VavBatchJob.this.isSavingToDB() ? XpSaveImage.SaveType.SaveToDB : XpSaveImage.SaveType.SaveToFile;
                        boolean saveStatus = save.saveImage(stype, VavBatchJob.this.refFrame);
                        if (debugTrace) {
                            System.err.println("BatchFrame.saveFrame() reference frame save to db status : " + saveStatus);
                        }
                        if (!saveStatus) {
                            String msg = "Error during reference image save";
                            VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, new Object[]{"TID=VAV_BATCH_SAVE"});
                        }
                    } else {
                        String msg = "Error during reference image save (output repository session is null).";
                        VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, "TID=VAV_BATCH_SAVE");
                    }
                    VavBatchJob.this.generateRefFrame = false;
                    VavBatchJob.this.refFrame = null;
                    params.imageNum = VavBatchJob.this.imageNum++;
                }
                if (debugTrace) {
                    System.err.println("BatchFrame.saveFrame() saving to db : " + VavBatchJob.this.isSavingToDB());
                }
                if (VavBatchJob.this.isSavingToDB()) {
                    String msg;
                    if (VavBatchJob.this.outputSession == null) {
                        String msg2 = "Error during image save (output repository session is null).";
                        VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg2, "TID=VAV_BATCH_SAVE");
                        this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, null);
                        return;
                    }
                    boolean saveStatus = false;
                    for (int saveFrameRetry = 0; !saveStatus && saveFrameRetry != saveFrameRetryCount; ++saveFrameRetry) {
                        if (!exitONsaveFrameFailure) {
                            saveFrameRetryCount = 1;
                        }
                        saveStatus = XpSaveUtil.saveFrame(VavBatchJob.this.isSavingToDB(), false, VavBatchJob.this.refComp, params, VavBatchJob.this.outputSession);
                    }
                    if (debugTrace) {
                        System.err.println("BatchFrame.saveFrame() saving to db status : " + saveStatus);
                    }
                    if (!saveStatus && exitONsaveFrameFailure) {
                        VavBatchJob.this.abortJob();
                        msg = "Error during dicom image save";
                        VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, new Object[]{"TID=VAV_BATCH_SAVE"});
                        this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, (Object)VavException.VavErrorCodes.VAV_BATCH_IMAGE_SAVE_FAILED);
                        return;
                    }
                    if (!saveStatus) {
                        msg = "Error during dicom image save";
                        VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, new Object[]{"TID=VAV_BATCH_SAVE"});
                        this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, (Object)VavException.VavErrorCodes.VAV_BATCH_IMAGE_SAVE_FAILED);
                        return;
                    }
                }
                if (params.defaultWindowWidthLevel != null && params.defaultWindowWidthLevel.length > 0) {
                    this.valueMap.put(this.wlKey, params.defaultWindowWidthLevel[1]);
                    this.valueMap.put(this.wwKey, params.defaultWindowWidthLevel[0]);
                    image.setPropertyTable(this.valueMap);
                }
                this.pcs.firePropertyChange(PROCESSING_COMPLETE_PROPERTY, null, image);
                return;
            }
            catch (Exception ex) {
                if (debugTrace) {
                    ex.printStackTrace();
                }
                String msg = "Error during dicom image save: " + ex.getMessage();
                VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, new Object[]{"TID=VAV_BATCH_SAVE", ex});
                this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, ex);
                return;
            }
        }

        private XpVisualComponent getBatchVC(Container comp) {
            Component[] children = comp.getComponents();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof ObliqueBatchVc) && !(children[i] instanceof RotateBatchVc) && !(children[i] instanceof Rotation3DVc)) continue;
                return (XpVisualComponent)children[i];
            }
            return null;
        }

        public void reportProcessingError(Exception ex) {
            if (debugTrace) {
                ex.printStackTrace();
            }
            String msg = "Reporting frame processing error: " + ex.getMessage();
            VavBatchJob.this.logger.log(Level.FINE, msg);
            this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, ex);
        }

        public void setWidth(int width) {
            this.pixWidth = width;
        }

        public int getWidth() {
            return this.pixWidth;
        }

        public void setHeight(int height) {
            this.pixHeight = height;
        }

        public int getHeight() {
            return this.pixHeight;
        }

        @Override
        public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
            throw new UnsupportedOperationException("getWorldBounds method not supported.");
        }

        @Override
        public void setLookPoint(double[] point) {
            System.arraycopy(point, 0, this.lookPoint, 0, 3);
        }

        @Override
        public double[] getLookPoint(double[] look_pt) {
            if (look_pt == null) {
                look_pt = new double[3];
            }
            System.arraycopy(this.lookPoint, 0, look_pt, 0, 3);
            return look_pt;
        }

        public void setActualLookPoint(double[] point) {
            if (this.actuallookPoint == null) {
                this.actuallookPoint = new double[3];
            }
            System.arraycopy(point, 0, this.actuallookPoint, 0, 3);
        }

        public double[] getActualLookPoint(double[] look_pt) {
            if (look_pt == null) {
                look_pt = new double[3];
            }
            if (this.actuallookPoint == null) {
                System.arraycopy(this.lookPoint, 0, look_pt, 0, 3);
            } else {
                System.arraycopy(this.actuallookPoint, 0, look_pt, 0, 3);
            }
            return look_pt;
        }

        @Override
        public void setEyePoint(double[] point) {
            System.arraycopy(point, 0, this.eyePoint, 0, 3);
        }

        @Override
        public double[] getEyePoint(double[] eye_pt) {
            if (eye_pt == null) {
                eye_pt = new double[3];
            }
            System.arraycopy(this.eyePoint, 0, eye_pt, 0, 3);
            return eye_pt;
        }

        @Override
        public void setUp(double[] vec) {
            System.arraycopy(vec, 0, this.upVector, 0, 3);
        }

        @Override
        public double[] getUp(double[] up_vect) {
            if (up_vect == null) {
                up_vect = new double[3];
            }
            System.arraycopy(this.upVector, 0, up_vect, 0, 3);
            return up_vect;
        }

        @Override
        public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
            this.setEyePoint(eyepoint);
            this.setLookPoint(lookpoint);
            this.setUp(up);
        }

        @Override
        public void setViewHeight(double height) {
            this.fov = height;
        }

        @Override
        public double getViewHeight() {
            return this.fov;
        }

        @Override
        public void setAspectRatio(double aspect) {
            throw new UnsupportedOperationException("setAspectRatio method not supported.  Aspect Ratio is always 1.");
        }

        @Override
        public double getAspectRatio() {
            return 1.0;
        }

        @Override
        public void setViewClip(double[] clipOffsets) {
            System.arraycopy(clipOffsets, 0, this.clipOffsets, 0, 2);
        }

        @Override
        public double[] getViewClip(double[] viewClip) {
            if (viewClip == null) {
                viewClip = new double[2];
            }
            System.arraycopy(this.clipOffsets, 0, viewClip, 0, 2);
            return viewClip;
        }

        public String getRenderStyle() {
            return this.renderStyle;
        }

        public void setRenderStyle(String renderStyle) {
            this.renderStyle = renderStyle;
        }

        @Override
        public void setPerspective(boolean b) {
            throw new UnsupportedOperationException("setPerspective method not supported.  Perspective is always false.");
        }

        @Override
        public boolean isPerspective() {
            return false;
        }

        public void setInverted(boolean invert) {
            this.inverted = invert;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public void setSpacing(double spc) {
            this.spacing = spc;
        }

        public double getSpacing() {
            return this.spacing;
        }

        public void setWindowing(double ww, double wl) {
            this.wwwl[0] = ww;
            this.wwwl[1] = wl;
        }

        public double[] getWindowing() {
            return this.wwwl;
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        @Override
        public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(prop, l);
        }

        @Override
        public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(prop, l);
        }

        @Override
        public void repaint() {
            throw new UnsupportedOperationException("repaint method not supported.");
        }

        @Override
        public boolean isAutoRepaint() {
            throw new UnsupportedOperationException("isAutoRepaint method not supported.");
        }

        @Override
        public void setAutoRepaint(boolean autoRepaint) {
            throw new UnsupportedOperationException("setAutoRepaint method not supported.");
        }

        @Override
        public Capable getCapable(String capableIFName) {
            try {
                Class<Capable> cap = Capable.class;
                Class cl = CvUtils.getClass(capableIFName);
                if (cap.isAssignableFrom(cl) && cl.isInstance(this)) {
                    return this;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    protected class TaskDoneRunnable
    implements Runnable {
        String taskName = "";

        public TaskDoneRunnable(String taskName) {
            this.taskName = taskName;
        }

        @Override
        public void run() {
            VavBatchJob.this.notifyTaskDone(this.taskName);
        }
    }

    protected class TaskFailedRunnable
    implements Runnable {
        String taskName = "";
        Exception exe = null;
        String reason = "";

        public TaskFailedRunnable(String taskName, String reasn, Exception e) {
            this.taskName = taskName;
            this.exe = e;
            this.reason = reasn;
        }

        @Override
        public void run() {
            VavBatchJob.this.notifyTaskFailed(this.taskName, this.reason, this.exe);
        }
    }

    protected class FireErrorRunnable
    implements Runnable {
        Object oldValue = null;
        Object newValue = null;

        public FireErrorRunnable(Object oldValue, Object newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void run() {
            VavBatchJob.this.pcs.firePropertyChange(VavBatchJob.PROCESSING_ERROR_PROPERTY, this.oldValue, this.newValue);
        }
    }

    protected class TaskProgressRunnable
    implements Runnable {
        String taskName = "";
        int units = 0;
        XpBufferedImage image = null;

        public TaskProgressRunnable(String taskName, int units, XpBufferedImage image) {
            this.taskName = taskName;
            this.units = units;
            this.image = image;
        }

        @Override
        public void run() {
            VavBatchJob.this.notifyTaskProgress(this.taskName, this.units, this.image);
        }
    }

    protected class TaskBeginRunnable
    implements Runnable {
        String taskName = "";
        int units = 0;

        public TaskBeginRunnable(String taskName, int units) {
            this.taskName = taskName;
            this.units = units;
        }

        @Override
        public void run() {
            VavBatchJob.this.logger.log(Level.INFO, "TID=VAV_INVOKE_LATER end");
            VavBatchJob.this.notifyTaskBegin(this.taskName, this.units);
        }
    }
}

