/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jip.voxtool.CTTableRemoval;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import com.ge.med.terra.jami.seg.BinGrid;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.tap.dm.volume.DMObjectVolume;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class VavAutoEdge {
    private short[] volData = null;
    private int offset = 0;
    private boolean volumeLoaded = false;
    private double slope = 1.0;
    private double intercept = 1024.0;
    private double ww = -1.0;
    private double wl = -1.0;
    private XjVolumeModel volume = null;
    public static final String VAV_AUTOEDGE_CTTABLEREMOVAL_PROPERTY = "vav.autoEdge.ctTableRemoval";
    private boolean applyCTTableRemoval = CvPropertiesManager.getBoolean("vav.autoEdge.ctTableRemoval", false);
    private static SegAlgorithmCreator sac = null;
    private static Logger logger = Logger.getLogger(VavAutoEdge.class.getName());
    private static final String minThresholdProperty = "vav.autoEdge.threshold.min";
    private static final String maxThresholdProperty = "vav.autoEdge.threshold.max";
    private static final int thresholdMinDef = Integer.parseInt(CvPropertiesManager.getProperty("vav.autoEdge.threshold.min", "0"));
    private static final int thresholdMaxDef = Integer.parseInt(CvPropertiesManager.getProperty("vav.autoEdge.threshold.max", "65535"));
    private int thresholdMin = thresholdMinDef;
    private int thresholdMax = thresholdMaxDef;
    public static final String VAV_AUTOEDGE_USEVOLWWWL_PROPERTY = "vav.autoEdge.useVolumeWWWL";
    private static boolean useVolWWWL = CvPropertiesManager.getBoolean("vav.autoEdge.useVolumeWWWL", false);

    public static synchronized SegAlgorithmCreator getCreator() {
        if (sac == null) {
            sac = new SegAlgorithmCreatorImpl();
            logger.log(Level.INFO, "VavAutoEdge : SegAlgorithmCreator set " + sac.getName());
        }
        return sac;
    }

    public static synchronized void setCreator(SegAlgorithmCreator sacreator) {
        sac = sacreator;
        if (sac != null) {
            logger.log(Level.INFO, "VavAutoEdge : SegAlgorithmCreator set " + sac.getName());
        }
    }

    public static int[] getMinMaxThreshold(String modality) {
        int[] minmax = new int[]{thresholdMinDef, thresholdMaxDef};
        if (modality != null) {
            modality = modality.toLowerCase(Locale.ENGLISH);
        }
        try {
            minmax[0] = Integer.parseInt(CvPropertiesManager.getProperty("vav.autoEdge.threshold.min." + modality));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            minmax[1] = Integer.parseInt(CvPropertiesManager.getProperty("vav.autoEdge.threshold.max." + modality));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return minmax;
    }

    public static void setUseVolumeWWWLForThresholding(boolean usevolwwwl) {
        useVolWWWL = usevolwwwl;
        logger.log(Level.INFO, "Use Volume WWWL For Thresolding : " + useVolWWWL);
    }

    private BinGrid.SegAlgorithm createAlgo() {
        BinGrid.SegAlgorithm sa = null;
        try {
            sa = VavAutoEdge.getCreator().createInstance();
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in creating SegAlgorithm : " + ex);
        }
        return sa;
    }

    public VavAutoEdge(XjVolumeModel vol) {
        this.setVolume(vol);
    }

    public void setVolume(XjVolumeModel vol) {
        if (vol == null) {
            this.volData = null;
            this.offset = 0;
            this.slope = 1.0;
            this.intercept = 1024.0;
            this.volume = null;
            this.volumeLoaded = false;
            this.ww = -1.0;
            this.wl = -1.0;
            return;
        }
        J3DVolumeModel vol_model = (J3DVolumeModel)vol;
        this.volData = (short[])vol_model.getJVolume().getVolumeData();
        this.offset = vol_model.getJVolume().PAD;
        this.slope = vol_model.getJVolume().rescaleSlope;
        this.intercept = vol_model.getJVolume().rescaleIntercept;
        this.ww = vol_model.getJVolume().initWW;
        this.wl = vol_model.getJVolume().initWL;
        System.out.println("ofset = " + this.offset);
        this.volume = vol;
        this.volumeLoaded = true;
    }

    private byte[] getEdgedByteMask() {
        byte[] mask = new byte[this.volData.length];
        if (this.volumeLoaded) {
            for (int x = 0; x < this.volData.length; ++x) {
                mask[this.offset + x] = (double)this.volData[x] * this.slope + this.intercept > (double)this.thresholdMin && (double)this.volData[x] * this.slope + this.intercept < (double)this.thresholdMax ? 15 : 0;
            }
        } else {
            return null;
        }
        return mask;
    }

    private short[] getEdgedShortMask() {
        short[] mask = new short[this.volData.length];
        if (this.volumeLoaded) {
            for (int x = 0; x < this.volData.length; ++x) {
                mask[x] = (double)this.volData[x] * this.slope + this.intercept > (double)this.thresholdMin && (double)this.volData[x] * this.slope + this.intercept < (double)this.thresholdMax ? Short.MIN_VALUE : 0;
            }
        } else {
            return null;
        }
        return mask;
    }

    public void setThresholding(int min, int max) {
        this.thresholdMin = min;
        this.thresholdMax = max;
        System.err.println("VavAutoEdge threshold [" + this.thresholdMin + "," + this.thresholdMax + "]");
    }

    public void applyCTAutoTableRemoval(boolean tableRemoval) {
        this.applyCTTableRemoval = tableRemoval;
    }

    public XjVolumeGeometry getAutoEdgedBoundingBox() {
        BinGrid.SegAlgorithm sa;
        String mod;
        if (!this.volumeLoaded) {
            return null;
        }
        if (useVolWWWL && this.ww != -1.0) {
            System.err.println("VavAutoEdge useVolWWWL");
            this.thresholdMin = (int)(this.wl - this.ww * 0.5);
            this.thresholdMax = (int)((double)this.thresholdMin + this.ww);
        }
        System.err.println("VavAutoEdge::getAutoEdgedBoundingBox threshold [" + this.thresholdMin + "," + this.thresholdMax + "]");
        VolGeom boundingBox = new VolGeom();
        int[] volDims = null;
        if (this.volume != null && this.volume.getVolume() != null && this.volume.getVolume().getVolumeDimensions(null) != null) {
            volDims = Arrays.copyOf(this.volume.getVolume().getVolumeDimensions(null), this.volume.getVolume().getVolumeDimensions(null).length);
        }
        int numColumns = 0;
        int numRows = 0;
        int numSlices = 0;
        if (volDims != null) {
            numColumns = volDims[0];
            numRows = volDims[1];
            numSlices = volDims[2];
        }
        int sliceSize = numRows * numColumns;
        int xmin = 0;
        int ymin = 0;
        int zmin = 0;
        if (numColumns != 0) {
            xmin = numColumns - 1;
        }
        int xmax = 0;
        if (numRows != 0) {
            ymin = numRows - 1;
        }
        int ymax = 0;
        if (numSlices != 0) {
            zmin = numSlices - 1;
        }
        int zmax = 0;
        byte[] bgrid = null;
        VolGeom.access$102(boundingBox, this.volume.getVolume().getXDirectionRAS(null));
        VolGeom.access$202(boundingBox, this.volume.getVolume().getYDirectionRAS(null));
        VolGeom.access$302(boundingBox, this.volume.getVolume().getZDirectionRAS(null));
        if (this.applyCTTableRemoval && "CT".equalsIgnoreCase(mod = DicomUtils.getModality(this.volume.getVolume())) && this.volume instanceof J3DVolumeModel && (sa = this.createAlgo()) != null) {
            J3DVolumeModel vol_model = (J3DVolumeModel)this.volume;
            JVolume.LinearVolume vol = vol_model.j_vol;
            short[] voldata = ((JVolume.LinearShort)vol).volume;
            BinGrid bg = new BinGrid(voldata, vol.PAD, vol.dx, vol.dy, vol.dz);
            BinGrid ctt = sa.segment(bg, new Object[]{this.volume.getVolume()}, new TaskMonitor(){

                @Override
                public void taskProgress(String taskName, int units) {
                    System.err.println("CTTableRemoval : task progress " + units);
                }

                @Override
                public void taskFailed(String taskName, String reason, Exception e) {
                    System.err.println("CTTableRemoval : task failed " + reason);
                }

                @Override
                public void taskDone(String taskName) {
                    System.err.println("CTTableRemoval : task done");
                }

                @Override
                public void taskBegin(String taskName, int totalWork) {
                    System.err.println("CTTableRemoval : task begin");
                }
            });
            bgrid = ctt.bingrid != null ? Arrays.copyOf(ctt.bingrid, ctt.bingrid.length) : null;
        }
        boolean foundZmin = false;
        boolean foundZmax = false;
        for (int z = 0; !(z >= numSlices || foundZmin && foundZmax); ++z) {
            for (int y = 0; !(y >= numRows || foundZmin && foundZmax); ++y) {
                for (int x = 0; x < numColumns; ++x) {
                    int bmod;
                    int bidx;
                    if (!foundZmin) {
                        int vidx = this.offset + x + numColumns * y + z * sliceSize;
                        boolean in = true;
                        if (bgrid != null) {
                            bidx = vidx - this.offset >> 3;
                            bmod = vidx % 8;
                            boolean bl = in = (bgrid[bidx] & 1 << bmod) != 0;
                        }
                        if (in && (double)this.volData[vidx] * this.slope + this.intercept > (double)this.thresholdMin && (double)this.volData[vidx] * this.slope + this.intercept < (double)this.thresholdMax) {
                            zmin = z;
                            foundZmin = true;
                        }
                    }
                    if (foundZmax) continue;
                    int vidx = this.offset + x + numColumns * y + (numSlices - 1 - z) * sliceSize;
                    boolean in = true;
                    if (bgrid != null) {
                        bidx = vidx - this.offset >> 3;
                        bmod = vidx % 8;
                        boolean bl = in = (bgrid[bidx] & 1 << bmod) != 0;
                    }
                    if (!in || !((double)this.volData[vidx] * this.slope + this.intercept > (double)this.thresholdMin) || !((double)this.volData[vidx] * this.slope + this.intercept < (double)this.thresholdMax)) continue;
                    zmax = numSlices - 1 - z;
                    foundZmax = true;
                }
            }
        }
        boolean foundYmin = false;
        boolean foundYmax = false;
        for (int y = 0; !(y >= numRows || foundYmin && foundYmax); ++y) {
            for (int z = 0; !(z >= numSlices || foundYmin && foundYmax); ++z) {
                for (int x = 0; x < numColumns; ++x) {
                    int bmod;
                    int bidx;
                    boolean in;
                    int vidx;
                    if (!foundYmin) {
                        vidx = this.offset + x + numColumns * y + z * sliceSize;
                        in = true;
                        if (bgrid != null) {
                            bidx = vidx - this.offset >> 3;
                            bmod = vidx % 8;
                            boolean bl = in = (bgrid[bidx] & 1 << bmod) != 0;
                        }
                        if (in && (double)this.volData[vidx] * this.slope + this.intercept > (double)this.thresholdMin && (double)this.volData[vidx] * this.slope + this.intercept < (double)this.thresholdMax) {
                            ymin = y;
                            foundYmin = true;
                        }
                    }
                    if (foundYmax) continue;
                    vidx = this.offset + x + numColumns * (numRows - 1 - y) + z * sliceSize;
                    in = true;
                    if (bgrid != null) {
                        bidx = vidx - this.offset >> 3;
                        bmod = vidx % 8;
                        boolean bl = in = (bgrid[bidx] & 1 << bmod) != 0;
                    }
                    if (!in || !((double)this.volData[vidx] * this.slope + this.intercept > (double)this.thresholdMin) || !((double)this.volData[vidx] * this.slope + this.intercept < (double)this.thresholdMax)) continue;
                    ymax = numRows - 1 - y;
                    foundYmax = true;
                }
            }
        }
        boolean foundXmin = false;
        boolean foundXmax = false;
        for (int x = 0; !(x >= numColumns || foundXmin && foundXmax); ++x) {
            for (int z = 0; !(z >= numSlices || foundXmin && foundXmax); ++z) {
                for (int y = 0; y < numRows; ++y) {
                    int bmod;
                    int bidx;
                    boolean in;
                    int vidx;
                    if (!foundXmin) {
                        vidx = this.offset + x + numColumns * y + z * sliceSize;
                        in = true;
                        if (bgrid != null) {
                            bidx = vidx - this.offset >> 3;
                            bmod = vidx % 8;
                            boolean bl = in = (bgrid[bidx] & 1 << bmod) != 0;
                        }
                        if (in && (double)this.volData[vidx] * this.slope + this.intercept > (double)this.thresholdMin && (double)this.volData[vidx] * this.slope + this.intercept < (double)this.thresholdMax) {
                            xmin = x;
                            foundXmin = true;
                        }
                    }
                    if (foundXmax) continue;
                    vidx = this.offset + (numColumns - 1 - x) + numColumns * y + z * sliceSize;
                    in = true;
                    if (bgrid != null) {
                        bidx = vidx - this.offset >> 3;
                        bmod = vidx % 8;
                        boolean bl = in = (bgrid[bidx] & 1 << bmod) != 0;
                    }
                    if (!in || !((double)this.volData[vidx] * this.slope + this.intercept > (double)this.thresholdMin) || !((double)this.volData[vidx] * this.slope + this.intercept < (double)this.thresholdMax)) continue;
                    xmax = numColumns - 1 - x;
                    foundXmax = true;
                }
            }
        }
        boundingBox.numberOfFrames = zmax - zmin + 1;
        boundingBox.height = ymax - ymin + 1;
        boundingBox.width = xmax - xmin + 1;
        JnMatrix4d vox2ras = new JnMatrix4d();
        JnMatrix4d ras2vox = new JnMatrix4d();
        XjVolumeUtils.calculateVoxelRASTransform((XjVolumeGeometry)this.volume.getVolume(), vox2ras, ras2vox);
        VolGeom.access$702(boundingBox, new double[]{xmin, ymin, zmin});
        vox2ras.transform(boundingBox.topLeft);
        return boundingBox;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(512, 512);
        T3DViewport port = new T3DViewport();
        DMSession sess = new DMSession(new String[]{"file", args[0]});
        DMObject[] sers = null;
        if (sess.getRelated("series") != null) {
            sers = Arrays.copyOf(sess.getRelated("series"), sess.getRelated("series").length);
        }
        if (sers == null || sers.length == 0) {
            return;
        }
        DMVolume vol = DMObjectVolume.buildVolume(DMObjectVolume.class.getName(), new Object[]{sers[0]});
        port.setVolume(vol);
        port.setSize(512, 512);
        frame.add(port);
        port.setRenderStyle("REFORMAT");
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        VavAutoEdge autoEdge = new VavAutoEdge(port.getVolumeModel());
        port.repaint();
        XjVolumeGeometry volgeom = autoEdge.getAutoEdgedBoundingBox();
        double[] ulc = volgeom.getRASOfOrigin(null);
        double[] dx = volgeom.getXDirectionRAS(null);
        double[] dy = volgeom.getYDirectionRAS(null);
        double[] dz = volgeom.getZDirectionRAS(null);
        int[] dims = volgeom.getVolumeDimensions(null);
        System.err.println(" Volume ULC : [" + ulc[0] + "," + ulc[1] + "," + ulc[2] + "]");
        System.err.println(" Volume dx : [" + dx[0] + "," + dx[1] + "," + dx[2] + "]");
        System.err.println(" Volume dy : [" + dy[0] + "," + dy[1] + "," + dy[2] + "]");
        System.err.println(" Volume dz : [" + dz[0] + "," + dz[1] + "," + dz[2] + "]");
        System.err.println(" Volume dims : [" + dims[0] + "," + dims[1] + "," + dims[2] + "]");
    }

    public static class VolGeom
    implements XjVolumeGeometry {
        private double[] topLeft = new double[3];
        private double[] ras_xdir = new double[3];
        private double[] ras_ydir = new double[3];
        private double[] ras_zdir = new double[3];
        private int width;
        private int height;
        private int numberOfFrames;

        public void init(double[] rasOrig, double[] rasdx, double[] rasdy, double[] rasdz, int[] dims) {
            System.arraycopy(rasOrig, 0, this.topLeft, 0, 3);
            System.arraycopy(rasdx, 0, this.ras_xdir, 0, 3);
            System.arraycopy(rasdy, 0, this.ras_ydir, 0, 3);
            System.arraycopy(rasdz, 0, this.ras_zdir, 0, 3);
            this.width = dims[0];
            this.height = dims[1];
            this.numberOfFrames = dims[2];
        }

        @Override
        public int[] getVolumeDimensions(int[] dims) {
            if (dims == null) {
                dims = new int[]{this.width < 0 ? 0 : this.width, this.height < 0 ? 0 : this.height, this.numberOfFrames < 0 ? 0 : this.numberOfFrames};
            }
            return dims;
        }

        @Override
        public double[] getRASOfOrigin(double[] ras_ulc) {
            if (ras_ulc == null) {
                ras_ulc = new double[3];
            }
            System.arraycopy(this.topLeft, 0, ras_ulc, 0, 3);
            return ras_ulc;
        }

        @Override
        public double[] getXDirectionRAS(double[] ras_dx) {
            if (ras_dx == null) {
                ras_dx = new double[3];
            }
            System.arraycopy(this.ras_xdir, 0, ras_dx, 0, 3);
            return ras_dx;
        }

        @Override
        public double[] getYDirectionRAS(double[] ras_dy) {
            if (ras_dy == null) {
                ras_dy = new double[3];
            }
            System.arraycopy(this.ras_ydir, 0, ras_dy, 0, 3);
            return ras_dy;
        }

        @Override
        public double[] getZDirectionRAS(double[] ras_dz) {
            if (ras_dz == null) {
                ras_dz = new double[3];
            }
            System.arraycopy(this.ras_zdir, 0, ras_dz, 0, 3);
            return ras_dz;
        }

        static /* synthetic */ double[] access$102(VolGeom x0, double[] x1) {
            x0.ras_xdir = x1;
            return x1;
        }

        static /* synthetic */ double[] access$202(VolGeom x0, double[] x1) {
            x0.ras_ydir = x1;
            return x1;
        }

        static /* synthetic */ double[] access$302(VolGeom x0, double[] x1) {
            x0.ras_zdir = x1;
            return x1;
        }

        static /* synthetic */ double[] access$702(VolGeom x0, double[] x1) {
            x0.topLeft = x1;
            return x1;
        }
    }

    private static class SegAlgorithmCreatorImpl
    implements SegAlgorithmCreator {
        private String segAlgo = CvPropertiesManager.getProperty("vav.autoEdge.ctTableRemovalAlgo", "com.ge.med.cse.cvf.j3d.vav.VavAutoEdge$VavCTTableRemoval");

        private SegAlgorithmCreatorImpl() {
        }

        @Override
        public BinGrid.SegAlgorithm createInstance() {
            BinGrid.SegAlgorithm sa = null;
            try {
                sa = BinGrid.createSegAlgorithm(this.segAlgo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sa;
        }

        @Override
        public String getName() {
            return this.segAlgo;
        }
    }

    private static class VavCTTableRemoval
    extends CTTableRemoval {
        private VavCTTableRemoval() {
        }

        public String getName() {
            return "VavCTTableRemoval";
        }

        public BinGrid segment(BinGrid bg, Object[] args, TaskMonitor tm) {
            XjVolumeInfo vol = (XjVolumeInfo)args[0];
            double ras_spx = JnVector3d.length(vol.getXDirectionRAS(null));
            double ras_spy = JnVector3d.length(vol.getYDirectionRAS(null));
            double ras_spz = JnVector3d.length(vol.getZDirectionRAS(null));
            double[] ras_sp = new double[]{ras_spx, ras_spy, ras_spz};
            return super.segment(bg, new Object[]{ras_sp}, tm);
        }
    }

    public static interface SegAlgorithmCreator {
        public BinGrid.SegAlgorithm createInstance();

        public String getName();
    }
}

