/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.j3d.ViewCalculator;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.vav.LoopMode;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import java.util.Arrays;

public class FixedPointViewCalculator
extends ViewCalculator {
    private static final double TOL = 1.0E-5;
    private static final double MIN_ANGLE = Math.toRadians(1.0);
    private double[] startLook = new double[3];
    private double[] startEye = new double[3];
    private double[] startUp = new double[3];
    private boolean startSet = false;
    private double[] endLook = new double[3];
    private double[] endEye = new double[3];
    private double[] endUp = new double[3];
    private boolean endSet = false;
    private double[] viewV = new double[3];
    private double[] upV = new double[3];
    private double[] rotationAxis = new double[3];
    private double rotationAngle = Math.PI * 2;
    private double angleRadians = MIN_ANGLE;
    private double distance = 0.0;
    private double strideMM = 0.0;
    private double minStrideOb;
    private double minStrideCV;
    private LoopMode mode = LoopMode.NONE;
    private double[] tmplook = new double[3];
    private double[] tmpeye = new double[3];
    private double[] tmpup = new double[3];
    private double[] tmpv = new double[3];
    private double[] rotationCenter;

    public FixedPointViewCalculator(T3DCapable capable) {
        super(capable);
    }

    @Override
    public void setVolume(XjVolumeGeometry vol) {
        super.setVolume(vol);
        double[] eye = this.t3dCapable.getEyePoint(null);
        double[] look = this.t3dCapable.getLookPoint(null);
        double[] view = new double[3];
        JnVector3d.sub(look, eye, view);
        JnVector3d.normalize(view);
        this.minStrideOb = J3DGeomUtils.getMinSpacing(vol);
        this.minStrideCV = J3DGeomUtils.getSliceSpacing(vol, view);
    }

    @Override
    public boolean isReady() {
        return super.isReady() && this.startSet && this.endSet && !LoopMode.NONE.equals((Object)this.mode);
    }

    public void setStart() {
        this.t3dCapable.getLookPoint(this.startLook);
        this.t3dCapable.getUp(this.startUp);
        this.t3dCapable.getEyePoint(this.startEye);
        this.startSet = true;
        this.endSet = false;
        this.calculateInitial();
    }

    public void setEnd() {
        if (this.startSet) {
            this.t3dCapable.getLookPoint(this.endLook);
            this.t3dCapable.getUp(this.endUp);
            this.t3dCapable.getEyePoint(this.endEye);
            this.endSet = true;
            this.calculateNewParameters();
        }
    }

    public void setMode(LoopMode mode) {
        this.mode = mode;
        this.angleRadians = MIN_ANGLE;
    }

    private void calculateNewParameters() {
        if (this.startSet && this.endSet) {
            this.distance = JnVector3d.distance(this.startLook, this.endLook);
            double[] angle = new double[1];
            this.calculateRotationMatrix(this.startLook, this.startEye, this.startUp, this.endLook, this.endEye, this.endUp, this.rotationAxis, angle);
            this.rotationAngle = angle[0];
        }
        int numViews = this.getNumFrames();
        if (this.rotationAngle < 1.0E-5) {
            this.angleRadians = MIN_ANGLE;
            this.strideMM = this.minStrideCV;
            this.setStrideMM(this.minStrideCV);
        } else if (this.distance < 1.0E-5) {
            if (numViews > 0) {
                this.angleRadians = this.rotationAngle / (double)numViews;
                this.strideMM = 0.0;
            }
        } else if (numViews != 0) {
            this.angleRadians = this.rotationAngle / (double)numViews;
            this.strideMM = this.distance / (double)(numViews - 1);
        } else if (this.rotationAngle != 0.0) {
            long views = Math.round(this.rotationAngle / this.angleRadians);
            if (views > 1L) {
                this.strideMM = this.distance / (double)(views - 1L);
            }
            this.strideMM = this.minStrideCV;
        } else if (this.distance != 0.0) {
            long views = Math.round(this.distance / this.strideMM) + 1L;
            this.angleRadians = this.rotationAngle / (double)views;
        }
    }

    private void calculateRotationMatrix(double[] startLook, double[] startEye, double[] startUp, double[] endLook, double[] endEye, double[] endUp, double[] rotationAxis, double[] rotationAngle) {
        double[] startview = new double[3];
        JnVector3d.sub(startLook, startEye, startview);
        JnVector3d.normalize(startview);
        double[] startright = new double[3];
        JnVector3d.cross(startview, startUp, startright);
        JnVector3d.normalize(startright);
        double[] endview = new double[3];
        JnVector3d.sub(endLook, endEye, endview);
        JnVector3d.normalize(endview);
        double[] endright = new double[3];
        JnVector3d.cross(endview, endUp, endright);
        JnVector3d.normalize(endright);
        JnVector3d origSliceI = new JnVector3d(startright);
        JnVector3d origSliceJ = new JnVector3d(startUp);
        origSliceJ.scale(-1.0);
        JnVector3d origSliceN = new JnVector3d(startview);
        JnVector3d rotatedSliceI = new JnVector3d(endright);
        JnVector3d rotatedSliceJ = new JnVector3d(endUp);
        rotatedSliceJ.scale(-1.0);
        JnVector3d rotatedSliceN = new JnVector3d(endview);
        double[] rotationAngles = new double[3];
        GeomUtils.rotationAnglesBetweenSlices(origSliceI, origSliceJ, origSliceN, rotatedSliceI, rotatedSliceJ, rotatedSliceN, rotationAngles);
        rotationAngles[0] = Math.toRadians(rotationAngles[0]);
        rotationAngles[1] = Math.toRadians(rotationAngles[1]);
        rotationAngles[2] = Math.toRadians(rotationAngles[2]);
        this.rotate(rotationAngles, rotationAxis, rotationAngle);
    }

    public final void rotate(double[] eulerAngles, double[] rotationAxis, double[] rotationAngle) {
        double x = eulerAngles[0];
        double y = eulerAngles[1];
        double z = eulerAngles[2];
        double c1 = Math.cos(y / 2.0);
        double s1 = Math.sin(y / 2.0);
        double c2 = Math.cos(z / 2.0);
        double s2 = Math.sin(z / 2.0);
        double c3 = Math.cos(x / 2.0);
        double s3 = Math.sin(x / 2.0);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        rotationAxis[0] = c1c2 * s3 + s1s2 * c3;
        rotationAxis[1] = s1 * c2 * c3 + c1 * s2 * s3;
        rotationAxis[2] = c1 * s2 * c3 - s1 * c2 * s3;
        rotationAngle[0] = 2.0 * Math.acos(w);
        double norm = rotationAxis[0] * rotationAxis[0] + rotationAxis[1] * rotationAxis[1] + rotationAxis[2] * rotationAxis[2];
        if (norm < 1.0E-10) {
            rotationAxis[0] = 1.0;
            rotationAxis[2] = 0.0;
            rotationAxis[1] = 0.0;
        } else {
            norm = Math.sqrt(norm);
            rotationAxis[0] = rotationAxis[0] / norm;
            rotationAxis[1] = rotationAxis[1] / norm;
            rotationAxis[2] = rotationAxis[2] / norm;
        }
    }

    @Override
    public int getNumFrames() {
        if (this.startSet) {
            switch (this.mode) {
                case PAGE: {
                    return (int)Math.round(this.distance / this.strideMM) + 1;
                }
                case ROTATE: {
                    return (int)Math.round(this.rotationAngle / this.angleRadians) + 1;
                }
                case BOTH: {
                    int angleViews = (int)Math.round(this.rotationAngle / this.angleRadians);
                    int distanceViews = (int)Math.round(this.distance / this.strideMM) + 1;
                    return Math.max(angleViews, distanceViews);
                }
            }
            return 1;
        }
        return 1;
    }

    public void setStrideMM(double strideMM) {
        if ((LoopMode.BOTH.equals((Object)this.mode) || LoopMode.PAGE.equals((Object)this.mode)) && this.distance > 0.0) {
            this.strideMM = this.convertStride(strideMM);
            double numSteps = Math.round(this.distance / strideMM) + 1L;
            if (LoopMode.BOTH.equals((Object)this.mode)) {
                this.angleRadians = this.rotationAngle / (numSteps - 1.0);
            }
        } else {
            this.strideMM = 0.0;
        }
    }

    private double convertStride(double stride) {
        if (this.startSet && this.endSet) {
            if (LoopMode.PAGE.equals((Object)this.mode) || this.angleRadians == 0.0) {
                stride = Math.max(stride, this.minStrideCV);
                int temp = (int)Math.round(stride / this.minStrideCV);
                stride = (double)temp * this.minStrideCV;
                double steps = this.distance / stride + 1.0;
                double rndSteps = Math.ceil(steps);
                this.distance = stride * (rndSteps - 1.0);
                return stride;
            }
            stride = Math.max(stride, this.minStrideOb);
            double numSteps = this.distance / stride + 1.0;
            double rndNumSteps = Math.round(numSteps);
            return this.distance / (rndNumSteps - 1.0);
        }
        return stride;
    }

    public double getStrideMM() {
        if (this.strideMM == -1.0) {
            // empty if block
        }
        return this.strideMM;
    }

    public double setAngleStep(double angleRadians) {
        if ((LoopMode.BOTH.equals((Object)this.mode) || LoopMode.ROTATE.equals((Object)this.mode)) && this.rotationAngle > 0.0) {
            this.angleRadians = this.convertAngle(angleRadians);
            double numSteps = this.rotationAngle / this.angleRadians + 1.0;
            if (LoopMode.BOTH.equals((Object)this.mode)) {
                this.strideMM = this.distance / (numSteps - 1.0);
            }
        } else {
            this.angleRadians = 0.0;
        }
        return this.angleRadians;
    }

    private double convertAngle(double angleRadians) {
        if (this.startSet && this.endSet) {
            double numSteps = this.rotationAngle / (angleRadians = Math.max(angleRadians, MIN_ANGLE)) + 1.0;
            double rndNumSteps = Math.round(numSteps);
            if (rndNumSteps > 1.0) {
                return this.rotationAngle / (rndNumSteps - 1.0);
            }
            return this.rotationAngle;
        }
        return angleRadians;
    }

    public void setAngleStepDegrees(double angle) {
        this.setAngleStep(Math.toRadians(angle));
    }

    public double getAngleStep() {
        return this.angleRadians;
    }

    public double getAngleStepDegrees() {
        return Math.toDegrees(this.angleRadians);
    }

    public void setNumberOfImages(int numOfImages) {
        switch (this.mode) {
            case PAGE: {
                this.angleRadians = 0.0;
                this.strideMM = this.convertStride(this.distance / (double)(numOfImages - 1));
                break;
            }
            case ROTATE: {
                this.angleRadians = this.rotationAngle / (double)numOfImages;
                this.strideMM = 0.0;
                break;
            }
            case BOTH: {
                this.angleRadians = this.rotationAngle / (double)(numOfImages - 1);
                this.strideMM = this.distance / (double)(numOfImages - 1);
                break;
            }
        }
    }

    @Override
    public void getView(int i, double[] eyept, double[] lookpt, double[] up) {
        JnVector3d startLookJn = new JnVector3d(this.startLook);
        if (this.strideMM > 0.0) {
            double[] tempLookV = new double[3];
            JnVector3d.sub(this.endLook, this.startLook, tempLookV);
            JnVector3d tempLookVJn = new JnVector3d(tempLookV);
            tempLookVJn.normalize();
            tempLookVJn.scale((double)i * this.strideMM);
            startLookJn.add(tempLookVJn);
        }
        System.arraycopy(startLookJn.toArray(), 0, lookpt, 0, 3);
        JnMatrix3d mat = new JnMatrix3d();
        if (!this.endSet) {
            mat.setRotate(this.angleRadians * (double)i, this.upV[0], this.upV[1], this.upV[2]);
        } else {
            mat.setRotate(this.angleRadians * (double)i, this.rotationAxis[0], this.rotationAxis[1], this.rotationAxis[2]);
        }
        System.arraycopy(this.viewV, 0, this.tmpv, 0, 3);
        mat.transform(this.tmpv);
        System.arraycopy(this.upV, 0, this.tmpup, 0, 3);
        mat.transform(this.tmpup);
        JnVector3d.sub(lookpt, this.tmpv, eyept);
        System.arraycopy(this.tmpup, 0, up, 0, 3);
    }

    @Override
    public int getViewIndex(double[] eyept, double[] lookpt, double[] up) {
        int result = -1;
        double[] tempLookV = new double[3];
        JnVector3d.sub(this.endLook, this.startLook, tempLookV);
        JnVector3d lookVector = new JnVector3d(tempLookV);
        double[] tempV = new double[3];
        JnVector3d.sub(lookpt, this.startLook, tempV);
        JnVector3d vector = new JnVector3d(tempV);
        double length = vector.length();
        if (length > 0.0) {
            lookVector.normalize();
            vector.normalize();
            double dot = lookVector.dot(vector);
            if (GeomUtils.fuzzyEquals(1.0, dot)) {
                if (this.distance > 0.0) {
                    if (length > this.distance) {
                        return -1;
                    }
                    return (int)(length / this.strideMM);
                }
            } else {
                return -1;
            }
        }
        double[] rotationAxis = new double[3];
        double[] rotationAngle = new double[1];
        this.calculateRotationMatrix(this.startLook, this.startEye, this.startUp, lookpt, eyept, up, rotationAxis, rotationAngle);
        double rotationdiff = this.diffvec(rotationAxis, this.rotationAxis);
        result = rotationdiff < 1.0E-5 ? (int)(rotationAngle[0] / this.angleRadians) : 0;
        return result;
    }

    private void calculateInitial() {
        this.t3dCapable.getLookPoint(this.tmplook);
        this.t3dCapable.getEyePoint(this.tmpeye);
        this.t3dCapable.getUp(this.tmpup);
        JnVector3d.sub(this.tmplook, this.tmpeye, this.tmpv);
        JnVector3d.normalize(this.tmpv);
        System.arraycopy(this.tmpup, 0, this.upV, 0, 3);
        System.arraycopy(this.tmpv, 0, this.viewV, 0, 3);
    }

    @Override
    protected void updateContent() {
    }

    protected final double diffvec(double[] v1, double[] v2) {
        int len = v1.length;
        double sum = 0.0;
        for (int i = 0; i < len; ++i) {
            sum += Math.abs(v1[i] - v2[i]);
        }
        return sum;
    }

    public void startFromSlice(double[] sliceEye, double[] sliceLook, double[] sliceUp) {
        this.startEye = (double[])(sliceEye != null ? Arrays.copyOf(sliceEye, sliceEye.length) : null);
        this.startLook = (double[])(sliceLook != null ? Arrays.copyOf(sliceLook, sliceLook.length) : null);
        this.startUp = (double[])(sliceUp != null ? Arrays.copyOf(sliceUp, sliceUp.length) : null);
        this.startSet = true;
        this.endSet = false;
        this.calculateInitial();
    }

    public void endToSlice(double[] sliceEye, double[] sliceLook, double[] sliceUp) {
        if (this.startSet) {
            this.endEye = (double[])(sliceEye != null ? Arrays.copyOf(sliceEye, sliceEye.length) : null);
            this.endLook = (double[])(sliceLook != null ? Arrays.copyOf(sliceLook, sliceLook.length) : null);
            this.endUp = (double[])(sliceUp != null ? Arrays.copyOf(sliceUp, sliceUp.length) : null);
            this.endSet = true;
            this.calculateNewParameters();
        }
    }
}

