/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.utils;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.terra.tap.dm.DMComposite;
import java.io.File;

public abstract class VavMemoryResourceCalculator {
    public static final int memoryUsageMin = Integer.parseInt(CvPropertiesManager.getProperty("vav.memoryUsageMin", "350"));
    private static VavMemoryResourceCalculator instance = null;

    public static VavMemoryResourceCalculator getInstance() {
        String rescal = CvPropertiesManager.getProperty("vav.memoryResourceCalculatorClass", "com.ge.med.cse.cvf.j3d.utils.VavMemoryResourceCalculator$DefaultMemoryResourceCalculator");
        if (instance != null && instance.getClass().getName().equals(rescal)) {
            return instance;
        }
        try {
            Class cla = CvUtils.getClass(rescal);
            if (cla != null) {
                instance = (VavMemoryResourceCalculator)cla.newInstance();
                return instance;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public abstract int calRequiredMemUnits(XjVolumeGeometry var1);

    public abstract int calRequiredMemUnits(DMComposite var1, int var2);

    public abstract boolean isVolumeSizeWithinLimits(int var1);

    public abstract int getVolumeSizeLimit();

    public abstract int getVolumeSizeLimitByNumSlices();

    public static class DefaultMemoryResourceCalculator
    extends VavMemoryResourceCalculator {
        private static final int memLimit = Integer.parseInt(CvPropertiesManager.getProperty("vav.rendererInputMemoryLimit", "1265"));
        private static final int imgsLimit = Integer.parseInt(CvPropertiesManager.getProperty("vav.rendererInputImageLimit", "0"));
        private static final double memoryUsageFactor = Double.parseDouble(CvPropertiesManager.getProperty("vav.memoryUsageFactor", "2.00"));

        @Override
        public boolean isVolumeSizeWithinLimits(int volSize) {
            return volSize <= memLimit;
        }

        @Override
        public int getVolumeSizeLimit() {
            return memLimit;
        }

        @Override
        public int calRequiredMemUnits(DMComposite image, int numImages) {
            File imageFile = new File(image.getFilePath());
            long imageSize = imageFile.length();
            System.out.println("<<<<<<<<<<(int)((numImages * imageSize * memoryUsageFactor) / (1024*1024)):::" + (int)((double)((long)numImages * imageSize) * memoryUsageFactor / 1048576.0));
            return (int)((double)((long)numImages * imageSize) * memoryUsageFactor / 1048576.0);
        }

        @Override
        public int calRequiredMemUnits(XjVolumeGeometry volume) {
            int[] volDims = volume.getVolumeDimensions(null);
            int pixSize = 1;
            if (volume instanceof XjVolumeInfo) {
                pixSize = ((XjVolumeInfo)volume).getBitsPerVoxel() >> 3;
            }
            System.out.println("Dynamic volume Bytes per Pixel : " + pixSize);
            long volSize = volDims[0] * volDims[1] * volDims[2] * pixSize;
            int volmem = (int)((double)volSize * memoryUsageFactor / 1048576.0);
            System.out.println("<<<<<<<<<Dynamic volmem>>>>>>>>>>>>>::" + volmem);
            return volmem;
        }

        @Override
        public int getVolumeSizeLimitByNumSlices() {
            return imgsLimit;
        }
    }
}

