/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.utils;

import com.ge.med.cse.cvf.idc.XjVolumeCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.dm.volume.DMObjectVolume;
import java.awt.Component;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class J3DGeomUtils {
    private static final Logger logger = Logger.getLogger(J3DGeomUtils.class.getName());
    public static final double EPSILON = 1.0E-4;
    private static final double TOL = 0.01;
    public static final short PLANE_TYPE_AXIAL = 2;
    public static final short PLANE_TYPE_SAGITTAL = 4;
    public static final short PLANE_TYPE_CORONAL = 8;
    public static final short PLANE_TYPE_OB_AXIAL = 18;
    public static final short PLANE_TYPE_OB_SAGITTAL = 20;
    public static final short PLANE_TYPE_OB_CORONAL = 24;
    public static final NumberFormat decimalFormat = NumberFormat.getInstance(Locale.US);
    public static final int MAX_NUM_THICK_SLICES = 31;
    private static DMTag rstag;
    private static DMTag ritag;
    private static XpDicomElement rselem;
    private static XpDicomElement rielem;
    public static final int DATA_INVALID = -1;
    public static final int DATA_VALID = 0;
    public static final int PIX_DIM_NOT_SAME = 1;
    public static final int SLICES_NOT_COPLANAR = 2;
    public static final int SLICES_NOT_COAXIAL = 3;
    public static final int SLICE_SAPCING_NOT_SAME = 4;
    public static final int DUPLICATE_SLICE_LOCATIONS = 5;
    public static final int SLICE_THICKNESS_NOT_SAME = 6;
    public static final double CORNER_SHIFT_TOLERANCE;
    public static final double LOC_SHIFT_TOLERANCE;
    public static final double NORMAL_SHIFT_TOLERANCE;
    public static final double PIXEL_SPACING_TOLERANCE;
    public static final double TOLERANCE = 0.01;
    public static final boolean checkSliceThickness;
    public static final boolean ignoreDuplicates;
    public static final int maxAllowableMissingSlices;
    private static DMTag localtionTag;
    private static XpDicomElement elem0;

    public static boolean fuzzyEquals(double d1, double d2) {
        return Math.abs(d2 - d1) <= 1.0E-4;
    }

    public static boolean fuzzyEquals(JnVector3d v1, JnVector3d v2) {
        return Math.abs(v2.x - v1.x) <= 1.0E-4 && Math.abs(v2.y - v1.y) <= 1.0E-4 && Math.abs(v2.z - v1.z) <= 1.0E-4;
    }

    public static boolean isZero(JnVector3d v) {
        return Math.abs(v.x) < 1.0E-10 && Math.abs(v.y) < 1.0E-10 && Math.abs(v.z) < 1.0E-10;
    }

    public static void snapPointToVolume(double[] voxPoint, int[] volDims) {
        for (int i = 0; i < 3; ++i) {
            if (Math.abs(voxPoint[i]) < 0.01) {
                voxPoint[i] = 0.0;
                continue;
            }
            if (!(Math.abs(voxPoint[i] - (double)(volDims[i] - 1)) < 0.01)) continue;
            voxPoint[i] = volDims[i] - 1;
        }
    }

    public static void snapPointToVolume(JnVector3d voxPoint, int[] volDims) {
        if (Math.abs(voxPoint.x) < 0.01) {
            voxPoint.x = 0.0;
        } else if (Math.abs(voxPoint.x - (double)(volDims[0] - 1)) < 0.01) {
            voxPoint.x = volDims[0] - 1;
        }
        if (Math.abs(voxPoint.y) < 0.01) {
            voxPoint.y = 0.0;
        } else if (Math.abs(voxPoint.y - (double)(volDims[1] - 1)) < 0.01) {
            voxPoint.y = volDims[1] - 1;
        }
        if (Math.abs(voxPoint.z) < 0.01) {
            voxPoint.z = 0.0;
        } else if (Math.abs(voxPoint.z - (double)(volDims[2] - 1)) < 0.01) {
            voxPoint.z = volDims[2] - 1;
        }
    }

    public static void roundPoint(double[] point) {
        for (int i = 0; i < point.length; ++i) {
            long rounded = Math.round(point[i]);
            double diff = (double)rounded - point[i];
            if (!(Math.abs(diff) < 0.01)) continue;
            point[i] = rounded;
        }
    }

    public static void roundPoint(JnVector3d point) {
        long rounded = Math.round(point.x);
        double diff = (double)rounded - point.x;
        if (Math.abs(diff) < 0.01) {
            point.x = rounded;
        }
        if (Math.abs(diff = (double)(rounded = Math.round(point.y)) - point.y) < 0.01) {
            point.y = rounded;
        }
        if (Math.abs(diff = (double)(rounded = Math.round(point.z)) - point.z) < 0.01) {
            point.z = rounded;
        }
    }

    public static boolean isInVolume(double[] rasPoint, int[] volDims, CTransform ras2vox) {
        JnVector3d pt = new JnVector3d();
        pt.set(rasPoint);
        ras2vox.transform(pt);
        J3DGeomUtils.roundPoint(pt);
        return pt.x >= 0.0 && pt.x < (double)volDims[0] && pt.y >= 0.0 && pt.y < (double)volDims[1] && pt.z >= 0.0 && pt.z < (double)volDims[2];
    }

    public static boolean isInVolume(double[] rasPoint, int[] volDims, JnMatrix4d ras2vox) {
        JnVector3d pt = new JnVector3d();
        pt.set(rasPoint);
        ras2vox.transform(pt);
        J3DGeomUtils.roundPoint(pt);
        return pt.x >= 0.0 && pt.x < (double)volDims[0] && pt.y >= 0.0 && pt.y < (double)volDims[1] && pt.z >= 0.0 && pt.z < (double)volDims[2];
    }

    public static double[] matrixToAngles(JnMatrix3d rotationMatrix, double[] rotationAngles) {
        double cy;
        if (rotationAngles == null || rotationAngles.length < 3) {
            rotationAngles = new double[3];
        }
        if ((cy = Math.sqrt(rotationMatrix.m11 * rotationMatrix.m11 + rotationMatrix.m21 * rotationMatrix.m21)) > 1.0E-7) {
            rotationAngles[1] = Math.toDegrees(Math.atan2(rotationMatrix.m02, rotationMatrix.m00));
            rotationAngles[2] = Math.toDegrees(Math.atan2(-rotationMatrix.m01, cy));
            rotationAngles[0] = Math.toDegrees(Math.atan2(rotationMatrix.m21, rotationMatrix.m11));
        } else {
            rotationAngles[1] = Math.toDegrees(Math.atan2(-rotationMatrix.m20, rotationMatrix.m22));
            rotationAngles[2] = Math.toDegrees(Math.atan2(-rotationMatrix.m01, cy));
            rotationAngles[0] = 0.0;
        }
        return rotationAngles;
    }

    public static int majorVectorComponent(JnVector3d vec) {
        if (Math.abs(vec.z) >= Math.abs(vec.x) && Math.abs(vec.z) >= Math.abs(vec.y)) {
            return 2;
        }
        if (Math.abs(vec.x) >= Math.abs(vec.y)) {
            return 0;
        }
        return 1;
    }

    public static int alignedToVolumeXYZ(CTransform jn_ras2vox, JnVector3d v) {
        double[] zero_tx = new double[]{0.0, 0.0, 0.0};
        double[] view = new double[]{v.x, v.y, v.z};
        JnVector3d.normalize(view);
        jn_ras2vox.transform(view);
        jn_ras2vox.transform(zero_tx);
        JnVector3d.sub(view, zero_tx, view);
        JnVector3d.normalize(view);
        double x = Math.abs(view[0]);
        double y = Math.abs(view[1]);
        double z = Math.abs(view[2]);
        if (x < 1.0E-4 && y < 1.0E-4) {
            return 2;
        }
        if (x < 1.0E-4 && z < 1.0E-4) {
            return 1;
        }
        if (y < 1.0E-4 && z < 1.0E-4) {
            return 0;
        }
        return -1;
    }

    public static boolean isOnthePlane(double[] vector, double[] look, double[] eye) {
        JnVector3d view = new JnVector3d();
        view.set(eye[0] - look[0], eye[1] - look[1], eye[2] - look[2]);
        view.normalize();
        JnVector3d v = new JnVector3d(vector);
        double dot = v.dot(view);
        return Math.abs(dot) < 1.0E-4;
    }

    public static void getWorldBounds(XjVolumeGeometry vol, double[] ulc, double[] xside, double[] yside, double[] zside) {
        if (vol == null) {
            return;
        }
        if (ulc == null) {
            ulc = new double[3];
        }
        if (xside == null) {
            xside = new double[3];
        }
        if (yside == null) {
            yside = new double[3];
        }
        if (zside == null) {
            zside = new double[3];
        }
        int[] dims = new int[3];
        vol.getRASOfOrigin(ulc);
        vol.getXDirectionRAS(xside);
        vol.getYDirectionRAS(yside);
        vol.getZDirectionRAS(zside);
        vol.getVolumeDimensions(dims);
        ulc[0] = ulc[0] - 0.5 * xside[0] - 0.5 * yside[0];
        ulc[1] = ulc[1] - 0.5 * xside[1] - 0.5 * yside[1];
        ulc[2] = ulc[2] - 0.5 * xside[2] - 0.5 * yside[2];
        xside[0] = xside[0] * (double)dims[0];
        xside[1] = xside[1] * (double)dims[0];
        xside[2] = xside[2] * (double)dims[0];
        yside[0] = yside[0] * (double)dims[1];
        yside[1] = yside[1] * (double)dims[1];
        yside[2] = yside[2] * (double)dims[1];
        zside[0] = zside[0] * (double)dims[2];
        zside[1] = zside[1] * (double)dims[2];
        zside[2] = zside[2] * (double)dims[2];
    }

    public static void getWorldBounds(XjVolumeGeometry vol, JnVector3d ulc, JnVector3d xside, JnVector3d yside, JnVector3d zside) {
        if (vol == null) {
            return;
        }
        double[] o = new double[3];
        double[] x = new double[3];
        double[] y = new double[3];
        double[] z = new double[3];
        J3DGeomUtils.getWorldBounds(vol, o, x, y, z);
        if (ulc == null) {
            ulc = new JnVector3d();
        }
        ulc.set(o);
        if (xside == null) {
            xside = new JnVector3d();
        }
        xside.set(x);
        if (yside == null) {
            yside = new JnVector3d();
        }
        yside.set(y);
        if (zside == null) {
            zside = new JnVector3d();
        }
        zside.set(z);
    }

    public static final double[] getVolumeCenterRAS(XjVolumeGeometry vol, double[] result) {
        if (result == null) {
            result = new double[3];
        }
        double[] orig = vol.getRASOfOrigin(null);
        double[] xdir = vol.getXDirectionRAS(null);
        double[] ydir = vol.getYDirectionRAS(null);
        double[] zdir = vol.getZDirectionRAS(null);
        int[] dims = vol.getVolumeDimensions(null);
        result[0] = orig[0] + ((double)Math.round((double)(dims[0] - 1) * 0.5) - 0.5) * xdir[0] + ((double)Math.round((double)(dims[1] - 1) * 0.5) - 0.5) * ydir[0] + (double)Math.round((double)(dims[2] - 1) * 0.5) * zdir[0];
        result[1] = orig[1] + ((double)Math.round((double)(dims[0] - 1) * 0.5) - 0.5) * xdir[1] + ((double)Math.round((double)(dims[1] - 1) * 0.5) - 0.5) * ydir[1] + (double)Math.round((double)(dims[2] - 1) * 0.5) * zdir[1];
        result[2] = orig[2] + ((double)Math.round((double)(dims[0] - 1) * 0.5) - 0.5) * xdir[2] + ((double)Math.round((double)(dims[1] - 1) * 0.5) - 0.5) * ydir[2] + (double)Math.round((double)(dims[2] - 1) * 0.5) * zdir[2];
        return result;
    }

    public static final double[] getVolumeCenterRAS(double[] ulc, double[] xside, double[] yside, double[] zside, double[] result) {
        if (result == null) {
            result = new double[]{ulc[0] + xside[0] * 0.5 + yside[0] * 0.5 + zside[0] * 0.5, ulc[1] + xside[1] * 0.5 + yside[1] * 0.5 + zside[1] * 0.5, ulc[2] + xside[2] * 0.5 + yside[2] * 0.5 + zside[2] * 0.5};
        }
        return result;
    }

    public static void alignVolumeToRAS(XjVolumeGeometry volume, JnVector3d volOrigin, JnVector3d volEdge0, JnVector3d volEdge1, JnVector3d volEdge2) {
        if (volume == null) {
            return;
        }
        if (volOrigin == null) {
            volOrigin = new JnVector3d();
        }
        if (volEdge0 == null) {
            volEdge0 = new JnVector3d();
        }
        if (volEdge1 == null) {
            volEdge1 = new JnVector3d();
        }
        if (volEdge2 == null) {
            volEdge2 = new JnVector3d();
        }
        J3DGeomUtils.getWorldBounds(volume, volOrigin, volEdge0, volEdge1, volEdge2);
        J3DGeomUtils.alignVolumeToRAS(volOrigin, volEdge0, volEdge1, volEdge2);
    }

    public static void constraintCenterInVolume(JnVector3d volOrigin, JnVector3d volEdge0, JnVector3d volEdge1, JnVector3d volEdge2) {
        JnVector3d edge0 = new JnVector3d();
        JnVector3d edge1 = new JnVector3d();
        JnVector3d edge2 = new JnVector3d();
        edge0.set(volEdge0);
        edge1.set(volEdge1);
        edge2.set(volEdge2);
        JnVector3d[] vertices = new JnVector3d[8];
        for (int i = 0; i < 8; ++i) {
            vertices[i] = new JnVector3d();
        }
        vertices[0].set(volOrigin);
        vertices[1].add(volOrigin, edge0);
        vertices[2].add(volOrigin, edge1);
        vertices[3].add(vertices[1], edge1);
        vertices[4].add(volOrigin, edge2);
        vertices[5].add(vertices[1], edge2);
        vertices[6].add(vertices[2], edge2);
        vertices[7].add(vertices[3], edge2);
        JnVector3d minRAS = new JnVector3d();
        minRAS.set(vertices[0]);
        for (int i = 1; i < 8; ++i) {
            if (vertices[i].x < minRAS.x) {
                minRAS.x = vertices[i].x;
            }
            if (vertices[i].y < minRAS.y) {
                minRAS.y = vertices[i].y;
            }
            if (!(vertices[i].z < minRAS.z)) continue;
            minRAS.z = vertices[i].z;
        }
        JnVector3d maxRAS = new JnVector3d();
        maxRAS.set(vertices[0]);
        for (int i = 1; i < 8; ++i) {
            if (vertices[i].x > maxRAS.x) {
                maxRAS.x = vertices[i].x;
            }
            if (vertices[i].y > maxRAS.y) {
                maxRAS.y = vertices[i].y;
            }
            if (!(vertices[i].z > maxRAS.z)) continue;
            maxRAS.z = vertices[i].z;
        }
        JnVector3d temp = new JnVector3d();
        double distToMinRAS = temp.sub(vertices[0], minRAS).magnitudeSq();
        int originIndex = 0;
        for (int i = 1; i < 8; ++i) {
            double dist = temp.sub(vertices[i], minRAS).magnitudeSq();
            if (!(dist < distToMinRAS)) continue;
            distToMinRAS = dist;
            originIndex = i;
        }
        volOrigin.set(vertices[originIndex]);
        if ((originIndex & 1) == 1) {
            edge0.multiplyBy(-1.0);
        }
        if ((originIndex & 2) == 2) {
            edge1.multiplyBy(-1.0);
        }
        if ((originIndex & 4) == 4) {
            edge2.multiplyBy(-1.0);
        }
        JnVector3d rVec = null;
        JnVector3d aVec = null;
        JnVector3d sVec = null;
        double rightAngle = 1.5707963267948966;
        double edge2Mag = edge2.magnitude();
        double angleToS = rightAngle - Math.abs(Math.acos(edge2.z / edge2Mag) - rightAngle);
        double angleToA = rightAngle - Math.abs(Math.acos(edge2.y / edge2Mag) - rightAngle);
        double angleToR = rightAngle - Math.abs(Math.acos(edge2.x / edge2Mag) - rightAngle);
        if (angleToR < angleToS) {
            if (angleToA < angleToR) {
                aVec = edge2;
            } else {
                rVec = edge2;
            }
        } else if (angleToA < angleToS) {
            aVec = edge2;
        } else {
            sVec = edge2;
        }
        double edge1Mag = edge1.magnitude();
        if (sVec != null) {
            angleToA = rightAngle - Math.abs(Math.acos(edge1.y / edge1Mag) - rightAngle);
            angleToR = rightAngle - Math.abs(Math.acos(edge1.x / edge1Mag) - rightAngle);
            if (angleToR < angleToA) {
                rVec = edge1;
                aVec = edge0;
            } else {
                aVec = edge1;
                rVec = edge0;
            }
        } else if (aVec != null) {
            angleToS = rightAngle - Math.abs(Math.acos(edge1.z / edge1Mag) - rightAngle);
            angleToR = rightAngle - Math.abs(Math.acos(edge1.x / edge1Mag) - rightAngle);
            if (angleToR < angleToS) {
                rVec = edge1;
                sVec = edge0;
            } else {
                sVec = edge1;
                rVec = edge0;
            }
        } else if (rVec != null) {
            angleToS = rightAngle - Math.abs(Math.acos(edge1.z / edge1Mag) - rightAngle);
            angleToA = rightAngle - Math.abs(Math.acos(edge1.y / edge1Mag) - rightAngle);
            if (angleToA < angleToS) {
                aVec = edge1;
                sVec = edge0;
            } else {
                sVec = edge1;
                aVec = edge0;
            }
        }
        volEdge0.set(rVec);
        volEdge1.set(aVec);
        volEdge2.set(sVec);
    }

    public static void alignVolumeToRAS(JnVector3d volOrigin, JnVector3d volEdge0, JnVector3d volEdge1, JnVector3d volEdge2) {
        JnVector3d edge0 = new JnVector3d();
        JnVector3d edge1 = new JnVector3d();
        JnVector3d edge2 = new JnVector3d();
        edge0.set(volEdge0);
        edge1.set(volEdge1);
        edge2.set(volEdge2);
        JnVector3d[] vertices = new JnVector3d[8];
        for (int i = 0; i < 8; ++i) {
            vertices[i] = new JnVector3d();
        }
        vertices[0].set(volOrigin);
        vertices[1].add(volOrigin, edge0);
        vertices[2].add(volOrigin, edge1);
        vertices[3].add(vertices[1], edge1);
        vertices[4].add(volOrigin, edge2);
        vertices[5].add(vertices[1], edge2);
        vertices[6].add(vertices[2], edge2);
        vertices[7].add(vertices[3], edge2);
        JnVector3d minRAS = new JnVector3d();
        minRAS.set(vertices[0]);
        for (int i = 1; i < 8; ++i) {
            if (vertices[i].x < minRAS.x) {
                minRAS.x = vertices[i].x;
            }
            if (vertices[i].y < minRAS.y) {
                minRAS.y = vertices[i].y;
            }
            if (!(vertices[i].z < minRAS.z)) continue;
            minRAS.z = vertices[i].z;
        }
        JnVector3d temp = new JnVector3d();
        double distToMinRAS = temp.sub(vertices[0], minRAS).magnitudeSq();
        int originIndex = 0;
        for (int i = 1; i < 8; ++i) {
            double dist = temp.sub(vertices[i], minRAS).magnitudeSq();
            if (!(dist < distToMinRAS)) continue;
            distToMinRAS = dist;
            originIndex = i;
        }
        volOrigin.set(vertices[originIndex]);
        if ((originIndex & 1) == 1) {
            edge0.multiplyBy(-1.0);
        }
        if ((originIndex & 2) == 2) {
            edge1.multiplyBy(-1.0);
        }
        if ((originIndex & 4) == 4) {
            edge2.multiplyBy(-1.0);
        }
        JnVector3d rVec = null;
        JnVector3d aVec = null;
        JnVector3d sVec = null;
        double rightAngle = 1.5707963267948966;
        double edge2Mag = edge2.magnitude();
        double angleToS = rightAngle - Math.abs(Math.acos(edge2.z / edge2Mag) - rightAngle);
        double angleToA = rightAngle - Math.abs(Math.acos(edge2.y / edge2Mag) - rightAngle);
        double angleToR = rightAngle - Math.abs(Math.acos(edge2.x / edge2Mag) - rightAngle);
        if (angleToR < angleToS) {
            if (angleToA < angleToR) {
                aVec = edge2;
            } else {
                rVec = edge2;
            }
        } else if (angleToA < angleToS) {
            aVec = edge2;
        } else {
            sVec = edge2;
        }
        double edge1Mag = edge1.magnitude();
        if (sVec != null) {
            angleToA = rightAngle - Math.abs(Math.acos(edge1.y / edge1Mag) - rightAngle);
            angleToR = rightAngle - Math.abs(Math.acos(edge1.x / edge1Mag) - rightAngle);
            if (angleToR < angleToA) {
                rVec = edge1;
                aVec = edge0;
            } else {
                aVec = edge1;
                rVec = edge0;
            }
        } else if (aVec != null) {
            angleToS = rightAngle - Math.abs(Math.acos(edge1.z / edge1Mag) - rightAngle);
            angleToR = rightAngle - Math.abs(Math.acos(edge1.x / edge1Mag) - rightAngle);
            if (angleToR < angleToS) {
                rVec = edge1;
                sVec = edge0;
            } else {
                sVec = edge1;
                rVec = edge0;
            }
        } else if (rVec != null) {
            angleToS = rightAngle - Math.abs(Math.acos(edge1.z / edge1Mag) - rightAngle);
            angleToA = rightAngle - Math.abs(Math.acos(edge1.y / edge1Mag) - rightAngle);
            if (angleToA < angleToS) {
                aVec = edge1;
                sVec = edge0;
            } else {
                sVec = edge1;
                aVec = edge0;
            }
        }
        volEdge0.set(rVec);
        volEdge1.set(aVec);
        volEdge2.set(sVec);
    }

    public static String getSliceLocation(XpSlice slice) {
        short planeType = J3DGeomUtils.getPlaneType(slice);
        JnVector3d center = new JnVector3d();
        center.add(slice.ul, slice.br);
        center.scale(0.5);
        if (planeType == 2 || planeType == 18) {
            return J3DGeomUtils.formatDouble(center.z);
        }
        if (planeType == 8 || planeType == 24) {
            return J3DGeomUtils.formatDouble(center.y);
        }
        return J3DGeomUtils.formatDouble(center.x);
    }

    public static String getSliceLocationString(XpSlice slice, NumberFormat formatter) {
        short planeType = J3DGeomUtils.getPlaneType(slice);
        JnVector3d center = new JnVector3d();
        center.add(slice.ul, slice.br);
        center.scale(0.5);
        if (planeType == 2 || planeType == 18) {
            return center.z < 0.0 ? "I" + J3DGeomUtils.formatDouble(Math.abs(center.z), formatter) : "S" + J3DGeomUtils.formatDouble(center.z, formatter);
        }
        if (planeType == 8 || planeType == 24) {
            return center.y < 0.0 ? "P" + J3DGeomUtils.formatDouble(Math.abs(center.y), formatter) : "A" + J3DGeomUtils.formatDouble(center.y, formatter);
        }
        return center.x < 0.0 ? "L" + J3DGeomUtils.formatDouble(Math.abs(center.x), formatter) : "R" + J3DGeomUtils.formatDouble(center.x, formatter);
    }

    public static double getSliceLocation(XpSlice slice, int planeType) {
        JnVector3d center = new JnVector3d();
        center.add(slice.ul, slice.br);
        center.scale(0.5);
        if (planeType == 2 || planeType == 18) {
            return center.z;
        }
        if (planeType == 8 || planeType == 24) {
            return center.y;
        }
        return center.x;
    }

    public static short getPlaneType(XpSlice slice) {
        return J3DGeomUtils.getPlaneType(slice.N);
    }

    public static short getPlaneType(JnVector3d sliceNormal) {
        short planeType;
        double rightAngle = 1.5707963267948966;
        JnVector3d normal = sliceNormal;
        double normalMag = normal.magnitude();
        double angleToS = rightAngle - Math.abs(Math.acos(normal.z / normalMag) - rightAngle);
        double angleToA = rightAngle - Math.abs(Math.acos(normal.y / normalMag) - rightAngle);
        double angleToR = rightAngle - Math.abs(Math.acos(normal.x / normalMag) - rightAngle);
        if (angleToR < angleToS) {
            if (angleToA < angleToR) {
                planeType = 8;
                if (!J3DGeomUtils.fuzzyEquals(angleToA, 0.0)) {
                    planeType = (short)(planeType + 16);
                }
            } else {
                planeType = 4;
                if (!J3DGeomUtils.fuzzyEquals(angleToR, 0.0)) {
                    planeType = (short)(planeType + 16);
                }
            }
        } else if (angleToA < angleToS) {
            planeType = 8;
            if (!J3DGeomUtils.fuzzyEquals(angleToA, 0.0)) {
                planeType = (short)(planeType + 16);
            }
        } else {
            planeType = 2;
            if (!J3DGeomUtils.fuzzyEquals(angleToS, 0.0)) {
                planeType = (short)(planeType + 16);
            }
        }
        return planeType;
    }

    public static String formatDouble(double value) {
        String strValue = Double.toString(value);
        int maxFracDigits = 8;
        while (strValue.length() > 16 && maxFracDigits > 0) {
            logger.log(Level.FINER, "Reducing double value precision to convert to string. Max fraction digits: " + maxFracDigits);
            decimalFormat.setMaximumFractionDigits(maxFracDigits);
            strValue = decimalFormat.format(value);
            if (--maxFracDigits > 0) continue;
            throw new RuntimeException("Error formating double to string: value=" + value);
        }
        return strValue;
    }

    public static String formatDouble(double value, NumberFormat formatter) {
        if (formatter == null) {
            formatter = decimalFormat;
        }
        return formatter.format(value);
    }

    public static double getSliceSpacing(XjVolumeGeometry geom, double[] eye, double[] look) {
        double[] xdir = geom.getXDirectionRAS(null);
        double[] ydir = geom.getYDirectionRAS(null);
        double[] zdir = geom.getZDirectionRAS(null);
        double xlen = JnVector3d.length(xdir);
        double ylen = JnVector3d.length(ydir);
        double zlen = JnVector3d.length(zdir);
        double[] view = new double[3];
        JnVector3d.sub(look, eye, view);
        JnVector3d.normalize(view);
        double xcomp = Math.abs(view[0]);
        double ycomp = Math.abs(view[1]);
        double zcomp = Math.abs(view[2]);
        double spacing = xcomp >= ycomp && xcomp > zcomp ? xlen : (ycomp >= xcomp && ycomp > zcomp ? ylen : zlen);
        return spacing;
    }

    public static double getSliceSpacing(XjVolumeGeometry geom, double[] unitView) {
        double[] xdir = geom.getXDirectionRAS(null);
        double[] ydir = geom.getYDirectionRAS(null);
        double[] zdir = geom.getZDirectionRAS(null);
        double xlen = JnVector3d.length(xdir);
        double ylen = JnVector3d.length(ydir);
        double zlen = JnVector3d.length(zdir);
        double xcomp = Math.abs(unitView[0]);
        double ycomp = Math.abs(unitView[1]);
        double zcomp = Math.abs(unitView[2]);
        double spacing = xcomp >= ycomp && xcomp > zcomp ? xlen : (ycomp >= xcomp && ycomp > zcomp ? ylen : zlen);
        return spacing;
    }

    public static double getMinSpacing(XjVolumeGeometry geom) {
        double[] xdir = geom.getXDirectionRAS(null);
        double[] ydir = geom.getYDirectionRAS(null);
        double[] zdir = geom.getZDirectionRAS(null);
        double xlen = JnVector3d.length(xdir);
        double ylen = JnVector3d.length(ydir);
        double zlen = JnVector3d.length(zdir);
        return Math.min(xlen, Math.min(ylen, zlen));
    }

    public static double getMaxSpacing(XjVolumeGeometry vol) {
        if (vol == null) {
            return 0.0;
        }
        double[] tmpx = vol.getXDirectionRAS(null);
        double[] tmpy = vol.getYDirectionRAS(null);
        double[] tmpz = vol.getZDirectionRAS(null);
        int[] vdims = vol.getVolumeDimensions(null);
        JnVector3d.scale(tmpx, vdims[0] - 1);
        JnVector3d.scale(tmpy, vdims[1] - 1);
        JnVector3d.scale(tmpz, vdims[2] - 1);
        double xlen = JnVector3d.length(tmpx);
        double ylen = JnVector3d.length(tmpy);
        double zlen = JnVector3d.length(tmpz);
        double extent = Math.max(xlen, Math.max(ylen, zlen));
        double maxSpacing = Math.max(JnVector3d.length(vol.getXDirectionRAS(null)), Math.max(JnVector3d.length(vol.getYDirectionRAS(null)), JnVector3d.length(vol.getZDirectionRAS(null))));
        return Math.min(extent, maxSpacing * 31.0);
    }

    public static double getDefaultDFOV(double[] ulc, double[] xside, double[] yside, double[] zside, double[] lookpt, double[] up, double[] eye) {
        double xlen = JnVector3d.length(xside);
        double ylen = JnVector3d.length(yside);
        double zlen = JnVector3d.length(zside);
        JnVector3d viewvec = new JnVector3d();
        viewvec.sub(lookpt, eye);
        viewvec.normalize();
        JnVector3d upvec = new JnVector3d(up);
        upvec.normalize();
        JnVector3d rightvec = new JnVector3d();
        JnVector3d.cross(upvec, viewvec, rightvec);
        rightvec.normalize();
        double xcomp = Math.abs(upvec.x);
        double ycomp = Math.abs(upvec.y);
        double zcomp = Math.abs(upvec.z);
        double dfov = -1.0;
        dfov = xcomp >= ycomp && xcomp > zcomp ? xlen : (ycomp >= xcomp && ycomp > zcomp ? ylen : zlen);
        xcomp = Math.abs(rightvec.x);
        ycomp = Math.abs(rightvec.y);
        zcomp = Math.abs(rightvec.z);
        dfov = xcomp >= ycomp && xcomp > zcomp ? (dfov < xlen ? xlen : dfov) : (ycomp >= xcomp && ycomp > zcomp ? (dfov < ylen ? ylen : dfov) : (dfov < zlen ? zlen : dfov));
        return dfov;
    }

    public static double[] getBestFitDfov(double[] ulc, double[] xside, double[] yside, double[] zside, double[] lookpt, double[] up, double[] eye) {
        JnVector3d x = new JnVector3d(xside);
        JnVector3d y = new JnVector3d(yside);
        JnVector3d z = new JnVector3d(zside);
        double[] dx = x.toArray();
        JnVector3d.normalize(dx);
        double[] dy = y.toArray();
        JnVector3d.normalize(dy);
        double[] dz = z.toArray();
        JnVector3d.normalize(dz);
        JnVector3d viewvec = new JnVector3d();
        viewvec.sub(lookpt, eye);
        viewvec.normalize();
        CTransform vox2ras = new CTransform();
        CTransform ras2vox = new CTransform();
        J3DGeomUtils.calculateVoxelRASTransforms(ulc, dx, dy, dz, vox2ras, ras2vox);
        int edge = J3DGeomUtils.alignedToVolumeXYZ(ras2vox, viewvec);
        if (edge == 0) {
            return new double[]{JnVector3d.length(yside), JnVector3d.length(zside)};
        }
        if (edge == 1) {
            return new double[]{JnVector3d.length(xside), JnVector3d.length(zside)};
        }
        if (edge == 2) {
            return new double[]{JnVector3d.length(xside), JnVector3d.length(yside)};
        }
        JnVector3d upvec = new JnVector3d(up);
        upvec.normalize();
        JnVector3d rightvec = new JnVector3d();
        JnVector3d.cross(upvec, viewvec, rightvec);
        rightvec.normalize();
        double dfovh = -1.0;
        double dfovw = -1.0;
        JnVector3d p1 = new JnVector3d();
        JnVector3d p2 = new JnVector3d();
        if (GeomUtils.lineParallelepipedIntersection(new JnVector3d(lookpt), upvec.normalize(), new JnVector3d(ulc), new JnVector3d(xside), new JnVector3d(yside), new JnVector3d(zside), p1, p2)) {
            dfovh = Math.abs(p1.sub(p2).magnitude());
            if (GeomUtils.lineParallelepipedIntersection(new JnVector3d(lookpt), rightvec.normalize(), new JnVector3d(ulc), new JnVector3d(xside), new JnVector3d(yside), new JnVector3d(zside), p1, p2)) {
                dfovw = Math.abs(p1.sub(p2).magnitude());
            }
        }
        return new double[]{dfovw, dfovh};
    }

    public static double[] getBestFitDfov(XjVolumeGeometry vol, double[] lookpt, double[] up, double[] eye) {
        double[] ulc = new double[3];
        double[] xside = new double[3];
        double[] yside = new double[3];
        double[] zside = new double[3];
        J3DGeomUtils.getWorldBounds(vol, ulc, xside, yside, zside);
        return J3DGeomUtils.getBestFitDfov(ulc, xside, yside, zside, lookpt, up, eye);
    }

    public static double getMaxSliceThickness(XjVolumeGeometry vol, double[] lookpt, double[] eyept) {
        double[] ulc = new double[3];
        double[] xside = new double[3];
        double[] yside = new double[3];
        double[] zside = new double[3];
        J3DGeomUtils.getWorldBounds(vol, ulc, xside, yside, zside);
        return J3DGeomUtils.getMaxSliceThickness(ulc, xside, yside, zside, lookpt, eyept);
    }

    public static double getMaxSliceThickness(XjVolumeGeometry vol, JnVector3d linePt, JnVector3d lineVec) {
        double[] ulc = new double[3];
        double[] xside = new double[3];
        double[] yside = new double[3];
        double[] zside = new double[3];
        J3DGeomUtils.getWorldBounds(vol, ulc, xside, yside, zside);
        JnVector3d p1 = new JnVector3d();
        JnVector3d p2 = new JnVector3d();
        if (GeomUtils.lineParallelepipedIntersection(linePt, lineVec, new JnVector3d(ulc), new JnVector3d(xside), new JnVector3d(yside), new JnVector3d(zside), p1, p2)) {
            return Math.abs(p1.sub(p2).magnitude());
        }
        return 0.0;
    }

    public static double getMaxSliceThickness(double[] ulc, double[] xside, double[] yside, double[] zside, double[] lookpt, double[] eyept) {
        JnVector3d viewvec = new JnVector3d();
        viewvec.sub(lookpt, eyept);
        JnVector3d p1 = new JnVector3d();
        JnVector3d p2 = new JnVector3d();
        if (GeomUtils.lineParallelepipedIntersection(new JnVector3d(lookpt), viewvec.normalize(), new JnVector3d(ulc), new JnVector3d(xside), new JnVector3d(yside), new JnVector3d(zside), p1, p2)) {
            return Math.abs(p1.sub(p2).magnitude());
        }
        return 0.0;
    }

    public static double getMinSliceThickness(XjVolumeGeometry vol, double[] lookpt, double[] eyept) {
        JnVector3d v = new JnVector3d(Math.abs(lookpt[0] - eyept[0]), Math.abs(lookpt[1] - eyept[1]), Math.abs(lookpt[2] - eyept[2]));
        return J3DGeomUtils.getMinSliceThickness(vol, v);
    }

    public static double getMinSliceThickness(XjVolumeGeometry vol, JnVector3d normal) {
        CTransform vox2ras = new CTransform();
        CTransform ras2vox = new CTransform();
        J3DGeomUtils.calculateVoxelRASTransforms(vol, vox2ras, ras2vox);
        boolean oblique = J3DGeomUtils.alignedToVolumeXYZ(ras2vox, normal) < 0;
        return J3DGeomUtils.getMinSliceThickness(vol, normal.toArray(), oblique);
    }

    public static double getMinSliceThickness(XjVolumeGeometry vol, double[] lookpt, double[] eyept, boolean oblique) {
        double[] normal = new double[]{Math.abs(eyept[0] - lookpt[0]), Math.abs(eyept[1] - lookpt[1]), Math.abs(eyept[2] - lookpt[2])};
        JnVector3d.normalize(normal);
        return J3DGeomUtils.getMinSliceThickness(vol, normal, oblique);
    }

    public static double getMinSliceThickness(XjVolumeGeometry vol, double[] normal, boolean oblique) {
        return J3DGeomUtils.getMinSliceThickness(vol.getXDirectionRAS(null), vol.getYDirectionRAS(null), vol.getZDirectionRAS(null), normal, oblique);
    }

    public static double getMinSliceThickness(double[] ras_dx, double[] ras_dy, double[] ras_dz, double[] normal, boolean oblique) {
        double nz;
        double dimX = JnVector3d.length(ras_dx);
        double dimY = JnVector3d.length(ras_dy);
        double dimZ = JnVector3d.length(ras_dz);
        if (oblique) {
            return Math.min(dimZ, Math.min(dimY, dimX));
        }
        double nx = Math.abs(normal[0]);
        double ny = Math.abs(normal[1]);
        if (ny > (nz = Math.abs(normal[2]))) {
            if (nx > ny) {
                return dimX;
            }
            return dimY;
        }
        if (nx > nz) {
            return dimY;
        }
        return dimZ;
    }

    public static void getTiltOrientationTransform(XjVolumeGeometry g, JnMatrix4d result) {
        double[] xdir = g.getXDirectionRAS(null);
        double[] ydir = g.getYDirectionRAS(null);
        double[] zdir = g.getZDirectionRAS(null);
        J3DGeomUtils.getTiltOrientationTransform(xdir, ydir, zdir, result);
    }

    public static void getTiltOrientationTransform(double[] xdir, double[] ydir, double[] zdir, JnMatrix4d result) {
        JnVector3d x = new JnVector3d(xdir);
        x.normalize();
        double tilt = J3DGeomUtils.getTiltAngle(xdir, ydir, zdir);
        result.setIdentity();
        result.setRotate(-tilt, x.x, x.y, x.z);
    }

    public static double getTiltAngle(double[] xdir, double[] ydir, double[] zdir) {
        double tilt;
        JnVector3d x = new JnVector3d(xdir);
        JnVector3d y = new JnVector3d(ydir);
        JnVector3d z = new JnVector3d(zdir);
        x.normalize();
        y.normalize();
        z.normalize();
        JnVector3d k = new JnVector3d();
        JnVector3d.cross(x, y, k);
        k.normalize();
        double k_dot = k.dot(new double[]{0.0, 0.0, 1.0});
        double ang = Math.acos(y.dot(z)) - 1.5707963267948966;
        if (k_dot < 0.0) {
            ang = -ang;
        }
        if (Math.abs(tilt = ang) < 0.001) {
            tilt = 0.0;
        }
        return tilt;
    }

    public static void centerOnFOV(T3DCapable t3dcap) {
        if (t3dcap == null) {
            return;
        }
        double[] ulc = new double[3];
        double[] xside = new double[3];
        double[] yside = new double[3];
        double[] zside = new double[3];
        t3dcap.getWorldBounds(ulc, xside, yside, zside);
        double[] center = new double[3];
        if (t3dcap instanceof XjVolumeCapable) {
            J3DGeomUtils.getVolumeCenterRAS(((XjVolumeCapable)((Object)t3dcap)).getVolume(), center);
        } else {
            J3DGeomUtils.getVolumeCenterRAS(ulc, xside, yside, zside, center);
        }
        JnVector3d viewVector = new JnVector3d(t3dcap.getLookPoint(null));
        viewVector.sub(t3dcap.getEyePoint(null));
        JnVector3d rightVector = new JnVector3d();
        JnVector3d upVector = new JnVector3d();
        upVector.set(t3dcap.getUp(null));
        JnVector3d tmpV1 = new JnVector3d();
        JnVector3d tmpV2 = new JnVector3d();
        tmpV1.set(upVector);
        double[] look = t3dcap.getLookPoint(null);
        tmpV2.set(center[0] - look[0], center[1] - look[1], center[2] - look[2]);
        tmpV1.normalize();
        double dot = tmpV2.dot(tmpV1);
        tmpV1.scale(dot);
        look[0] = look[0] + tmpV1.x;
        look[1] = look[1] + tmpV1.y;
        look[2] = look[2] + tmpV1.z;
        JnVector3d.cross(viewVector, upVector, rightVector);
        tmpV1.set(rightVector);
        tmpV2.set(center[0] - look[0], center[1] - look[1], center[2] - look[2]);
        tmpV1.normalize();
        dot = tmpV2.dot(tmpV1);
        tmpV1.scale(dot);
        look[0] = look[0] + tmpV1.x;
        look[1] = look[1] + tmpV1.y;
        look[2] = look[2] + tmpV1.z;
        JnVector3d eyev = new JnVector3d(look);
        eyev.sub(viewVector);
        t3dcap.setCamera(eyev.generateArray(), look, upVector.generateArray());
        t3dcap.repaint();
    }

    public static void getVolumeGeometry(DMTagValueInterface[] dmos, double[] ras_ulc, double[] ras_dx, double[] ras_dy, double[] ras_dz, int[] dims) {
        J3DGeomUtils.getVolumeGeometry(dmos, ras_ulc, ras_dx, ras_dy, ras_dz, dims, null);
    }

    public static void getVolumeGeometry(DMTagValueInterface[] dmos, double[] ras_ulc, double[] ras_dx, double[] ras_dy, double[] ras_dz, int[] dims, double[] slopeIntercept) {
        if (dmos == null || dmos.length < 2) {
            return;
        }
        Object str = dmos[0].getValue(new DMTag(8, 112));
        boolean manufacturedByGE = str != null && str.toString().trim().equalsIgnoreCase("GE MEDICAL SYSTEMS");
        String modality = DicomUtils.getModality(dmos[0]);
        XpSlice[] slices = new XpSlice[dmos.length];
        for (int i = 0; i < dmos.length; ++i) {
            slices[i] = new XpSlice(J3DGeomUtils.wrapImage(dmos[i]));
        }
        final CPoint c0 = slices[0].getUpperLeft();
        CPoint c1 = slices[1].getUpperLeft();
        final CPoint v = new CPoint(new double[]{c0.x - c1.x, c0.y - c1.y, c0.z - c1.z}, 2);
        Arrays.sort(slices, new Comparator<XpSlice>(){

            @Override
            public int compare(XpSlice s1, XpSlice s2) {
                CPoint c1 = new CPoint(s1.getUpperLeft());
                CPoint c2 = new CPoint(s2.getUpperLeft());
                c1.sub(c0);
                c2.sub(c0);
                double d1 = c1.dot(v);
                double d2 = c2.dot(v);
                return Double.compare(d2, d1);
            }
        });
        slices[0].getRASOfOrigin(ras_ulc);
        dims[0] = slices[0].getSliceColumns();
        dims[1] = slices[0].getSliceRows();
        dims[2] = slices.length;
        slices[0].getXDirectionRAS(ras_dx);
        slices[1].getYDirectionRAS(ras_dy);
        CPoint.sub(slices[1].getUpperLeft().generateArray(), slices[0].getUpperLeft().generateArray(), ras_dz);
        if (modality.equalsIgnoreCase("CT") && manufacturedByGE) {
            JnVector3d.scaleAdd(ras_ulc, ras_dx, 0.5, ras_ulc);
            JnVector3d.scaleAdd(ras_ulc, ras_dy, 0.5, ras_ulc);
        }
        CPoint s0 = slices[0].getUpperLeft();
        CPoint sn = slices[slices.length - 1].getUpperLeft();
        CPoint zv = new CPoint(new double[]{sn.x - s0.x, sn.y - s0.y, sn.z - s0.z}, 2);
        double[] dArray = new double[]{ras_dz[0] * (double)(dims[2] - 1), ras_dz[1] * (double)(dims[2] - 1), ras_dz[2] * (double)(dims[2] - 1)};
        double zdir = JnVector3d.length(dArray);
        if (Math.abs(zdir - zv.length()) > LOC_SHIFT_TOLERANCE) {
            int nSlices;
            double minSpacing = 0.0;
            double spacing = 0.0;
            CPoint dz = new CPoint(2);
            JnVector3d tmp = new JnVector3d();
            for (int i = 1; i < slices.length; ++i) {
                tmp.sub(slices[i].getUpperLeft(), slices[i - 1].getUpperLeft());
                spacing = Math.abs(tmp.length());
                if (spacing <= LOC_SHIFT_TOLERANCE || !(minSpacing <= LOC_SHIFT_TOLERANCE) && !(spacing < minSpacing)) continue;
                minSpacing = spacing;
                dz.set(tmp);
            }
            dims[2] = nSlices = (int)(Math.floor(zv.length() / dz.length()) + 1.0);
            ras_dz[0] = dz.x;
            ras_dz[1] = dz.y;
            ras_dz[2] = dz.z;
        }
        if (slopeIntercept != null && slopeIntercept.length == 2) {
            double rs = 1.0;
            double ri = 0.0;
            for (DMTagValueInterface dmo : dmos) {
                J3DGeomUtils.rselem.value = dmo.getValue(rstag);
                J3DGeomUtils.rielem.value = dmo.getValue(ritag);
                double s = rselem.getDoubleValue();
                double i = rielem.getDoubleValue();
                rs = rs < s ? s : rs;
                ri = ri < i ? i : ri;
            }
            slopeIntercept[0] = rs;
            slopeIntercept[1] = ri;
        }
    }

    public static XjVolumeInfo getVolume(DMTagValueInterface[] dmos, DMTag[] voltags) {
        Object[] objectArray;
        DMTagValueInterface[] o;
        Object object = o = dmos instanceof DMComposite[] ? dmos : dmos[0];
        if (voltags != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = o;
            objectArray = objectArray2;
            objectArray2[1] = voltags;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = o;
        }
        Object[] objs = objectArray;
        DMObjectVolume vol = new DMObjectVolume(objs){
            private String modality = null;
            private static final double angleToleranceInDegrees = 0.1;

            @Override
            public double[] getRASOfOrigin(double[] rasulc) {
                boolean manufacturedByGE;
                Object str = this.getValue(8, 112);
                boolean bl = manufacturedByGE = str != null && str.toString().trim().equalsIgnoreCase("GE MEDICAL SYSTEMS");
                if (this.modality == null) {
                    this.modality = DicomUtils.getModality(this);
                }
                if (rasulc == null) {
                    rasulc = new double[3];
                }
                rasulc = super.getRASOfOrigin(rasulc);
                double[] ras_dx = super.getXDirectionRAS(null);
                double[] ras_dy = super.getYDirectionRAS(null);
                if (this.modality.equalsIgnoreCase("CT") && manufacturedByGE) {
                    JnVector3d.scaleAdd(rasulc, ras_dx, 0.5, rasulc);
                    JnVector3d.scaleAdd(rasulc, ras_dy, 0.5, rasulc);
                }
                return rasulc;
            }

            @Override
            public double[] getZDirectionRAS(double[] rasdz) {
                rasdz = super.getZDirectionRAS(rasdz);
                double[] xdir = this.getXDirectionRAS(null);
                double[] ydir = this.getYDirectionRAS(null);
                double[] dz = new double[3];
                JnVector3d.cross(xdir, ydir, dz);
                JnVector3d.normalize(dz);
                double zAngle = Math.toDegrees(new JnVector3d(dz).angle(new JnVector3d(rasdz)));
                zAngle = Math.abs(zAngle);
                if (zAngle > 90.0) {
                    zAngle = 180.0 - zAngle;
                    JnVector3d.scale(dz, -1.0);
                }
                if (this.modality == null) {
                    this.modality = DicomUtils.getModality(this);
                }
                double len = JnVector3d.dot(rasdz, dz);
                if ("MR".equalsIgnoreCase(this.modality) && zAngle > 0.0 && zAngle < 0.1) {
                    JnVector3d.scale(dz, len);
                    rasdz[0] = dz[0];
                    rasdz[1] = dz[1];
                    rasdz[2] = dz[2];
                }
                return rasdz;
            }
        };
        return vol;
    }

    public static String getErrorString(int code) {
        String ans = "";
        switch (code) {
            case -1: {
                return "DATA_INVALID";
            }
            case 0: {
                return "DATA_VALID";
            }
            case 1: {
                return "PIX_DIM_NOT_SAME";
            }
            case 2: {
                return "SLICES_NOT_COPLANAR";
            }
            case 3: {
                return "SLICES_NOT_COAXIAL";
            }
            case 4: {
                return "SLICE_SAPCING_NOT_SAME";
            }
            case 5: {
                return "DUPLICATE_SLICE_LOCATIONS";
            }
            case 6: {
                return "SLICE_THICKNESS_NOT_SAME";
            }
        }
        return ans;
    }

    public static int validateInputVolume(DMTagValueInterface[] images) {
        if (images == null || images.length < 2) {
            logger.log(Level.INFO, "Volume should contain atleast 2 images");
            return -1;
        }
        DMTag imtag = new DMTag(32, 19);
        class MyXpSlice
        extends XpSlice
        implements DMTagValueInterface {
            private DMTagValueInterface dmobject = null;

            MyXpSlice(DMTagValueInterface dmo) {
                super(J3DGeomUtils.wrapImage(dmo));
                this.dmobject = dmo;
            }

            @Override
            public String getType() {
                return this.dmobject.getType();
            }

            @Override
            public Object getValue(DMTag t) {
                return this.dmobject.getValue(t);
            }
        }
        MyXpSlice[] slices = new MyXpSlice[images.length];
        for (int i = 0; i < images.length; ++i) {
            slices[i] = new MyXpSlice(images[i]);
        }
        final CPoint c0 = slices[0].getUpperLeft();
        CPoint c1 = slices[1].getUpperLeft();
        final CPoint v = new CPoint(new double[]{c0.x - c1.x, c0.y - c1.y, c0.z - c1.z}, 2);
        Arrays.sort(slices, new Comparator<XpSlice>(){

            @Override
            public int compare(XpSlice s1, XpSlice s2) {
                CPoint c1 = new CPoint(s1.getUpperLeft());
                CPoint c2 = new CPoint(s2.getUpperLeft());
                c1.sub(c0);
                c2.sub(c0);
                double d1 = c1.dot(v);
                double d2 = c2.dot(v);
                return Double.compare(d2, d1);
            }
        });
        MyXpSlice im0 = slices[0];
        CPoint c0ulc = im0.getUpperLeft();
        DMTag thkTag = new DMTag(24, 80);
        double thickness = 0.0;
        int numDuplicateSlices = 0;
        double minSpacing = 0.0;
        double maxSpacing = 0.0;
        if (checkSliceThickness) {
            String val = (String)im0.getValue(thkTag);
            thickness = Double.parseDouble(val);
        }
        JnVector3d tmp1 = new JnVector3d();
        JnVector3d tmp2 = new JnVector3d();
        JnVector3d edgeV = new JnVector3d();
        MyXpSlice imN = slices[slices.length - 1];
        CPoint culcN = imN.getUpperLeft();
        tmp1.sub(culcN, c0ulc);
        edgeV.set(tmp1).normalize();
        MyXpSlice im1 = slices[1];
        CPoint culc1 = im1.getUpperLeft();
        tmp1.sub(culc1, c0ulc);
        double spacing = Math.abs(tmp1.dot(im0.N));
        if (spacing <= LOC_SHIFT_TOLERANCE) {
            ++numDuplicateSlices;
            logger.log(Level.INFO, "Volume contains duplicate slice locations : images " + im0.getValue(imtag) + "[ULHC:" + c0ulc.toString() + "]" + " , " + im1.getValue(imtag) + "[ULHC:" + culc1.toString() + "]");
            spacing = 0.0;
            if (!ignoreDuplicates) {
                return 5;
            }
        }
        minSpacing = maxSpacing = spacing;
        for (int i = 1; i < images.length; ++i) {
            String val;
            MyXpSlice im = slices[i];
            CPoint culc = im.getUpperLeft();
            if (im0.width != im.width || im0.height != im.height || Math.abs(im0.pixelSizeX - im.pixelSizeX) > PIXEL_SPACING_TOLERANCE || Math.abs(im0.pixelSizeY - im.pixelSizeY) > PIXEL_SPACING_TOLERANCE) {
                logger.log(Level.INFO, "All images don't have the same pixel dimensions : image" + im0.getValue(imtag) + "[" + im0.width + " x " + im0.height + " , " + im0.pixelSizeX + "\\" + im0.pixelSizeY + "]" + " image" + im.getValue(imtag) + "[" + im.width + " x " + im.height + " , " + im.pixelSizeX + "\\" + im.pixelSizeY + "]");
                return 1;
            }
            tmp1.set(im0.I).normalize();
            tmp2.set(im.I).normalize();
            double diff = Math.abs(tmp1.sub(tmp2).magnitude());
            if (diff > NORMAL_SHIFT_TOLERANCE) {
                logger.log(Level.INFO, "All images are not parallel : image" + im0.getValue(imtag) + "[I:" + tmp1.toString() + "]" + " image" + im.getValue(imtag) + "[I:" + tmp2.toString() + "] Diff : " + diff);
                return 2;
            }
            tmp1.set(im0.J).normalize();
            tmp2.set(im.J).normalize();
            diff = Math.abs(tmp1.sub(tmp2).magnitude());
            if (diff > NORMAL_SHIFT_TOLERANCE) {
                logger.log(Level.INFO, "All images are not parallel : image" + im0.getValue(imtag) + "[J:" + tmp1.toString() + "]" + " image" + im.getValue(imtag) + "[J:" + tmp2.toString() + "] Diff : " + diff);
                return 2;
            }
            tmp1.sub(culc, c0ulc);
            double dot = tmp1.dot(edgeV);
            double shift = Math.sqrt(tmp1.magnitudeSq() - dot * dot);
            if (Math.abs(shift) > CORNER_SHIFT_TOLERANCE) {
                logger.log(Level.INFO, "All images are not co-axial : image" + im0.getValue(imtag) + "[ULHC:" + c0ulc.toString() + "]" + " image" + im.getValue(imtag) + "[ULHC:" + culc.toString() + "] [EdgeVector: " + edgeV.toString() + "] shift " + shift);
                return 3;
            }
            im1 = slices[i - 1];
            tmp1.sub(culc, im1.getUpperLeft());
            spacing = Math.abs(tmp1.dot(im1.N));
            if (spacing <= LOC_SHIFT_TOLERANCE) {
                ++numDuplicateSlices;
                logger.log(Level.INFO, "Volume contains duplicate slice locations : images " + im1.getValue(imtag) + "[ULHC:" + im1.getUpperLeft().toString() + "]" + " , " + im.getValue(imtag) + "[ULHC:" + culc.toString() + "]");
                if (!ignoreDuplicates) {
                    return 5;
                }
            } else if (minSpacing <= LOC_SHIFT_TOLERANCE) {
                maxSpacing = spacing > maxSpacing ? spacing : maxSpacing;
                minSpacing = spacing;
            } else if (Math.abs(spacing - minSpacing) > LOC_SHIFT_TOLERANCE) {
                logger.log(Level.INFO, "Volume contains inconsistant slice spacing , missing slices between : images " + im.getValue(imtag) + " - " + im1.getValue(imtag) + " , " + ", Expected Spacing/Actual Spacing : " + minSpacing + "/" + spacing);
                maxSpacing = spacing > maxSpacing ? spacing : maxSpacing;
                minSpacing = spacing < minSpacing ? spacing : minSpacing;
                double allowedSpacing = minSpacing * (double)(maxAllowableMissingSlices + 1);
                if (maxSpacing - allowedSpacing > LOC_SHIFT_TOLERANCE) {
                    logger.log(Level.INFO, "Can allowonly upto a max of " + allowedSpacing + " mm gap");
                    return 4;
                }
                if (spacing - allowedSpacing > LOC_SHIFT_TOLERANCE) {
                    logger.log(Level.INFO, "Can allowonly upto a max of " + allowedSpacing + " mm gap");
                    return 4;
                }
            }
            if (checkSliceThickness && (diff = Math.abs(thickness - Double.parseDouble(val = (String)im.getValue(thkTag)))) > 0.01) {
                return 6;
            }
            if (!ignoreDuplicates || slices.length - numDuplicateSlices >= 2) continue;
            logger.log(Level.INFO, "Volume should contain atleast 2 images");
            return -1;
        }
        return 0;
    }

    public static VolumeInfoStatus validateInputVolume(XjVolumeInfo volInfo, boolean ignoreSpacing) {
        double spacing;
        VolumeInfoStatus status = new VolumeInfoStatus();
        if (volInfo == null || volInfo.getVolumeDimensions(null)[2] < 2) {
            status.msg = "Volume should contain atleast 2 slices";
            status.error = -1;
            logger.log(Level.INFO, status.msg);
            return status;
        }
        XpSlice im0 = new XpSlice(J3DGeomUtils.wrapImage(volInfo, 0));
        CPoint c0ulc = im0.getUpperLeft();
        double thickness = 0.0;
        int numDuplicateSlices = 0;
        if (checkSliceThickness) {
            String val = (String)volInfo.getVSliceValue(0, 24, 80);
            thickness = Double.parseDouble(val);
        }
        JnVector3d tmp1 = new JnVector3d();
        JnVector3d tmp2 = new JnVector3d();
        JnVector3d edgeV = new JnVector3d();
        int numSlices = volInfo.getVolumeDimensions(null)[2];
        XpSlice imN = new XpSlice(J3DGeomUtils.wrapImage(volInfo, numSlices - 1));
        CPoint culcN = imN.getUpperLeft();
        tmp1.sub(culcN, c0ulc);
        edgeV.set(tmp1).normalize();
        XpSlice im1 = new XpSlice(J3DGeomUtils.wrapImage(volInfo, 1));
        CPoint culc1 = im1.getUpperLeft();
        tmp1.sub(culc1, c0ulc);
        status.minSpacing = status.maxSpacing = (spacing = Math.abs(tmp1.dot(im0.N)));
        if (!ignoreSpacing && spacing <= LOC_SHIFT_TOLERANCE) {
            ++numDuplicateSlices;
            status.msg = "Volume contains duplicate slice locations : images " + volInfo.getVSliceValue(0, 32, 19) + "[ULHC:" + c0ulc.toString() + "]" + " , " + volInfo.getVSliceValue(1, 32, 19) + "[ULHC:" + culc1.toString() + "]";
            spacing = 0.0;
            if (!ignoreDuplicates) {
                status.error = 5;
                logger.log(Level.INFO, status.msg);
                return status;
            }
        }
        for (int i = 1; i < numSlices; ++i) {
            String val;
            XpSlice im = new XpSlice(J3DGeomUtils.wrapImage(volInfo, i));
            CPoint culc = im.getUpperLeft();
            if (im0.width != im.width || im0.height != im.height || Math.abs(im0.pixelSizeX - im.pixelSizeX) > PIXEL_SPACING_TOLERANCE || Math.abs(im0.pixelSizeY - im.pixelSizeY) > PIXEL_SPACING_TOLERANCE) {
                status.msg = "All images don't have the same pixel dimensions : image" + volInfo.getVSliceValue(0, 32, 19) + "[" + im0.width + " x " + im0.height + " , " + im0.pixelSizeX + "\\" + im0.pixelSizeY + "]" + " image" + volInfo.getVSliceValue(i, 32, 19) + "[" + im.width + " x " + im.height + " , " + im.pixelSizeX + "\\" + im.pixelSizeY + "]";
                status.error = 1;
                logger.log(Level.INFO, status.msg);
                return status;
            }
            tmp1.set(im0.I).normalize();
            tmp2.set(im.I).normalize();
            double diff = Math.abs(tmp1.sub(tmp2).magnitude());
            if (diff > NORMAL_SHIFT_TOLERANCE) {
                status.msg = "All images are not parallel : image" + volInfo.getVSliceValue(0, 32, 19) + "[I:" + tmp1.toString() + "]" + " image" + volInfo.getVSliceValue(i, 32, 19) + "[I:" + tmp2.toString() + "] Diff : " + diff;
                status.error = 2;
                logger.log(Level.INFO, status.msg);
                return status;
            }
            tmp1.set(im0.J).normalize();
            tmp2.set(im.J).normalize();
            diff = Math.abs(tmp1.sub(tmp2).magnitude());
            if (diff > NORMAL_SHIFT_TOLERANCE) {
                status.msg = "All images are not parallel : image" + volInfo.getVSliceValue(0, 32, 19) + "[J:" + tmp1.toString() + "]" + " image" + volInfo.getVSliceValue(i, 32, 19) + "[J:" + tmp2.toString() + "] Diff : " + diff;
                status.error = 2;
                logger.log(Level.INFO, status.msg);
                return status;
            }
            tmp1.sub(culc, c0ulc);
            double dot = tmp1.dot(edgeV);
            double shift = Math.sqrt(tmp1.magnitudeSq() - dot * dot);
            if (Math.abs(shift) > CORNER_SHIFT_TOLERANCE) {
                status.msg = "All images are not co-axial : image" + volInfo.getVSliceValue(0, 32, 19) + "[ULHC:" + c0ulc.toString() + "]" + " image" + volInfo.getVSliceValue(i, 32, 19) + "[ULHC:" + culc.toString() + "] [EdgeVector: " + edgeV.toString() + "] shift " + shift;
                status.error = 3;
                logger.log(Level.INFO, status.msg);
                return status;
            }
            im1 = new XpSlice(J3DGeomUtils.wrapImage(volInfo, i - 1));
            tmp1.sub(culc, im1.getUpperLeft());
            spacing = Math.abs(tmp1.dot(im1.N));
            if (spacing < status.minSpacing) {
                status.minSpacing = spacing;
                status.minSpacingSliceIndex = i - 1;
            }
            if (spacing > status.maxSpacing) {
                status.maxSpacing = spacing;
                status.maxSpacingSliceIndex = i - 1;
            }
            if (!ignoreSpacing) {
                if (spacing <= LOC_SHIFT_TOLERANCE) {
                    ++numDuplicateSlices;
                    status.msg = "Volume contains duplicate slice locations : images " + volInfo.getVSliceValue(i - 1, 32, 19) + "[ULHC:" + im1.getUpperLeft().toString() + "]" + " , " + volInfo.getVSliceValue(i, 32, 19) + "[ULHC:" + culc.toString() + "]";
                    if (!ignoreDuplicates) {
                        status.error = 5;
                        logger.log(Level.INFO, status.msg);
                        return status;
                    }
                } else if (Math.abs(spacing - status.minSpacing) > LOC_SHIFT_TOLERANCE) {
                    logger.log(Level.INFO, "Volume contains inconsistant slice spacing , missing slices between : images " + volInfo.getVSliceValue(i - 1, 32, 19) + " - " + volInfo.getVSliceValue(i, 32, 19) + " , " + ", Expected Spacing/Actual Spacing : " + status.minSpacing + "/" + spacing);
                    status.maxSpacing = spacing > status.maxSpacing ? spacing : status.maxSpacing;
                    status.minSpacing = spacing < status.minSpacing ? spacing : status.minSpacing;
                    double allowedSpacing = status.minSpacing * (double)(maxAllowableMissingSlices + 1);
                    if (status.maxSpacing - allowedSpacing > LOC_SHIFT_TOLERANCE) {
                        status.msg = "Can allowonly upto a max of " + allowedSpacing + " mm gap";
                        status.error = 4;
                        logger.log(Level.INFO, status.msg);
                        return status;
                    }
                    if (spacing - allowedSpacing > LOC_SHIFT_TOLERANCE) {
                        status.msg = "Can allowonly upto a max of " + allowedSpacing + " mm gap";
                        status.error = 4;
                        logger.log(Level.INFO, status.msg);
                        return status;
                    }
                }
            }
            if (checkSliceThickness && Math.abs(thickness - Double.parseDouble(val = (String)volInfo.getVSliceValue(i, 24, 80))) > 0.01) {
                status.msg = "Volume contains inconsistant slice thickness : images " + volInfo.getVSliceValue(i - 1, 32, 19) + " , " + " Expected/Actual : " + thickness + "/" + Double.parseDouble(val);
                status.error = 6;
                logger.log(Level.INFO, status.msg);
                return status;
            }
            if (!ignoreDuplicates || numSlices - numDuplicateSlices >= 2) continue;
            status.msg = "Volume should contain atleast 2 images";
            status.error = -1;
            logger.log(Level.INFO, status.msg);
            return status;
        }
        return status;
    }

    public static VolumeInfoStatus validateImage(XjVolumeInfo volInfo, XjDicomObject image) {
        class HackXjDicomObject
        implements XjDicomObject {
            private XjDicomObject obj = null;

            public HackXjDicomObject(XjDicomObject obj) {
                this.obj = obj;
            }

            @Override
            public int getValues(XjTagValue[] tv) {
                if (this.obj instanceof DMImage) {
                    DMImage img = (DMImage)this.obj;
                    DMElement[] elements = DMElement.genDMelements(tv);
                    img.getComposite().getValues(elements);
                    for (int i = 0; i < elements.length; ++i) {
                        if (!(elements[i].value instanceof DMiSequence)) continue;
                        elements[i].value = new DMSequence((DMiSequence)elements[i].value);
                    }
                    int count = 0;
                    for (int i = 0; i < elements.length; ++i) {
                        ++count;
                        tv[i] = elements[i].getXjTagValue(tv[i]);
                    }
                    return count;
                }
                return this.obj.getValues(tv);
            }

            @Override
            public Object getValue(int group, int element) {
                return this.obj.getValue(group, element);
            }
        }
        HackXjDicomObject dmo = new HackXjDicomObject(image);
        VolumeInfoStatus status = J3DGeomUtils.validateImage(volInfo, new XpSlice(dmo));
        if (status.error == 0 && checkSliceThickness) {
            String thk = (String)volInfo.getValue(24, 80);
            String val = (String)dmo.getValue(24, 80);
            if (Math.abs(Double.parseDouble(thk) - Double.parseDouble(val)) > 0.01) {
                status.msg = "Volume contains inconsistant slice thickness :  Expected/Actual : " + thk + "/" + val;
                status.error = 6;
                logger.log(Level.INFO, status.msg);
            }
        }
        return status;
    }

    public static VolumeInfoStatus validateImage(XjVolumeInfo volInfo, DMComposite image) {
        XpSlice slice = new XpSlice(J3DGeomUtils.wrapImage(image));
        VolumeInfoStatus status = J3DGeomUtils.validateImage(volInfo, slice);
        if (status.error == 0 && checkSliceThickness) {
            String thk = (String)volInfo.getValue(24, 80);
            String val = (String)image.getValue(24, 80);
            if (Math.abs(Double.parseDouble(thk) - Double.parseDouble(val)) > 0.01) {
                status.msg = "Volume contains inconsistant slice thickness :  Expected/Actual : " + thk + "/" + val;
                status.error = 6;
                logger.log(Level.INFO, status.msg);
            }
        }
        return status;
    }

    public static VolumeInfoStatus validateImage(XjVolumeInfo volInfo, XpSlice slice) {
        VolumeInfoStatus status = new VolumeInfoStatus();
        if (volInfo == null) {
            status.msg = "Volume info null";
            status.error = -1;
            logger.log(Level.INFO, status.msg);
            return status;
        }
        CPoint imulc = slice.getUpperLeft();
        double[] ulc = volInfo.getRASOfOrigin(null);
        double[] dx = volInfo.getXDirectionRAS(null);
        double[] dy = volInfo.getYDirectionRAS(null);
        double[] dz = volInfo.getZDirectionRAS(null);
        int[] dims = volInfo.getVolumeDimensions(null);
        if (slice.width != dims[0] || slice.height != dims[1] || Math.abs(slice.pixelSizeX - JnVector3d.length(dx)) > PIXEL_SPACING_TOLERANCE || Math.abs(slice.pixelSizeY - JnVector3d.length(dy)) > PIXEL_SPACING_TOLERANCE) {
            status.msg = "The image does not have the same pixel dimension as the volume : image[" + slice.width + " x " + slice.height + " , " + slice.pixelSizeX + "\\" + slice.pixelSizeY + "]" + " volume" + "[" + dims[0] + " x " + dims[1] + " , " + JnVector3d.length(dx) + "\\" + JnVector3d.length(dy) + "]";
            status.error = 1;
            logger.log(Level.INFO, status.msg);
            return status;
        }
        JnVector3d tmp1 = new JnVector3d(slice.I.toArray());
        tmp1.normalize();
        JnVector3d tmp2 = new JnVector3d(dx);
        tmp2.normalize();
        double diff = Math.abs(tmp1.sub(tmp2).magnitude());
        if (diff > NORMAL_SHIFT_TOLERANCE) {
            status.msg = "Image dx nor same as volume dx : image[I:" + tmp1.toString() + "]" + " volume" + "[dx:" + tmp2.toString() + "] Diff : " + diff;
            status.error = 2;
            logger.log(Level.INFO, status.msg);
            return status;
        }
        tmp1.set(slice.J.toArray());
        tmp1.normalize();
        tmp2.set(dy);
        tmp2.normalize();
        diff = Math.abs(tmp1.sub(tmp2).magnitude());
        if (diff > NORMAL_SHIFT_TOLERANCE) {
            status.msg = "Image dy nor same as volume dy : image[J:" + tmp1.toString() + "]" + " volume" + "[dy:" + tmp2.toString() + "] Diff : " + diff;
            status.error = 2;
            logger.log(Level.INFO, status.msg);
            return status;
        }
        tmp1.sub(imulc.toArray(), ulc);
        tmp1.normalize();
        double dot = tmp1.dot(dz);
        double shift = Math.sqrt(tmp1.magnitudeSq() - dot * dot);
        if (Math.abs(shift) > CORNER_SHIFT_TOLERANCE) {
            status.msg = "The image is not co-axial with the volume: image[ULHC:" + imulc.toString() + "]" + " volume" + "[ULHC:" + ulc.toString() + "] [EdgeVector: " + dz.toString() + "] shift " + shift;
            status.error = 3;
            logger.log(Level.INFO, status.msg);
            return status;
        }
        return status;
    }

    public static String validateInputVolumeErrorString(int errorCode) {
        String errorString = "Failed to create static volume. ";
        switch (errorCode) {
            case -1: {
                errorString = errorString + "Input Data set is Invalid !!";
                break;
            }
            case 1: {
                errorString = errorString + "All images do not have the same pixel dimensions (pixel Size and slice width/height) !!";
                break;
            }
            case 2: {
                errorString = errorString + "All images are not parallel !!";
                break;
            }
            case 3: {
                errorString = errorString + "Input volume is not coaxial. The four corners of all the images do not lie on an edge of a single parallelepiped !!";
                break;
            }
            case 4: {
                errorString = errorString + "Spacing between adjacent images is not the same for each set of adjacent images !!";
                break;
            }
            case 5: {
                errorString = errorString + "Spacing between adjacent images is not the same for each set of adjacent images.";
                errorString = errorString + "Duplicate image locations !!";
                break;
            }
            case 6: {
                errorString = errorString + "All images do not have the same slice thickness !!";
                break;
            }
            default: {
                errorString = errorString + "Unknown error !!";
            }
        }
        return errorString;
    }

    public static void calculateVoxelRASTransforms(XjVolumeGeometry xj_vol, CTransform vox2ras, CTransform ras2vox) {
        J3DGeomUtils.calculateVoxelRASTransforms(xj_vol.getRASOfOrigin(null), xj_vol.getXDirectionRAS(null), xj_vol.getYDirectionRAS(null), xj_vol.getZDirectionRAS(null), vox2ras, ras2vox);
    }

    public static void calculateVoxelRASTransforms(double[] vol_origin, double[] vol_dir_x, double[] vol_dir_y, double[] vol_dir_z, CTransform vox2ras, CTransform ras2vox) {
        double[] vol_orig = new double[]{vol_origin[0] - vol_dir_x[0] * 0.5 - vol_dir_y[0] * 0.5, vol_origin[1] - vol_dir_x[1] * 0.5 - vol_dir_y[1] * 0.5, vol_origin[2] - vol_dir_x[2] * 0.5 - vol_dir_y[2] * 0.5};
        vox2ras.set(vol_dir_x[0], vol_dir_y[0], vol_dir_z[0], vol_orig[0], vol_dir_x[1], vol_dir_y[1], vol_dir_z[1], vol_orig[1], vol_dir_x[2], vol_dir_y[2], vol_dir_z[2], vol_orig[2], 0.0, 0.0, 0.0, 1.0);
        vox2ras.inverse(ras2vox);
    }

    public static double[] getDoubleArrayValue(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, "\\");
        double[] doubleArray = new double[tokenizer.countTokens()];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = Double.parseDouble(tokenizer.nextToken());
        }
        return doubleArray;
    }

    public static XjDicomObject wrapImage(DMTagValueInterface comp) {
        return new myXjDicomObject(comp);
    }

    public static XjDicomObject wrapImage(XjVolumeInfo vol, int sliceIndex) {
        return new myXjDicomObject(vol, sliceIndex);
    }

    public static void sortSlicesByLocation(XpSlice[] slices) {
        if (slices == null || slices.length < 2) {
            return;
        }
        final CPoint c0 = slices[0].getUpperLeft();
        CPoint c1 = slices[1].getUpperLeft();
        final CPoint v = new CPoint(new double[]{c0.x - c1.x, c0.y - c1.y, c0.z - c1.z}, 2);
        Arrays.sort(slices, new Comparator<XpSlice>(){

            @Override
            public int compare(XpSlice s1, XpSlice s2) {
                CPoint c1 = new CPoint(s1.getUpperLeft());
                CPoint c2 = new CPoint(s2.getUpperLeft());
                c1.sub(c0);
                c2.sub(c0);
                double d1 = c1.dot(v);
                double d2 = c2.dot(v);
                return Double.compare(d2, d1);
            }
        });
    }

    private static CPoint getULC(DMTagValueInterface img) {
        J3DGeomUtils.elem0.value = img.getValue(localtionTag);
        CPoint c0 = new CPoint(elem0.getDoubleArrayValue(), 2);
        return c0;
    }

    public static void sortSlicesByLocation(DMObject[] images) {
        if (images == null || images.length < 2) {
            return;
        }
        final CPoint c0 = J3DGeomUtils.getULC(images[0]);
        CPoint c1 = J3DGeomUtils.getULC(images[1]);
        final CPoint v = new CPoint(new double[]{c0.x - c1.x, c0.y - c1.y, c0.z - c1.z}, 2);
        Arrays.sort(images, new Comparator<DMObject>(){

            @Override
            public int compare(DMObject im1, DMObject im2) {
                CPoint c1 = J3DGeomUtils.getULC(im1);
                CPoint c2 = J3DGeomUtils.getULC(im2);
                c1.sub(c0);
                c2.sub(c0);
                double d1 = c1.dot(v);
                double d2 = c2.dot(v);
                return Double.compare(d1, d2);
            }
        });
    }

    public static void sortSlicesByLocation(DMTagValueInterface[] images) {
        if (images == null || images.length < 2) {
            return;
        }
        final CPoint c0 = new XpSlice(J3DGeomUtils.wrapImage(images[0])).getUpperLeft();
        CPoint c1 = new XpSlice(J3DGeomUtils.wrapImage(images[1])).getUpperLeft();
        final CPoint v = new CPoint(new double[]{c0.x - c1.x, c0.y - c1.y, c0.z - c1.z}, 2);
        Arrays.sort(images, new Comparator<DMTagValueInterface>(){

            @Override
            public int compare(DMTagValueInterface im1, DMTagValueInterface im2) {
                XpSlice s1 = new XpSlice(J3DGeomUtils.wrapImage(im1));
                XpSlice s2 = new XpSlice(J3DGeomUtils.wrapImage(im2));
                CPoint c1 = new CPoint(s1.getUpperLeft());
                CPoint c2 = new CPoint(s2.getUpperLeft());
                c1.sub(c0);
                c2.sub(c0);
                double d1 = c1.dot(v);
                double d2 = c2.dot(v);
                return Double.compare(d2, d1);
            }
        });
    }

    public static void sortSlicesByLocation(DMImage[] images) {
        if (images == null || images.length < 2) {
            return;
        }
        final CPoint c0 = new XpSlice(images[0]).getUpperLeft();
        CPoint c1 = new XpSlice(images[1]).getUpperLeft();
        final CPoint v = new CPoint(new double[]{c0.x - c1.x, c0.y - c1.y, c0.z - c1.z}, 2);
        Arrays.sort(images, new Comparator<DMImage>(){

            @Override
            public int compare(DMImage im1, DMImage im2) {
                XpSlice s1 = new XpSlice(im1);
                XpSlice s2 = new XpSlice(im2);
                CPoint c1 = new CPoint(s1.getUpperLeft());
                CPoint c2 = new CPoint(s2.getUpperLeft());
                c1.sub(c0);
                c2.sub(c0);
                double d1 = c1.dot(v);
                double d2 = c2.dot(v);
                return Double.compare(d2, d1);
            }
        });
    }

    public static double[] rotationAnglesBetweenSlices(JnVector3d origSliceI, JnVector3d origSliceJ, JnVector3d origSliceN, JnVector3d rotatedSliceI, JnVector3d rotatedSliceJ, JnVector3d rotatedSliceN, double[] rotationAngles) {
        JnMatrix3d origMatrix = new JnMatrix3d();
        origMatrix.set(origSliceI.x, origSliceJ.x, origSliceN.x, origSliceI.y, origSliceJ.y, origSliceN.y, origSliceI.z, origSliceJ.z, origSliceN.z);
        JnMatrix3d rotatedMatrix = new JnMatrix3d();
        rotatedMatrix.set(rotatedSliceI.x, rotatedSliceJ.x, rotatedSliceN.x, rotatedSliceI.y, rotatedSliceJ.y, rotatedSliceN.y, rotatedSliceI.z, rotatedSliceJ.z, rotatedSliceN.z);
        origMatrix.invert();
        JnMatrix3d rotationMatrix = new JnMatrix3d();
        rotationMatrix.mul(rotatedMatrix, origMatrix);
        return J3DGeomUtils.matrixToAngles(rotationMatrix, rotationAngles);
    }

    public static void update3DCursorPosition(T3DViewport vp, Point pt) {
        if (vp == null) {
            return;
        }
        Component[] tcomp = vp.getT3DComponent().getComponents();
        if (tcomp == null || tcomp.length == 0) {
            return;
        }
        for (int i = 0; i < tcomp.length; ++i) {
            if (!(tcomp[i] instanceof Cursor3DVc)) continue;
            double[] newRASpt = GeomUtils.DisplayToRAS(new int[]{pt.x, pt.y, 0}, vp.getEyePoint(null), vp.getLookPoint(null), vp.getUp(null), vp.getViewHeight(), vp.getWidth(), vp.getHeight(), new double[3]);
            ((Cursor3DVc)tcomp[i]).getCursorModel().setPoint(new CPoint(newRASpt, 2));
            return;
        }
    }

    public static void updateSlice(XpSlice slice, int imgWidth, int imgHeight, double viewHeight, double viewAspectRatio, double[] lookpt, double[] eyept, double[] up) {
        slice.width = imgWidth;
        slice.height = imgHeight;
        double viewWidth = viewHeight * viewAspectRatio;
        int w = slice.width;
        int h = slice.height;
        double spx = viewWidth / (double)w;
        double spy = viewHeight / (double)h;
        JnVector3d temp_v = new JnVector3d();
        JnVector3d u = new JnVector3d(up);
        JnVector3d v = new JnVector3d(lookpt);
        temp_v.set(eyept);
        v.sub(temp_v);
        JnVector3d.cross(v, u, temp_v);
        JnVector3d r = temp_v;
        r.normalize();
        u.normalize();
        CPoint ul = new CPoint(2);
        CPoint ur = new CPoint(2);
        CPoint br = new CPoint(2);
        ul.x = lookpt[0] - (double)(w - 1) * 0.5 * r.x * spx + (double)(h - 1) * 0.5 * u.x * spy;
        ul.y = lookpt[1] - (double)(w - 1) * 0.5 * r.y * spx + (double)(h - 1) * 0.5 * u.y * spy;
        ul.z = lookpt[2] - (double)(w - 1) * 0.5 * r.z * spx + (double)(h - 1) * 0.5 * u.z * spy;
        ur.x = lookpt[0] + (double)(w - 1) * 0.5 * r.x * spx + (double)(h - 1) * 0.5 * u.x * spy;
        ur.y = lookpt[1] + (double)(w - 1) * 0.5 * r.y * spx + (double)(h - 1) * 0.5 * u.y * spy;
        ur.z = lookpt[2] + (double)(w - 1) * 0.5 * r.z * spx + (double)(h - 1) * 0.5 * u.z * spy;
        br.x = lookpt[0] + (double)(w - 1) * 0.5 * r.x * spx - (double)(h - 1) * 0.5 * u.x * spy;
        br.y = lookpt[1] + (double)(w - 1) * 0.5 * r.y * spx - (double)(h - 1) * 0.5 * u.y * spy;
        br.z = lookpt[2] + (double)(w - 1) * 0.5 * r.z * spx - (double)(h - 1) * 0.5 * u.z * spy;
        slice.pixelSizeX = spx;
        slice.pixelSizeY = spy;
        slice.setCorners(ul, ur, br);
    }

    public static CTransform calculateDispToRASTransform(XjVolumeGeometry vinfo, double[] look, JnVector3d view, JnVector3d up, JnVector3d right, double viewHeight, int winWidth, int winHeight, CTransform ras2vox) {
        JnVector3d xdir = new JnVector3d();
        JnVector3d ydir = new JnVector3d();
        JnVector3d zdir = new JnVector3d();
        double[] dir_x = vinfo.getXDirectionRAS(null);
        double[] dir_y = vinfo.getYDirectionRAS(null);
        double[] dir_z = vinfo.getZDirectionRAS(null);
        double ras_spx = JnVector3d.length(dir_x);
        double ras_spy = JnVector3d.length(dir_y);
        double ras_spz = JnVector3d.length(dir_z);
        double aratio = (double)winWidth / (double)winHeight;
        double viewWidth = viewHeight * aratio;
        double view_spx = viewWidth / (double)winWidth;
        double view_spy = viewHeight / (double)winHeight;
        double view_spz = XjVolumeUtils.getViewStepSize(ras2vox, view, ras_spx, ras_spy, ras_spz);
        CTransform _disp2ras = new CTransform();
        xdir.set(right.x * view_spx, right.y * view_spx, right.z * view_spx);
        ydir.set(up.x * view_spy, up.y * view_spy, up.z * view_spy);
        zdir.set(view.x * view_spz, view.y * view_spz, view.z * view_spz);
        _disp2ras.set(xdir.x, ydir.x, zdir.x, look[0] - xdir.x * (double)winWidth * 0.5 - ydir.x * (double)winHeight * 0.5, xdir.y, ydir.y, zdir.y, look[1] - xdir.y * (double)winWidth * 0.5 - ydir.y * (double)winHeight * 0.5, xdir.z, ydir.z, zdir.z, look[2] - xdir.z * (double)winWidth * 0.5 - ydir.z * (double)winHeight * 0.5, 0.0, 0.0, 0.0, 1.0);
        return _disp2ras;
    }

    static {
        if (decimalFormat instanceof DecimalFormat) {
            ((DecimalFormat)decimalFormat).applyPattern("##.#");
            decimalFormat.setMaximumFractionDigits(8);
        }
        rstag = new DMTag(40, 4179);
        ritag = new DMTag(40, 4178);
        rselem = new XpDicomElement(40, 4179);
        rielem = new XpDicomElement(40, 4178);
        CORNER_SHIFT_TOLERANCE = Double.parseDouble(CvPropertiesManager.getProperty("vav.tolerance.slice_corner_shift", "1.0"));
        LOC_SHIFT_TOLERANCE = Double.parseDouble(CvPropertiesManager.getProperty("vav.tolerance.slice_loc_shift", "0.01"));
        NORMAL_SHIFT_TOLERANCE = Double.parseDouble(CvPropertiesManager.getProperty("vav.tolerance.slice_normal_shift", "0.01"));
        PIXEL_SPACING_TOLERANCE = Double.parseDouble(CvPropertiesManager.getProperty("vav.tolerance.slice_pixel_spacing_xy", "0.0001"));
        checkSliceThickness = CvPropertiesManager.getBoolean("vav.tolerance.check_slice_thickness", false);
        ignoreDuplicates = CvPropertiesManager.getBoolean("vav.tolerance.ignore_duplicates", true);
        maxAllowableMissingSlices = Integer.parseInt(CvPropertiesManager.getProperty("vav.tolerance.max_missing_slices_allowed", "0"));
        localtionTag = new DMTag(32, 50);
        elem0 = new XpDicomElement(32, 50);
    }

    public static class dummyVolume
    implements XjVolumeGeometry {
        private double[] ras_ulc = new double[3];
        private double[] ras_dx = new double[3];
        private double[] ras_dy = new double[3];
        private double[] ras_dz = new double[3];
        private int[] voldims = new int[3];

        public dummyVolume(DMTagValueInterface[] imgs) {
            J3DGeomUtils.getVolumeGeometry(imgs, this.ras_ulc, this.ras_dx, this.ras_dy, this.ras_dz, this.voldims);
        }

        public dummyVolume(double[] orig, double[] xside, double[] yside, double[] zside) {
            this.ras_ulc[0] = orig[0];
            this.ras_ulc[1] = orig[1];
            this.ras_ulc[2] = orig[2];
            this.ras_dx[0] = xside[0];
            this.ras_dx[1] = xside[1];
            this.ras_dx[2] = xside[2];
            this.ras_dy[0] = yside[0];
            this.ras_dy[1] = yside[1];
            this.ras_dy[2] = yside[2];
            this.ras_dz[0] = zside[0];
            this.ras_dz[1] = zside[1];
            this.ras_dz[2] = zside[2];
            JnVector3d.normalize(this.ras_dx);
            JnVector3d.normalize(this.ras_dy);
            JnVector3d.normalize(this.ras_dz);
            this.voldims[0] = (int)JnVector3d.length(xside) + 1;
            this.voldims[1] = (int)JnVector3d.length(yside) + 1;
            this.voldims[2] = (int)JnVector3d.length(zside) + 1;
        }

        public dummyVolume(double[] ulc, double[] dx, double[] dy, double[] dz, int[] dims) {
            this.ras_ulc[0] = ulc[0];
            this.ras_ulc[1] = ulc[1];
            this.ras_ulc[2] = ulc[2];
            this.ras_dx[0] = dx[0];
            this.ras_dx[1] = dx[1];
            this.ras_dx[2] = dx[2];
            this.ras_dy[0] = dy[0];
            this.ras_dy[1] = dy[1];
            this.ras_dy[2] = dy[2];
            this.ras_dz[0] = dz[0];
            this.ras_dz[1] = dz[1];
            this.ras_dz[2] = dz[2];
            this.voldims[0] = dims[0];
            this.voldims[1] = dims[1];
            this.voldims[2] = dims[2];
        }

        @Override
        public int[] getVolumeDimensions(int[] dims) {
            if (dims == null) {
                dims = new int[3];
            }
            System.arraycopy(this.voldims, 0, dims, 0, 3);
            return dims;
        }

        @Override
        public double[] getRASOfOrigin(double[] ras_ulc) {
            if (ras_ulc == null) {
                ras_ulc = new double[]{this.ras_ulc[0], this.ras_ulc[1], this.ras_ulc[2]};
            }
            return ras_ulc;
        }

        @Override
        public double[] getXDirectionRAS(double[] ras_dx) {
            if (ras_dx == null) {
                ras_dx = new double[]{this.ras_dx[0], this.ras_dx[1], this.ras_dx[2]};
            }
            return ras_dx;
        }

        @Override
        public double[] getYDirectionRAS(double[] ras_dy) {
            if (ras_dy == null) {
                ras_dy = new double[]{this.ras_dy[0], this.ras_dy[1], this.ras_dy[2]};
            }
            return ras_dy;
        }

        @Override
        public double[] getZDirectionRAS(double[] ras_dz) {
            if (ras_dz == null) {
                ras_dz = new double[]{this.ras_dz[0], this.ras_dz[1], this.ras_dz[2]};
            }
            return ras_dz;
        }
    }

    private static class myXjDicomObject
    implements XjDicomObject {
        private DMTagValueInterface dmcomp = null;
        private XjVolumeInfo volInfo = null;
        private int sliceIndex = 0;

        public myXjDicomObject(XjVolumeInfo vinfo, int zindex) {
            this.volInfo = vinfo;
            this.sliceIndex = zindex;
        }

        public myXjDicomObject(DMTagValueInterface comp) {
            this.dmcomp = comp;
        }

        @Override
        public Object getValue(int group, int element) {
            if (this.dmcomp != null) {
                return this.dmcomp.getValue(new DMTag(group, element));
            }
            if (this.volInfo != null) {
                return this.volInfo.getVSliceValue(this.sliceIndex, group, element);
            }
            return null;
        }

        @Override
        public int getValues(XjTagValue[] tv) {
            if (this.dmcomp instanceof DMComposite) {
                DMElement[] data = DMElement.genDMelements(tv);
                ((DMComposite)this.dmcomp).getValues(data);
                return DMElement.getXjTagValue(data, tv);
            }
            if (this.dmcomp instanceof DMObject) {
                DMElement[] data = DMElement.genDMelements(tv);
                ((DMObject)this.dmcomp).getValues(data);
                return DMElement.getXjTagValue(data, tv);
            }
            if (this.volInfo != null && tv != null && tv.length > 0) {
                for (int i = 0; i < tv.length; ++i) {
                    tv[i].value = this.getValue(tv[i].group, tv[i].element);
                }
                return tv.length;
            }
            return 0;
        }
    }

    public static class VolumeInfoStatus {
        public int error = 0;
        public String msg = null;
        public double minSpacing = 0.0;
        public double maxSpacing = 0.0;
        public int minSpacingSliceIndex = 0;
        public int maxSpacingSliceIndex = 0;
    }
}

