/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.utils;

import com.ge.med.cse.cvf.j3d.J3DDefaultObliqueController;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;

public class DoubleObliqueController {
    private J3DDefaultObliqueController[] obliqueController = new J3DDefaultObliqueController[2];
    private T3DCapable _controllerPort = null;
    private static ArrayList<J3DDefaultObliqueController> AllObliqueControllers = new ArrayList();
    private static HashMap<J3DDefaultObliqueController, T3DCapable[]> Controllers_viewersMap = new HashMap();
    private static ArrayList<J3DViewport> ViewPorts = new ArrayList();
    private SelectionListener selectionListener;

    public DoubleObliqueController(J3DViewport tvp, Cursor3DModel cursor) {
        this._controllerPort = tvp;
        this.selectionListener = new SelectionListener();
        this.obliqueController[0] = new J3DDefaultObliqueController(tvp.getT3DComponent(), 1.5707963267948966, tvp.getT3DComponent(), cursor);
        this.obliqueController[1] = new J3DDefaultObliqueController(tvp.getT3DComponent(), 0.0, tvp.getT3DComponent(), cursor);
        AllObliqueControllers.add(this.obliqueController[0]);
        AllObliqueControllers.add(this.obliqueController[1]);
        ViewPorts.add(tvp);
        DragListener one = new DragListener(this.obliqueController[1]);
        DragListener two = new DragListener(this.obliqueController[0]);
        this.obliqueController[0].addMouseMotionListener(one);
        this.obliqueController[1].addMouseMotionListener(two);
        this.obliqueController[0].addMouseListener(one);
        this.obliqueController[1].addMouseListener(two);
    }

    public J3DDefaultObliqueController getObliqueController(int i) {
        return this.obliqueController[i];
    }

    public void addViewer(J3DViewport viewerFor1, J3DViewport viewerFor2) {
        this.obliqueController[0].addViewer(viewerFor1);
        this.obliqueController[1].addViewer(viewerFor2);
        this.obliqueController[0].snapViewer();
        this.obliqueController[1].snapViewer();
    }

    public void setVisible(boolean b) {
        this.obliqueController[0].setVisible(b);
        this.obliqueController[1].setVisible(b);
    }

    public void setRxColor(Color col1, Color col2) {
        this.obliqueController[0].setRxColor(col1);
        this.obliqueController[1].setRxColor(col2);
    }

    public void storeViewers(T3DCapable[] cap1, T3DCapable[] cap2) {
        Controllers_viewersMap.put(this.getObliqueController(0), cap1);
        Controllers_viewersMap.put(this.getObliqueController(1), cap2);
    }

    public void setName(String port_one, String port_two) {
        this.obliqueController[0].setName(port_one);
        this.obliqueController[1].setName(port_two);
    }

    public void removeAllViewers() {
        this.obliqueController[0].removeAllViewers();
        this.obliqueController[1].removeAllViewers();
    }

    public void removePortListeners() {
        this._controllerPort.removePropertyChangeListener("COMPONENT_SELECTED", this.selectionListener);
    }

    public void addPortSelectionChangeListeners() {
        this._controllerPort.addPropertyChangeListener("COMPONENT_SELECTED", this.selectionListener);
    }

    private class SelectionListener
    implements PropertyChangeListener {
        private SelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean val = (Boolean)evt.getNewValue();
            if (val) {
                T3DCapable[] cap;
                for (J3DDefaultObliqueController obl : AllObliqueControllers) {
                    cap = (T3DCapable[])Controllers_viewersMap.get(obl);
                    if (cap == null) continue;
                    for (int i = 0; i < cap.length; ++i) {
                        obl.addViewer(cap[i]);
                    }
                }
                Controllers_viewersMap.clear();
                for (J3DDefaultObliqueController obl : AllObliqueControllers) {
                    if (obl == DoubleObliqueController.this.obliqueController[0] || obl == DoubleObliqueController.this.obliqueController[1]) continue;
                    cap = obl.getObliqueViewers();
                    obl.removeAllViewers();
                    Controllers_viewersMap.put(obl, cap);
                }
            }
        }
    }

    private class DragListener
    implements MouseMotionListener,
    MouseListener {
        J3DDefaultObliqueController OrthogonalController = null;

        public DragListener(J3DDefaultObliqueController obl) {
            this.OrthogonalController = obl;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            J3DDefaultObliqueController eventSourceObliqueController = (J3DDefaultObliqueController)e.getSource();
            double angle_Diff = this.OrthogonalController.getAngle() - eventSourceObliqueController.getAngle();
            this.OrthogonalController.setAngle(eventSourceObliqueController.getAngle() + Math.signum(angle_Diff) * Math.PI / 2.0);
            for (J3DDefaultObliqueController obl : AllObliqueControllers) {
                T3DCapable[] cap = (T3DCapable[])Controllers_viewersMap.get(obl);
                if (cap == null) continue;
                obl.allignRxToViewer(cap[0]);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            for (J3DViewport port : ViewPorts) {
                port.setSelected(false);
            }
            ((J3DViewport)DoubleObliqueController.this._controllerPort).setSelected(true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

