/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.utils;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DicomDiff {
    public static List diffTags(String dicomFilePath1, String dicomFilePath2) throws FileNotFoundException {
        ArrayList diffList = new ArrayList();
        dicomParser dp1 = new dicomParser(dicomFilePath1);
        dicomParser dp2 = new dicomParser(dicomFilePath2);
        DicomDiff.parseAndDiff(dp1, dp2, diffList);
        return diffList;
    }

    public static List diffTags(InputStream dicomFile1, InputStream dicomFile2) throws FileNotFoundException {
        ArrayList diffList = new ArrayList();
        dicomParser dp1 = new dicomParser();
        dp1.setFile(dicomFile1);
        dicomParser dp2 = new dicomParser();
        dp2.setFile(dicomFile2);
        DicomDiff.parseAndDiff(dp1, dp2, diffList);
        return diffList;
    }

    protected static void parseAndDiff(dicomParser dp1, dicomParser dp2, List diffList) {
        while (dp1.hasMoreTags() || dp2.hasMoreTags()) {
            int geDiff;
            if (!dp1.hasMoreTags()) {
                while (dp2.hasMoreTags()) {
                    DicomDiff.addDiff(null, dp2.readNext(), diffList);
                }
                continue;
            }
            if (!dp2.hasMoreTags()) {
                while (dp1.hasMoreTags()) {
                    DicomDiff.addDiff(dp1.readNext(), null, diffList);
                }
                continue;
            }
            tagValue tv1 = dp1.readNext();
            tagValue tv2 = dp2.readNext();
            System.out.println("===========tv1.group::" + tv1.group + "   " + "tv1.element::" + tv1.element + "  " + "tv2.group::" + tv2.group + "   " + "tv1.element::" + tv2.element);
            while ((geDiff = DicomDiff.compareGE(tv1, tv2)) != 0) {
                if (geDiff < 0) {
                    DicomDiff.addDiff(tv1, null, diffList);
                    if (!dp1.hasMoreTags()) break;
                    tv1 = dp1.readNext();
                }
                if (geDiff <= 0) continue;
                DicomDiff.addDiff(null, tv2, diffList);
                if (!dp2.hasMoreTags()) break;
                tv2 = dp2.readNext();
            }
            if (DicomDiff.compareGE(tv1, tv2) != 0) continue;
            DicomDiff.compareTags(tv1, tv2, diffList);
        }
    }

    protected static int compareGE(tagValue tv1, tagValue tv2) {
        if (tv1.group < tv2.group) {
            return -1;
        }
        if (tv1.group > tv2.group) {
            return 1;
        }
        if (tv1.element < tv2.element) {
            return -1;
        }
        if (tv1.element > tv2.element) {
            return 1;
        }
        return 0;
    }

    public static boolean compareTags(tagValue tv1, tagValue tv2, List diffList) {
        if (tv1.group != tv2.group) {
            throw new RuntimeException("Groups do not match: " + tagValue.atToString(tv1.group, tv1.element) + " != " + tagValue.atToString(tv2.group, tv2.element));
        }
        if (tv1.element != tv2.element) {
            throw new RuntimeException("Elements do not match: " + tagValue.atToString(tv1.group, tv1.element) + " != " + tagValue.atToString(tv2.group, tv2.element));
        }
        if (tv1.vrep != tv2.vrep) {
            DicomDiff.addDiff(tv1, tv2, diffList);
            return false;
        }
        if (tv1.value instanceof Object[] && tv2.value instanceof Object[]) {
            boolean equal = true;
            Object[] v1 = (Object[])tv1.value;
            Object[] v2 = (Object[])tv2.value;
            if (v1.length != v2.length) {
                DicomDiff.addDiff(tv1, tv2, diffList);
                equal = false;
            }
            for (int i = 0; i < v1.length && equal; ++i) {
                if (v1[i].equals(v2[i])) continue;
                DicomDiff.addDiff(tv1, tv2, diffList);
                equal = false;
            }
            return equal;
        }
        if (!tv1.value.equals(tv2.value)) {
            DicomDiff.addDiff(tv1, tv2, diffList);
            return false;
        }
        return true;
    }

    protected static void addDiff(tagValue tv1, tagValue tv2, List diffList) {
        DicomDiffStruct diff = new DicomDiffStruct();
        diff.group = tv1 != null ? tv1.group : tv2.group;
        diff.element = tv1 != null ? tv1.element : tv2.element;
        diff.vr1 = tv1 != null ? tv1.vrString() : "";
        diff.vr2 = tv2 != null ? tv2.vrString() : "";
        diff.value1 = tv1 != null ? tv1.value : "MISSING";
        diff.value2 = tv2 != null ? tv2.value : "MISSING";
        diffList.add(diff);
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            List diffList;
            DMSession session1 = new DMSession(new String[]{"file", args[0]});
            DMSession session2 = new DMSession(new String[]{"file", args[1]});
            DMObject[] images1 = session1.getRelated("image");
            DMObject[] images2 = session2.getRelated("image");
            try {
                diffList = DicomDiff.diffTags(images1[0].getComposites()[0].getFilePath(), images2[0].getComposites()[0].getFilePath());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            System.out.println("Number of different tags: " + diffList.size());
            for (int i = 0; i < diffList.size(); ++i) {
                System.out.println(diffList.get(i));
            }
        }
    }

    public static class DicomDiffStruct {
        public int group;
        public int element;
        public String vr1;
        public String vr2;
        public Object value1;
        public Object value2;

        public String atToString() {
            String sg = Integer.toHexString(this.group);
            sg = "0000".substring(sg.length()) + sg;
            String se = Integer.toHexString(this.element);
            se = "0000".substring(se.length()) + se;
            return "(0x" + sg + ",0x" + se + ")";
        }

        public String toString() {
            return this.atToString() + "\n\tFirst : [" + this.vr1 + "] " + this.value1 + "\n\tSecond: [" + this.vr2 + "] " + this.value2;
        }
    }
}

