/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.ui;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.idc.XjVolumeCapable;
import com.ge.med.cse.cvf.j3d.J3DSlabLocationRangeModel;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.OnPortControl;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.terra.xpv.base.PlasmaControl;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class J3DThickScrollBar
extends JScrollBar
implements PlasmaControl,
OnPortControl {
    private Capable capable = null;
    private static final String SCROLLBARUI_CLASSNAME = "ScrollBarUI.class";
    private transient PropertyChangeListener viewtypeChangeListner = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            J3DThickScrollBar.this.setUIEnableState();
        }
    };
    private transient PropertyChangeListener volumeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!J3DThickScrollBar.this.getValueIsAdjusting()) {
                J3DThickScrollBar.this.setRangeLocation();
                J3DThickScrollBar.this.setRangeThickness();
            }
        }
    };
    private transient PropertyChangeListener framePositionChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!J3DThickScrollBar.this.getValueIsAdjusting()) {
                J3DThickScrollBar.this.setRangeLocation();
                J3DThickScrollBar.this.setRangeThickness();
            }
        }
    };
    private transient PropertyChangeListener thicknessChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!J3DThickScrollBar.this.getValueIsAdjusting()) {
                J3DThickScrollBar.this.setRangeThickness();
            }
        }
    };
    private transient ChangeListener rangeModelListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            J3DThickScrollBar.this.rangeModelChanged();
        }
    };

    public J3DThickScrollBar() {
        ScrollBarUI scrollUI = null;
        Class scrollUIClass = LookAndFeelFactory.getClass(SCROLLBARUI_CLASSNAME);
        try {
            scrollUI = (ScrollBarUI)scrollUIClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        this.setUI(scrollUI);
        this.setName("J3DThickScrollBar");
    }

    public J3DThickScrollBar(ScrollBarUI ui) {
        ScrollBarUI sbui = ui != null ? ui : new MetalScrollBarUI();
        this.setUI(sbui);
        this.setName("J3DThickScrollBar");
    }

    public double getThickness() {
        BoundedRangeModel model = this.getModel();
        if (model instanceof J3DSlabLocationRangeModel) {
            return ((J3DSlabLocationRangeModel)model).getThickness();
        }
        return 0.0;
    }

    public void setThickness(double v) {
        BoundedRangeModel model = this.getModel();
        if (model instanceof J3DSlabLocationRangeModel) {
            ((J3DSlabLocationRangeModel)model).setThickness(v);
        }
    }

    public void setMaxThickness(double max) {
        BoundedRangeModel model = this.getModel();
        if (model instanceof J3DSlabLocationRangeModel) {
            ((J3DSlabLocationRangeModel)model).setMaxThickness(max);
        }
    }

    public double getMaxThickness() {
        BoundedRangeModel model = this.getModel();
        if (model instanceof J3DSlabLocationRangeModel) {
            return ((J3DSlabLocationRangeModel)model).getMaxThickness();
        }
        return 0.0;
    }

    public boolean isThicknessControlEnabled() {
        BoundedRangeModel model = this.getModel();
        if (model instanceof J3DSlabLocationRangeModel) {
            return ((J3DSlabLocationRangeModel)model).isThicknessControlEnabled();
        }
        return false;
    }

    public void setThicknessControlEnabled(boolean enabled) {
        BoundedRangeModel model = this.getModel();
        if (model instanceof J3DSlabLocationRangeModel) {
            ((J3DSlabLocationRangeModel)model).setThicknessControlEnabled(enabled);
        }
    }

    public double[] getMarkerIndices() {
        BoundedRangeModel model = this.getModel();
        if (model instanceof J3DSlabLocationRangeModel) {
            return ((J3DSlabLocationRangeModel)model).getMarkerIndices();
        }
        return null;
    }

    public void setMarkerIndices(double[] indices) {
        BoundedRangeModel model = this.getModel();
        if (model instanceof J3DSlabLocationRangeModel) {
            ((J3DSlabLocationRangeModel)model).setMarkerIndices(indices);
        }
    }

    public void setDoubleValue(double val) {
        BoundedRangeModel model = this.getModel();
        if (model instanceof J3DSlabLocationRangeModel) {
            ((J3DSlabLocationRangeModel)model).setDoubleValue(val);
        }
    }

    @Override
    public void setValue(int v) {
        super.setValue(v);
    }

    @Override
    public void listenTo(Component c) {
        if (c instanceof Capable) {
            this.setCapable((Capable)((Object)c));
        }
    }

    @Override
    public void setCapable(Capable cap) {
        if (cap.getCapable(FramePositioningCapable.class.getName()) != null && cap.getCapable(T3DCapable.class.getName()) != null) {
            if (this.capable != null) {
                this.capable.removePropertyChangeListener("FrameIndex", this.framePositionChangeListener);
                this.capable.removePropertyChangeListener("viewClip", this.thicknessChangeListener);
                this.capable.removePropertyChangeListener("VOLUME_PROPERTY", this.volumeChangeListener);
                this.capable.removePropertyChangeListener("viewType", this.viewtypeChangeListner);
            }
            this.capable = cap;
            this.capable.addPropertyChangeListener("FrameIndex", this.framePositionChangeListener);
            this.capable.addPropertyChangeListener("viewClip", this.thicknessChangeListener);
            this.capable.addPropertyChangeListener("VOLUME_PROPERTY", this.volumeChangeListener);
            this.capable.addPropertyChangeListener("viewType", this.viewtypeChangeListner);
            this.setRangeLocation();
            this.setRangeThickness();
            this.setUIEnableState();
        }
    }

    private void setUIEnableState() {
        ViewTypeCapable vtCap;
        if (this.capable != null && (vtCap = (ViewTypeCapable)this.capable.getCapable(ViewTypeCapable.class.getName())) != null) {
            if ("3D" == vtCap.getViewType()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private void setRangeThickness() {
        T3DCapable t3dCapable = (T3DCapable)this.capable.getCapable(T3DCapable.class.getName());
        XjVolumeCapable volCap = (XjVolumeCapable)this.capable.getCapable(XjVolumeCapable.class.getName());
        if (t3dCapable != null) {
            double[] viewClip = new double[2];
            t3dCapable.getViewClip(viewClip);
            BoundedRangeModel model = this.getModel();
            if (model instanceof J3DSlabLocationRangeModel) {
                double[] ulc = new double[3];
                double[] xside = new double[3];
                double[] yside = new double[3];
                double[] zside = new double[3];
                t3dCapable.getWorldBounds(ulc, xside, yside, zside);
                ((J3DSlabLocationRangeModel)model).setMaxThickness(J3DGeomUtils.getMaxSliceThickness(ulc, xside, yside, zside, t3dCapable.getLookPoint(null), t3dCapable.getEyePoint(null)));
                ((J3DSlabLocationRangeModel)model).setThickness(viewClip[1] - viewClip[0]);
            }
        }
    }

    private void setRangeLocation() {
        FramePositioningCapable framePositioningCapable = (FramePositioningCapable)this.capable.getCapable(FramePositioningCapable.class.getName());
        if (framePositioningCapable != null) {
            int numFrames = framePositioningCapable.getNumFrames();
            int currentFrame = framePositioningCapable.getFrameIndex();
            BoundedRangeModel model = this.getModel();
            if (model instanceof J3DSlabLocationRangeModel) {
                ((J3DSlabLocationRangeModel)model).setRangeProperties(currentFrame, 1, 0, numFrames, model.getValueIsAdjusting());
            }
        }
    }

    private void rangeModelChanged() {
        BoundedRangeModel model = this.getModel();
        double newFrameIndex = model instanceof J3DSlabLocationRangeModel ? ((J3DSlabLocationRangeModel)model).getDoubleValue() - (double)((J3DSlabLocationRangeModel)model).getMinimum() : 0.0;
        double thickness = this.getThickness();
        FramePositioningCapable framePositioningCapable = (FramePositioningCapable)this.capable.getCapable(FramePositioningCapable.class.getName());
        if (framePositioningCapable != null && (double)framePositioningCapable.getFrameIndex() != newFrameIndex) {
            framePositioningCapable.setFrameIndex((int)newFrameIndex);
        }
        double[] viewClip = new double[2];
        double[] newClip = new double[2];
        T3DCapable t3dCapable = (T3DCapable)this.capable.getCapable(T3DCapable.class.getName());
        if (t3dCapable != null) {
            t3dCapable.getViewClip(viewClip);
            newClip[0] = -thickness / 2.0;
            newClip[1] = thickness / 2.0;
            if (Math.abs(thickness - (Math.abs(viewClip[0]) + Math.abs(viewClip[1]))) > 0.01) {
                if (thickness <= 1.0) {
                    t3dCapable.setViewClip(new double[]{0.0, 0.0});
                } else {
                    t3dCapable.setViewClip(newClip);
                    if (t3dCapable instanceof T3DRenderStyleCapable && (CvUtils.getT3DRenderStyle("REFORMAT").equals(((T3DRenderStyleCapable)((Object)t3dCapable)).getRenderStyle()) || CvUtils.getT3DRenderStyle("REFORMAT.TC").equals(((T3DRenderStyleCapable)((Object)t3dCapable)).getRenderStyle()) || CvUtils.getT3DRenderStyle("REFORMAT.NN").equals(((T3DRenderStyleCapable)((Object)t3dCapable)).getRenderStyle()))) {
                        CvUtils.setT3DRenderStyle((T3DRenderStyleCapable)((Object)t3dCapable), "MAJOR_AXIS_MIP");
                    }
                }
                t3dCapable.repaint();
            }
        }
    }

    @Override
    public void setModel(BoundedRangeModel newModel) {
        super.setModel(newModel);
        this.getModel().addChangeListener(this.rangeModelListener);
    }
}

