/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.cpanels;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.cpanels.VavBatchRxPanelUI;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.j3d.vav.VavRotateBatchModel;
import com.ge.med.cse.cvf.j3d.vav.ui.RotateBatchVc;
import com.ge.med.cse.cvf.j3d.vav.ui.Rotation3DVc;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class VavRotateBatchUI
extends VavBatchRxPanelUI {
    public static final double DEFAULT_FOV_VAL = 10.0;
    private transient VavRotateBatchModel batchModel = null;
    private JLabel numImagesLabel = new JLabel(NUM_IMAGES, 4);
    private JLabel angleLabel = new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_ANGLE_IMAGES"), 4);
    private JLabel thicknessLabel = new JLabel(THICKNESS, 4);
    private JLabel modeLabel = new JLabel(MODE, 4);
    private JLabel fovLabel = new JLabel(FOV, 4);
    private JTextField numImagesBox = new JTextField();
    private JTextField angleBox = new JTextField();
    private JTextField thicknessBox = new JTextField();
    private JTextField fovBox = new JTextField();
    private JComboBox modeBox = new JComboBox();
    private RotateBatchVc rotateVc = null;
    private Rotation3DVc rotate3DVc = null;
    private boolean isPanelVisible = false;
    private transient PropertyChangeListener viewTypeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ViewTypeCapable vcap;
            J3DViewport vp;
            if (VavRotateBatchUI.this.batchModel != null && (vp = (J3DViewport)VavRotateBatchUI.this.batchModel.getTargetPort()) != null && (vcap = (ViewTypeCapable)vp.getCapable(ViewTypeCapable.class.getName())) != null) {
                if (vcap.getViewType().equals("3D")) {
                    vp.lockViewType(false);
                } else {
                    vp.lockViewType(true);
                }
            }
        }
    };
    private transient PropertyChangeListener viewtypeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            VavRotateBatchUI.this.updateFromModel();
            if (VavRotateBatchUI.this.isPanelVisible) {
                VavRotateBatchUI.this.removeVc();
                VavRotateBatchUI.this.postVc();
            }
        }
    };

    public VavRotateBatchUI() {
        this.batchModel = new VavRotateBatchModel();
        this.initUI();
    }

    @Override
    public void panelStart() {
        this.isPanelVisible = true;
        this.batchModel.addPropertyChangeListener("BATCHMODEL_UPDATED_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("NUM_IMAGES_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("FOV_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("RENDER_MODE_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("ANGLE_BETWEEN_VIEWS_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("THICKNESS_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("CENTER_POINT_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("INITIAL_NORMAL_VECTOR_PROPERTY", this);
        this.updateFromModel();
        J3DViewport vp = (J3DViewport)this.batchModel.getTargetPort();
        if (vp != null) {
            if (!this.batchModel.is3DRotationMode()) {
                vp.lockViewType(true);
            }
            vp.addPropertyChangeListener("viewType", this.viewTypeListener);
        }
        this.postVc();
    }

    @Override
    public void panelStop() {
        this.isPanelVisible = false;
        this.removeVc();
        if (this.batchModel != null) {
            this.batchModel.removePropertyChangeListener("BATCHMODEL_UPDATED_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("NUM_IMAGES_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("FOV_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("RENDER_MODE_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("ANGLE_BETWEEN_VIEWS_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("THICKNESS_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("CENTER_POINT_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("INITIAL_NORMAL_VECTOR_PROPERTY", this);
            J3DViewport vp = (J3DViewport)this.batchModel.getTargetPort();
            if (vp != null) {
                if (!this.batchModel.is3DRotationMode()) {
                    vp.lockViewType(false);
                }
                vp.removePropertyChangeListener("viewType", this.viewTypeListener);
            }
        }
    }

    private void initUI() {
        this.setBackground(UIManager.getColor("P8"));
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new EmptyBorder(5, 5, 2, 5));
        mainPanel.setBackground(null);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbconst = new GridBagConstraints();
        gbconst.gridx = 0;
        gbconst.gridy = 0;
        gbconst.anchor = 13;
        gbconst.insets = new Insets(2, 0, 2, 2);
        mainPanel.add((Component)this.numImagesLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 0;
        gbconst.anchor = 17;
        gbconst.insets = new Insets(2, 2, 2, 0);
        this.numImagesBox.setEditable(true);
        this.numImagesBox.setPreferredSize(new Dimension(80, 30));
        this.numImagesBox.setName(VavRotateBatchUI.class.getName() + "_numImagesBox");
        this.numImagesBox.setText(Integer.toString(this.batchModel.getNumImages()));
        this.numImagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nimgs = VavRotateBatchUI.this.numImagesBox.getText().trim();
                if (nimgs.length() > 0) {
                    VavRotateBatchUI.this.batchModel.setNumImages(Integer.parseInt(nimgs));
                }
                VavRotateBatchUI.this.updateFromModel();
            }
        });
        mainPanel.add((Component)this.numImagesBox, gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 1;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.thicknessLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 1;
        gbconst.insets = new Insets(2, 2, 2, 0);
        gbconst.anchor = 17;
        this.thicknessBox.setEditable(true);
        this.thicknessBox.setName(VavRotateBatchUI.class.getName() + "_thicknessBox");
        this.thicknessBox.setText(Double.toString(this.batchModel.getThickness()));
        this.thicknessBox.setPreferredSize(new Dimension(80, 30));
        this.thicknessBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String thk = VavRotateBatchUI.this.thicknessBox.getText().trim();
                if (thk.length() > 0) {
                    VavRotateBatchUI.this.batchModel.setThickness(Double.parseDouble(thk));
                }
                VavRotateBatchUI.this.updateFromModel();
            }
        });
        mainPanel.add((Component)this.thicknessBox, gbconst);
        gbconst.gridx = 2;
        gbconst.gridy = 1;
        gbconst.insets = new Insets(0, 2, 0, 0);
        gbconst.anchor = 17;
        mainPanel.add((Component)new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_MM")), gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 2;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.angleLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 2;
        gbconst.insets = new Insets(2, 2, 2, 0);
        gbconst.anchor = 17;
        this.angleBox.setEditable(true);
        this.angleBox.setPreferredSize(new Dimension(80, 30));
        this.angleBox.setName(VavRotateBatchUI.class.getName() + "_angleBox");
        this.angleBox.setText(Double.toString(this.batchModel.getAngleBetweenViews()));
        this.angleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String ang = VavRotateBatchUI.this.angleBox.getText().trim();
                if (ang.length() > 0) {
                    VavRotateBatchUI.this.batchModel.setAngleBetweenViews(Double.parseDouble(ang));
                }
                VavRotateBatchUI.this.updateFromModel();
            }
        });
        mainPanel.add((Component)this.angleBox, gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 3;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.modeLabel, gbconst);
        this.modeBox.setName(VavRotateBatchUI.class.getName() + "_modeBox");
        this.modeBox.setPreferredSize(new Dimension(80, 35));
        this.modeBox.addItem(AVG);
        this.modeBox.addItem(MINIP);
        this.modeBox.addItem(MIP);
        this.modeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VavRotateBatchUI.this.modeBox.getSelectedItem().equals("AVG")) {
                    VavRotateBatchUI.this.batchModel.setRenderStyle("MAJOR_AXIS_AVERAGE");
                } else if (VavRotateBatchUI.this.modeBox.getSelectedItem().equals("MINIP")) {
                    VavRotateBatchUI.this.batchModel.setRenderStyle("MAJOR_AXIS_MINIP");
                } else if (VavRotateBatchUI.this.modeBox.getSelectedItem().equals("MIP")) {
                    VavRotateBatchUI.this.batchModel.setRenderStyle("MAJOR_AXIS_MIP");
                }
            }
        });
        this.modeBox.setFocusable(false);
        gbconst.gridx = 1;
        gbconst.gridy = 3;
        gbconst.anchor = 17;
        gbconst.insets = new Insets(2, 2, 2, 0);
        mainPanel.add((Component)this.modeBox, gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 4;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.fovLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 4;
        gbconst.insets = new Insets(2, 2, 2, 0);
        gbconst.anchor = 17;
        this.fovBox.setEditable(true);
        this.fovBox.setName(VavRotateBatchUI.class.getName() + "_fovBox");
        this.fovBox.setText(Double.toString(this.batchModel.getFov() / 10.0));
        this.fovBox.setPreferredSize(new Dimension(80, 30));
        this.fovBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fov = VavRotateBatchUI.this.fovBox.getText().trim();
                if (fov.length() > 0) {
                    double fovVal = Double.parseDouble(fov) * 10.0;
                    VavRotateBatchUI.this.batchModel.setFov(fovVal);
                }
                VavRotateBatchUI.this.updateFromModel();
            }
        });
        mainPanel.add((Component)this.fovBox, gbconst);
        gbconst.gridx = 2;
        gbconst.gridy = 4;
        gbconst.insets = new Insets(0, 2, 0, 0);
        gbconst.anchor = 17;
        mainPanel.add((Component)new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_CM")), gbconst);
        this.add((Component)mainPanel, "North");
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VavRotateBatchUI.this.updateFromModel(evt.getPropertyName());
            }
        });
    }

    private void updateFromModel(String updateForProperty) {
        if (updateForProperty.equalsIgnoreCase("BATCHMODEL_UPDATED_PROPERTY")) {
            this.updateFromModel();
        } else if (updateForProperty.equalsIgnoreCase("NUM_IMAGES_PROPERTY")) {
            this.numImagesBox.setText(Integer.toString(this.batchModel.getNumImages()));
        } else if (updateForProperty.equalsIgnoreCase("FOV_PROPERTY")) {
            this.fovBox.setText(formatter.format(this.batchModel.getFov() / 10.0));
        } else if (updateForProperty.equalsIgnoreCase("RENDER_MODE_PROPERTY")) {
            if (this.batchModel.getRenderStyle().equals("MAJOR_AXIS_AVERAGE") || this.batchModel.getRenderStyle().equals("FULLBODY_AVERAGE") || this.batchModel.getRenderStyle().equals("AVERAGE")) {
                this.modeBox.setSelectedItem("AVG");
            } else if (this.batchModel.getRenderStyle().equals("MAJOR_AXIS_MINIP") || this.batchModel.getRenderStyle().equals("FULLBODY_MINIP") || this.batchModel.getRenderStyle().equals("MINIP")) {
                this.modeBox.setSelectedItem("MINIP");
            } else if (this.batchModel.getRenderStyle().equals("MAJOR_AXIS_MIP") || this.batchModel.getRenderStyle().equals("FULLBODY_MIP") || this.batchModel.getRenderStyle().equals("MIP")) {
                this.modeBox.setSelectedItem("MIP");
            }
        } else if (updateForProperty.equalsIgnoreCase("ANGLE_BETWEEN_VIEWS_PROPERTY")) {
            this.angleBox.setText(formatter.format(this.batchModel.getAngleBetweenViews()));
        } else if (updateForProperty.equalsIgnoreCase("THICKNESS_PROPERTY")) {
            this.checkThicknessLimits(this.batchModel.getThickness());
        } else if (updateForProperty.equalsIgnoreCase("CENTER_POINT_PROPERTY")) {
            this.updateFromModel();
        } else if (updateForProperty.equalsIgnoreCase("INITIAL_NORMAL_VECTOR_PROPERTY")) {
            this.updateFromModel();
        }
    }

    @Override
    public void loadProtocolSelection(VVBatchProtocol protocol) {
        if (this.batchModel != null) {
            this.batchModel.loadFromProtocol(protocol);
        }
    }

    @Override
    public void setTarget(T3DViewport port) {
        if (this.batchModel.getTargetPort() != null) {
            this.batchModel.getTargetPort().removePropertyChangeListener("viewType", this.viewtypeListener);
        }
        port.addPropertyChangeListener("viewType", this.viewtypeListener);
        this.batchModel.setTarget(port);
    }

    private void updateFromModel() {
        this.numImagesBox.setText(Integer.toString(this.batchModel.getNumImages()));
        this.angleBox.setText(Double.toString(this.batchModel.getAngleBetweenViews()));
        if (this.batchModel.getRenderStyle().equals("MAJOR_AXIS_AVERAGE") || this.batchModel.getRenderStyle().equals("FULLBODY_AVERAGE") || this.batchModel.getRenderStyle().equals("AVERAGE")) {
            this.modeBox.setSelectedItem("AVG");
        } else if (this.batchModel.getRenderStyle().equals("MAJOR_AXIS_MINIP") || this.batchModel.getRenderStyle().equals("FULLBODY_MINIP") || this.batchModel.getRenderStyle().equals("MINIP")) {
            this.modeBox.setSelectedItem("MINIP");
        } else if (this.batchModel.getRenderStyle().equals("MAJOR_AXIS_MIP") || this.batchModel.getRenderStyle().equals("FULLBODY_MIP") || this.batchModel.getRenderStyle().equals("MIP")) {
            this.modeBox.setSelectedItem("MIP");
        }
        this.checkThicknessLimits(this.batchModel.getThickness());
        if (this.batchModel.getTargetPort() != null) {
            VavRotateBatchModel rotateBatch = this.batchModel;
            String strRenderStyle = this.batchModel.getRenderStyle();
            if (rotateBatch.is3DRotationMode() && (strRenderStyle.equals("VOLUME") || strRenderStyle.equals("FULLBODY_MIP") || strRenderStyle.equals("FULLBODY_MINIP") || strRenderStyle.equals("FULLBODY_AVERAGE"))) {
                T3DViewport vport = this.batchModel.getTargetPort();
                vport.setViewHeight(this.batchModel.getFov());
            }
        }
        this.fovBox.setText(formatter.format(this.batchModel.getFov() / 10.0));
    }

    @Override
    public VavBatchModel getBatchModel() {
        return this.batchModel;
    }

    private void postVc() {
        T3DViewport vport = this.batchModel.getTargetPort();
        if (vport != null) {
            String renderStyle = vport.getRenderStyle();
            if ("FULLBODY_AVERAGE".equals(renderStyle) || "FULLBODY_MIP".equals(renderStyle) || "FULLBODY_MINIP".equals(renderStyle) || "VOLUME".equals(renderStyle)) {
                this.batchModel.set3DRotationMode(true);
                this.rotate3DVc = new Rotation3DVc(this.batchModel);
                vport.getT3DComponent().add((Component)this.rotate3DVc);
            } else {
                this.batchModel.set3DRotationMode(false);
                this.rotateVc = new RotateBatchVc(this.batchModel);
                vport.getT3DComponent().add((Component)this.rotateVc, 0);
            }
            vport.updateUI();
            vport.repaint();
        }
    }

    private void removeVc() {
        Container parent;
        if (this.rotateVc != null && this.rotateVc.getParent() != null) {
            this.rotateVc.shutDown();
            parent = this.rotateVc.getParent();
            this.rotateVc.getParent().remove((Component)this.rotateVc);
            parent.repaint();
            this.rotateVc = null;
        }
        if (this.rotate3DVc != null && this.rotate3DVc.getParent() != null) {
            this.rotate3DVc.shutDown();
            parent = this.rotate3DVc.getParent();
            this.rotate3DVc.getParent().remove((Component)this.rotate3DVc);
            parent.repaint();
            this.rotate3DVc = null;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test Batch Rx");
        VavRotateBatchUI rotateBatch = new VavRotateBatchUI();
        frame.getContentPane().add(rotateBatch);
        frame.setSize(300, 200);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    @Override
    public void setSeriesDescription(String desc) {
        this.batchModel.setSeriesDescription(desc);
    }

    private void checkThicknessLimits(double thickness) {
        if (this.batchModel != null) {
            boolean enable = false;
            String strRenderStyle = this.batchModel.getRenderStyle();
            if (strRenderStyle.equals("VOLUME") || strRenderStyle.equals("FULLBODY_MIP") || strRenderStyle.equals("FULLBODY_MINIP") || strRenderStyle.equals("FULLBODY_AVERAGE")) {
                this.thicknessBox.setText("0.0");
                this.modeBox.setVisible(false);
                this.modeLabel.setVisible(false);
                this.thicknessBox.setEnabled(false);
                this.thicknessLabel.setEnabled(false);
            } else {
                double minThickness = Math.abs(J3DGeomUtils.getMinSliceThickness(this.batchModel.getTargetVolume(), this.batchModel.getSliceLookPoint(0, null), this.batchModel.getSliceEyePoint(0, null)));
                enable = thickness > minThickness;
                this.thicknessBox.setText(formatter.format(this.batchModel.getThickness()));
                this.thicknessBox.setEnabled(true);
                this.thicknessLabel.setEnabled(true);
                this.modeBox.setVisible(true);
                this.modeLabel.setVisible(true);
                this.modeBox.setEnabled(enable);
                this.modeLabel.setEnabled(enable);
            }
        }
    }
}

