/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.cpanels;

import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.laf.AbstractNumberedThumSliderUI;
import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.autoControls.XPwCineModeControl;
import com.ge.med.terra.xpv.autoControls.XPwCineRateSlider2;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

public class VavPreviewPanel
extends JPanel
implements ActionListener {
    private JLabel preview = new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_PREVIEW"));
    private JLabel imgIndx = new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_IMG_INDEX"));
    private JSlider imgNumslider = new JSlider();
    private JLabel imgIndx_val = new JLabel("10");
    private JButton play = new JButton();
    private JButton stepFw = new JButton();
    private JButton stepBw = new JButton();
    private JLabel mode = new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_PLAY_MODE"));
    private XPwCineModeControl pongBut = new XPwCineModeControl(false);
    private XPwCineModeControl loopBut = new XPwCineModeControl(true);
    private XPwCineRateSlider3 fpsSlider = new XPwCineRateSlider3();
    private JButton close = new JButton(CvUtils.getResourceBundle().getString("XP_CINE_CLS"));
    private JLabel speed = new JLabel(CvUtils.getResourceBundle().getString("XP_CINE_FRMRATE_LBL"));
    private JTextField fpsValueField = new JTextField();
    private CineCapable cineCap = null;
    private FramePositioningCapable frpCap = null;
    private XPscreen screen_ = null;
    private static final String PAUSE = "Pause";
    private static final String PLAY = "play_forward";
    private static final String STEP_FORWARD = "step_forward";
    private static final String STEP_BACKWARD = "step_backward";
    private static final String PAUSE_ICON = "XP_CINE_PAUSE_ICON";
    private static final String PLAY_ICON = "XP_CINE_PLY_FW_ICON";
    private transient VavBatchModel model_ = null;
    public static final String SLIDERUI_NAME = "vavpanel.sliderui";
    transient ChangeListener imgNumslider_listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!VavPreviewPanel.this.cineCap.getCine() && VavPreviewPanel.this.cineCap.getEndOffset() > 0 && VavPreviewPanel.this.cineCap.getOffset() != VavPreviewPanel.this.imgNumslider.getValue()) {
                VavPreviewPanel.this.cineCap.setOffset(VavPreviewPanel.this.imgNumslider.getValue());
            }
        }
    };
    transient PropertyChangeListener frameIndx_listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VavPreviewPanel.this.cineCap != null) {
                VavPreviewPanel.this.updateImageIndexSlider(VavPreviewPanel.this.cineCap);
            }
        }
    };

    public VavPreviewPanel() {
        this.initUI();
    }

    public void panelStart() {
        this.play.doClick();
        this.imgNumslider.addChangeListener(this.imgNumslider_listener);
    }

    public void panelStop() {
        this.cineCap.setCine(false);
        if (this.play.getActionCommand().equalsIgnoreCase(PAUSE)) {
            this.play.setIcon(CvUtils.getIcon(PLAY_ICON));
            this.play.setActionCommand(PLAY);
        }
        this.imgNumslider.removeChangeListener(this.imgNumslider_listener);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(null);
        JPanel main_panel = new JPanel();
        main_panel.setBackground(null);
        main_panel.setLayout(new GridBagLayout());
        this.imgNumslider.setFocusable(false);
        this.imgNumslider.setValue(1);
        this.imgNumslider.setBackground(null);
        this.imgNumslider.setName(VavPreviewPanel.class.getName() + "_imgnumSlider");
        this.play.setIcon(CvUtils.getIcon(PLAY_ICON));
        this.play.setActionCommand(PLAY);
        this.play.setFocusable(false);
        this.play.addActionListener(this);
        this.play.setName(VavPreviewPanel.class.getName() + "_playButton");
        this.stepFw.setIcon(CvUtils.getIcon("XP_CINE_STEP_FW_ICON"));
        this.stepFw.setFocusable(false);
        this.stepFw.setActionCommand(STEP_FORWARD);
        this.stepFw.addActionListener(this);
        this.stepFw.setName(VavPreviewPanel.class.getName() + "_FwdButton");
        this.stepBw.setIcon(CvUtils.getIcon("XP_CINE_STEP_BW_ICON"));
        this.stepBw.setFocusable(false);
        this.stepBw.setActionCommand(STEP_BACKWARD);
        this.stepBw.addActionListener(this);
        this.stepBw.setName(VavPreviewPanel.class.getName() + "_BwdButton");
        ButtonGroup group = new ButtonGroup();
        group.add(this.loopBut);
        group.add(this.pongBut);
        this.loopBut.setFocusable(false);
        this.loopBut.setPreferredSize(new Dimension(60, 30));
        this.loopBut.setSelected(true);
        this.pongBut.setFocusable(false);
        this.pongBut.setPreferredSize(new Dimension(60, 30));
        this.fpsSlider.setFocusable(false);
        this.fpsSlider.setToolTipText(null);
        this.fpsSlider.setPreferredSize(new Dimension(100, 30));
        this.fpsSlider.setBackground(null);
        this.fpsSlider.setName(VavPreviewPanel.class.getName() + "_fps");
        this.close.setFocusable(false);
        this.close.setActionCommand("CLOSE");
        this.close.setName(VavPreviewPanel.class.getName() + "_close");
        this.close.addActionListener(this);
        this.fpsValueField.setColumns(2);
        this.fpsValueField.setEditable(false);
        this.fpsValueField.setBorder(null);
        this.fpsValueField.setText(Integer.toString(this.fpsSlider.getValue()));
        JPanel panel1 = new JPanel();
        panel1.setBackground(null);
        panel1.setLayout(new GridBagLayout());
        panel1.add((Component)this.imgIndx, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel1.add((Component)this.imgNumslider, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 5, 2), 0, 0));
        panel1.add((Component)this.imgIndx_val, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 2), 0, 0));
        JPanel panel11 = new JPanel();
        panel11.setBackground(null);
        panel11.setLayout(new GridBagLayout());
        panel11.add((Component)this.stepBw, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 15), 0, 0));
        panel11.add((Component)this.play, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 15), 0, 0));
        panel11.add((Component)this.stepFw, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 15), 0, 0));
        JPanel panel2 = new JPanel();
        panel2.setBackground(null);
        panel2.setLayout(new GridBagLayout());
        panel2.add((Component)this.mode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel2.add((Component)this.loopBut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel2.add((Component)this.pongBut, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 5), 0, 0));
        JPanel panel3 = new JPanel();
        panel3.setBackground(null);
        panel3.setLayout(new GridBagLayout());
        panel3.add((Component)this.speed, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 8, 5, 5), 0, 0));
        panel3.add((Component)this.fpsSlider, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
        JPanel panel4 = new JPanel();
        panel4.setBackground(null);
        panel4.setLayout(new GridBagLayout());
        panel4.add((Component)this.close, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        JPanel panel5 = new JPanel();
        panel5.setBackground(null);
        panel5.setLayout(new GridBagLayout());
        panel5.add((Component)panel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 5), 0, 0));
        panel5.add((Component)panel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 5), 0, 0));
        panel5.add((Component)panel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 5), 0, 0));
        panel5.add((Component)panel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 5), 0, 0));
        panel5.add((Component)panel11, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 30, 5), 0, 0));
        main_panel.add((Component)panel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 0, 10, 10), 0, 0));
        this.add((Component)main_panel, "Center");
    }

    public void setScreen(XPscreen screen) {
        this.screen_ = screen;
        this.cineCap = (CineCapable)this.screen_.getCapable(CineCapable.class.getName());
        this.frpCap = (FramePositioningCapable)this.screen_.getCapable(FramePositioningCapable.class.getName());
        this.screen_.removePropertyChangeListener("FrameIndex", this.frameIndx_listener);
        this.screen_.addPropertyChangeListener("FrameIndex", this.frameIndx_listener);
    }

    private void updateImageIndexSlider(CineCapable cineCapable) {
        int offset = cineCapable.getOffset();
        this.imgNumslider.setValue(offset);
        this.imgIndx_val.setText(Integer.toString(offset + 1));
    }

    public void setModel(VavBatchModel model) {
        this.model_ = model;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("CLOSE")) {
            this.panelStop();
            this.firePropertyChange("close_panel", null, "PreviewPanel");
        } else if (e.getActionCommand().equalsIgnoreCase(PLAY)) {
            if (this.cineCap == null || this.frpCap == null) {
                return;
            }
            JComponent[] ports = this.screen_.getAllPorts();
            int index = -1;
            for (int i = 0; i < ports.length; ++i) {
                if (!(ports[i] instanceof T3DViewport) || this.model_ == null || !ports[i].equals(this.model_.getTargetPort())) continue;
                index = i;
                break;
            }
            this.screen_.setSelectedPortNumber(index);
            this.cineCap.setStartOffset(0);
            this.cineCap.setEndOffset(this.frpCap.getNumFrames() - 1);
            this.cineCap.setCineRate((int)(1000.0 / (double)this.fpsSlider.getValue()));
            this.cineCap.setCineSkip(1);
            this.imgNumslider.setMinimum(this.cineCap.getStartOffset());
            this.imgNumslider.setMaximum(this.cineCap.getEndOffset());
            this.cineCap.setCine(true);
            this.fpsSlider.setCineOn(true);
            this.play.setIcon(CvUtils.getIcon(PAUSE_ICON));
            this.play.setActionCommand(PAUSE);
            this.play.setToolTipText(CvUtils.getResourceBundle().getString("PAUSE_TOOLTIP"));
            this.stepFw.setEnabled(false);
            this.stepBw.setEnabled(false);
            this.loopBut.setEnabled(false);
            this.pongBut.setEnabled(false);
        } else if (e.getActionCommand().equalsIgnoreCase(STEP_FORWARD)) {
            if (this.cineCap == null || this.frpCap == null) {
                return;
            }
            int nextInd = this.cineCap.getCineSkip() + this.frpCap.getFrameIndex();
            if (nextInd > this.frpCap.getNumFrames() - 1) {
                this.cineCap.setOffset(this.frpCap.getFrameIndex());
            } else {
                this.cineCap.setOffset(nextInd);
            }
        } else if (e.getActionCommand().equalsIgnoreCase(STEP_BACKWARD)) {
            if (this.cineCap == null || this.frpCap == null) {
                return;
            }
            int prevInd = this.frpCap.getFrameIndex() - this.cineCap.getCineSkip();
            if (prevInd < this.cineCap.getStartOffset()) {
                this.cineCap.setOffset(this.frpCap.getFrameIndex());
            } else {
                this.cineCap.setOffset(prevInd);
            }
        } else if (e.getActionCommand().equalsIgnoreCase(PAUSE)) {
            this.cineCap.setCine(false);
            this.fpsSlider.setCineOn(false);
            this.stepBw.setEnabled(true);
            this.stepFw.setEnabled(true);
            this.loopBut.setEnabled(true);
            this.pongBut.setEnabled(true);
            this.play.setIcon(CvUtils.getIcon(PLAY_ICON));
            this.play.setActionCommand(PLAY);
            this.play.setToolTipText(CvUtils.getResourceBundle().getString("XP_CINE_PLAY_FW"));
        }
    }

    private class XPwCineRateSlider3
    extends XPwCineRateSlider2 {
        private int noSkipFrameRate;
        private boolean isCineOn = false;
        private AbstractNumberedThumSliderUI sliderUI = null;

        public XPwCineRateSlider3() {
            this.setMaximum(50);
            this.sliderUI = this.createSliderUI();
        }

        private AbstractNumberedThumSliderUI createSliderUI() {
            Class sliderUIClass = LookAndFeelFactory.getClass(VavPreviewPanel.SLIDERUI_NAME);
            if (sliderUIClass != null) {
                try {
                    return (AbstractNumberedThumSliderUI)sliderUIClass.getConstructor(JSlider.class).newInstance(this);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public void setNoSkipFrameRate(int rate) {
            this.noSkipFrameRate = rate;
            this.repaint();
        }

        public void setCineOn(boolean onOff) {
            this.isCineOn = onOff;
            this.repaint();
        }

        @Override
        public void updateUI() {
            if (this.sliderUI == null) {
                this.sliderUI = this.createSliderUI();
            }
            this.setUI((SliderUI)((Object)this.sliderUI));
            this.updateLabelUIs();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isCineOn && this.noSkipFrameRate > 0) {
                Graphics2D g2 = (Graphics2D)g;
                Rectangle rect = this.getThumbRect();
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                FontMetrics fm = g2.getFontMetrics();
                String valString = "" + this.noSkipFrameRate;
                int sw = fm.stringWidth(valString);
                Rectangle track = this.getTrackRect();
                if (null != track && null != rect) {
                    int x = track.x + (int)((double)(track.width * this.noSkipFrameRate) / (double)(this.getMaximum() - this.getMinimum()));
                    g2.setColor(new Color(0.1f, 0.1f, 0.1f, 0.7f));
                    g2.drawString(valString, x - sw / 2, rect.y);
                    g2.setColor(new Color(1.0f, 0.5f, 0.1f, 1.0f));
                    g2.fillRect(x, rect.y + (rect.height - 4) / 2, 3, 5);
                }
            }
        }

        public Rectangle getTrackRect() {
            if (this.getUI() != null && this.getUI() instanceof AbstractNumberedThumSliderUI) {
                return ((AbstractNumberedThumSliderUI)((Object)this.getUI())).getTrackRect();
            }
            return null;
        }

        @Override
        public Rectangle getThumbRect() {
            if (this.getUI() != null && this.getUI() instanceof AbstractNumberedThumSliderUI) {
                return ((AbstractNumberedThumSliderUI)((Object)this.getUI())).getThumbRect();
            }
            return null;
        }
    }
}

