/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.cpanels;

import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.cpanels.VavBatchRxPanelUI;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.j3d.vav.VavRectPrismBatchModel;
import com.ge.med.cse.cvf.j3d.vav.ui.ObliqueBatchVc;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class VavObliqueBatchUI
extends VavBatchRxPanelUI {
    private VavRectPrismBatchModel batchModel = null;
    public static final double DEFAULT_FOV_VAL = 10.0;
    public static final double MAX_THICKNESS_FACTOR = 32.0;
    private JLabel numImagesLabel = new JLabel(NUM_IMAGES, 4);
    private JLabel spacingLabel = new JLabel(SPACING, 4);
    private JLabel thicknessLabel = new JLabel(THICKNESS, 4);
    private JLabel modeLabel = new JLabel(MODE, 4);
    private JLabel fovLabel = new JLabel(FOV, 4);
    private JTextField numImagesBox = new JTextField();
    private JTextField spacingBox = new JTextField();
    private JTextField thicknessBox = new JTextField();
    private JTextField fovBox = new JTextField();
    private JComboBox modeBox = new JComboBox();
    private ObliqueBatchVc rectPrismVc = null;

    public VavObliqueBatchUI() {
        this.batchModel = new VavRectPrismBatchModel(VVBatchProtocol.createDefaultProtocol());
        this.initUI();
    }

    @Override
    public void panelStart() {
        this.batchModel.addPropertyChangeListener("BATCHMODEL_UPDATED_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("NUM_IMAGES_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("FOV_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("RENDER_MODE_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("SPACING_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("THICKNESS_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("CENTER_POINT_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("NORMAL_VEC_PROPERTY", this);
        this.updateFromModel();
        J3DViewport vp = (J3DViewport)this.batchModel.getTargetPort();
        if (vp != null) {
            vp.lockViewType(true);
        }
        this.postVc();
    }

    @Override
    public void panelStop() {
        this.removeVc();
        if (this.batchModel != null) {
            this.batchModel.removePropertyChangeListener("BATCHMODEL_UPDATED_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("NUM_IMAGES_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("FOV_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("RENDER_MODE_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("SPACING_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("THICKNESS_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("CENTER_POINT_PROPERTY", this);
            this.batchModel.removePropertyChangeListener("NORMAL_VEC_PROPERTY", this);
            J3DViewport vp = (J3DViewport)this.batchModel.getTargetPort();
            if (vp != null) {
                vp.lockViewType(false);
            }
        }
    }

    private void initUI() {
        this.setBackground(UIManager.getColor("P8"));
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPanel.setBackground(null);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbconst = new GridBagConstraints();
        gbconst.gridx = 0;
        gbconst.gridy = 0;
        gbconst.anchor = 13;
        gbconst.insets = new Insets(2, 0, 2, 2);
        mainPanel.add((Component)this.numImagesLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 0;
        gbconst.anchor = 17;
        gbconst.insets = new Insets(2, 2, 2, 0);
        this.numImagesBox.setEditable(true);
        this.numImagesBox.setPreferredSize(new Dimension(80, 30));
        this.numImagesBox.setName(VavObliqueBatchUI.class.getName() + "_numImagesBox");
        this.numImagesBox.setText(Integer.toString(this.batchModel.getNumImages()));
        this.numImagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String nimgs = VavObliqueBatchUI.this.numImagesBox.getText().trim();
                if (nimgs.length() > 0) {
                    VavObliqueBatchUI.this.batchModel.setNumImages(Integer.parseInt(nimgs), false);
                }
                VavObliqueBatchUI.this.updateFromModel();
            }
        });
        mainPanel.add((Component)this.numImagesBox, gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 1;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.spacingLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 1;
        gbconst.insets = new Insets(2, 2, 2, 0);
        gbconst.anchor = 17;
        this.spacingBox.setEditable(true);
        this.spacingBox.setPreferredSize(new Dimension(80, 30));
        this.spacingBox.setName(VavObliqueBatchUI.class.getName() + "_spacingBox");
        this.spacingBox.setText(Double.toString(this.batchModel.getSpacing()));
        this.spacingBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String spc = VavObliqueBatchUI.this.spacingBox.getText().trim();
                if (spc.length() > 0) {
                    VavObliqueBatchUI.this.batchModel.setSpacing(Double.parseDouble(spc), true);
                }
                VavObliqueBatchUI.this.updateFromModel();
            }
        });
        mainPanel.add((Component)this.spacingBox, gbconst);
        gbconst.gridx = 2;
        gbconst.gridy = 1;
        gbconst.insets = new Insets(0, 2, 0, 0);
        gbconst.anchor = 17;
        mainPanel.add((Component)new JLabel("mm"), gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 2;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.thicknessLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 2;
        gbconst.insets = new Insets(2, 2, 2, 0);
        gbconst.anchor = 17;
        this.thicknessBox.setEditable(true);
        this.thicknessBox.setPreferredSize(new Dimension(80, 30));
        this.thicknessBox.setName(VavObliqueBatchUI.class.getName() + "_thicknessBox");
        this.thicknessBox.setText(Double.toString(this.batchModel.getThickness()));
        this.thicknessBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String thk = VavObliqueBatchUI.this.thicknessBox.getText().trim();
                if (thk.length() > 0) {
                    VavObliqueBatchUI.this.batchModel.setThickness(Double.parseDouble(thk));
                }
                VavObliqueBatchUI.this.updateFromModel();
            }
        });
        mainPanel.add((Component)this.thicknessBox, gbconst);
        gbconst.gridx = 2;
        gbconst.gridy = 2;
        gbconst.insets = new Insets(0, 2, 0, 0);
        gbconst.anchor = 17;
        mainPanel.add((Component)new JLabel("mm"), gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 3;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.modeLabel, gbconst);
        this.modeBox.setName(VavObliqueBatchUI.class.getName() + "_modeBox");
        this.modeBox.addItem(AVG);
        this.modeBox.addItem(MINIP);
        this.modeBox.addItem(MIP);
        this.modeBox.setFocusable(false);
        this.modeBox.setPreferredSize(new Dimension(80, 35));
        this.modeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VavObliqueBatchUI.this.modeBox.getSelectedItem().equals("AVG")) {
                    VavObliqueBatchUI.this.batchModel.setRenderStyle("MAJOR_AXIS_AVERAGE");
                } else if (VavObliqueBatchUI.this.modeBox.getSelectedItem().equals("MINIP")) {
                    VavObliqueBatchUI.this.batchModel.setRenderStyle("MAJOR_AXIS_MINIP");
                } else if (VavObliqueBatchUI.this.modeBox.getSelectedItem().equals("MIP")) {
                    VavObliqueBatchUI.this.batchModel.setRenderStyle("MAJOR_AXIS_MIP");
                }
            }
        });
        gbconst.gridx = 1;
        gbconst.gridy = 3;
        gbconst.anchor = 17;
        gbconst.insets = new Insets(2, 2, 2, 0);
        mainPanel.add((Component)this.modeBox, gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 4;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.fovLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 4;
        gbconst.insets = new Insets(2, 2, 2, 2);
        gbconst.anchor = 17;
        this.fovBox.setEditable(true);
        this.fovBox.setPreferredSize(new Dimension(80, 30));
        this.fovBox.setName(VavObliqueBatchUI.class.getName() + "_fovBox");
        this.fovBox.setText(Double.toString(this.batchModel.getFov() / 10.0));
        this.fovBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String fov = VavObliqueBatchUI.this.fovBox.getText().trim();
                if (fov.length() > 0) {
                    Double value = Double.parseDouble(fov) * 10.0;
                    VavObliqueBatchUI.this.batchModel.setFov(value);
                }
                VavObliqueBatchUI.this.updateFromModel();
            }
        });
        mainPanel.add((Component)this.fovBox, gbconst);
        gbconst.gridx = 2;
        gbconst.gridy = 4;
        gbconst.insets = new Insets(0, 2, 0, 0);
        gbconst.anchor = 17;
        mainPanel.add((Component)new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_CM")), gbconst);
        this.add((Component)mainPanel, "North");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("BATCHMODEL_UPDATED_PROPERTY")) {
            this.updateFromModel();
        } else if (evt.getPropertyName().equalsIgnoreCase("NUM_IMAGES_PROPERTY")) {
            this.numImagesBox.setText(Integer.toString(this.batchModel.getNumImages()));
        } else if (evt.getPropertyName().equalsIgnoreCase("FOV_PROPERTY")) {
            this.fovBox.setText(formatter.format(this.batchModel.getFov() / 10.0));
        } else if (evt.getPropertyName().equalsIgnoreCase("RENDER_MODE_PROPERTY")) {
            if (evt.getNewValue().equals("MAJOR_AXIS_AVERAGE") || evt.getNewValue().equals("FULLBODY_AVERAGE") || this.batchModel.getRenderStyle().equals("AVERAGE")) {
                this.modeBox.setSelectedItem("AVG");
            } else if (evt.getNewValue().equals("MAJOR_AXIS_MINIP") || evt.getNewValue().equals("FULLBODY_MINIP") || this.batchModel.getRenderStyle().equals("MINIP")) {
                this.modeBox.setSelectedItem("MINIP");
            } else if (evt.getNewValue().equals("MAJOR_AXIS_MIP") || evt.getNewValue().equals("FULLBODY_MIP") || this.batchModel.getRenderStyle().equals("MIP")) {
                this.modeBox.setSelectedItem("MIP");
            }
        } else if (evt.getPropertyName().equalsIgnoreCase("SPACING_PROPERTY")) {
            this.spacingBox.setText(formatter.format(this.batchModel.getSpacing()));
        } else if (evt.getPropertyName().equalsIgnoreCase("THICKNESS_PROPERTY")) {
            this.checkThicknessLimits(this.batchModel.getThickness());
        } else if (evt.getPropertyName().equalsIgnoreCase("CENTER_POINT_PROPERTY")) {
            this.updateFromModel();
        } else if (evt.getPropertyName().equalsIgnoreCase("NORMAL_VEC_PROPERTY")) {
            this.updateFromModel();
        }
    }

    @Override
    public void loadProtocolSelection(VVBatchProtocol protocol) {
        if (this.batchModel != null) {
            this.batchModel.loadFromProtocol(protocol);
            this.batchModel.setFov(this.batchModel.getFitToVolumeFOV());
        }
    }

    @Override
    public void setTarget(T3DViewport port) {
        this.batchModel.setTarget(port);
    }

    @Override
    public VavBatchModel getBatchModel() {
        return this.batchModel;
    }

    private void updateFromModel() {
        this.numImagesBox.setText(Integer.toString(this.batchModel.getNumImages()));
        String renderStyle = this.batchModel.getRenderStyle();
        if (renderStyle.equals("MAJOR_AXIS_AVERAGE") || renderStyle.equals("FULLBODY_AVERAGE") || renderStyle.equals("AVERAGE")) {
            this.modeBox.setSelectedItem("AVG");
        } else if (renderStyle.equals("MAJOR_AXIS_MINIP") || renderStyle.equals("FULLBODY_MINIP") || renderStyle.equals("MINIP")) {
            this.modeBox.setSelectedItem("MINIP");
        } else if (renderStyle.equals("MAJOR_AXIS_MIP") || renderStyle.equals("FULLBODY_MIP") || renderStyle.equals("MIP")) {
            this.modeBox.setSelectedItem("MIP");
        }
        this.checkThicknessLimits(this.batchModel.getThickness());
        this.spacingBox.setText(formatter.format(this.batchModel.getSpacing()));
        this.fovBox.setText(formatter.format(this.batchModel.getFov() / 10.0));
    }

    private void postVc() {
        T3DViewport targetPort = this.batchModel.getTargetPort();
        if (targetPort != null) {
            this.rectPrismVc = new ObliqueBatchVc(this.batchModel);
            targetPort.getT3DComponent().add((Component)this.rectPrismVc, 0);
            targetPort.updateUI();
            targetPort.repaint();
        }
    }

    private void removeVc() {
        if (this.rectPrismVc != null && this.rectPrismVc.getParent() != null) {
            this.rectPrismVc.shutDown();
            Container parent = this.rectPrismVc.getParent();
            this.rectPrismVc.getParent().remove((Component)this.rectPrismVc);
            parent.repaint();
            this.rectPrismVc = null;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test Batch Rx");
        VavObliqueBatchUI obliqueBatch = new VavObliqueBatchUI();
        frame.getContentPane().add(obliqueBatch);
        frame.setSize(400, 300);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    @Override
    public void setSeriesDescription(String desc) {
        this.batchModel.setSeriesDescription(desc);
    }

    private void checkThicknessLimits(double thickness) {
        if (this.batchModel != null) {
            boolean enable = false;
            double minThickness = Math.abs(J3DGeomUtils.getMinSliceThickness(this.batchModel.getTargetVolume(), this.batchModel.getSliceLookPoint(0, null), this.batchModel.getSliceEyePoint(0, null)));
            enable = thickness > minThickness;
            this.thicknessBox.setText(formatter.format(this.batchModel.getThickness()));
            this.modeBox.setEnabled(enable);
            this.modeLabel.setEnabled(enable);
        }
    }
}

