/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.cpanels;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.cpanels.VavBatchRxPanelUI;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.vav.LoopMode;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.j3d.vav.VavLoopModel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class VavLoopBatchUI
extends VavBatchRxPanelUI {
    private JLabel numImagesLabel = new JLabel(NUM_IMAGES, 4);
    private JLabel spacingLabel = new JLabel(SPACING, 4);
    private JLabel angleLabel = new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_ANGLE_IMAGES"), 4);
    private JLabel targetVp = new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_TARGET_VP") + " : ", 4);
    private JLabel targetVp_value = new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_AXIAL"));
    private JButton startBut = new JButton(CvUtils.getResourceBundle().getString("XP_VAV_START"));
    private JButton endBut = new JButton(CvUtils.getResourceBundle().getString("XP_VAV_END"));
    private JTextField numImagesBox = new JTextField();
    private JTextField spacingBox = new JTextField();
    private JTextField angleBox = new JTextField();
    private T3DViewport vp = null;
    private transient VavLoopModel batchModel = null;
    transient ActionListener start_end_listener = new ActionListener(){
        private boolean startSet = false;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase("Start")) {
                JComponent selected_port = null;
                XPscreen screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, VavLoopBatchUI.this.vp);
                if (screen != null) {
                    selected_port = screen.getSelectedPort();
                }
                if (selected_port != null && selected_port instanceof T3DViewport && !VavLoopBatchUI.this.vp.equals((T3DViewport)selected_port)) {
                    VavLoopBatchUI.this.vp = (T3DViewport)selected_port;
                }
                VavLoopBatchUI.this.batchModel.setTarget(VavLoopBatchUI.this.vp);
                if (VavLoopBatchUI.this.vp != null && VavLoopBatchUI.this.vp instanceof ViewTypeCapable) {
                    this.startSet = true;
                    VavLoopBatchUI.this.endBut.setEnabled(true);
                    String viewType = ((ViewTypeCapable)((Object)VavLoopBatchUI.this.vp)).getViewType();
                    VavLoopBatchUI.this.targetVp_value.setText(viewType.toLowerCase());
                    VavLoopBatchUI.this.numImagesLabel.setEnabled(true);
                    VavLoopBatchUI.this.numImagesBox.setEnabled(true);
                    if (viewType.equalsIgnoreCase("AXIAL") || viewType.equalsIgnoreCase("CORONAL") || viewType.equalsIgnoreCase("SAGITTAL")) {
                        VavLoopBatchUI.this.batchModel.setMode(LoopMode.PAGE);
                        VavLoopBatchUI.this.angleLabel.setEnabled(false);
                        VavLoopBatchUI.this.angleBox.setEnabled(false);
                        VavLoopBatchUI.this.spacingLabel.setEnabled(false);
                        VavLoopBatchUI.this.spacingBox.setEnabled(false);
                    } else if (viewType.equalsIgnoreCase("OBLIQUE")) {
                        VavLoopBatchUI.this.batchModel.setMode(LoopMode.BOTH);
                        if (VavLoopBatchUI.this.batchModel.getAngleBetweenViews() > 0.0) {
                            VavLoopBatchUI.this.angleBox.setEnabled(true);
                            VavLoopBatchUI.this.angleLabel.setEnabled(true);
                        } else {
                            VavLoopBatchUI.this.angleBox.setEnabled(false);
                            VavLoopBatchUI.this.angleLabel.setEnabled(false);
                        }
                        if (VavLoopBatchUI.this.batchModel.getSpacing() > 0.0) {
                            VavLoopBatchUI.this.spacingLabel.setEnabled(true);
                            VavLoopBatchUI.this.spacingBox.setEnabled(true);
                        } else {
                            VavLoopBatchUI.this.spacingLabel.setEnabled(false);
                            VavLoopBatchUI.this.spacingBox.setEnabled(false);
                        }
                    } else if (viewType.equalsIgnoreCase("3D")) {
                        VavLoopBatchUI.this.batchModel.setMode(LoopMode.ROTATE);
                        VavLoopBatchUI.this.angleLabel.setEnabled(true);
                        VavLoopBatchUI.this.angleBox.setEnabled(true);
                        VavLoopBatchUI.this.spacingLabel.setEnabled(false);
                        VavLoopBatchUI.this.spacingBox.setEnabled(false);
                    }
                    VavLoopBatchUI.this.batchModel.setStart();
                    VavLoopBatchUI.this.updateTextFields();
                }
            } else if (e.getActionCommand().equalsIgnoreCase("End") && this.startSet) {
                VavLoopBatchUI.this.batchModel.setEnd();
                VavLoopBatchUI.this.numImagesLabel.setEnabled(true);
                VavLoopBatchUI.this.numImagesBox.setEnabled(true);
                if (VavLoopBatchUI.this.batchModel.getMode().equals((Object)LoopMode.PAGE)) {
                    VavLoopBatchUI.this.spacingLabel.setEnabled(true);
                    VavLoopBatchUI.this.spacingBox.setEnabled(true);
                } else if (VavLoopBatchUI.this.batchModel.getMode().equals((Object)LoopMode.ROTATE)) {
                    VavLoopBatchUI.this.angleLabel.setEnabled(true);
                    VavLoopBatchUI.this.angleBox.setEnabled(true);
                } else if (VavLoopBatchUI.this.batchModel.getMode().equals((Object)LoopMode.BOTH)) {
                    if (VavLoopBatchUI.this.batchModel.getAngleBetweenViews() > 0.0) {
                        VavLoopBatchUI.this.angleBox.setEnabled(true);
                        VavLoopBatchUI.this.angleLabel.setEnabled(true);
                    } else {
                        VavLoopBatchUI.this.angleBox.setEnabled(false);
                        VavLoopBatchUI.this.angleLabel.setEnabled(false);
                    }
                    if (VavLoopBatchUI.this.batchModel.getSpacing() > 0.0) {
                        VavLoopBatchUI.this.spacingLabel.setEnabled(true);
                        VavLoopBatchUI.this.spacingBox.setEnabled(true);
                    } else {
                        VavLoopBatchUI.this.spacingLabel.setEnabled(false);
                        VavLoopBatchUI.this.spacingBox.setEnabled(false);
                    }
                }
                VavLoopBatchUI.this.updateTextFields();
            }
        }
    };

    public VavLoopBatchUI() {
        this.batchModel = new VavLoopModel();
        this.initUI();
    }

    @Override
    public void panelStart() {
        this.batchModel.addPropertyChangeListener("NUM_IMAGES_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("ANGLE_BETWEEN_VIEWS_PROPERTY", this);
        this.batchModel.addPropertyChangeListener("SPACING_PROPERTY", this);
    }

    @Override
    public void panelStop() {
        this.batchModel.removePropertyChangeListener("NUM_IMAGES_PROPERTY", this);
        this.batchModel.removePropertyChangeListener("ANGLE_BETWEEN_VIEWS_PROPERTY", this);
        this.batchModel.removePropertyChangeListener("SPACING_PROPERTY", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("NUM_IMAGES_PROPERTY")) {
            this.numImagesBox.setText(((Integer)evt.getNewValue()).toString());
        } else if (evt.getPropertyName().equalsIgnoreCase("SPACING_PROPERTY")) {
            this.spacingBox.setText(formatter.format(this.batchModel.getSpacing()));
        } else if (evt.getPropertyName().equalsIgnoreCase("ANGLE_BETWEEN_VIEWS_PROPERTY")) {
            this.angleBox.setText(formatter.format(this.batchModel.getAngleBetweenViews()));
        }
    }

    private void initUI() {
        this.setBackground(UIManager.getColor("P8"));
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPanel.setBackground(null);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbconst = new GridBagConstraints();
        gbconst.gridx = 0;
        gbconst.gridy = 0;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.numImagesLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 0;
        gbconst.insets = new Insets(2, 2, 2, 0);
        gbconst.anchor = 17;
        this.numImagesBox.setText("10");
        this.numImagesBox.setPreferredSize(new Dimension(80, 30));
        this.numImagesBox.setName(VavLoopBatchUI.class.getName() + "_numImages");
        this.numImagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VavLoopBatchUI.this.batchModel.setNumImages(Integer.parseInt(VavLoopBatchUI.this.numImagesBox.getText()));
                VavLoopBatchUI.this.spacingBox.setText(VavBatchRxPanelUI.formatter.format(VavLoopBatchUI.this.batchModel.getSpacing()));
                VavLoopBatchUI.this.angleBox.setText(VavBatchRxPanelUI.formatter.format(VavLoopBatchUI.this.batchModel.getAngleBetweenViews()));
            }
        });
        mainPanel.add((Component)this.numImagesBox, gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 1;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.spacingLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 1;
        gbconst.insets = new Insets(2, 2, 2, 2);
        gbconst.anchor = 17;
        this.spacingBox.setText("1.0");
        this.spacingBox.setPreferredSize(new Dimension(80, 30));
        this.spacingBox.setName(VavLoopBatchUI.class.getName() + "_spacing");
        this.spacingBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VavLoopBatchUI.this.checkSpacingLimits(Double.parseDouble(VavLoopBatchUI.this.spacingBox.getText()));
                VavLoopBatchUI.this.angleBox.setText(VavBatchRxPanelUI.formatter.format(VavLoopBatchUI.this.batchModel.getAngleBetweenViews()));
                VavLoopBatchUI.this.numImagesBox.setText(Integer.toString(VavLoopBatchUI.this.batchModel.getNumImages()));
            }
        });
        mainPanel.add((Component)this.spacingBox, gbconst);
        gbconst.gridx = 2;
        gbconst.gridy = 1;
        gbconst.insets = new Insets(0, 2, 0, 0);
        gbconst.anchor = 17;
        mainPanel.add((Component)new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_MM")), gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 2;
        gbconst.insets = new Insets(2, 0, 2, 2);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.angleLabel, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 2;
        gbconst.insets = new Insets(2, 2, 2, 0);
        gbconst.anchor = 17;
        this.angleBox.setText(Double.toString(this.batchModel.getAngleBetweenViews()));
        this.angleBox.setPreferredSize(new Dimension(80, 30));
        this.angleBox.setName(VavLoopBatchUI.class.getName() + "_angle");
        this.angleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VavLoopBatchUI.this.batchModel.setAngleBetweenViews(Double.parseDouble(VavLoopBatchUI.this.angleBox.getText()));
                VavLoopBatchUI.this.numImagesBox.setText(Integer.toString(VavLoopBatchUI.this.batchModel.getNumImages()));
                VavLoopBatchUI.this.spacingBox.setText(VavBatchRxPanelUI.formatter.format(VavLoopBatchUI.this.batchModel.getSpacing()));
            }
        });
        mainPanel.add((Component)this.angleBox, gbconst);
        gbconst.gridx = 0;
        gbconst.gridy = 3;
        gbconst.insets = new Insets(2, 0, 2, 0);
        gbconst.anchor = 13;
        mainPanel.add((Component)this.targetVp, gbconst);
        gbconst.gridx = 1;
        gbconst.gridy = 3;
        gbconst.insets = new Insets(2, 4, 2, 0);
        gbconst.anchor = 17;
        mainPanel.add((Component)this.targetVp_value, gbconst);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        panel1.setBackground(null);
        this.startBut.setFocusable(false);
        this.endBut.setFocusable(false);
        this.endBut.setEnabled(false);
        this.startBut.setActionCommand("Start");
        this.endBut.setActionCommand("End");
        this.startBut.setName(VavLoopBatchUI.class.getName() + "_start");
        this.endBut.setName(VavLoopBatchUI.class.getName() + "_end");
        this.startBut.addActionListener(this.start_end_listener);
        this.endBut.addActionListener(this.start_end_listener);
        panel1.add((Component)this.startBut, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(2, 20, 2, 10), 0, 0));
        panel1.add((Component)this.endBut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(2, 5, 2, 10), 0, 0));
        mainPanel.add((Component)panel1, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)mainPanel, "North");
    }

    @Override
    public VavBatchModel getBatchModel() {
        return this.batchModel;
    }

    @Override
    public void loadProtocolSelection(VVBatchProtocol protocol) {
    }

    @Override
    public void setTarget(T3DViewport port) {
        this.vp = port;
        this.batchModel.setTarget(this.vp);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test Batch Rx");
        VavLoopBatchUI loopBatch = new VavLoopBatchUI();
        frame.getContentPane().add(loopBatch);
        frame.setSize(300, 200);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    @Override
    public void setSeriesDescription(String desc) {
        this.batchModel.setSeriesDescription(desc);
    }

    private void checkSpacingLimits(double spacing) {
        double spacingVal = spacing;
        boolean oblique = false;
        if (this.batchModel.getTargetPort() != null) {
            double minThickness = J3DGeomUtils.getMinSliceThickness(this.batchModel.getTargetPort().getVolume(), this.batchModel.getSliceLookPoint(0, null), this.batchModel.getSliceEyePoint(0, null), oblique);
            if (spacingVal < minThickness) {
                spacingVal = minThickness;
            } else if (spacingVal > J3DGeomUtils.getMaxSpacing(this.batchModel.getTargetPort().getVolume())) {
                spacingVal = J3DGeomUtils.getMaxSpacing(this.batchModel.getTargetPort().getVolume());
            }
            this.batchModel.setSpacing(Double.parseDouble(formatter.format(spacingVal)));
            this.spacingBox.setText(formatter.format(spacingVal));
        }
    }

    private void updateTextFields() {
        this.numImagesBox.setText(Integer.toString(this.batchModel.getNumImages()));
        this.spacingBox.setText(formatter.format(this.batchModel.getSpacing()));
        this.angleBox.setText(formatter.format(this.batchModel.getAngleBetweenViews()));
    }
}

