/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.cpanels;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.action.VavBatchSaveAction;
import com.ge.med.cse.cvf.j3d.cpanels.SaveAsProtocolDialog;
import com.ge.med.cse.cvf.j3d.cpanels.VavBatchProgressPanel;
import com.ge.med.cse.cvf.j3d.cpanels.VavBatchRxPanelUI;
import com.ge.med.cse.cvf.j3d.cpanels.VavPreviewPanel;
import com.ge.med.cse.cvf.j3d.ui.VavProtocolSelectionUI;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.j3d.vav.VavBatchPreviewViewType;
import com.ge.med.cse.cvf.ui.XpGridButtonPanel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.CineCapable;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VavBatchRxPanel
extends XPcaAutoControlPanel {
    private String appIdentifier;
    private JTabbedPane modeSelectionTab = new JTabbedPane();
    private JPanel protocol_panel = new JPanel();
    private JLabel protocols_label = new JLabel(CvUtils.getResourceBundle().getString("Xp_VAV_PROTOCOL"), 2);
    private VavProtocolSelectionUI protocolListComboBox = new VavProtocolSelectionUI();
    private JLabel more_label = new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_MORE"), 2);
    private JButton exit = new JButton();
    private static final String PREVIEW = CvUtils.getResourceBundle().getString("XP_VAV_PREVIEW");
    private static final String OK = CvUtils.getResourceBundle().getString("XP_BUT_OK");
    private static final String SAVE_AS_PROTOCOL = CvUtils.getResourceBundle().getString("XP_VAV_SAVE_AS_PROTOCOL");
    private static final String CANCEL = CvUtils.getResourceBundle().getString("XP_BUT_CANCEL");
    private JPanel previewSavePanel = new JPanel();
    private JLabel seriesDescLabel = new JLabel(CvUtils.getResourceBundle().getString("XP_VAV_SERIES_DESC") + " : ", 4);
    private JComboBox seriesDesctBox = new JComboBox();
    private JButton previewButton = new JButton(PREVIEW);
    private JButton okButton = new JButton(OK);
    private JButton cancelButton = new JButton(CANCEL);
    private JButton saveAsProtocolButton = new JButton(SAVE_AS_PROTOCOL);
    private JCheckBox save = new JCheckBox(CvUtils.getResourceBundle().getString("XP_PRESET_SAVE"), true);
    private JCheckBox film = new JCheckBox(CvUtils.getResourceBundle().getString("XP_FILM_LEVEL"));
    private JCheckBox referenceOn = new JCheckBox("Ref", CvPropertiesManager.getBoolean("vav.referenceframe", false));
    private static final String OBLIQUE = CvUtils.getResourceBundle().getString("XP_VAV_OBLIQUE");
    private static final String ROTATE = CvUtils.getResourceBundle().getString("XP_VAV_ROTATE");
    private static final String LOOP = CvUtils.getResourceBundle().getString("XP_VAV_LOOP");
    private static final String FAN = CvUtils.getResourceBundle().getString("XP_VAV_FAN");
    private JPanel mainPanel = new JPanel();
    private XPscreen screen_ = null;
    private CardLayout cardLayout = new CardLayout();
    static final String batchPanel_name = "BatchPanel";
    static final String previewPanel_name = "PreviewPanel";
    static final String progressPanel_name = "ProgressPanel";
    private VavBatchProgressPanel progressPanel = new VavBatchProgressPanel();
    private VavPreviewPanel previewPanel = new VavPreviewPanel();
    private transient ActionListenerImpl listener = new ActionListenerImpl();
    private boolean refOn = true;
    public static final String CLOSE_PANEL = "close_panel";
    transient ChangeListener change_listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            VavBatchRxPanel.this.changeTab(VavBatchRxPanel.this.modeSelectionTab.getSelectedIndex());
        }
    };
    transient ActionListener saveFilm_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (VavBatchRxPanel.this.save.isSelected() || VavBatchRxPanel.this.film.isSelected()) {
                VavBatchRxPanel.this.okButton.setEnabled(true);
            } else {
                VavBatchRxPanel.this.okButton.setEnabled(false);
            }
        }
    };
    transient ActionListener refImage_listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println(" In the ref Image listener");
            if (VavBatchRxPanel.this.referenceOn.isSelected()) {
                VavBatchRxPanel.this.setRefOn(true);
                System.out.println(" In the ref Image listener on");
            } else {
                VavBatchRxPanel.this.setRefOn(false);
            }
        }
    };
    private transient VavBatchModel model = null;
    private String prevView = null;
    private T3DViewport prevPort = null;
    private VavBatchRxPanelUI prevSelectedTab = null;
    private double[] pre_eyept = new double[3];
    private double[] pre_lookpt = new double[3];
    private double[] pre_up = new double[3];
    private String pre_renderStyle = null;
    private double[] pre_viewClip = null;
    private double prev_dfov = 0.0;
    transient PropertyChangeListener close_listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue().toString().equals(VavBatchRxPanel.previewPanel_name)) {
                if (VavBatchRxPanel.this.prevPort instanceof ViewTypeCapable) {
                    ((ViewTypeCapable)((Object)VavBatchRxPanel.this.prevPort)).setViewType(VavBatchRxPanel.this.prevView);
                }
                VavBatchRxPanel.this.prevPort.setViewClip(VavBatchRxPanel.this.pre_viewClip);
                VavBatchRxPanel.this.prevPort.setCamera(VavBatchRxPanel.this.pre_eyept, VavBatchRxPanel.this.pre_lookpt, VavBatchRxPanel.this.pre_up);
                VavBatchRxPanel.this.prevPort.setViewHeight(VavBatchRxPanel.this.prev_dfov);
                VavBatchRxPanel.this.prevPort.setRenderStyle(VavBatchRxPanel.this.pre_renderStyle);
                VavBatchRxPanel.this.prevPort.repaint();
                VavBatchRxPanel.this.prevSelectedTab.panelStart();
                VavBatchRxPanel.this.showpanel(VavBatchRxPanel.batchPanel_name);
            } else if (evt.getNewValue().toString().equals(VavBatchRxPanel.progressPanel_name)) {
                VavBatchRxPanel.this.showpanel(VavBatchRxPanel.batchPanel_name);
            }
        }
    };

    public boolean isRefOn() {
        return this.refOn;
    }

    public void setRefOn(boolean refOn) {
        this.refOn = refOn;
    }

    public VavBatchRxPanel() {
        this.setName("VavBatchRxPanel");
        this.setIcon(CvUtils.getIcon("XP_BATCH_ICON"));
        this.initUI();
        this.progressPanel.addPropertyChangeListener(CLOSE_PANEL, this.close_listener);
        this.previewPanel.addPropertyChangeListener(CLOSE_PANEL, this.close_listener);
        this.previewPanel.setVisible(false);
        this.progressPanel.setVisible(false);
        this.setAll(true);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (this.checkCineStatus()) {
            return;
        }
        int selectionIndex = this.protocolListComboBox.getSelectedIndex();
        if (this.protocolListComboBox.getItemCount() > 0) {
            if (selectionIndex == -1) {
                this.protocolListComboBox.setSelectedIndex(0);
            } else {
                this.protocolListComboBox.setSelectedIndex(selectionIndex);
            }
        }
    }

    @Override
    public void panelStop() {
        super.panelStop();
        if (this.previewPanel.isVisible()) {
            this.previewPanel.panelStop();
            if (this.prevPort instanceof ViewTypeCapable) {
                ((ViewTypeCapable)((Object)this.prevPort)).setViewType(this.prevView);
            }
            this.prevPort.repaint();
        }
        this.showpanel(batchPanel_name);
        this.removeVcs();
    }

    private void initUI() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setBackground(null);
        this.setLayout(this.cardLayout);
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbconst = new GridBagConstraints();
        this.protocolListComboBox.setFocusable(false);
        this.protocolListComboBox.addActionListener(new comboboxListenerImpl());
        this.more_label.setName(VavBatchRxPanel.class.getName() + "_moreLabel");
        this.more_label.setCursor(new Cursor(12));
        this.more_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (VavBatchRxPanel.this.more_label.isEnabled()) {
                    VavBatchRxPanel.this.protocolListComboBox.loadBatchProtocolList();
                    VavBatchRxPanel.this.protocolListComboBox.setPreferredSize(new Dimension(200, 35));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (VavBatchRxPanel.this.more_label.isEnabled()) {
                    VavBatchRxPanel.this.more_label.setEnabled(false);
                    VavBatchRxPanel.this.protocolListComboBox.setPopupVisible(true);
                }
            }
        });
        this.exit.setIcon(CvUtils.getIcon("XP_BATCH_CLOSE_ICON"));
        this.exit.addActionListener(this.listener);
        this.exit.setActionCommand("Exit");
        this.exit.setBackground(UIManager.getColor("p10"));
        this.exit.setToolTipText(CvUtils.getResourceBundle().getString("XP_CLOSE_APP_TOOLTIP"));
        this.exit.setName(VavBatchRxPanel.class.getName() + "_exit");
        this.exit.setFocusPainted(false);
        this.exit.setFocusable(false);
        this.exit.setBorder(null);
        this.exit.setForeground(UIManager.getColor("P3"));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JPanel topPanel1 = new JPanel();
        topPanel1.setLayout(new BorderLayout());
        topPanel1.setBorder(null);
        topPanel1.setBackground(UIManager.getColor("P9"));
        JPanel exitPanel = new JPanel();
        exitPanel.setBorder(null);
        exitPanel.setLayout(new GridBagLayout());
        exitPanel.add((Component)this.exit, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel1.add((Component)exitPanel, "East");
        topPanel.add((Component)topPanel1, "North");
        this.protocol_panel.setLayout(new GridBagLayout());
        this.protocol_panel.setBackground(UIManager.getColor("P9"));
        this.protocol_panel.add((Component)this.protocols_label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 2, 2), 0, 0));
        this.protocol_panel.add((Component)this.protocolListComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 2, 2), 0, 0));
        this.protocol_panel.add((Component)this.more_label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 2, 2), 0, 0));
        gbconst.anchor = 11;
        gbconst.fill = 17;
        gbconst.insets = new Insets(2, 2, 2, 2);
        gbconst.gridx = 0;
        gbconst.gridy = 0;
        this.mainPanel.add((Component)this.protocol_panel, gbconst);
        gbconst.anchor = 11;
        gbconst.fill = 10;
        gbconst.insets = new Insets(2, 2, 2, 2);
        gbconst.gridx = 0;
        gbconst.gridy = 1;
        this.modeSelectionTab.setBackground(UIManager.getColor("p10"));
        this.mainPanel.add((Component)this.modeSelectionTab, gbconst);
        this.seriesDesctBox.addItem("Processed Images");
        this.seriesDesctBox.setEditable(true);
        this.seriesDesctBox.setName(VavBatchRxPanel.class.getName() + "_seriesDescription");
        this.seriesDesctBox.setPreferredSize(new Dimension(155, 35));
        this.protocolListComboBox.setName(VavBatchRxPanel.class.getName() + "_protocolList");
        this.protocolListComboBox.setPreferredSize(new Dimension(100, 35));
        this.modeSelectionTab.setName(VavBatchRxPanel.class.getName() + "_modeSelectionTab");
        this.okButton.setName(VavBatchRxPanel.class.getName() + "_okButton");
        this.cancelButton.setName(VavBatchRxPanel.class.getName() + "_cancelButton");
        this.saveAsProtocolButton.setName(VavBatchRxPanel.class.getName() + "_saveAsProtocolButton");
        final ArrayList editedList = new ArrayList();
        this.seriesDesctBox.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String editedValue = VavBatchRxPanel.this.seriesDesctBox.getEditor().getItem().toString().trim();
                ((VavBatchRxPanelUI)VavBatchRxPanel.this.modeSelectionTab.getSelectedComponent()).setSeriesDescription(editedValue);
                VavBatchRxPanel.this.seriesDesctBox.setSelectedItem(editedValue);
                if (editedList != null && !editedList.contains(editedValue)) {
                    editedList.add(editedValue);
                    VavBatchRxPanel.this.seriesDesctBox.addItem(editedValue);
                }
                if (VavBatchRxPanel.this.seriesDesctBox.getItemCount() > 10) {
                    VavBatchRxPanel.this.seriesDesctBox.removeItemAt(1);
                }
            }
        });
        this.save.setFocusable(false);
        this.film.setFocusable(false);
        this.save.setName(VavBatchRxPanel.class.getName() + "_save");
        this.film.setName(VavBatchRxPanel.class.getName() + "_film");
        this.save.addActionListener(this.saveFilm_listener);
        this.film.addActionListener(this.saveFilm_listener);
        this.referenceOn.setToolTipText("Reference Image ON");
        this.referenceOn.setFocusable(false);
        this.referenceOn.setName(VavBatchRxPanel.class.getName() + "_ReferenceImage");
        this.referenceOn.addActionListener(this.refImage_listener);
        this.setRefOn(this.referenceOn.isSelected());
        JLabel output = new JLabel("Output : ", 4);
        output.setFocusable(false);
        JPanel filmSave = new JPanel();
        filmSave.setBackground(UIManager.getColor("P9"));
        filmSave.setLayout(new GridBagLayout());
        filmSave.add((Component)this.save, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 5), 0, 0));
        filmSave.add((Component)this.film, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 5), 0, 0));
        filmSave.add((Component)this.referenceOn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 5), 0, 0));
        this.previewSavePanel.setLayout(new GridBagLayout());
        this.previewSavePanel.setBackground(UIManager.getColor("P9"));
        this.previewSavePanel.add((Component)this.seriesDescLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 2, 0), 0, 0));
        this.previewSavePanel.add((Component)this.seriesDesctBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 5), 0, 0));
        this.previewSavePanel.add((Component)output, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.previewSavePanel.add((Component)filmSave, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.previewSavePanel.add((Component)this.previewButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 2, 0), 0, 0));
        this.previewSavePanel.add((Component)this.okButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 30, 2, 5), 0, 0));
        this.previewSavePanel.add((Component)this.cancelButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 2, 0), 0, 0));
        this.previewSavePanel.add((Component)this.saveAsProtocolButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 30, 2, 5), 0, 0));
        gbconst.insets = new Insets(2, 2, 0, 2);
        gbconst.gridx = 0;
        gbconst.gridy = 3;
        gbconst.fill = 10;
        gbconst.anchor = 11;
        this.mainPanel.add((Component)this.previewSavePanel, gbconst);
        this.okButton.setFocusable(false);
        this.okButton.setActionCommand(OK);
        this.okButton.addActionListener(this.listener);
        this.cancelButton.setFocusable(false);
        this.cancelButton.setActionCommand(CANCEL);
        this.cancelButton.addActionListener(this.listener);
        this.saveAsProtocolButton.setFocusable(false);
        this.saveAsProtocolButton.setActionCommand(SAVE_AS_PROTOCOL);
        this.saveAsProtocolButton.addActionListener(this.listener);
        this.previewButton.setFocusable(false);
        this.previewButton.setActionCommand(PREVIEW);
        this.previewButton.setName(VavBatchRxPanel.class.getName() + "_preview");
        this.previewButton.addActionListener(this.listener);
        VavBatchRxPanelUI loop = VavBatchRxPanelUI.getBatchUI("LOOP");
        this.modeSelectionTab.add(LOOP, loop);
        JLabel loop_label = new JLabel(LOOP, 0);
        loop_label.setCursor(new Cursor(12));
        loop_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VavBatchRxPanel.this.changeTab(0);
            }
        });
        VavBatchRxPanelUI oblique = VavBatchRxPanelUI.getBatchUI("OBLIQUE");
        this.modeSelectionTab.add(OBLIQUE, oblique);
        JLabel oblique_label = new JLabel(OBLIQUE, 0);
        oblique_label.setCursor(new Cursor(12));
        oblique_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VavBatchRxPanel.this.changeTab(1);
            }
        });
        VavBatchRxPanelUI rotate = VavBatchRxPanelUI.getBatchUI("ROTATION");
        this.modeSelectionTab.add(ROTATE, rotate);
        JLabel rotate_label = new JLabel(ROTATE, 0);
        rotate_label.setCursor(new Cursor(12));
        rotate_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VavBatchRxPanel.this.changeTab(2);
            }
        });
        this.modeSelectionTab.addChangeListener(this.change_listener);
        this.mainPanel.setBackground(UIManager.getColor("P9"));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        topPanel.setBorder(BorderFactory.createEtchedBorder(0, UIManager.getColor("p10"), UIManager.getColor("p10")));
        topPanel.add((Component)this.mainPanel, "Center");
        topPanel.setBackground(UIManager.getColor("P9"));
        JPanel mainpanel1 = new JPanel();
        mainpanel1.setLayout(new BorderLayout());
        mainpanel1.setBorder(null);
        mainpanel1.add((Component)topPanel, "North");
        mainpanel1.setBackground(UIManager.getColor("P9"));
        this.add((Component)mainpanel1, batchPanel_name);
        this.showpanel(batchPanel_name);
    }

    private void changeTab(int i) {
        this.modeSelectionTab.setSelectedIndex(i);
        if (this.modeSelectionTab.getSelectedIndex() >= 0) {
            if (this.checkCineStatus()) {
                return;
            }
            JComponent port = null;
            JComponent[] ports = this.screen_.getAllPorts();
            for (int index = 0; index < ports.length; ++index) {
                VVBatchProtocol selectedProtocol;
                ViewTypeCapable vcap = (ViewTypeCapable)((Object)ports[index]);
                if (null == vcap || this.modeSelectionTab.getSelectedIndex() == 0 || null == (selectedProtocol = (VVBatchProtocol)this.protocolListComboBox.getItemAt(this.protocolListComboBox.getSelectedIndex())) || selectedProtocol.viewName == null || !selectedProtocol.viewName.toLowerCase(Locale.ENGLISH).startsWith(vcap.getViewType().toLowerCase(Locale.ENGLISH))) continue;
                port = ports[index];
                this.screen_.setComponentSelection(index);
                this.screen_.updateUI();
                this.screen_.repaint();
                break;
            }
            if (null == port) {
                port = this.screen_.getSelectedPort();
            }
            if (port != null && port instanceof T3DViewport) {
                this.removeVcs();
                if (this.modeSelectionTab.getSelectedIndex() == 0) {
                    this.protocol_panel.setVisible(false);
                } else {
                    this.protocol_panel.setVisible(true);
                }
                ((VavBatchRxPanelUI)this.modeSelectionTab.getSelectedComponent()).setTarget((T3DViewport)port);
                ((VavBatchRxPanelUI)this.modeSelectionTab.getSelectedComponent()).panelStart();
            }
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen_ = screen;
        super.setScreen(screen);
        this.previewPanel.setScreen(screen);
        this.progressPanel.setScreen(screen);
        this.appIdentifier = (String)screen.getClientProperty("APP_IDENTIFIER");
        this.protocolListComboBox.setAppIdentifier(this.appIdentifier);
    }

    private void removeVcs() {
        for (int i = 0; i < this.modeSelectionTab.getTabCount(); ++i) {
            ((VavBatchRxPanelUI)this.modeSelectionTab.getComponentAt(i)).panelStop();
        }
    }

    private void preview() {
        this.prevSelectedTab = (VavBatchRxPanelUI)this.modeSelectionTab.getSelectedComponent();
        this.model = this.prevSelectedTab.getBatchModel();
        this.prevSelectedTab.panelStop();
        JComponent port = this.model.getTargetPort();
        if (port == null) {
            port = this.getSelectedPort();
        }
        if (port instanceof T3DViewport) {
            this.prevPort = port;
            this.pre_eyept = this.prevPort.getEyePoint(null);
            this.pre_lookpt = this.prevPort.getLookPoint(null);
            this.pre_up = this.prevPort.getUp(null);
            this.pre_renderStyle = this.prevPort.getRenderStyle();
            this.pre_viewClip = this.prevPort.getViewClip(null);
            this.prev_dfov = this.prevPort.getViewHeight();
        }
        if (this.prevPort != null && this.prevPort instanceof ViewTypeCapable) {
            this.prevView = ((ViewTypeCapable)((Object)this.prevPort)).getViewType();
            ((ViewTypeCapable)((Object)port)).setViewType("Batch_Preview");
            ViewTypeCapable.ViewTypeActor view = ((ViewTypeCapable)((Object)port)).getViewType("Batch_Preview");
            if (view instanceof VavBatchPreviewViewType) {
                ((VavBatchPreviewViewType)view).setModel(this.model);
            }
            port.repaint();
        }
    }

    public void showpanel(String panelName) {
        this.cardLayout.show(this, panelName);
        this.previewPanel.setVisible(false);
        this.progressPanel.setVisible(false);
        if (panelName.equalsIgnoreCase(previewPanel_name)) {
            this.previewPanel.setVisible(true);
            this.progressPanel.setVisible(false);
        } else if (panelName.equalsIgnoreCase(progressPanel_name)) {
            this.progressPanel.setVisible(true);
            this.previewPanel.setVisible(false);
        }
    }

    @Override
    public String getTitle() {
        return "Batch";
    }

    private boolean checkCineStatus() {
        if (this.screen_ != null) {
            CineCapable cineCap = (CineCapable)this.screen_.getCapable(CineCapable.class.getName());
            return cineCap.getCine();
        }
        return false;
    }

    private class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase(PREVIEW)) {
                if (VavBatchRxPanel.this.checkCineStatus()) {
                    return;
                }
                VavBatchRxPanel.this.preview();
                VavBatchRxPanel.this.add(VavBatchRxPanel.previewPanel_name, VavBatchRxPanel.this.previewPanel);
                VavBatchRxPanel.this.showpanel(VavBatchRxPanel.previewPanel_name);
                VavBatchRxPanel.this.previewPanel.setModel(VavBatchRxPanel.this.model);
                VavBatchRxPanel.this.previewPanel.panelStart();
            } else if (e.getActionCommand().equalsIgnoreCase(OK)) {
                VavBatchModel model = ((VavBatchRxPanelUI)VavBatchRxPanel.this.modeSelectionTab.getSelectedComponent()).getBatchModel();
                if (VavBatchRxPanel.this.save.isSelected()) {
                    model.setSaving(true);
                }
                if (VavBatchRxPanel.this.film.isSelected()) {
                    model.setFilming(true);
                }
                VavBatchSaveAction batchAction = new VavBatchSaveAction();
                batchAction.setCapable(VavBatchRxPanel.this.getScreen());
                batchAction.setModel(model);
                if (VavBatchRxPanel.this.referenceOn.isSelected()) {
                    batchAction.setRefImageOn(true);
                } else {
                    batchAction.setRefImageOn(false);
                }
                batchAction.actionPerformed(e);
                VavBatchRxPanel.this.add(VavBatchRxPanel.progressPanel_name, VavBatchRxPanel.this.progressPanel);
                VavBatchRxPanel.this.showpanel(VavBatchRxPanel.progressPanel_name);
            } else if (e.getActionCommand().equalsIgnoreCase(SAVE_AS_PROTOCOL)) {
                final SaveAsProtocolDialog saveAsProtocolDialog = new SaveAsProtocolDialog(VavBatchRxPanel.this.screen_, SAVE_AS_PROTOCOL);
                saveAsProtocolDialog.setVisible(true);
                saveAsProtocolDialog.addSaveActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VavBatchModel model = ((VavBatchRxPanelUI)VavBatchRxPanel.this.modeSelectionTab.getSelectedComponent()).getBatchModel();
                        VVBatchProtocol protocol = VVBatchProtocol.createDefaultProtocol();
                        model.saveToProtocol(protocol);
                        try {
                            protocol.saveBatchProtocol(saveAsProtocolDialog.getSelectedAnatomy() + File.separator + saveAsProtocolDialog.getSeriesDescription());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                });
            } else if (e.getActionCommand().equalsIgnoreCase("Exit")) {
                if (VavBatchRxPanel.this.base_ != null) {
                    VavBatchRxPanel.this.base_.getSelector().setSelectedItem(null);
                } else {
                    XpGridButtonPanel.exitPanel();
                }
            } else if (e.getActionCommand().equalsIgnoreCase(CANCEL)) {
                VavBatchRxPanel.this.protocolListComboBox.setSelectedIndex(-1);
                VavBatchRxPanel.this.panelStop();
            }
        }
    }

    private class comboboxListenerImpl
    implements ActionListener {
        private comboboxListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (VavBatchRxPanel.this.protocolListComboBox.getSelectedIndex() >= 0) {
                if (VavBatchRxPanel.this.checkCineStatus()) {
                    return;
                }
                VVBatchProtocol selectedProtocol = (VVBatchProtocol)VavBatchRxPanel.this.protocolListComboBox.getItemAt(VavBatchRxPanel.this.protocolListComboBox.getSelectedIndex());
                JComponent port = VavBatchRxPanel.this.screen_.getSelectedPort();
                if (port != null && port instanceof T3DViewport) {
                    if (selectedProtocol.model.equalsIgnoreCase("FAN") || selectedProtocol.model.equalsIgnoreCase("ROTATION")) {
                        VavBatchRxPanel.this.changeTab(2);
                    } else if (selectedProtocol.model.equalsIgnoreCase("OBLIQUE")) {
                        VavBatchRxPanel.this.changeTab(1);
                    }
                    ((VavBatchRxPanelUI)VavBatchRxPanel.this.modeSelectionTab.getComponentAt(VavBatchRxPanel.this.modeSelectionTab.getSelectedIndex())).loadProtocolSelection(selectedProtocol);
                }
            }
        }
    }
}

