/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.cpanels;

import com.ge.med.cse.cvf.appframework.Application;
import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.j3d.vav.VavBatchJob;
import com.ge.med.cse.cvf.j3d.vav.ui.VavImageProgressVc;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class VavBatchProgressPanel
extends JPanel {
    private JTable table = null;
    private MyTableModel tbModel = new MyTableModel();
    private List<VavBatchJob> batchJobs = new ArrayList<VavBatchJob>();
    private JCheckBox prvport = new JCheckBox("PreviewPort", true);
    private JButton closeBut = new JButton("Close");
    private VavImageProgressVc progressVc = null;
    private T3DViewport port = null;
    private XPscreen screen_ = null;

    public VavBatchProgressPanel() {
        this.initUI();
    }

    private void initUI() {
        this.closeBut.setName(VavBatchProgressPanel.class.getName() + "_closeButton");
        this.setLayout(new BorderLayout());
        this.setBackground(null);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.table = new JTable(this.tbModel);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ProgressRender());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new Buttonrender());
        this.table.getColumnModel().getColumn(2).setCellEditor(new Buttonrender());
        this.table.setRowHeight(27);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(20);
        this.table.setIntercellSpacing(new Dimension(2, 2));
        this.table.setBackground(null);
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 260));
        this.table.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.prvport.setFocusable(false);
        this.prvport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VavBatchProgressPanel.this.port != null && VavBatchProgressPanel.this.progressVc != null) {
                    if (VavBatchProgressPanel.this.prvport.isSelected()) {
                        VavBatchProgressPanel.this.port.getT3DComponent().remove((Component)VavBatchProgressPanel.this.progressVc);
                        VavBatchProgressPanel.this.port.getT3DComponent().add((Component)VavBatchProgressPanel.this.progressVc);
                        VavBatchProgressPanel.this.port.getT3DComponent().invalidate();
                        VavBatchProgressPanel.this.port.getT3DComponent().repaint();
                    } else {
                        VavBatchProgressPanel.this.port.getT3DComponent().remove((Component)VavBatchProgressPanel.this.progressVc);
                        VavBatchProgressPanel.this.port.getT3DComponent().invalidate();
                        VavBatchProgressPanel.this.port.getT3DComponent().repaint();
                    }
                }
            }
        });
        this.closeBut.setFocusable(false);
        this.closeBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MyTableModel)VavBatchProgressPanel.this.table.getModel()).getDataVector().removeAllElements();
                VavBatchProgressPanel.this.firePropertyChange("close_panel", null, "ProgressPanel");
            }
        });
        JScrollPane pane = new JScrollPane(this.table);
        JPanel panel1 = new JPanel();
        panel1.setBackground(null);
        panel1.setLayout(new BorderLayout());
        panel1.add((Component)pane, "Center");
        JPanel panel2 = new JPanel();
        panel2.setBackground(null);
        panel2.setLayout(new GridBagLayout());
        panel2.setBackground(UIManager.getColor("P8"));
        panel2.add((Component)this.prvport, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 20, 10), 0, 0));
        panel2.add((Component)this.closeBut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 20, 10), 0, 0));
        JPanel panel3 = new JPanel();
        panel3.setBackground(null);
        panel3.setLayout(new BorderLayout());
        panel3.add((Component)panel1, "Center");
        panel3.add((Component)panel2, "South");
        panel3.setOpaque(true);
        this.add((Component)panel3, "North");
    }

    public void setScreen(XPscreen screen) {
        this.screen_ = screen;
        String appId = (String)this.screen_.getClientProperty("APP_IDENTIFIER");
        Application app = ContextProvider.getApplicationContext(appId).getApplication();
    }

    public String getTitle() {
        return "BatchProgress";
    }

    private class ImageProgressMonitor
    extends VavImageProgressVc {
        int index = 0;

        public ImageProgressMonitor(int indx) {
            this.index = indx;
        }

        public void taskBegin(String taskName, int totalWork) {
            T3DViewport comp = ((VavBatchJob)VavBatchProgressPanel.this.batchJobs.get(this.index)).getModel().getTargetPort();
            VavBatchProgressPanel.this.progressVc = this;
            if (comp != null) {
                VavBatchProgressPanel.this.port = comp;
                if (VavBatchProgressPanel.this.prvport.isSelected()) {
                    VavBatchProgressPanel.this.port.getT3DComponent().remove((Component)((Object)this));
                    VavBatchProgressPanel.this.port.getT3DComponent().add((Component)((Object)this));
                } else {
                    VavBatchProgressPanel.this.port.getT3DComponent().remove((Component)((Object)this));
                }
            } else {
                if (VavBatchProgressPanel.this.screen_.getPort(0) != null && VavBatchProgressPanel.this.screen_.getPort(0) instanceof T3DViewport) {
                    VavBatchProgressPanel.this.port = (T3DViewport)VavBatchProgressPanel.this.screen_.getPort(0);
                }
                if (VavBatchProgressPanel.this.prvport.isSelected()) {
                    VavBatchProgressPanel.this.port.getT3DComponent().remove((Component)((Object)this));
                    VavBatchProgressPanel.this.port.getT3DComponent().add((Component)((Object)this));
                } else {
                    VavBatchProgressPanel.this.port.getT3DComponent().remove((Component)((Object)this));
                }
            }
            super.taskBegin(taskName, totalWork);
        }

        public void taskDone(String taskName) {
            VavBatchProgressPanel.this.progressVc = null;
            super.taskDone(taskName);
        }

        public void taskFailed(String arg0, String arg1, Exception arg2) {
            VavBatchProgressPanel.this.port.getT3DComponent().remove((Component)((Object)this));
            super.taskFailed(arg0, arg1, arg2);
        }
    }

    private class BatchMonitor
    implements TaskMonitor {
        int index = 0;

        public BatchMonitor(int index) {
            this.index = index;
        }

        @Override
        public void taskBegin(String taskName, int totalWork) {
            JProgressBar comp = (JProgressBar)VavBatchProgressPanel.this.table.getColumnModel().getColumn(1).getCellRenderer().getTableCellRendererComponent(VavBatchProgressPanel.this.table, null, false, false, this.index, 1);
            comp.setMaximum(totalWork);
        }

        @Override
        public void taskDone(String taskName) {
            System.err.println("<<<<<<<task is done>>>>>>>>>>>");
        }

        @Override
        public void taskFailed(String taskName, String reason, Exception e) {
            System.err.println("<<<<<<<task is failed>>>>>>>>>>>");
        }

        @Override
        public void taskProgress(String taskName, int units) {
            VavBatchProgressPanel.this.table.getCellRenderer(this.index, 1).getTableCellRendererComponent(VavBatchProgressPanel.this.table, new Integer(units), false, false, this.index, 1);
            VavBatchProgressPanel.this.table.repaint();
        }
    }

    private class Buttonrender
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        private JButton button = new JButton("Abort");
        private int rowIndex = -1;
        private int colIndex = -1;

        public Buttonrender() {
            this.button.setActionCommand("EDIT");
            this.button.setFocusable(false);
            this.button.addActionListener(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null && value instanceof Boolean) {
                this.button.setEnabled((Boolean)value);
            }
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.rowIndex = row;
            this.colIndex = column;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.getText();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int resp;
            if (e.getActionCommand().equals("EDIT") && (resp = JOptionPane.showConfirmDialog(VavBatchProgressPanel.this, "Do u want t abort the job?", "Abort Confirm", 2)) == 0 && this.rowIndex != -1) {
                ((VavBatchJob)VavBatchProgressPanel.this.batchJobs.get(this.rowIndex)).abortJob();
            }
            this.fireEditingStopped();
        }
    }

    private class ProgressRender
    implements TableCellRenderer {
        private JProgressBar bar = new JProgressBar();

        public ProgressRender() {
            this.bar.setMaximum(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                if (value instanceof Integer) {
                    if (this.bar.getMaximum() > 0 && ((Integer)value).intValue() == this.bar.getMaximum()) {
                        return new JLabel("Done", 0);
                    }
                    this.bar.setValue((Integer)value);
                    this.bar.setStringPainted(true);
                } else {
                    return new JLabel((String)value, 0);
                }
            }
            return this.bar;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Description", "Status", "Abort"};
        private Class[] columnClasses = new Class[]{String.class, JProgressBar.class, String.class};
        Vector data = new Vector();
        private ArrayList<String> modelSerDc = new ArrayList();

        private MyTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            VavBatchJob job = (VavBatchJob)this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return this.modelSerDc.get(rowIndex);
                }
                case 1: {
                    return job.isComplete() ? "Done" : (job.isAborted() ? "Aborted" : Integer.valueOf(job.getNumFramesProcessed()));
                }
                case 2: {
                    return job.isComplete() || job.isAborted() ? new Boolean(false) : new Boolean(true);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClasses[columnIndex];
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (value != null && value instanceof VavBatchJob && rowIndex != -1) {
                this.data.add(rowIndex, value);
                this.modelSerDc.add(rowIndex, ((VavBatchJob)value).getModel().getSeriesDescription());
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        public Vector getDataVector() {
            return this.data;
        }
    }
}

