/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.cpanels;

import com.ge.med.cse.cvf.controls.CvMouseControllerUtil;
import com.ge.med.cse.cvf.idc.MouseModeCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.action.J3DDoubleObliqueViewAction;
import com.ge.med.cse.cvf.j3d.action.J3DObliqueViewAction;
import com.ge.med.cse.cvf.j3d.action.J3DPortLinkUnlinkAction;
import com.ge.med.cse.cvf.j3d.cpanels.J3DViewResetPanel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class J3DImageControlPanel
extends XPcaAutoControlPanel
implements ActionListener {
    public static final String CLOSE_APP = "close_app";
    protected transient Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    protected static int currentSelectedMode = -1;
    protected static int prevSelectedMode = -1;
    protected JPanel controlBtnPanel = null;
    protected JToggleButton linkBtn = null;
    protected JToggleButton minMaxBtn = null;
    protected JButton closeBtn = null;
    protected HashMap<Integer, AbstractButton> mouseModeToButtonMap = new HashMap();
    protected HashMap<String, Integer> buttonActionToModeMap = new HashMap();
    protected transient MouseModeCapable modeCapable = null;
    protected String appName = null;
    protected String prefix = "";
    protected static final int MOUSE_MODE_ACTION_BTN = CvMouseControllerUtil.getMouseModeToApplyButton(CvPropertiesManager.getProperties());
    protected static final String BORDER_FACTORY = "BorderFactory.class";
    protected J3DViewResetPanel j3dViewResetPanel = null;
    protected JToggleButton singleOblique = null;
    protected JToggleButton doubleOblique = null;
    protected JToggleButton dummyButton = new JToggleButton();
    private transient J3DObliqueViewAction singleObliqueAction = null;
    private transient J3DDoubleObliqueViewAction doubleObliqueAction = null;
    private transient J3DPortLinkUnlinkAction linkButtonAction = null;
    transient PropertyChangeListener j3dCineListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String modesOnCine;
            boolean isCineOn = (Boolean)evt.getNewValue();
            boolean previewPortOn = false;
            JComponent selPort = J3DImageControlPanel.this.getScreen().getSelectedPort();
            if (selPort instanceof J3DViewport) {
                J3DViewport vp = (J3DViewport)selPort;
                boolean bl = previewPortOn = vp.getViewType().equals("Batch_Preview");
            }
            if ((modesOnCine = CvPropertiesManager.getProperty(J3DImageControlPanel.this.prefix + "MouseModesEnabledDuringCineOn")) == null) {
                return;
            }
            String[] modesOnDuringCine = modesOnCine.split(",");
            ArrayList<Integer> modesOnDrngCine = new ArrayList<Integer>();
            for (int i = 0; i < modesOnDuringCine.length; ++i) {
                modesOnDrngCine.add(Integer.valueOf(modesOnDuringCine[i].trim()));
            }
            if (previewPortOn) {
                for (Map.Entry<Integer, AbstractButton> pair : J3DImageControlPanel.this.mouseModeToButtonMap.entrySet()) {
                    J3DImageControlPanel.this.mouseModeToButtonMap.get(pair.getKey()).setEnabled(!isCineOn);
                }
                J3DImageControlPanel.this.singleOblique.setEnabled(!isCineOn);
                J3DImageControlPanel.this.doubleOblique.setEnabled(!isCineOn);
                J3DImageControlPanel.this.linkBtn.setEnabled(!isCineOn);
            } else {
                for (Map.Entry<Integer, AbstractButton> pair : J3DImageControlPanel.this.mouseModeToButtonMap.entrySet()) {
                    if (modesOnDrngCine.contains(pair.getKey())) continue;
                    J3DImageControlPanel.this.mouseModeToButtonMap.get(pair.getKey()).setEnabled(!isCineOn);
                }
                J3DImageControlPanel.this.singleOblique.setEnabled(!isCineOn);
                J3DImageControlPanel.this.doubleOblique.setEnabled(!isCineOn);
            }
            if (modesOnDrngCine.size() > 0) {
                if (isCineOn) {
                    prevSelectedMode = J3DImageControlPanel.this.modeCapable.getMouseMode(MOUSE_MODE_ACTION_BTN);
                    if (!modesOnDrngCine.contains(prevSelectedMode)) {
                        J3DImageControlPanel.this.modeCapable.setMouseMode(Integer.parseInt(CvPropertiesManager.getProperty(J3DImageControlPanel.this.prefix + "DefaultMouseModeDuringCineOn", "3")), MOUSE_MODE_ACTION_BTN);
                    }
                } else {
                    J3DImageControlPanel.this.modeCapable.setMouseMode(prevSelectedMode, MOUSE_MODE_ACTION_BTN);
                }
            }
        }
    };
    transient PropertyChangeListener selectionChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            J3DImageControlPanel.this.setMouseModeCapable();
            if (J3DImageControlPanel.this.controlBtnPanel.getComponentCount() == 0) {
                J3DImageControlPanel.this.addControllers();
            }
        }
    };
    transient PropertyChangeListener mouseModeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int newMode;
            Integer[] newValue = (Integer[])evt.getNewValue();
            if (newValue.length == 2 && currentSelectedMode != (newMode = newValue[0].intValue())) {
                currentSelectedMode = newMode;
                if (J3DImageControlPanel.this.mouseModeToButtonMap.get(newMode) != null) {
                    J3DImageControlPanel.this.mouseModeToButtonMap.get(newMode).setSelected(true);
                }
            }
        }
    };

    public J3DImageControlPanel() {
        try {
            this.appName = "J3D";
            if (this.appName != null || this.appName != "") {
                this.prefix = this.appName + ".";
            }
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public J3DImageControlPanel(String appName) {
        try {
            this.appName = appName;
            if (this.appName != null || this.appName != "") {
                this.prefix = this.appName + ".";
            }
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.log(Level.SEVERE, "Image control panel creation failed." + ex);
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(null);
        this.setLayout(new GridBagLayout());
        this.setName("J3DImageControlPanel");
        this.controlBtnPanel = new JPanel();
        this.controlBtnPanel.setLayout(new GridBagLayout());
        if (null != UIManager.getColor("P8")) {
            this.controlBtnPanel.setBackground(UIManager.getColor("P8"));
        }
        this.singleOblique = new JToggleButton();
        this.singleOblique.setFocusPainted(false);
        this.singleOblique.setFocusable(false);
        this.singleOblique.setBackground(null);
        this.singleOblique.setBorder(null);
        if (null != UIManager.getColor("P3")) {
            this.singleOblique.setForeground(UIManager.getColor("P3"));
        }
        this.singleOblique.setIcon(CvUtils.getIcon("XP_SINGLE_OBLIQUE_ICON"));
        this.singleObliqueAction = new J3DObliqueViewAction();
        this.singleOblique.addItemListener(this.singleObliqueAction);
        this.singleOblique.setName("SINGLE_OBLIQUE_CONTROLLER_BUTTON");
        this.doubleOblique = new JToggleButton();
        this.doubleOblique.setFocusPainted(false);
        this.doubleOblique.setFocusable(false);
        this.doubleOblique.setBackground(null);
        this.doubleOblique.setBorder(null);
        if (null != UIManager.getColor("P3")) {
            this.doubleOblique.setForeground(UIManager.getColor("P3"));
        }
        this.doubleOblique.setIcon(CvUtils.getIcon("XP_DOUBLE_OBLIQUE_ICON"));
        this.doubleObliqueAction = new J3DDoubleObliqueViewAction();
        this.doubleOblique.addItemListener(this.doubleObliqueAction);
        this.doubleOblique.setName("DOUBLE_OBLIQUE_CONTROLLER_BUTTON");
        ModifiedButtonGroup bg = new ModifiedButtonGroup();
        bg.add(this.doubleOblique);
        bg.add(this.singleOblique);
        bg.add(this.dummyButton);
        JPanel obliqueControllers = new JPanel();
        obliqueControllers.setLayout(new GridBagLayout());
        if (null != UIManager.getColor("P8")) {
            obliqueControllers.setBackground(UIManager.getColor("P8"));
        }
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0);
        obliqueControllers.add((Component)this.singleOblique, c);
        c = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0);
        obliqueControllers.add((Component)this.doubleOblique, c);
        this.linkBtn = new JToggleButton();
        this.linkBtn.setFocusPainted(false);
        this.linkBtn.setFocusable(false);
        this.linkBtn.setBackground(null);
        this.linkBtn.setBorder(null);
        if (null != UIManager.getColor("P3")) {
            this.linkBtn.setForeground(UIManager.getColor("P3"));
        }
        this.linkBtn.setIcon(CvUtils.getIcon("XP_UNLINK_PORT_ICON"));
        this.linkBtn.setSelectedIcon(CvUtils.getIcon("XP_LINK_PORT_ICON"));
        this.linkBtn.setName(J3DImageControlPanel.class.getName() + "link_button");
        this.linkButtonAction = new J3DPortLinkUnlinkAction();
        this.linkBtn.addItemListener(this.linkButtonAction);
        JPanel linkButtonPanel = new JPanel();
        linkButtonPanel.setLayout(new BorderLayout());
        linkButtonPanel.setName(J3DImageControlPanel.class.getName() + "link_pnl");
        if (null != UIManager.getColor("P8")) {
            linkButtonPanel.setBackground(UIManager.getColor("P8"));
        }
        linkButtonPanel.add((Component)this.linkBtn, "East");
        this.closeBtn = new JButton();
        this.closeBtn.setIcon(CvUtils.getIcon("XP_CLOSE_APP_ICON2"));
        this.closeBtn.setToolTipText(CvUtils.getResourceBundle().getString("XP_CLOSE_APP_TOOLTIP"));
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                J3DImageControlPanel.this.getScreen().firePropertyChange(J3DImageControlPanel.CLOSE_APP, false, true);
            }
        });
        this.closeBtn.setFocusPainted(false);
        this.closeBtn.setFocusable(false);
        this.closeBtn.setBackground(null);
        this.closeBtn.setBorder(null);
        if (null != UIManager.getColor("P3")) {
            this.closeBtn.setForeground(UIManager.getColor("P3"));
        }
        this.closeBtn.setPreferredSize(new Dimension(20, 20));
        this.closeBtn.setName(J3DImageControlPanel.class.getName() + "closeBtn");
        JPanel closePnl = new JPanel();
        if (null != UIManager.getColor("P10")) {
            closePnl.setBackground(UIManager.getColor("P10"));
        }
        closePnl.setLayout(new BorderLayout());
        closePnl.add((Component)this.closeBtn, "East");
        closePnl.setName(J3DImageControlPanel.class.getName() + "closePnl");
        JPanel btnPanel = new JPanel();
        if (null != UIManager.getColor("P10")) {
            btnPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("P10")));
        }
        if (null != UIManager.getColor("P8")) {
            btnPanel.setBackground(UIManager.getColor("P8"));
        }
        btnPanel.add(this.controlBtnPanel);
        btnPanel.add(obliqueControllers);
        btnPanel.add(closePnl);
        JPanel orienMainPanel = new JPanel();
        orienMainPanel.setLayout(new BorderLayout());
        if (null != UIManager.getColor("P10")) {
            orienMainPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("P10")));
        }
        if (null != UIManager.getColor("P8")) {
            orienMainPanel.setBackground(UIManager.getColor("P8"));
        }
        this.j3dViewResetPanel = new J3DViewResetPanel();
        orienMainPanel.add((Component)this.j3dViewResetPanel, "West");
        this.add((Component)btnPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel emptyPnl = new JPanel();
        if (null != UIManager.getColor("P8")) {
            emptyPnl.setBackground(UIManager.getColor("P10"));
        }
        this.add((Component)emptyPnl, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)orienMainPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.setMouseModeCapable();
        this.addControllers();
        this.j3dViewResetPanel.setScreen(screen);
        this.doubleObliqueAction.setCapable(screen);
        this.singleObliqueAction.setCapable(screen);
        if (this.linkBtn != null) {
            int capablePortCount = 0;
            int nports = this.getScreen().getScreenLayout().getNoOfPorts();
            for (int i = 0; i < nports; ++i) {
                if (!(this.getScreen().getPort(i) instanceof Capable)) continue;
                ++capablePortCount;
            }
            if (this.linkBtn.getAction() instanceof PlasmaControl) {
                ((PlasmaControl)((Object)this.linkBtn.getAction())).setCapable(screen);
            }
            this.linkBtn.setVisible(capablePortCount > 1);
        }
        this.addPropertyChangeListeners();
    }

    protected void setMouseModeCapable() {
        XpMouseController mouseCtrl;
        XpViewport port = this.findSelectedViewportByClass(T3DViewport.class);
        if (port instanceof T3DViewport && (mouseCtrl = ((T3DViewport)port).getMouseController()) instanceof MouseModeCapable) {
            this.modeCapable = (MouseModeCapable)((Object)mouseCtrl);
        }
    }

    protected void addControllers() {
        if (null != this.modeCapable) {
            try {
                int[] modes = this.modeCapable.getSupportedModes();
                AbstractButton[] btns = CvMouseControllerUtil.getMouseModeButtons(this.modeCapable, "HORIZONTAL");
                for (int i = 0; i < modes.length; ++i) {
                    if (btns[i] != null) {
                        this.controlBtnPanel.add((Component)btns[i], new GridBagConstraints(i, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0));
                        currentSelectedMode = this.modeCapable.getMouseMode(MOUSE_MODE_ACTION_BTN);
                        if (currentSelectedMode == modes[i]) {
                            btns[i].setSelected(true);
                        }
                        this.mouseModeToButtonMap.put(modes[i], btns[i]);
                        this.buttonActionToModeMap.put(btns[i].getActionCommand(), modes[i]);
                    }
                    btns[i].addActionListener(this);
                    JSeparator separator1 = new JSeparator(1);
                    if (null != UIManager.getColor("P10")) {
                        separator1.setForeground(UIManager.getColor("P10"));
                    }
                    this.controlBtnPanel.add((Component)separator1, new GridBagConstraints(modes.length, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0));
                }
                this.modeCapable.removePropertyChangeListener(this.mouseModeChangeListener);
                this.modeCapable.addPropertyChangeListener(this.mouseModeChangeListener);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.log(Level.WARNING, "Unable to install Mouse Controllers. " + e.getLocalizedMessage());
            }
        }
    }

    protected void addPropertyChangeListeners() {
        this.getScreen().removePropertyChangeListener("Cine", this.j3dCineListener);
        this.getScreen().addPropertyChangeListener("Cine", this.j3dCineListener);
        this.getScreen().removePropertyChangeListener("ComponentSelection", this.selectionChangeListener);
        this.getScreen().addPropertyChangeListener("ComponentSelection", this.selectionChangeListener);
    }

    protected XpViewport findSelectedViewportByClass(Class c) {
        XPscreen cap_ = this.getScreen();
        if (cap_ == null) {
            return null;
        }
        SelectionCapable selCap = (SelectionCapable)cap_.getCapable(SelectionCapable.class.getName());
        if (selCap == null) {
            return c.isInstance(cap_) && cap_ instanceof XpViewport ? (XpViewport)((Object)cap_) : null;
        }
        JComponent comp = null;
        do {
            if (c.isInstance(comp = selCap.getViewportComponent(selCap.getComponentSelection())) && comp instanceof XpViewport) {
                return (XpViewport)comp;
            }
            SelectionCapable selectionCapable = selCap = comp instanceof SelectionCapable ? (SelectionCapable)((Object)comp) : null;
        } while (comp != null && selCap != null);
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int mode = this.buttonActionToModeMap.get(e.getActionCommand());
        this.modeCapable.setMouseMode(mode, MOUSE_MODE_ACTION_BTN);
        currentSelectedMode = mode;
    }

    private class ModifiedButtonGroup
    extends ButtonGroup {
        ButtonModel prevmodel = null;

        private ModifiedButtonGroup() {
        }

        @Override
        public void setSelected(ButtonModel model, boolean selected) {
            if (selected) {
                super.setSelected(model, selected);
            } else if (this.prevmodel == model) {
                super.setSelected(J3DImageControlPanel.this.dummyButton.getModel(), true);
            }
            this.prevmodel = model;
        }
    }
}

