/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.cpanels;

import com.ge.med.cse.cvf.action.XpF1FilmAction;
import com.ge.med.cse.cvf.action.XpF2FilmAction;
import com.ge.med.cse.cvf.action.XpF3FilmAction;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class J3DFilmPanel
extends XPcaAutoControlPanel {
    private JButton flmImg;
    private JButton flmPage;
    private JButton flmMid;
    private Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    private boolean uiIntiated = false;
    private static String FILM_IMAGE = "FilmImage";
    private static String FILM_PAGE = "FilmPage";
    private static String FILM_MID = "FilmMid";

    public J3DFilmPanel() {
        this.setIcon(CvUtils.getIcon("XP_FILM_ICON"));
        this.setBackground(null);
        this.setName("J3DFilmControlPanel");
        TransactionLogName tln = new TransactionLogName("TID=CreateJ3DFilmPanel");
        this.logger.log(Level.FINE, "{0} begin Creating Film Panel", tln);
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            this.initUI();
            this.uiIntiated = true;
        }
        this.logger.log(Level.FINE, "{0} end Creating Film Panel", tln);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (CvPropertiesManager.getBoolean("isLazyLoading", false) && !this.uiIntiated) {
            this.initUI();
            CvUtils.updateBackground(this, UIManager.getColor("P9"));
            this.setActionCapable(this.flmImg);
            this.setActionCapable(this.flmPage);
            this.setActionCapable(this.flmMid);
            this.uiIntiated = true;
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.flmImg = new JButton();
        this.flmImg.setName(FILM_IMAGE);
        this.flmImg.setAction(new XpF1FilmAction());
        this.flmImg.setFocusable(false);
        this.flmPage = new JButton();
        this.flmPage.setName(FILM_PAGE);
        this.flmPage.setAction(new XpF2FilmAction());
        this.flmPage.setFocusable(false);
        this.flmMid = new JButton();
        this.flmMid.setName(FILM_MID);
        this.flmMid.setAction(new XpF3FilmAction());
        this.flmMid.setFocusable(false);
        JPanel topbpanel = new JPanel();
        topbpanel.setLayout(new GridBagLayout());
        topbpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), CvUtils.getResourceBundle().getString("XP_FILM_NOW")));
        topbpanel.add((Component)this.flmImg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 20), 0, 0));
        topbpanel.add((Component)this.flmPage, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 20), 0, 0));
        topbpanel.add((Component)this.flmMid, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 20), 0, 0));
        this.add((Component)topbpanel, "North");
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        if (this.uiIntiated) {
            this.setActionCapable(this.flmImg);
            this.setActionCapable(this.flmPage);
            this.setActionCapable(this.flmMid);
        }
    }

    private void setActionCapable(JButton flmPage2) {
        if (flmPage2.getAction() instanceof PlasmaControl) {
            ((PlasmaControl)((Object)flmPage2.getAction())).setCapable(this.screen_);
        }
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_FILM_PA_TOOLTIP");
    }
}

