/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.action;

import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.appframework.DataContext;
import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.dataloader.basic.VolumeDatasetModel;
import com.ge.med.cse.cvf.j3d.vav.VavBatchJob;
import com.ge.med.cse.cvf.j3d.vav.VavBatchJobContainer;
import com.ge.med.cse.cvf.j3d.vav.VavBatchManager;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.idc.Capable;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.event.ActionEvent;

public class VavBatchSaveAction
extends BaseAction {
    private VavBatchModel batchModel = null;
    private boolean refImageOn = true;

    @Override
    protected String getName() {
        return null;
    }

    public void setRefImageOn(boolean refOn) {
        this.refImageOn = refOn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.batchModel == null) {
            return;
        }
        Capable cap = this.getCapable();
        if (cap instanceof XPscreen) {
            String appId = (String)((XPscreen)cap).getClientProperty("APP_IDENTIFIER");
            VavBatchManager batchManager = VavBatchManager.getInstance(appId);
            String dataset = ContextProvider.getDataContext(appId).getDatasetsForScreen(ContextProvider.getApplicationContext(appId).getCurrentScreen())[0];
            DataContext dc = ContextProvider.getDataContext(appId);
            DatasetModel dsmodel = dc.getDatasetModel(dataset);
            this.batchModel.setAutoRun(false);
            VavBatchJobContainer jobs = null;
            if (this.batchModel.getTargetPort() != null) {
                jobs = batchManager.addBatchJobs(new VavBatchModel[]{this.batchModel}, null, this.batchModel.getTargetPort());
            } else if (dsmodel instanceof VolumeDatasetModel && ((VolumeDatasetModel)dsmodel).getVolumeModel(0) != null) {
                VolumeDatasetModel volDsModel = (VolumeDatasetModel)dsmodel;
                XjVolumeModel volmodel = volDsModel.getVolumeModel(0);
                jobs = batchManager.addBatchJobs(new VavBatchModel[]{this.batchModel}, null, volmodel);
            } else {
                XjVolumeInfo inputVolInfo = (XjVolumeInfo)dsmodel.getModelData(0);
                jobs = batchManager.addBatchJobs(new VavBatchModel[]{this.batchModel}, null, inputVolInfo);
            }
            if (jobs != null) {
                for (VavBatchJob job : jobs.getBatchJobs()) {
                    job.setReferenceFrame(this.refImageOn);
                }
                jobs.confirm();
                batchManager.startProcessing();
            }
        }
    }

    public void setModel(VavBatchModel model) {
        this.batchModel = model;
    }
}

