/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.action;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.ui.ActiveAnnotationControl;
import java.awt.Component;
import java.awt.event.MouseEvent;

public class J3DThicknessActiveAnnotation
implements ActiveAnnotationControl {
    private static int stepFactor = 2;
    private static double minThk = 0.0;
    private static double maxThk = 0.0;
    private T3DViewport vp = null;
    private double[] ulc = new double[3];
    private double[] xside = new double[3];
    private double[] yside = new double[3];
    private double[] zside = new double[3];

    @Override
    public String getShortDescription() {
        return "Adjust Slice Thickness";
    }

    @Override
    public void listenTo(Component c) {
        Component comp;
        for (comp = c; comp != null && !(comp instanceof T3DViewport); comp = comp.getParent()) {
        }
        if (comp instanceof T3DViewport) {
            this.vp = (T3DViewport)comp;
        }
    }

    @Override
    public void setCapable(Capable capable) {
        if (capable instanceof Component) {
            this.listenTo((Component)((Object)capable));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        double old;
        if (this.vp == null) {
            Component comp;
            for (comp = (Component)e.getSource(); comp != null && !(comp instanceof T3DViewport); comp = comp.getParent()) {
            }
            if (comp instanceof T3DViewport) {
                this.vp = (T3DViewport)comp;
            }
        }
        if (this.vp == null || CvUtils.isCinePlaying(this.vp)) {
            return;
        }
        this.vp.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
        ViewTypeCapable vtcap = (ViewTypeCapable)this.vp.getCapable(ViewTypeCapable.class.getName());
        boolean obl = vtcap != null && vtcap.getViewType(vtcap.getViewType()).isObliqueControllable();
        minThk = J3DGeomUtils.getMinSliceThickness(this.vp.getVolume(), this.vp.getLookPoint(null), this.vp.getEyePoint(null), obl);
        maxThk = J3DGeomUtils.getMaxSliceThickness(this.ulc, this.xside, this.yside, this.zside, this.vp.getLookPoint(null), this.vp.getEyePoint(null));
        double[] clip = this.vp.getViewClip(null);
        double thk = old = clip[1] - clip[0];
        if (e.getButton() == 1) {
            thk -= (double)stepFactor;
        } else if (e.getButton() == 3) {
            thk += (double)stepFactor;
        }
        if (thk < minThk) {
            thk = minThk;
        } else if (thk > maxThk) {
            thk = maxThk;
        }
        if (thk > minThk && old <= minThk) {
            CvUtils.setT3DRenderStyle(this.vp, "MAJOR_AXIS_MIP");
        }
        this.vp.setViewClip(new double[]{-thk / 2.0, thk / 2.0});
        this.vp.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

