/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class J3DResetCursorAction
extends BaseAction {
    @Override
    protected String getName() {
        return "J3D_RESET_CURSOR";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String[] params = this.getParams();
        try {
            if (params != null && params.length > 0) {
                this.getLogger().log(Level.WARNING, "Invalid parameter passed with command");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                this.setParams(null);
            } else {
                XpViewport port = this.findSelectedViewportByClass(T3DViewport.class);
                if (port instanceof T3DViewport) {
                    Component[] comps = ((T3DViewport)port).getT3DComponent().getComponents();
                    if (comps == null || comps.length == 0) {
                        return;
                    }
                    for (int i = 0; i < comps.length; ++i) {
                        if (!(comps[i] instanceof Cursor3DVc)) continue;
                        ((Cursor3DVc)comps[i]).getCursorModel().setPoint(new CPoint(((T3DViewport)port).getLookPoint(null), 2));
                    }
                }
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during reseting 3d cursor, stack trace {0}", new Object[]{exp});
        }
    }
}

