/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.action;

import com.ge.med.cse.cvf.base.BaseScreen;
import com.ge.med.cse.cvf.j3d.J3DDefaultObliqueController;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.j3d.CubeTrackball;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.DefaultCursor3DModel;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.base.PlasmaControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class J3DObliqueViewAction
implements ItemListener,
PlasmaControl {
    private BaseScreen _screen = null;
    private J3DViewport currentControllerPort = null;
    private J3DDefaultObliqueController obliqueController = null;
    private Cursor3DModel cursor = null;
    private PropertyChangeListener selectionListener = null;
    private PropertyChangeListener viewtypeListener = null;
    private CPoint volume_center;
    private J3DViewport[] screenports;

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.cursor == null) {
            this.screenports = new J3DViewport[this._screen.getNumPorts()];
            for (int i = 0; i < this._screen.getNumPorts(); ++i) {
                this.screenports[i] = (J3DViewport)this._screen.getPort(i);
            }
            DefaultCursor3DModel cursorModel = this.findCursorModel(this.screenports[0]);
            this.cursor = cursorModel != null ? cursorModel : new DefaultCursor3DModel();
            this.viewtypeListener = new ViewChangedListener();
            this.selectionListener = new SelectionListener();
            double[] center_ = new double[3];
            J3DGeomUtils.getVolumeCenterRAS(this.screenports[0].getVolume(), center_);
            this.volume_center = new CPoint(center_[0], center_[1], center_[2], 2);
            this.cursor.setPoint(this.volume_center);
            this.obliqueController = new J3DDefaultObliqueController(null, 0.0, null, this.cursor);
            this.obliqueController.setRxColor(Color.red);
            this.obliqueController.setName("Oblique Port");
        }
        this.switchController(e.getStateChange() == 1);
    }

    private DefaultCursor3DModel findCursorModel(J3DViewport viewport) {
        Component[] comps = viewport.getT3DComponent().getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Cursor3DVc)) continue;
            return (DefaultCursor3DModel)((Cursor3DVc)comps[i]).getCursorModel();
        }
        return null;
    }

    public void switchController(boolean isControllerOn) {
        int i;
        if (isControllerOn) {
            this.cursor.setPoint(this.volume_center);
            for (i = 0; i < this._screen.getNumPorts(); ++i) {
                this.screenports[i].addPropertyChangeListener("COMPONENT_SELECTED", this.selectionListener);
                this.screenports[i].addPropertyChangeListener("viewType", this.viewtypeListener);
            }
            this.refreshSettings();
        } else {
            for (i = 0; i < this._screen.getNumPorts(); ++i) {
                this.screenports[i].removePropertyChangeListener("COMPONENT_SELECTED", this.selectionListener);
                this.screenports[i].removePropertyChangeListener("viewType", this.viewtypeListener);
            }
            this.obliqueController.setController(null);
            this.obliqueController.setReferenceVc(null);
            if (this.currentControllerPort != null) {
                this.currentControllerPort.getT3DComponent().remove(this.obliqueController);
                this.currentControllerPort.repaint();
            }
        }
        for (i = 0; i < this._screen.getNumPorts(); ++i) {
            this.showGraphics(this.screenports[i], !isControllerOn);
        }
    }

    private J3DViewport findFirstNonObliquePort() {
        for (int i = 0; i < this.screenports.length; ++i) {
            if (this.screenports[i].getViewType() == "OBLIQUE") continue;
            return this.screenports[i];
        }
        return null;
    }

    private void showGraphics(T3DViewport vp, boolean show) {
        T3DComponent tc = vp.getT3DComponent();
        Component[] comp = tc.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof CubeTrackball)) continue;
            comp[i].setVisible(show);
        }
    }

    private void refreshSettings() {
        this.obliqueController.setController(null);
        this.obliqueController.setReferenceVc(null);
        this.currentControllerPort = this.findFirstNonObliquePort();
        if (this.currentControllerPort != null) {
            this.obliqueController.setAngle(0.0);
            this.obliqueController.setReferenceVc(this.currentControllerPort.getT3DComponent());
            this.obliqueController.setController(this.currentControllerPort.getT3DComponent());
            this.currentControllerPort.getT3DComponent().add(this.obliqueController);
            this.currentControllerPort.getT3DComponent().repaint();
        }
        for (int i = 0; i < this.screenports.length; ++i) {
            this.showGraphics(this.screenports[i], false);
            if (this.screenports[i].getViewType() != "OBLIQUE") continue;
            this.obliqueController.addViewer(this.screenports[i]);
        }
        this.obliqueController.snapViewer();
    }

    @Override
    public void setCapable(Capable cap) {
        if (cap instanceof BaseScreen) {
            this._screen = (BaseScreen)cap;
        }
    }

    private class ViewChangedListener
    implements PropertyChangeListener {
        private ViewChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (J3DObliqueViewAction.this.currentControllerPort != null) {
                J3DObliqueViewAction.this.currentControllerPort.getT3DComponent().remove(J3DObliqueViewAction.this.obliqueController);
                J3DObliqueViewAction.this.currentControllerPort.repaint();
            }
            J3DObliqueViewAction.this.refreshSettings();
        }
    }

    private class SelectionListener
    implements PropertyChangeListener {
        private SelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            J3DViewport controller_port = (J3DViewport)evt.getSource();
            if (controller_port.getViewType() == "OBLIQUE") {
                return;
            }
            if (J3DObliqueViewAction.this.currentControllerPort == controller_port) {
                return;
            }
            J3DObliqueViewAction.this.obliqueController.setAngle(0.0);
            J3DObliqueViewAction.this.currentControllerPort.getT3DComponent().remove(J3DObliqueViewAction.this.obliqueController);
            J3DObliqueViewAction.this.currentControllerPort.repaint();
            J3DObliqueViewAction.this.obliqueController.setReferenceVc(controller_port.getT3DComponent());
            J3DObliqueViewAction.this.obliqueController.setController(controller_port.getT3DComponent());
            for (int i = 0; i < J3DObliqueViewAction.this.screenports.length; ++i) {
                if (!J3DObliqueViewAction.this.screenports[i].getViewType().equalsIgnoreCase("OBLIQUE")) continue;
                J3DObliqueViewAction.this.obliqueController.addViewer(J3DObliqueViewAction.this.screenports[i]);
            }
            controller_port.getT3DComponent().add(J3DObliqueViewAction.this.obliqueController);
            J3DObliqueViewAction.this.cursor.setPoint(J3DObliqueViewAction.this.volume_center);
            J3DObliqueViewAction.this.currentControllerPort = controller_port;
            J3DObliqueViewAction.this.obliqueController.snapViewer();
        }
    }
}

