/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.action;

import com.ge.med.cse.cvf.base.BaseScreen;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.utils.DoubleObliqueController;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.j3d.CubeTrackball;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.DefaultCursor3DModel;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.base.PlasmaControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class J3DDoubleObliqueViewAction
implements ItemListener,
PlasmaControl {
    private BaseScreen _screen = null;
    private final int numControllers = 3;
    private DoubleObliqueController[] doubleobliqueController;
    private Cursor3DModel cursor = null;
    private Color port1_color = Color.RED;
    private Color port2_color = Color.GREEN;
    private Color port3_color = Color.BLUE;
    private CPoint volume_centr = null;
    private J3DViewport[] screenports;
    private String[] viewportViews = null;

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.cursor == null) {
            this.screenports = new J3DViewport[this._screen.getNumPorts()];
            this.doubleobliqueController = new DoubleObliqueController[3];
            this.viewportViews = new String[3];
            for (int i = 0; i < this._screen.getNumPorts(); ++i) {
                this.screenports[i] = (J3DViewport)this._screen.getPort(i);
            }
            DefaultCursor3DModel cursorModel = this.findCursorModel(this.screenports[0]);
            this.cursor = cursorModel != null ? cursorModel : new DefaultCursor3DModel();
            double[] center_ = new double[3];
            J3DGeomUtils.getVolumeCenterRAS(this.screenports[0].getVolume(), center_);
            this.volume_centr = new CPoint(center_[0], center_[1], center_[2], 2);
            this.cursor.setPoint(this.volume_centr);
            for (int i = 0; i < 3; ++i) {
                this.doubleobliqueController[i] = new DoubleObliqueController(this.screenports[i], this.cursor);
                this.viewportViews[i] = this.screenports[i].getViewType();
            }
            this.doubleobliqueController[0].setRxColor(this.port3_color, this.port2_color);
            this.doubleobliqueController[0].setName("port3", "port2");
            this.doubleobliqueController[1].setRxColor(this.port3_color, this.port1_color);
            this.doubleobliqueController[1].setName("port3", "port1");
            this.doubleobliqueController[2].setRxColor(this.port1_color, this.port2_color);
            this.doubleobliqueController[2].setName("port1", "port2");
        }
        this.switchController(e.getStateChange() == 1);
    }

    public void switchController(boolean isControllerOn) {
        int i;
        if (isControllerOn) {
            for (i = 0; i < 3; ++i) {
                this.screenports[i].getT3DComponent().add(this.doubleobliqueController[i].getObliqueController(0));
                this.screenports[i].getT3DComponent().add(this.doubleobliqueController[i].getObliqueController(1));
                this.doubleobliqueController[i].addPortSelectionChangeListeners();
                this.doubleobliqueController[i].getObliqueController(0).setAngle(1.5707963267948966);
                this.doubleobliqueController[i].getObliqueController(1).setAngle(0.0);
                this.screenports[i].setViewType("OBLIQUE");
                this.screenports[i].lockViewType(true);
            }
            this.doubleobliqueController[0].addViewer(this.screenports[2], this.screenports[1]);
            this.doubleobliqueController[1].storeViewers(new T3DCapable[]{this.screenports[2]}, new T3DCapable[]{this.screenports[0]});
            this.doubleobliqueController[2].storeViewers(new T3DCapable[]{this.screenports[0]}, new T3DCapable[]{this.screenports[1]});
            this.cursor.setPoint(this.volume_centr);
        } else {
            for (i = 0; i < 3; ++i) {
                this.screenports[i].getT3DComponent().remove(this.doubleobliqueController[i].getObliqueController(0));
                this.screenports[i].getT3DComponent().remove(this.doubleobliqueController[i].getObliqueController(1));
                this.doubleobliqueController[i].removeAllViewers();
                this.doubleobliqueController[i].removePortListeners();
                this.screenports[i].setViewType(this.viewportViews[i]);
                this.screenports[i].lockViewType(false);
            }
        }
        for (i = 0; i < 3; ++i) {
            this.showGraphics(this.screenports[i], !isControllerOn);
            this.screenports[i].repaint();
        }
    }

    private void showGraphics(T3DViewport vp, boolean show) {
        T3DComponent tc = vp.getT3DComponent();
        Component[] comp = tc.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof CubeTrackball)) continue;
            comp[i].setVisible(show);
        }
    }

    @Override
    public void setCapable(Capable cap) {
        if (cap instanceof BaseScreen) {
            this._screen = (BaseScreen)cap;
        }
    }

    private DefaultCursor3DModel findCursorModel(J3DViewport viewport) {
        Component[] comps = viewport.getT3DComponent().getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Cursor3DVc)) continue;
            return (DefaultCursor3DModel)((Cursor3DVc)comps[i]).getCursorModel();
        }
        return null;
    }
}

