/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.appframework.DataContext;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.idc.VolumeDatasetCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VolumeDatasetCapableImpl
implements VolumeDatasetCapable {
    private static final Logger logger = Logger.getLogger(VolumeDatasetCapableImpl.class.getName());
    private final DataContext datacontext;
    private J3DViewport viewport = null;
    private String datasetName = null;
    private DatasetModel datasetModel = null;
    private ArrayList<String> supportedDatasets = new ArrayList();
    private static final String SUPPORTED_DATASETS = ".supportedDatasets";
    private static final String DISPLAYNAME = ".displayName";
    PropertyChangeListener modelLoadedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue().toString().equalsIgnoreCase(VolumeDatasetCapableImpl.this.datasetName)) {
                VolumeDatasetCapableImpl.this.datacontext.getDatasetLoader(VolumeDatasetCapableImpl.this.datasetName).load(VolumeDatasetCapableImpl.this.viewport, VolumeDatasetCapableImpl.this.datasetModel, CvPropertiesManager.getProperties(), null);
            }
        }
    };

    public VolumeDatasetCapableImpl(J3DViewport viewport) {
        this.viewport = viewport;
        this.datacontext = ContextProvider.getDataContext((String)viewport.getClientProperty("APP_IDENTIFIER"));
        Properties props = CvPropertiesManager.getProperties();
        String supportedDatasetNames = props.getProperty(viewport.getName() + SUPPORTED_DATASETS);
        if (supportedDatasetNames == null) {
            logger.log(Level.INFO, "No supported dataset for viewport " + viewport.getName());
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(supportedDatasetNames, ",");
        this.supportedDatasets.clear();
        while (tokenizer.hasMoreTokens()) {
            String supportedDatasetName = tokenizer.nextToken();
            if (supportedDatasetName == "" || this.supportedDatasets.contains(supportedDatasetName)) continue;
            this.supportedDatasets.add(supportedDatasetName);
        }
    }

    @Override
    public String getDataset() {
        return this.datasetName;
    }

    @Override
    public String[] getSupportedDatasets() {
        return this.supportedDatasets.toArray(new String[0]);
    }

    @Override
    public void setDataset(String datasetName) {
        if (!this.supportedDatasets.contains(datasetName)) {
            logger.log(Level.INFO, datasetName + " dataset is not supported by viewport");
            return;
        }
        String prevDataset = this.datasetName;
        this.datasetName = datasetName;
        if (this.datasetName != prevDataset) {
            DatasetModel prevDatasetModel = this.datacontext.getDatasetModel(prevDataset);
            this.datasetModel = this.datacontext.getDatasetModel(this.datasetName);
            if (this.datasetModel == null) {
                logger.log(Level.INFO, "DatasetModel is null for dataset " + this.datasetName);
                return;
            }
            if (this.datasetModel.getModelData(0) != null) {
                System.out.println("VolumeDatasetCapableImpl.setDataset() :: Direct loading :: " + this.datasetName);
                this.datacontext.getDatasetLoader(this.datasetName).load(this.viewport, this.datasetModel, CvPropertiesManager.getProperties(), null);
            } else {
                System.out.println("VolumeDatasetCapableImpl.setDataset() ::  Model Building for :: " + this.datasetName);
                if (prevDatasetModel != null) {
                    prevDatasetModel.removePropertyChangeListener("MODELLOADED", this.modelLoadedListener);
                }
                this.datasetModel.addPropertyChangeListener("MODELLOADED", this.modelLoadedListener);
                this.datasetModel.buildModel();
            }
            String volume = (String)CvPropertiesManager.getProperties().get(datasetName + DISPLAYNAME);
            this.viewport.getAnnotationVc().getAnnotationModel().setProperty("volume", volume);
            PropertyChangeEvent pcEvent = new PropertyChangeEvent(this.viewport, "datasetChange", prevDataset, this.datasetName);
            PropertyChangeListener[] pcListeners = this.viewport.getPropertyChangeListeners("datasetChange");
            for (int i = 0; i < pcListeners.length; ++i) {
                pcListeners[i].propertyChange(pcEvent);
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
    }

    @Override
    public Capable getCapable(String capableIFName) {
        return null;
    }

    @Override
    public boolean isAutoRepaint() {
        return false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void removePropertyChangeListener(String s, PropertyChangeListener l) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void setAutoRepaint(boolean autoRepaint) {
    }
}

