/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class ViewCalculator
implements FramePositioningCapable {
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected int curpos = 0;
    protected int numViews = 0;
    protected JnVector3d firstLookPt = new JnVector3d();
    protected double[] currentLookPt = new double[3];
    protected double[] currentEyePt = new double[3];
    protected double[] currentUp = new double[3];
    protected double[] ulc = new double[3];
    protected double[] xside = new double[3];
    protected double[] yside = new double[3];
    protected double[] zside = new double[3];
    protected int[] vdims = new int[3];
    protected double[] xdir = new double[3];
    protected double[] ydir = new double[3];
    protected double[] zdir = new double[3];
    protected boolean volumeLoaded = false;
    protected XjVolumeGeometry volumeGeom = null;
    protected T3DCapable t3dCapable = null;
    protected boolean isUpdating = false;
    protected JnMatrix4d ras2vox = new JnMatrix4d();
    protected JnMatrix4d vox2ras = new JnMatrix4d();
    private PropertyChangeListener updateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!ViewCalculator.this.isUpdating) {
                ViewCalculator.this.updateContent();
            }
        }
    };

    public ViewCalculator() {
    }

    public ViewCalculator(T3DCapable capable) {
        this.setT3DCapable(capable);
    }

    public ViewCalculator(T3DCapable capable, XjVolumeGeometry vol) {
        this.setT3DCapable(capable);
        this.setVolume(vol);
    }

    public void setT3DCapable(T3DCapable capable) {
        if (this.t3dCapable != null) {
            this.t3dCapable.removePropertyChangeListener("camera", this.updateListener);
            this.t3dCapable.removePropertyChangeListener("eyePoint", this.updateListener);
            this.t3dCapable.removePropertyChangeListener("lookPoint", this.updateListener);
        }
        this.t3dCapable = capable;
        if (this.t3dCapable != null) {
            this.t3dCapable.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
            this.t3dCapable.addPropertyChangeListener("camera", this.updateListener);
            this.t3dCapable.addPropertyChangeListener("eyePoint", this.updateListener);
            this.t3dCapable.addPropertyChangeListener("lookPoint", this.updateListener);
            this.updateContent();
        }
    }

    public void setVolume(XjVolumeGeometry vol) {
        if (this.volumeLoaded && this.volumeGeom == vol) {
            return;
        }
        this.reset();
        this.volumeGeom = vol;
        if (vol == null) {
            return;
        }
        vol.getVolumeDimensions(this.vdims);
        vol.getXDirectionRAS(this.xdir);
        vol.getYDirectionRAS(this.ydir);
        vol.getZDirectionRAS(this.zdir);
        if (this.t3dCapable != null) {
            this.t3dCapable.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
            XjVolumeUtils.calculateVoxelRASTransform(vol, this.vox2ras, this.ras2vox);
            this.volumeLoaded = true;
            this.updateContent();
        }
    }

    public boolean isReady() {
        return this.t3dCapable != null && this.volumeLoaded;
    }

    protected void reset() {
        this.ras2vox.setIdentity();
        this.vox2ras.setIdentity();
        this.volumeLoaded = false;
        this.volumeGeom = null;
        this.curpos = 0;
        this.numViews = 0;
        this.currentLookPt[0] = 0.0;
        this.currentLookPt[1] = 0.0;
        this.currentLookPt[2] = 0.0;
        this.currentEyePt[0] = 0.0;
        this.currentEyePt[1] = 0.0;
        this.currentEyePt[2] = 0.0;
        this.currentUp[0] = 0.0;
        this.currentUp[1] = 0.0;
        this.currentUp[2] = 0.0;
        this.vdims[0] = 0;
        this.vdims[1] = 0;
        this.vdims[2] = 0;
        this.xdir[0] = 0.0;
        this.xdir[1] = 0.0;
        this.xdir[2] = 0.0;
        this.ydir[0] = 0.0;
        this.ydir[1] = 0.0;
        this.ydir[2] = 0.0;
        this.zdir[0] = 0.0;
        this.zdir[1] = 0.0;
        this.zdir[2] = 0.0;
        this.ulc[0] = 0.0;
        this.ulc[1] = 0.0;
        this.ulc[2] = 0.0;
        this.xside[0] = 0.0;
        this.xside[1] = 0.0;
        this.xside[2] = 0.0;
        this.yside[0] = 0.0;
        this.yside[1] = 0.0;
        this.yside[2] = 0.0;
        this.zside[0] = 0.0;
        this.zside[1] = 0.0;
        this.zside[2] = 0.0;
    }

    protected abstract void updateContent();

    public abstract void getView(int var1, double[] var2, double[] var3, double[] var4);

    public abstract int getViewIndex(double[] var1, double[] var2, double[] var3);

    protected double getDefaultSpacing(double[] rasVector) {
        double spc = 0.0;
        double xlen = JnVector3d.length(this.xdir);
        double ylen = JnVector3d.length(this.ydir);
        double zlen = JnVector3d.length(this.zdir);
        double xcomp = Math.abs(rasVector[0]);
        double ycomp = Math.abs(rasVector[1]);
        double zcomp = Math.abs(rasVector[2]);
        spc = xcomp >= ycomp && xcomp > zcomp ? xlen : (ycomp >= xcomp && ycomp > zcomp ? ylen : zlen);
        return spc;
    }

    protected final boolean isInVolume(double[] rasPoint) {
        if (!this.volumeLoaded) {
            return false;
        }
        int[] volDims = this.volumeGeom.getVolumeDimensions(null);
        return J3DGeomUtils.isInVolume(rasPoint, volDims, this.ras2vox);
    }

    @Override
    public int getNumFrames() {
        return this.numViews;
    }

    @Override
    public void setFrameIndex(int index) {
        if (index < 0 || index >= this.numViews) {
            return;
        }
        if (index == this.curpos) {
            return;
        }
        this.isUpdating = true;
        this.getView(index, this.currentEyePt, this.currentLookPt, this.currentUp);
        this.curpos = index;
        this.t3dCapable.setCamera(this.currentEyePt, this.currentLookPt, this.currentUp);
        this.fireFrameIndexPropertyChange(-1, this.curpos);
        this.isUpdating = false;
    }

    @Override
    public int getFrameIndex() {
        int index = this.curpos;
        return index;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String s, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(s, l);
    }

    @Override
    public void repaint() {
        if (this.t3dCapable != null) {
            this.t3dCapable.repaint();
        }
    }

    @Override
    public boolean isAutoRepaint() {
        return false;
    }

    @Override
    public void setAutoRepaint(boolean autoRepaint) {
    }

    @Override
    public Capable getCapable(String capableIFName) {
        if (FramePositioningCapable.class.getName().equals(capableIFName)) {
            return this;
        }
        return null;
    }

    protected void fireFrameIndexPropertyChange(int oldIndex, int newIndex) {
        this.pcs.firePropertyChange("FrameIndex", oldIndex, newIndex);
    }
}

