/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.idc.VolumeDatasetCapable;
import com.ge.med.cse.cvf.j3d.AbstractViewType;
import com.ge.med.cse.cvf.j3d.J3DZPagingViewCalculator;
import com.ge.med.cse.cvf.j3d.ViewCalculator;
import com.ge.med.cse.cvf.screenbuilder.helper.Helper;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.ActiveAnnotationCapable;
import com.ge.med.idc.XjDynamicVolume;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class TwoDViewType
extends AbstractViewType {
    protected static final String ACTIVEANNOTATION_SUFFIX = "ActiveAnnotation";
    protected static final String ITEM_SUFFIX = ".items";
    protected static final String HELPER_SUFFIX = "helper";
    private String name = "2D";
    private ViewCalculator viewCalculator = null;
    private T3DViewport prevPort = null;
    private XjDynamicVolume prevVol = null;
    private String dataset = "Unknown";
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("IMAGE_ADDED")) {
                int newindex = (Integer)evt.getNewValue();
                TwoDViewType.this.viewCalculator.setFrameIndex(newindex);
            } else if (evt.getPropertyName().equals("VOLUME_PROPERTY") && TwoDViewType.this.prevPort.getVolume() instanceof XjDynamicVolume) {
                if (TwoDViewType.this.prevVol != null) {
                    TwoDViewType.this.prevVol.removePropertyChangeListener(TwoDViewType.this.pcl);
                    TwoDViewType.this.prevVol = null;
                }
                if (TwoDViewType.this.t3dport == null) {
                    return;
                }
                VolumeDatasetCapable vcap = (VolumeDatasetCapable)TwoDViewType.this.t3dport.getCapable(VolumeDatasetCapable.class.getName());
                if (vcap != null) {
                    TwoDViewType.this.dataset = vcap.getDataset();
                }
                TwoDViewType.this.reconfigActiveAnnotation();
                TwoDViewType.this.prevVol = (XjDynamicVolume)TwoDViewType.this.prevPort.getVolume();
                TwoDViewType.this.prevVol.addPropertyChangeListener("IMAGE_ADDED", TwoDViewType.this.pcl);
            }
        }
    };

    @Override
    protected void syncPort() {
        if (this.prevPort != null) {
            this.prevPort.removePropertyChangeListener("VOLUME_PROPERTY", this.pcl);
            this.prevPort = null;
        }
        if (this.prevVol != null) {
            this.prevVol.removePropertyChangeListener(this.pcl);
            this.prevVol = null;
        }
        if (this.t3dport == null) {
            return;
        }
        this.prevPort = this.t3dport;
        if (this.prevPort.getVolume() instanceof XjDynamicVolume) {
            VolumeDatasetCapable vcap = (VolumeDatasetCapable)this.t3dport.getCapable(VolumeDatasetCapable.class.getName());
            if (vcap != null) {
                this.dataset = vcap.getDataset();
            }
            this.reconfigActiveAnnotation();
            this.prevVol = (XjDynamicVolume)this.prevPort.getVolume();
            this.prevVol.addPropertyChangeListener("IMAGE_ADDED", this.pcl);
        }
        this.prevPort.addPropertyChangeListener("VOLUME_PROPERTY", this.pcl);
        this.hideTrackBall();
        this.reset();
        this.t3dport.setMouseController(this.mouseController);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isObliqueControllable() {
        return false;
    }

    @Override
    public boolean is3DViewType() {
        return false;
    }

    @Override
    public boolean isVolumeLayersAllowed() {
        return false;
    }

    @Override
    public void reset() {
        if (this.t3dport == null) {
            return;
        }
        if (!this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("REFORMAT")) && !this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("REFORMAT.TC"))) {
            CvUtils.setT3DRenderStyle(this.t3dport, "REFORMAT.TC");
        }
        this.t3dport.setViewClip(new double[]{0.0, 0.0});
        this.setCamera();
        super.reset();
    }

    @Override
    public ViewCalculator getViewCalculator() {
        if (this.viewCalculator == null) {
            this.viewCalculator = new J3DZPagingViewCalculator();
        }
        return this.viewCalculator;
    }

    @Override
    public String[] getSubViewTypes() {
        return null;
    }

    @Override
    public ViewTypeCapable.ViewTypeActor getViewType(String viewType) {
        return null;
    }

    private void setCamera() {
        if (this.t3dport != null && this.t3dport.getVolume() != null) {
            double[] ulc = new double[3];
            double[] xside = new double[3];
            double[] yside = new double[3];
            double[] zside = new double[3];
            this.t3dport.getWorldBounds(ulc, xside, yside, zside);
            JnVector3d look = new JnVector3d(ulc);
            look.scaleAdd(0.5, xside);
            look.scaleAdd(0.5, yside);
            JnVector3d eye = new JnVector3d();
            eye.add(look, JnVector3d.cross(xside, yside).normalize());
            JnVector3d.scale(yside, -1.0);
            this.t3dport.setCamera(eye.toArray(), look.toArray(), yside);
        }
    }

    protected void reconfigActiveAnnotation() {
        if (!(this.t3dport instanceof ActiveAnnotationCapable)) {
            return;
        }
        T3DViewport aacap = this.t3dport;
        aacap.clearActiveAnnotationListeners();
        String aaprop = this.dataset + "." + ACTIVEANNOTATION_SUFFIX;
        String aahelperprop = aaprop + "." + HELPER_SUFFIX;
        String aadefhelperprop = "ActiveAnnotation.helper";
        String aahelper = CvPropertiesManager.getProperty(aahelperprop, CvPropertiesManager.getProperty(aadefhelperprop));
        Helper aah = null;
        try {
            aah = (Helper)CvUtils.getClass(aahelper).newInstance();
            if (aah != null) {
                aah.config(this.t3dport, aaprop + ITEM_SUFFIX, CvPropertiesManager.getProperties());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

