/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.AbstractViewType;
import com.ge.med.cse.cvf.j3d.J3DDefaultPagingViewCalculator;
import com.ge.med.cse.cvf.j3d.ViewCalculator;
import com.ge.med.cse.cvf.util.CvUtils;

public class OrthogonalViewType
extends AbstractViewType {
    private String name = "AXIAL";
    private String viewOrien = OrthogonalViewType.getViewOrientation(this.name);
    private ViewCalculator viewCalculator = null;

    public OrthogonalViewType() {
    }

    public OrthogonalViewType(String name) {
        if (name.equals("AXIAL") || name.equals("SAGITTAL") || name.equals("CORONAL")) {
            this.name = name;
            this.viewOrien = OrthogonalViewType.getViewOrientation(name);
        } else if (name.equals("A") || name.equals("P")) {
            this.name = "CORONAL";
            this.viewOrien = name;
        } else if (name.equals("R") || name.equals("L")) {
            this.name = "SAGITTAL";
            this.viewOrien = name;
        } else if (name.equals("S") || name.equals("I")) {
            this.name = "AXIAL";
            this.viewOrien = name;
        }
    }

    @Override
    protected void syncPort() {
        if (this.t3dport == null) {
            return;
        }
        this.hideTrackBall();
        if (this.t3dport.getVolume() != null && this.t3dport.getT3DComponent().getNumVolumeLayers() > 1) {
            CvUtils.setT3DRenderStyle(this.t3dport, "REFORMAT");
        } else if (!(this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("MAJOR_AXIS_MIP")) || this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("MAJOR_AXIS_MINIP")) || this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("MAJOR_AXIS_AVERAGE")))) {
            CvUtils.setT3DRenderStyle(this.t3dport, "MAJOR_AXIS_MIP");
        }
        this.t3dport.setViewClip(new double[]{0.0, 0.0});
        OrthogonalViewType.setViewOrientation(this.t3dport, this.viewOrien, this.getCursorLocation());
        this.t3dport.setMouseController(this.mouseController);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isObliqueControllable() {
        return false;
    }

    @Override
    public boolean is3DViewType() {
        return false;
    }

    @Override
    public boolean isVolumeLayersAllowed() {
        return true;
    }

    @Override
    public void reset() {
        if (this.t3dport == null) {
            return;
        }
        if (this.t3dport.getVolume() != null && this.t3dport.getT3DComponent().getNumVolumeLayers() > 1) {
            CvUtils.setT3DRenderStyle(this.t3dport, "REFORMAT");
        } else if (!(this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("MAJOR_AXIS_MIP")) || this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("MAJOR_AXIS_MINIP")) || this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("MAJOR_AXIS_AVERAGE")))) {
            CvUtils.setT3DRenderStyle(this.t3dport, "MAJOR_AXIS_MIP");
        }
        this.t3dport.setViewClip(new double[]{0.0, 0.0});
        OrthogonalViewType.setViewOrientation(this.t3dport, this.viewOrien, null);
        super.reset();
    }

    @Override
    public ViewCalculator getViewCalculator() {
        if (this.viewCalculator == null) {
            this.viewCalculator = new J3DDefaultPagingViewCalculator();
        }
        return this.viewCalculator;
    }

    @Override
    public String[] getSubViewTypes() {
        return null;
    }

    @Override
    public ViewTypeCapable.ViewTypeActor getViewType(String viewType) {
        return null;
    }

    private static String getViewOrientation(String viewType) {
        if ("AXIAL".equals(viewType)) {
            return "I";
        }
        if ("CORONAL".equals(viewType)) {
            return "A";
        }
        if ("SAGITTAL".equals(viewType)) {
            return "L";
        }
        return viewType;
    }

    public static class CoronalViewType
    extends OrthogonalViewType {
        public CoronalViewType() {
            super("CORONAL");
        }
    }

    public static class SagittalViewType
    extends OrthogonalViewType {
        public SagittalViewType() {
            super("SAGITTAL");
        }
    }

    public static class AxialViewType
    extends OrthogonalViewType {
        public AxialViewType() {
            super("AXIAL");
        }
    }
}

