/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.idc.MultiSelectionCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Fusion3DCapable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class J3DWindowingLinkedDirector
implements XpViewportDirector {
    private ArrayList<J3DViewport> portList = new ArrayList();
    private WindowingPropertyChangeListener listener = new WindowingPropertyChangeListener(this);
    private Map<String, String> psValidation = new HashMap<String, String>();

    public J3DWindowingLinkedDirector() {
        this.init();
    }

    private void init() {
        String validation = CvPropertiesManager.getProperty("PRIMARY.SECONDARY.J3DWindowingLinkedDirector", "AXIAL:AXIAL,CORONAL,SAGITTAL,OBLIQUE,3D;CORONAL:CORONAL,AXIAL,SAGITTAL,OBLIQUE,3D;SAGITTAL:SAGITTAL,CORONAL,AXIAL,OBLIQUE,3D;OBLIQUE:OBLIQUE,SAGITTAL,CORONAL,AXIAL,3D;3D:3D,OBLIQUE,SAGITTAL,CORONAL,AXIAL");
        if (validation != null) {
            String[] primarySecondary_pair;
            for (String ps : primarySecondary_pair = validation.split(";")) {
                String[] psKeypair = ps.split(":");
                this.psValidation.put(psKeypair[0], psKeypair[1]);
            }
        }
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof T3DCapable) {
            this.portList.add((J3DViewport)viewport);
            ((J3DViewport)viewport).addPropertyChangeListener("winMax", this.listener);
            ((J3DViewport)viewport).addPropertyChangeListener("winMin", this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            WindowLevelCapable port = this.portList.get(i);
            port.removePropertyChangeListener(this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener(this.listener);
        }
    }

    private void notifyChange(Object src) {
        J3DViewport refport = (J3DViewport)src;
        if (this.portList.isEmpty()) {
            return;
        }
        if (!this.isPrimaryViewPort(refport)) {
            return;
        }
        double refmax = refport.getWinMax();
        double refmin = refport.getWinMin();
        String primary_ViewType = refport.getViewType();
        XjVolumeModel vol = refport.getVolumeModel();
        String suppportedViewTypes = this.psValidation.get(primary_ViewType);
        if (suppportedViewTypes != null) {
            suppportedViewTypes = suppportedViewTypes.trim().toLowerCase();
        }
        for (int i = 0; i < this.portList.size(); ++i) {
            if (this.portList.get(i).equals(src) || !this.portList.get(i).isSelected()) continue;
            if (this.portList.get(i) instanceof Fusion3DCapable) {
                Fusion3DCapable fc = (Fusion3DCapable)this.portList.get(i).getCapable(Fusion3DCapable.class.getName());
                int j = fc.getNumVolumeLayers();
                for (int k = 0; k < j; ++k) {
                    XjVolumeModel volk = fc.getVolumeModel(k);
                    if (suppportedViewTypes == null || !suppportedViewTypes.contains(this.portList.get(i).getViewType().toLowerCase()) || vol != volk) continue;
                    int preLayerNumber = fc.getVolumeLayer();
                    fc.selectVolumeLayer(k);
                    this.update(i, refmax, refmin);
                    fc.selectVolumeLayer(preLayerNumber);
                }
                continue;
            }
            XjVolumeModel voli = this.portList.get(i).getVolumeModel();
            if (suppportedViewTypes == null || !suppportedViewTypes.contains(this.portList.get(i).getViewType().toLowerCase()) || vol != voli) continue;
            this.update(i, refmax, refmin);
        }
    }

    private void update(int i, double refmax, double refmin) {
        double max = this.portList.get(i).getWinMax();
        double min = this.portList.get(i).getWinMin();
        if (max != refmax || min != refmin) {
            this.portList.get(i).setWinMinMax(refmin, refmax);
        }
    }

    private boolean isPrimaryViewPort(J3DViewport source) {
        MultiSelectionCapable basescreen = (MultiSelectionCapable)((Object)SwingUtilities.getAncestorOfClass(MultiSelectionCapable.class, source));
        if (basescreen == null) {
            return false;
        }
        for (int i = 0; i < basescreen.getNumComponents(); ++i) {
            if (source != basescreen.getViewportComponent(i) || basescreen.getComponentSelectionState(i) != 0) continue;
            return true;
        }
        return false;
    }

    private static class WindowingPropertyChangeListener
    implements PropertyChangeListener {
        J3DWindowingLinkedDirector adaptee;

        public WindowingPropertyChangeListener(J3DWindowingLinkedDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.adaptee.notifyChange(evt.getSource());
        }
    }
}

