/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class J3DThicknessLinkedDirector
implements XpViewportDirector {
    private ArrayList<T3DCapable> portList = new ArrayList();
    private ThicknessPropertyChangeListener listener = new ThicknessPropertyChangeListener(this);

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof T3DCapable) {
            this.portList.add((T3DCapable)((Object)viewport));
            viewport.addPropertyChangeListener(this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DCapable port = this.portList.get(i);
            port.removePropertyChangeListener(this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener(this.listener);
        }
    }

    private void notifyThickness(Object src) {
        double[] thickness = ((J3DViewport)src).getViewClip(null);
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DCapable port;
            double[] portthickness;
            if (this.portList.get(i).equals(src) || (portthickness = (port = this.portList.get(i)).getViewClip(null))[0] == thickness[0] && portthickness[1] == thickness[1]) continue;
            port.setViewClip(thickness);
        }
    }

    private static class ThicknessPropertyChangeListener
    implements PropertyChangeListener {
        J3DThicknessLinkedDirector adaptee;

        public ThicknessPropertyChangeListener(J3DThicknessLinkedDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("viewClip".equalsIgnoreCase(propName)) {
                this.adaptee.notifyThickness(evt.getSource());
            }
        }
    }
}

