/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class J3DRenderStyleLinkedDirector
implements XpViewportDirector {
    private ArrayList<T3DRenderStyleCapable> portList = new ArrayList();
    private RenderStylePropertyChangeListener listener = new RenderStylePropertyChangeListener(this);

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof T3DCapable) {
            this.portList.add((T3DRenderStyleCapable)((Object)viewport));
            viewport.addPropertyChangeListener(this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DRenderStyleCapable port = this.portList.get(i);
            port.removePropertyChangeListener(this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener(this.listener);
        }
    }

    private void notifyRenderStyle(Object src) {
        String srcPortRenderStyle = ((J3DViewport)src).getRenderStyle();
        for (int i = 0; i < this.portList.size(); ++i) {
            T3DRenderStyleCapable port;
            String renderStyle;
            if (this.portList.get(i).equals(src) || (renderStyle = (port = this.portList.get(i)).getRenderStyle()).equals(srcPortRenderStyle)) continue;
            port.setRenderStyle(srcPortRenderStyle);
        }
    }

    private static class RenderStylePropertyChangeListener
    implements PropertyChangeListener {
        J3DRenderStyleLinkedDirector adaptee;

        public RenderStylePropertyChangeListener(J3DRenderStyleLinkedDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("renderStyle".equalsIgnoreCase(propName)) {
                this.adaptee.notifyRenderStyle(evt.getSource());
            }
        }
    }
}

