/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.screenbuilder.ScreenLoader;
import com.ge.med.cse.cvf.screenbuilder.VScreen;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class J3DPortLinkingManager {
    private static ScreenDisplayedListener screenDisplayedListener = null;
    private List<XpViewportDirector> linkDirectors = new ArrayList<XpViewportDirector>();
    private List<XpViewportDirector> permanentlyLinkedDirectors = new ArrayList<XpViewportDirector>();
    private static J3DPortLinkingManager portlinkmgr = null;
    private static boolean _linked;
    private J3DViewport[] ports3D = null;
    private ViewTypeListener viewListener = new ViewTypeListener();
    private ScreenLoader sc;

    private J3DPortLinkingManager() {
        this.init();
    }

    private void init() {
        Object o;
        Class c;
        int i;
        String[] lpdirs;
        Properties properties = CvPropertiesManager.getProperties();
        String val = properties.getProperty("DMPR_LinkedPortDirectors");
        if (val != null) {
            lpdirs = val.split(",");
            for (i = 0; i < lpdirs.length; ++i) {
                try {
                    c = CvUtils.getClass(lpdirs[i]);
                    o = c.newInstance();
                    if (!(o instanceof XpViewportDirector)) continue;
                    this.linkDirectors.add((XpViewportDirector)o);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((val = properties.getProperty("DMPR_Permanently_LinkedPortDirectors")) != null) {
            lpdirs = val.split(",");
            for (i = 0; i < lpdirs.length; ++i) {
                try {
                    c = CvUtils.getClass(lpdirs[i]);
                    o = c.newInstance();
                    if (!(o instanceof XpViewportDirector)) continue;
                    this.permanentlyLinkedDirectors.add((XpViewportDirector)o);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void connectViewport(XpViewport viewport, Class c) {
        for (XpViewportDirector xpdir : this.linkDirectors) {
            if (!c.isInstance(xpdir)) continue;
            xpdir.connectViewport(viewport);
            return;
        }
        for (XpViewportDirector xpdir : this.permanentlyLinkedDirectors) {
            if (!c.isInstance(xpdir)) continue;
            xpdir.connectViewport(viewport);
            return;
        }
    }

    private void disconnectViewport(XpViewport viewport, Class c) {
        for (XpViewportDirector xpdir : this.linkDirectors) {
            if (!c.isInstance(xpdir)) continue;
            xpdir.disconnectViewport(viewport);
            return;
        }
        for (XpViewportDirector xpdir : this.permanentlyLinkedDirectors) {
            if (!c.isInstance(xpdir)) continue;
            xpdir.disconnectViewport(viewport);
            return;
        }
    }

    private void disconnectAllViewports(Class c) {
        for (XpViewportDirector xpdir : this.linkDirectors) {
            if (!c.isInstance(xpdir)) continue;
            xpdir.disconnectAllViewports();
            return;
        }
        for (XpViewportDirector xpdir : this.permanentlyLinkedDirectors) {
            if (!c.isInstance(xpdir)) continue;
            xpdir.disconnectAllViewports();
            return;
        }
    }

    public static J3DPortLinkingManager getInstance() {
        if (portlinkmgr == null) {
            portlinkmgr = new J3DPortLinkingManager();
        }
        return portlinkmgr;
    }

    public void setScreenLoader(ScreenLoader screenLoader) {
        if (this.sc != null) {
            this.sc.removePropertyChangeListener("ScreenDisplayed", screenDisplayedListener);
        }
        this.sc = screenLoader;
        screenDisplayedListener = new ScreenDisplayedListener();
        this.sc.addPropertyChangeListener("ScreenDisplayed", screenDisplayedListener);
    }

    public void setPortsLinked(boolean link) throws ClassNotFoundException {
        block5: {
            block4: {
                _linked = link;
                if (!_linked) break block4;
                VScreen currentScreen = this.sc.getVScreen();
                if (!(currentScreen.getPorts()[0] instanceof T3DCapable)) break block5;
                for (int i = 0; i < this.linkDirectors.size(); ++i) {
                    int j;
                    String supportedPorts = CvPropertiesManager.getProperty(this.linkDirectors.get(i).getClass().getName() + ".supportedViewTypes");
                    String[] portsArray = supportedPorts.split(",");
                    ArrayList<String> supportedPorttsList = new ArrayList<String>();
                    for (j = 0; j < portsArray.length; ++j) {
                        supportedPorttsList.add(portsArray[j]);
                    }
                    for (j = 0; j < currentScreen.getPorts().length; ++j) {
                        String viewtype = ((J3DViewport)currentScreen.getPorts()[j]).getViewType();
                        if (!supportedPorttsList.contains(viewtype)) continue;
                        this.connectViewport((XpViewport)currentScreen.getPorts()[j], CvUtils.getClass(this.linkDirectors.get(i).getClass().getName()));
                    }
                }
                break block5;
            }
            for (int i = 0; i < this.linkDirectors.size(); ++i) {
                this.disconnectAllViewports(CvUtils.getClass(this.linkDirectors.get(i).getClass().getName()));
            }
        }
    }

    public void setPermanentPortsLinked(boolean link) throws ClassNotFoundException {
        if (link) {
            VScreen currentScreen = this.sc.getVScreen();
            for (int i = 0; i < this.permanentlyLinkedDirectors.size(); ++i) {
                int j;
                String supportedPorts = CvPropertiesManager.getProperty(this.permanentlyLinkedDirectors.get(i).getClass().getName() + ".supportedViewTypes");
                String[] portsArray = supportedPorts.split(",");
                ArrayList<String> supportedPorttsList = new ArrayList<String>();
                for (j = 0; j < portsArray.length; ++j) {
                    supportedPorttsList.add(portsArray[j]);
                }
                for (j = 0; j < currentScreen.getPorts().length; ++j) {
                    String viewtype = ((J3DViewport)currentScreen.getPorts()[j]).getViewType();
                    if (!supportedPorttsList.contains(viewtype)) continue;
                    this.connectViewport((XpViewport)currentScreen.getPorts()[j], CvUtils.getClass(this.permanentlyLinkedDirectors.get(i).getClass().getName()));
                }
            }
        } else {
            for (int i = 0; i < this.permanentlyLinkedDirectors.size(); ++i) {
                this.disconnectAllViewports(CvUtils.getClass(this.permanentlyLinkedDirectors.get(i).getClass().getName()));
            }
        }
    }

    public boolean getPortsLinked() {
        return _linked;
    }

    static /* synthetic */ J3DViewport[] access$302(J3DPortLinkingManager x0, J3DViewport[] x1) {
        x0.ports3D = x1;
        return x1;
    }

    private class ViewTypeListener
    implements PropertyChangeListener {
        private ViewTypeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int j;
            ArrayList<String> supportedPorttsList;
            String[] portsArray;
            String supportedPorts;
            Class<?> cl;
            J3DViewport port = (J3DViewport)evt.getSource();
            String viewtype = port.getViewType();
            Iterator iter = J3DPortLinkingManager.this.permanentlyLinkedDirectors.iterator();
            while (iter.hasNext()) {
                cl = ((XpViewportDirector)iter.next()).getClass();
                supportedPorts = CvPropertiesManager.getProperty(cl.getName() + ".supportedViewTypes");
                portsArray = supportedPorts.split(",");
                supportedPorttsList = new ArrayList<String>();
                for (j = 0; j < portsArray.length; ++j) {
                    supportedPorttsList.add(portsArray[j]);
                }
                if (supportedPorttsList.contains(viewtype)) {
                    J3DPortLinkingManager.this.connectViewport(port, cl);
                    continue;
                }
                J3DPortLinkingManager.this.disconnectViewport(port, cl);
            }
            iter = J3DPortLinkingManager.this.linkDirectors.iterator();
            while (iter.hasNext()) {
                cl = ((XpViewportDirector)iter.next()).getClass();
                supportedPorts = CvPropertiesManager.getProperty(cl.getName() + ".supportedViewTypes");
                portsArray = supportedPorts.split(",");
                supportedPorttsList = new ArrayList();
                for (j = 0; j < portsArray.length; ++j) {
                    supportedPorttsList.add(portsArray[j]);
                }
                if (supportedPorttsList.contains(viewtype)) {
                    J3DPortLinkingManager.this.connectViewport(port, cl);
                    continue;
                }
                J3DPortLinkingManager.this.disconnectViewport(port, cl);
            }
        }
    }

    private class ScreenDisplayedListener
    implements PropertyChangeListener {
        private ScreenDisplayedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String newScreen = (String)evt.getNewValue();
            VScreen newVScreen = J3DPortLinkingManager.this.sc.getScreen(newScreen);
            J3DPortLinkingManager.access$302(J3DPortLinkingManager.this, new J3DViewport[newVScreen.getPorts().length]);
        }
    }
}

