/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.DefaultCursor3DModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class J3DLinkedCursorDirector
implements XpViewportDirector,
PropertyChangeListener {
    protected static boolean debugTrace = CvPropertiesManager.getProperty("vav.debug_trace") != null;
    protected static final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.j3d.vav");
    private ArrayList<T3DViewport> portList = new ArrayList();
    private ArrayList<Cursor3DVc> cursorList = new ArrayList();
    private DefaultCursor3DModel model = new DefaultCursor3DModel();
    private Cursor3DListener cursorListener = new Cursor3DListener();
    boolean isVisble = false;
    boolean attached = false;

    @Override
    public void connectViewport(XpViewport viewport) {
        if (viewport == null || !(viewport instanceof T3DViewport) || this.portList.contains(viewport)) {
            return;
        }
        T3DViewport t3dvp = (T3DViewport)viewport;
        this.portList.add(t3dvp);
        this.cursorList.add(null);
        this.initPort(t3dvp);
        t3dvp.addPropertyChangeListener("VOLUME_PROPERTY", this);
        t3dvp.addPropertyChangeListener("lookPoint", this.cursorListener);
        t3dvp.addPropertyChangeListener("eyePoint", this.cursorListener);
        t3dvp.addPropertyChangeListener("viewType", this);
        if (this.portList.size() > 0 && !this.attached) {
            this.attached = true;
            this.portList.get(0).addPropertyChangeListener("Cine", this);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int index = 0; index < this.portList.size(); ++index) {
            if (index >= 0 && index < this.cursorList.size() && this.cursorList.get(index) != null) {
                this.portList.get(index).getT3DComponent().remove(this.cursorList.get(index));
                this.cursorList.get(index).removeMouseListener(this.cursorListener);
            }
            this.portList.get(index).removePropertyChangeListener("Cine", this);
            this.portList.get(index).removePropertyChangeListener("lookPoint", this.cursorListener);
            this.portList.get(index).removePropertyChangeListener("eyePoint", this.cursorListener);
            this.portList.get(index).removePropertyChangeListener("VOLUME_PROPERTY", this);
            this.portList.get(index).removePropertyChangeListener("viewType", this);
            this.attached = false;
        }
        this.model.removeChangeListener(this.cursorListener);
        this.cursorList.clear();
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (viewport == null || !this.portList.contains(viewport)) {
            return;
        }
        int index = this.portList.indexOf(viewport);
        if (index >= 0 && index < this.cursorList.size()) {
            if (this.cursorList.get(index) != null) {
                this.portList.get(index).getT3DComponent().remove(this.cursorList.get(index));
                this.cursorList.get(index).removeMouseListener(this.cursorListener);
            }
            this.cursorList.remove(index);
        }
        this.portList.remove(index);
        viewport.removePropertyChangeListener("Cine", this);
        viewport.removePropertyChangeListener("lookPoint", this.cursorListener);
        viewport.removePropertyChangeListener("eyePoint", this.cursorListener);
        viewport.removePropertyChangeListener("VOLUME_PROPERTY", this);
        viewport.removePropertyChangeListener("viewType", this);
        if (this.portList.size() == 0) {
            this.model.removeChangeListener(this.cursorListener);
            this.attached = false;
        }
    }

    private void initPort(T3DViewport port) {
        if (port.getVolumeModel() == null) {
            return;
        }
        ViewTypeCapable vcap = (ViewTypeCapable)port.getCapable(ViewTypeCapable.class.getName());
        if (vcap != null && !vcap.getViewType(vcap.getViewType()).isViewLinkable()) {
            return;
        }
        this.model.setBoundsCheckEnabled(true);
        this.model.setT3D(port);
        this.model.removeChangeListener(this.cursorListener);
        double[] lookpt = this.portList.get(0).getLookPoint(null);
        this.model.setPoint(new CPoint(lookpt, 2));
        this.model.addChangeListener(this.cursorListener);
        int index = this.portList.indexOf(port);
        if (index >= 0 && index < this.cursorList.size() && this.cursorList.get(index) == null) {
            Cursor3DVc cursor = new Cursor3DVc(this.model, port);
            cursor.setCheckingWorldBounds(true);
            cursor.setContinuousUpdateEnabled(true);
            cursor.setAutoPage(false);
            cursor.setCursorShape(Cursor3DVc.X_SHAPE);
            cursor.setCursorColor(Color.RED);
            cursor.addMouseListener(this.cursorListener);
            port.getT3DComponent().add(cursor);
            this.cursorList.add(index, cursor);
            port.updateUI();
        }
    }

    private void linkPort(boolean link, T3DViewport port) {
        if (port == null || !this.portList.contains(port)) {
            return;
        }
        int index = this.portList.indexOf(port);
        if (index >= 0 && index < this.cursorList.size() && this.cursorList.get(index) != null) {
            this.portList.get(index).getT3DComponent().remove(this.cursorList.get(index));
            this.cursorList.get(index).removeMouseListener(this.cursorListener);
        }
        port.removePropertyChangeListener("Cine", this);
        port.removePropertyChangeListener("lookPoint", this.cursorListener);
        port.removePropertyChangeListener("eyePoint", this.cursorListener);
        port.removePropertyChangeListener("VOLUME_PROPERTY", this);
        if (link) {
            if (index >= 0 && index < this.cursorList.size() && this.cursorList.get(index) != null) {
                this.portList.get(index).getT3DComponent().add(this.cursorList.get(index));
                this.cursorList.get(index).addMouseListener(this.cursorListener);
            }
            port.addPropertyChangeListener("Cine", this);
            port.addPropertyChangeListener("lookPoint", this.cursorListener);
            port.addPropertyChangeListener("eyePoint", this.cursorListener);
            port.addPropertyChangeListener("VOLUME_PROPERTY", this);
        }
        port.updateUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int size;
        if (evt.getPropertyName().equals("VOLUME_PROPERTY") && evt.getSource() instanceof T3DViewport) {
            this.initPort((T3DViewport)evt.getSource());
            logger.log(Level.INFO, "Port Volume changed ..... Cursor model point is " + this.model.getPoint(null).toArray());
        } else if (evt.getPropertyName().equals("viewType")) {
            ViewTypeCapable vtc;
            T3DViewport port = (T3DViewport)evt.getSource();
            if (debugTrace) {
                System.err.println("------- J3DLinkedCursorDirector .... VIEW_TYPE Change Property from port " + this.portList.indexOf(port));
            }
            if ((vtc = (ViewTypeCapable)port.getCapable(ViewTypeCapable.class.getName())) != null) {
                ViewTypeCapable.ViewTypeActor vactor = vtc.getViewType(vtc.getViewType());
                this.linkPort(vactor.isViewLinkable(), port);
            }
        } else if (evt.getPropertyName().equals("Cine") && (size = this.cursorList.size()) == 0) {
            return;
        }
    }

    private class Cursor3DListener
    extends MouseAdapter
    implements PropertyChangeListener,
    XjChangeListener {
        double[] eyePoint = new double[3];
        double[] lookPoint = new double[3];
        double[] upVector = new double[3];
        JnVector3d lookVector = new JnVector3d();
        JnVector3d cursorVector = new JnVector3d();
        double dot;
        JTextArea text = new JTextArea();
        JPopupMenu popup = new JPopupMenu();
        private final DecimalFormat df = new DecimalFormat("##0.0");
        private boolean isValueAdjusting = false;
        private double[] ulc = new double[3];
        private double[] xside = new double[3];
        private double[] yside = new double[3];
        private double[] zside = new double[3];
        private CPoint vect = new CPoint(2);

        private synchronized void syncPorts(CPoint cursor) {
            this.isValueAdjusting = true;
            int numPorts = J3DLinkedCursorDirector.this.portList.size();
            for (int i = 0; i < numPorts; ++i) {
                T3DViewport port = (T3DViewport)J3DLinkedCursorDirector.this.portList.get(i);
                String rstyle = port.getRenderStyle();
                if ("VOLUME".equals(rstyle) || "FULLBODY_MIP".equals(rstyle) || "FULLBODY_MINIP".equals(rstyle) || "FULLBODY_AVERAGE".equals(rstyle) || i < J3DLinkedCursorDirector.this.cursorList.size() && J3DLinkedCursorDirector.this.cursorList.get(i) != null && ((Cursor3DVc)J3DLinkedCursorDirector.this.cursorList.get(i)).isDriving()) continue;
                ViewTypeCapable vcap = (ViewTypeCapable)port.getCapable(ViewTypeCapable.class.getName());
                if (vcap != null && !vcap.getViewType(vcap.getViewType()).isViewLinkable()) {
                    return;
                }
                port.getEyePoint(this.eyePoint);
                port.getLookPoint(this.lookPoint);
                this.lookVector.set(this.eyePoint[0] - this.lookPoint[0], this.eyePoint[1] - this.lookPoint[1], this.eyePoint[2] - this.lookPoint[2]);
                this.cursorVector.set(cursor.x - this.lookPoint[0], cursor.y - this.lookPoint[1], cursor.z - this.lookPoint[2]);
                this.lookVector.normalize();
                this.dot = this.cursorVector.dot(this.lookVector);
                this.lookVector.scale(this.dot);
                this.eyePoint[0] = this.eyePoint[0] + this.lookVector.x;
                this.eyePoint[1] = this.eyePoint[1] + this.lookVector.y;
                this.eyePoint[2] = this.eyePoint[2] + this.lookVector.z;
                this.lookPoint[0] = this.lookPoint[0] + this.lookVector.x;
                this.lookPoint[1] = this.lookPoint[1] + this.lookVector.y;
                this.lookPoint[2] = this.lookPoint[2] + this.lookVector.z;
                if (debugTrace) {
                    port.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
                    if (!GeomUtils.isInsideVolume(this.ulc, this.xside, this.yside, this.zside, this.lookPoint)) {
                        System.err.println("------- J3DLinkedCursorDirector.syncPorts .... new look point outside volume ??????????????????");
                        System.err.println("------- J3DLinkedCursorDirector.syncPorts ....ulc : " + this.ulc[0] + " " + this.ulc[1] + " " + this.ulc[2]);
                        System.err.println("------- J3DLinkedCursorDirector.syncPorts ....xside : " + this.xside[0] + " " + this.xside[1] + " " + this.xside[2]);
                        System.err.println("------- J3DLinkedCursorDirector.syncPorts ....yside : " + this.yside[0] + " " + this.yside[1] + " " + this.yside[2]);
                        System.err.println("------- J3DLinkedCursorDirector.syncPorts ....zside : " + this.zside[0] + " " + this.zside[1] + " " + this.zside[2]);
                        System.err.println("------- J3DLinkedCursorDirector.syncPorts ....lookPoint : " + this.lookPoint[0] + " " + this.lookPoint[1] + " " + this.lookPoint[2]);
                    }
                }
                port.setCamera(this.eyePoint, this.lookPoint, port.getUp(this.upVector));
                port.refreshContents();
            }
            this.isValueAdjusting = false;
        }

        private synchronized boolean isValueAdjusting() {
            return this.isValueAdjusting;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.isValueAdjusting()) {
                return;
            }
            if ("lookPoint".equals(evt.getPropertyName()) || "eyePoint".equals(evt.getPropertyName())) {
                T3DCapable port = (T3DCapable)evt.getSource();
                ViewTypeCapable vcap = (ViewTypeCapable)port.getCapable(ViewTypeCapable.class.getName());
                if (vcap != null && !vcap.getViewType(vcap.getViewType()).isViewLinkable()) {
                    return;
                }
                port.getEyePoint(this.eyePoint);
                port.getLookPoint(this.lookPoint);
                this.vect.set(J3DLinkedCursorDirector.this.model.getPoint(null));
                this.lookVector.set(this.eyePoint[0] - this.lookPoint[0], this.eyePoint[1] - this.lookPoint[1], this.eyePoint[2] - this.lookPoint[2]);
                this.cursorVector.set(this.vect.x - this.lookPoint[0], this.vect.y - this.lookPoint[1], this.vect.z - this.lookPoint[2]);
                this.lookVector.normalize();
                this.dot = this.cursorVector.dot(this.lookVector);
                if (Math.abs(this.dot) > 1.0E-4) {
                    this.lookVector.scale(this.dot);
                    this.vect.sub(this.lookVector);
                    if (debugTrace) {
                        port.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
                        if (!GeomUtils.isInsideVolume(this.ulc, this.xside, this.yside, this.zside, this.vect.toArray())) {
                            System.err.println("------- J3DLinkedCursorDirector.propertyChange .... new cursor point outside volume ??????????????????");
                            System.err.println("------- J3DLinkedCursorDirector.propertyChange ....ulc : " + this.ulc[0] + " " + this.ulc[1] + " " + this.ulc[2]);
                            System.err.println("------- J3DLinkedCursorDirector.propertyChange ....xside : " + this.xside[0] + " " + this.xside[1] + " " + this.xside[2]);
                            System.err.println("------- J3DLinkedCursorDirector.propertyChange ....yside : " + this.yside[0] + " " + this.yside[1] + " " + this.yside[2]);
                            System.err.println("------- J3DLinkedCursorDirector.propertyChange ....zside : " + this.zside[0] + " " + this.zside[1] + " " + this.zside[2]);
                            System.err.println("------- J3DLinkedCursorDirector.propertyChange ....vect : " + this.vect.x + " " + this.vect.y + " " + this.vect.z);
                        }
                    }
                    J3DLinkedCursorDirector.this.model.setPoint(this.vect);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public synchronized void stateChanged(EventObject e) {
            Cursor3DModel model = (Cursor3DModel)e.getSource();
            this.syncPorts(model.getPoint(null));
        }
    }
}

