/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.j3d.ViewCalculator;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;

public class J3DDefaultPagingViewCalculator
extends ViewCalculator {
    private JnVector3d viewvec = new JnVector3d();
    private double spacing = -1.0;
    private double defaultSpacing = 1.0;
    private boolean snapToVoxel = CvPropertiesManager.getBoolean("cvf.j3d.viewcalculator.snapToVoxel", true);

    public J3DDefaultPagingViewCalculator() {
    }

    public J3DDefaultPagingViewCalculator(T3DCapable capable) {
        super(capable);
    }

    public J3DDefaultPagingViewCalculator(T3DCapable capable, XjVolumeGeometry vol) {
        super(capable, vol);
    }

    public void setSpacing(double spacingMM) {
        double oldSpc = this.spacing;
        this.spacing = spacingMM;
        if (this.t3dCapable == null || !this.volumeLoaded) {
            return;
        }
        if (this.spacing < this.defaultSpacing) {
            this.spacing = this.defaultSpacing;
        }
        this.curpos = this.getViewIndex(this.t3dCapable.getEyePoint(null), this.t3dCapable.getLookPoint(null), this.t3dCapable.getUp(null));
        double d = (double)(this.numViews - 1) * oldSpc;
        int x = (int)Math.floor(d / this.getSpacing());
        this.numViews = x + 1;
        this.fireFrameIndexPropertyChange(-1, this.curpos);
    }

    public double getSpacing() {
        if (this.spacing == -1.0) {
            return this.defaultSpacing;
        }
        return this.spacing;
    }

    @Override
    protected void reset() {
        super.reset();
        this.viewvec.set(0.0, 0.0, 0.0);
        this.spacing = -1.0;
        this.defaultSpacing = -1.0;
    }

    @Override
    protected void updateContent() {
        JnVector3d p2;
        JnVector3d p1;
        if (!this.volumeLoaded) {
            return;
        }
        double[] tmplook = this.t3dCapable.getLookPoint(null);
        double[] tmpeye = this.t3dCapable.getEyePoint(null);
        this.t3dCapable.getUp(this.currentUp);
        double[] tmpv = new double[3];
        JnVector3d.sub(tmplook, tmpeye, tmpv);
        JnVector3d.normalize(tmpv);
        double dotP = this.viewvec.dot(tmpv);
        if (Math.abs(dotP - 1.0) < 1.0E-4) {
            if (JnVector3d.distance(this.currentLookPt, tmplook) > 0.01) {
                double[] lookv = new double[3];
                JnVector3d.sub(this.currentLookPt, tmplook, lookv);
                JnVector3d.normalize(lookv);
                dotP = JnVector3d.dot(lookv, this.viewvec.toArray());
                if (Math.abs(dotP) > 1.0E-4) {
                    this.currentLookPt[0] = tmplook[0];
                    this.currentLookPt[1] = tmplook[1];
                    this.currentLookPt[2] = tmplook[2];
                    this.curpos = (int)Math.floor(JnVector3d.distance(this.firstLookPt.toArray(), tmplook) / this.getSpacing());
                    this.fireFrameIndexPropertyChange(-1, this.curpos);
                    return;
                }
            } else {
                return;
            }
        }
        this.currentLookPt[0] = tmplook[0];
        this.currentLookPt[1] = tmplook[1];
        this.currentLookPt[2] = tmplook[2];
        this.viewvec = new JnVector3d(tmpv);
        this.defaultSpacing = this.getDefaultSpacing(tmpv);
        if (this.spacing != -1.0 && this.spacing < this.defaultSpacing) {
            this.spacing = this.defaultSpacing;
        }
        if (GeomUtils.lineParallelepipedIntersection(new JnVector3d(tmplook), new JnVector3d(tmpv), new JnVector3d(this.ulc), new JnVector3d(this.xside), new JnVector3d(this.yside), new JnVector3d(this.zside), p1 = new JnVector3d(), p2 = new JnVector3d())) {
            int x;
            this.ras2vox.transform(p1);
            this.ras2vox.transform(p2);
            J3DGeomUtils.roundPoint(p1);
            J3DGeomUtils.roundPoint(p2);
            J3DGeomUtils.snapPointToVolume(p1, this.vdims);
            J3DGeomUtils.snapPointToVolume(p2, this.vdims);
            this.vox2ras.transform(p1);
            this.vox2ras.transform(p2);
            JnVector3d.sub(tmplook, tmpv, tmpeye);
            double p1l = JnVector3d.distance(tmplook, p1.toArray());
            double p1e = JnVector3d.distance(tmpeye, p1.toArray());
            double p2l = JnVector3d.distance(tmplook, p2.toArray());
            double p2e = JnVector3d.distance(tmpeye, p2.toArray());
            JnVector3d minpt = null;
            JnVector3d maxpt = null;
            if (p1e <= p1l && p2e <= p2l) {
                if (p1e >= p2e) {
                    minpt = p1;
                    maxpt = p2;
                } else {
                    minpt = p2;
                    maxpt = p1;
                }
            } else if (p1e > p1l && p2e > p2l) {
                if (p1e <= p2e) {
                    minpt = p1;
                    maxpt = p2;
                } else {
                    minpt = p2;
                    maxpt = p1;
                }
            } else if (p1e <= p2l) {
                minpt = p1;
                maxpt = p2;
            } else {
                minpt = p2;
                maxpt = p1;
            }
            double d = Math.abs(JnVector3d.distance(minpt.toArray(), tmplook));
            this.curpos = x = (int)Math.floor(d / this.getSpacing());
            d = Math.abs(JnVector3d.distance(tmplook, maxpt.toArray()));
            this.numViews = (x += (int)Math.floor(d / this.getSpacing())) + 1;
            int i = 0;
            do {
                this.getView(i, tmpeye, tmplook, this.currentUp);
            } while (!this.isInVolume(tmplook) && ++i < this.curpos);
            if (i == this.curpos) {
                this.firstLookPt.set(this.currentLookPt);
            } else {
                this.firstLookPt.set(tmplook);
            }
            this.numViews -= i;
            this.curpos -= i;
            i = this.numViews - 1;
            do {
                this.getView(i, tmpeye, tmplook, this.currentUp);
            } while (!this.isInVolume(tmplook) && --i > this.curpos);
            this.numViews = 1 + i;
        } else {
            this.curpos = 0;
            this.numViews = 0;
            this.firstLookPt.set(0.0, 0.0, 0.0);
        }
        this.fireFrameIndexPropertyChange(-1, this.curpos);
    }

    @Override
    public void getView(int i, double[] eyept, double[] lookpt, double[] up) {
        if (this.curpos == i) {
            this.t3dCapable.getEyePoint(eyept);
            this.t3dCapable.getLookPoint(lookpt);
            this.t3dCapable.getUp(up);
            return;
        }
        double[] tmplook = this.t3dCapable.getLookPoint(null);
        double[] tmpeye = this.t3dCapable.getEyePoint(null);
        JnVector3d tmpViewVec = new JnVector3d(tmplook);
        tmpViewVec.sub(tmpeye);
        tmpViewVec.normalize();
        tmpViewVec.scale(this.getSpacing() * (double)Math.abs(this.curpos - i));
        if (i > this.curpos) {
            lookpt[0] = tmplook[0] + tmpViewVec.x;
            lookpt[1] = tmplook[1] + tmpViewVec.y;
            lookpt[2] = tmplook[2] + tmpViewVec.z;
            eyept[0] = tmpeye[0] + tmpViewVec.x;
            eyept[1] = tmpeye[1] + tmpViewVec.y;
            eyept[2] = tmpeye[2] + tmpViewVec.z;
        } else if (i < this.curpos) {
            lookpt[0] = tmplook[0] - tmpViewVec.x;
            lookpt[1] = tmplook[1] - tmpViewVec.y;
            lookpt[2] = tmplook[2] - tmpViewVec.z;
            eyept[0] = tmpeye[0] - tmpViewVec.x;
            eyept[1] = tmpeye[1] - tmpViewVec.y;
            eyept[2] = tmpeye[2] - tmpViewVec.z;
        }
        if (this.snapToVoxel) {
            tmpViewVec.sub(eyept, lookpt).normalize();
            short plane = J3DGeomUtils.getPlaneType(tmpViewVec);
            double diff = 0.0;
            if (plane == 2) {
                JnVector3d tmpTransfrom = new JnVector3d(lookpt);
                this.ras2vox.transform(tmpTransfrom);
                tmpTransfrom.z = Math.rint(tmpTransfrom.z);
                this.vox2ras.transform(tmpTransfrom);
                diff = tmpTransfrom.z - lookpt[2];
                lookpt[2] = tmpTransfrom.z;
                eyept[2] = eyept[2] + diff;
            } else if (plane == 8) {
                JnVector3d tmpTransfrom = new JnVector3d(lookpt);
                this.ras2vox.transform(tmpTransfrom);
                tmpTransfrom.y = Math.rint(tmpTransfrom.y);
                this.vox2ras.transform(tmpTransfrom);
                diff = tmpTransfrom.y - lookpt[1];
                lookpt[1] = tmpTransfrom.y;
                eyept[1] = eyept[1] + diff;
            } else if (plane == 4) {
                JnVector3d tmpTransfrom = new JnVector3d(lookpt);
                this.ras2vox.transform(tmpTransfrom);
                tmpTransfrom.x = Math.rint(tmpTransfrom.x);
                this.vox2ras.transform(tmpTransfrom);
                diff = tmpTransfrom.x - lookpt[0];
                lookpt[0] = tmpTransfrom.x;
                eyept[0] = eyept[0] + diff;
            }
        }
        this.t3dCapable.getUp(up);
    }

    @Override
    public int getViewIndex(double[] eyept, double[] lookpt, double[] up) {
        int viewIndex = 0;
        double[] tmpv = new double[3];
        JnVector3d.sub(lookpt, eyept, tmpv);
        JnVector3d.normalize(tmpv);
        double dotP = this.viewvec.dot(tmpv);
        if (Math.abs(dotP - 1.0) >= 1.0E-4) {
            return -1;
        }
        viewIndex = (int)Math.floor(JnVector3d.distance(this.firstLookPt.toArray(), lookpt) / this.getSpacing());
        return viewIndex;
    }
}

