/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjDynamicVolume;
import com.ge.med.idc.XjSlice;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public class DynamicVolume
implements XjDynamicVolume,
XjVolume,
XpDicomObject {
    public static final String LOADING_COMPLETE = "LOADING_COMPLETE";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.j3d");
    private int[] volDims = null;
    private JnVector3d origRAS = null;
    private JnVector3d dxRAS = null;
    private JnVector3d dyRAS = null;
    private JnVector3d dzRAS = null;
    double dzMagnitude = 0.0;
    private IImage[] slices = null;
    private IImage firstSlice = null;
    private int bitsPerVoxel = -1;
    private int pixelType = 0;
    private boolean littleEndian;
    private double deflevel = 600.0;
    private double defwidth = 1200.0;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private String modality = "";
    private boolean manufacturedByGE = false;
    private boolean imageBroadcastPaused = false;
    private List<Integer> imageAddedQueue = new ArrayList<Integer>();
    private DMSession session = null;
    private DMQuery queryFilter = null;
    private boolean loadingComplete = false;
    private static final double IMAGE_POSITION_TOLERANCE = 0.1;
    private DMObject[] allImgs = null;
    private DMEventListener listener = new DMEventListener(){

        @Override
        public void actionPerformed(DMEvent e) {
            DMComposite comp = null;
            if (e.getSource() instanceof String) {
                String path = e.getSource().toString();
                if (path != null) {
                    comp = DynamicVolume.this.session.getComposite(path);
                }
            } else if (e.getSource() instanceof DMComposite) {
                comp = (DMComposite)e.getSource();
            }
            if (comp != null) {
                DynamicVolume.this.addImages(comp.getImages(null));
            }
        }
    };

    public DynamicVolume(XjVolumeGeometry volume) {
        this.volDims = volume.getVolumeDimensions(null);
        this.origRAS = new JnVector3d(volume.getRASOfOrigin(null));
        this.dxRAS = new JnVector3d(volume.getXDirectionRAS(null));
        this.dyRAS = new JnVector3d(volume.getYDirectionRAS(null));
        this.dzRAS = new JnVector3d(volume.getZDirectionRAS(null));
        this.dzMagnitude = this.dzRAS.magnitude();
        this.slices = new IImage[this.volDims[2]];
        if (this.session != null) {
            this.session.addDMEventListener(1, this.listener);
        }
    }

    public DynamicVolume(int[] dims, double[] ras_orig, double[] ras_dx, double[] ras_dy, double[] ras_dz) {
        this.volDims = new int[]{dims[0], dims[1], dims[2]};
        this.origRAS = ras_orig != null ? new JnVector3d(Arrays.copyOf(ras_orig, ras_orig.length)) : new JnVector3d(null);
        this.dxRAS = ras_dx != null ? new JnVector3d(Arrays.copyOf(ras_dx, ras_dx.length)) : new JnVector3d(null);
        this.dyRAS = ras_dy != null ? new JnVector3d(Arrays.copyOf(ras_dy, ras_dy.length)) : new JnVector3d(null);
        this.dzRAS = ras_dz != null ? new JnVector3d(Arrays.copyOf(ras_dz, ras_dz.length)) : new JnVector3d(null);
        this.dzMagnitude = this.dzRAS.magnitude();
        this.slices = new IImage[this.volDims[2]];
        this.firstSlice = null;
        if (this.session != null) {
            this.session.addDMEventListener(1, this.listener);
        }
    }

    public DynamicVolume(int[] dims, double[] ras_orig, double[] ras_dx, double[] ras_dy, double[] ras_dz, DMObject[] imgs) {
        this(dims, ras_orig, ras_dx, ras_dy, ras_dz);
        if (imgs != null) {
            this.allImgs = Arrays.copyOf(imgs, imgs.length);
        }
    }

    public void setDMSession(DMSession sess) {
        if (this.session != null) {
            this.session.removeDMEventListener(this.listener);
        }
        this.session = sess;
        if (this.session != null) {
            this.session.addDMEventListener(1, this.listener);
        }
    }

    public void setModality(String modalityStr) {
        this.modality = modalityStr;
    }

    public void setRescaleSlopeIntercept(double slope, double intercept) {
        this.rescaleSlope = slope;
        this.rescaleIntercept = intercept;
    }

    public void setImageFilter(String dmquery) {
        this.queryFilter = new DMQuery(dmquery);
    }

    public int addImage(DMImage img) {
        if (img == null) {
            return -1;
        }
        if (this.queryFilter != null && !this.queryFilter.valid(new myDMTagValueInterface(img))) {
            String missFitInfo = this.missFitInfo(img);
            String msg = "Invalid image: Does not belong to this volume as per the set filter " + this.queryFilter.toString();
            logger.info(msg + "\n" + missFitInfo);
            return -1;
        }
        int position = this.getImagePosition(img);
        if (position == -1) {
            String missFitInfo = this.missFitInfo(img);
            String msg = "Invalid image: Could not fit within bounds of defined volume.";
            logger.info(msg + "\n" + missFitInfo);
            return -1;
        }
        if (this.slices[position] != null) {
            String missFitInfo = this.missFitInfo(img);
            String msg = "Duplicate image location [" + position + "], Ignoring this image";
            logger.info(msg + "\n" + missFitInfo);
            return position;
        }
        if (this.firstSlice == null) {
            this.loadFirstImageValues(img);
        }
        IImage slice = this.loadSliceValues(img);
        if (this.firstSlice == null) {
            this.firstSlice = slice;
        }
        this.slices[position] = slice;
        if (this.imageBroadcastPaused) {
            this.imageAddedQueue.add(new Integer(position));
        } else {
            this.pcs.firePropertyChange(new PropertyChangeEvent(this, "IMAGE_ADDED", null, new Integer(position)));
        }
        return position;
    }

    protected String missFitInfo(DMImage img) {
        String missFitInfo = "";
        missFitInfo = missFitInfo + "Image tags: \n";
        missFitInfo = missFitInfo + "\tPosition: " + img.getValue(32, 50) + "\n";
        missFitInfo = missFitInfo + "\tOrientation: " + img.getValue(32, 55) + "\n";
        missFitInfo = missFitInfo + "\tRows: " + img.getValue(40, 16) + "\n";
        missFitInfo = missFitInfo + "\tCols: " + img.getValue(40, 17) + "\n";
        missFitInfo = missFitInfo + "\tPixel Spacing: " + img.getValue(40, 48) + "\n";
        missFitInfo = missFitInfo + "\tThickness: " + img.getValue(24, 80) + "\n";
        missFitInfo = missFitInfo + "Volume info: \n";
        missFitInfo = missFitInfo + "\tDimensions: " + this.volDims[0] + "," + this.volDims[1] + "," + this.volDims[2] + "\n";
        missFitInfo = missFitInfo + "\tOrigin: " + this.origRAS + "\n";
        missFitInfo = missFitInfo + "\tdx: " + this.dxRAS + "\n";
        missFitInfo = missFitInfo + "\tdy: " + this.dyRAS + "\n";
        missFitInfo = missFitInfo + "\tdz: " + this.dzRAS + "\n";
        return missFitInfo;
    }

    public int addImages(DMImage[] images) {
        if (images == null) {
            return 0;
        }
        int retVal = 0;
        for (int i = 0; i < images.length; ++i) {
            if (this.addImage(images[i]) < 0) continue;
            ++retVal;
        }
        return retVal;
    }

    private void loadFirstImageValues(DMImage img) {
        DMComposite dmc = img.getComposite();
        DMElement typeTag = new DMElement(40, 4);
        DMElement pixelsTag = new DMElement(32736, 16);
        DMElement bitsTag = new DMElement(40, 256);
        DMElement manTag = new DMElement(8, 112);
        DMElement modTag = new DMElement(8, 96);
        DMElement[] tags = new DMElement[]{pixelsTag, bitsTag, typeTag, manTag, modTag};
        tags[0].setFillValue(false);
        if (dmc instanceof DMComposite) {
            dmc.getValues(tags);
        } else if (dmc instanceof DMObject) {
            ((DMObject)((Object)dmc)).getValues(tags);
        } else {
            for (int i = 0; i < tags.length; ++i) {
                tags[i].value = dmc.getValue(new DMTag(tags[i].group, tags[i].element));
            }
        }
        Object str = manTag.value;
        this.manufacturedByGE = str != null && str.toString().trim().equals("GE MEDICAL SYSTEMS");
        str = modTag.value;
        this.modality = DicomUtils.getModality(dmc);
        this.littleEndian = tags[0].isLittleEndian();
        String imgType = ((String)typeTag.value).trim();
        this.bitsPerVoxel = fileImage.getBitsPerPix(tags);
        if ("MONOCHROME2".equalsIgnoreCase(imgType)) {
            this.pixelType = 1;
        } else if ("RGB".equalsIgnoreCase(imgType)) {
            this.pixelType = 2;
        } else if ("PALETTE COLOR".equalsIgnoreCase(imgType)) {
            this.pixelType = 3;
        }
        this.deflevel = DicomUtils.getWindowLevel(dmc);
        this.defwidth = DicomUtils.getWindowWidth(dmc);
        if ("MR".equalsIgnoreCase(this.modality)) {
            this.rescaleIntercept = 0.0;
            this.rescaleSlope = 1.0;
        }
    }

    private IImage loadSliceValues(DMImage img) {
        DMComposite dmc = img.getComposite();
        DMElement ulcElem = new DMElement(32, 50);
        DMElement tsElem = new DMElement(2, 16);
        DMElement pixElem = new DMElement(32736, 16);
        pixElem.fillValue = false;
        dmc.getValues(new DMElement[]{ulcElem, tsElem, pixElem});
        double[] ulc = new double[3];
        this.filldoubles(ulcElem.value.toString(), ulc);
        ulc[0] = -ulc[0];
        ulc[1] = -ulc[1];
        if (this.modality.equals("CT") && this.manufacturedByGE) {
            JnVector3d.scaleAdd(ulc, this.dxRAS.generateArray(), 0.5, ulc);
            JnVector3d.scaleAdd(ulc, this.dyRAS.generateArray(), 0.5, ulc);
        }
        boolean explicitVr = tsElem.value.equals(DMUtils.TS_EBE) || tsElem.value.equals(DMUtils.TS_ELE);
        IImage slice = new IImage();
        slice.filename = dmc.getFilePath();
        System.arraycopy(ulc, 0, slice.topLeft, 0, 3);
        slice.offset = pixElem.getOffset() + (long)(explicitVr ? 12 : 8);
        slice.dmc = dmc;
        return slice;
    }

    private int getImagePosition(DMImage img) {
        if (J3DGeomUtils.validateImage((XjVolumeInfo)this, (XjDicomObject)img).error != 0) {
            return -1;
        }
        XpDicomElement ulcElem = new XpDicomElement(32, 50);
        ulcElem.value = img.getValue(ulcElem.group, ulcElem.element);
        JnVector3d ulc = new JnVector3d(ulcElem.getDoubleArrayValue());
        String modality = DicomUtils.getModality(img);
        String str = (String)img.getValue(8, 112);
        this.manufacturedByGE = str != null && str.toString().trim().equals("GE MEDICAL SYSTEMS");
        ulc.x = -ulc.x;
        ulc.y = -ulc.y;
        if (modality.equals("CT") && this.manufacturedByGE) {
            ulc.scaleAdd(0.5, this.dxRAS);
            ulc.scaleAdd(0.5, this.dyRAS);
        }
        ulc.sub(this.origRAS);
        double doublePosition = ulc.magnitude() / this.dzMagnitude;
        int position = (int)Math.round(doublePosition);
        if (Math.abs(doublePosition - (double)position) > 0.1) {
            logger.finer("Invalid image: position=" + doublePosition + "\n" + "\torigRAS=" + this.origRAS + " ulcDICOM=" + ulc);
            return -1;
        }
        if (position < 0 || position >= this.slices.length) {
            logger.finer("Invalid image: position=" + doublePosition);
            return -1;
        }
        return position;
    }

    private void filldoubles(String str, double[] dv) {
        String[] s = str.split("\\\\");
        for (int i = 0; i < s.length; ++i) {
            dv[i] = Double.parseDouble(s[i]);
        }
    }

    public boolean isImageBroadcastPaused() {
        return this.imageBroadcastPaused;
    }

    public void setImageBroadcastPaused(boolean imageBroadcastPaused) {
        if (this.imageBroadcastPaused != imageBroadcastPaused) {
            this.imageBroadcastPaused = imageBroadcastPaused;
            if (!imageBroadcastPaused) {
                while (!this.imageAddedQueue.isEmpty()) {
                    this.pcs.firePropertyChange(new PropertyChangeEvent(this, "IMAGE_ADDED", null, this.imageAddedQueue.remove(0)));
                }
            }
        }
    }

    public void setLoadingComplete() {
        this.loadingComplete = true;
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, LOADING_COMPLETE, null, null));
        this.removePropertyChangeListeners("IMAGE_ADDED");
        this.removePropertyChangeListeners(LOADING_COMPLETE);
    }

    private void removePropertyChangeListeners(String name) {
        PropertyChangeListener[] allListeners = this.pcs.getPropertyChangeListeners(name);
        for (int i = 0; i < allListeners.length; ++i) {
            this.pcs.removePropertyChangeListener(name, allListeners[i]);
        }
    }

    public boolean isLoadingComplete() {
        return this.loadingComplete;
    }

    @Override
    public int[] getVolumeDimensions(int[] dims) {
        if (dims == null) {
            dims = new int[3];
        }
        System.arraycopy(this.volDims, 0, dims, 0, 3);
        return dims;
    }

    @Override
    public double[] getRASOfOrigin(double[] ras_ulc) {
        if (ras_ulc == null) {
            ras_ulc = new double[]{this.origRAS.x, this.origRAS.y, this.origRAS.z};
        }
        return ras_ulc;
    }

    @Override
    public double[] getXDirectionRAS(double[] ras_dx) {
        if (ras_dx == null) {
            ras_dx = new double[]{this.dxRAS.x, this.dxRAS.y, this.dxRAS.z};
        }
        return ras_dx;
    }

    @Override
    public double[] getYDirectionRAS(double[] ras_dy) {
        if (ras_dy == null) {
            ras_dy = new double[]{this.dyRAS.x, this.dyRAS.y, this.dyRAS.z};
        }
        return ras_dy;
    }

    @Override
    public double[] getZDirectionRAS(double[] ras_dz) {
        if (ras_dz == null) {
            ras_dz = new double[]{this.dzRAS.x, this.dzRAS.y, this.dzRAS.z};
        }
        return ras_dz;
    }

    @Override
    public long getVSliceOffset(int sliceNo) {
        if (sliceNo < 0 || sliceNo >= this.slices.length || this.slices[sliceNo] == null) {
            return -1L;
        }
        return this.slices[sliceNo].offset;
    }

    @Override
    public String getVSlicePath(int sliceNo) {
        if (sliceNo < 0 || sliceNo >= this.slices.length || this.slices[sliceNo] == null) {
            return null;
        }
        return this.slices[sliceNo].filename;
    }

    @Override
    public int getBitsPerVoxel() {
        if (this.firstSlice == null) {
            return 16;
        }
        return this.bitsPerVoxel;
    }

    @Override
    public int getPixelType() {
        if (this.firstSlice == null) {
            return -1;
        }
        return this.pixelType;
    }

    @Override
    public boolean isVolumeLittleEndian() {
        return this.littleEndian;
    }

    @Override
    public Object getVSliceValue(int sliceNo, int group, int element) {
        if (sliceNo >= 0 && sliceNo < this.slices.length && this.slices[sliceNo] != null) {
            return this.slices[sliceNo].dmc.getValue(new DMTag(group, element));
        }
        if (this.allImgs != null && "PT".equalsIgnoreCase(this.modality) && group == 40 && element == 4179 && sliceNo >= 0 && sliceNo < this.allImgs.length) {
            return this.allImgs[sliceNo].getValue(group, element);
        }
        return this.filter(group, element);
    }

    @Override
    public Object getValue(int group, int element) {
        if (this.firstSlice != null) {
            return this.firstSlice.dmc.getValue(new DMTag(group, element));
        }
        if (this.allImgs != null && "PT".equalsIgnoreCase(this.modality) && group == 40 && element == 4179) {
            return this.allImgs[0].getValue(group, element);
        }
        return this.filter(group, element);
    }

    @Override
    public int getValues(XjTagValue[] tv) {
        for (int i = 0; i < tv.length; ++i) {
            tv[i].value = this.getValue(tv[i].group, tv[i].element);
        }
        return tv.length;
    }

    @Override
    public int getValues(XpDicomElement[] values) {
        if (this.firstSlice == null) {
            return 1;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i].value = this.getValue(values[i].group, values[i].element);
        }
        return 0;
    }

    @Override
    public int getValue(XpDicomElement value) {
        if (this.firstSlice == null) {
            return 1;
        }
        value.value = this.getValue(value.group, value.element);
        return 0;
    }

    @Override
    public String getRelatedComposite() {
        if (this.firstSlice == null) {
            return null;
        }
        return this.firstSlice.filename;
    }

    private Object filter(int group, int element) {
        if (group == 40 && element == 4176) {
            return new Float(this.deflevel);
        }
        if (group == 40 && element == 4177) {
            return new Float(this.defwidth);
        }
        if (group == 40 && element == 4178) {
            return new Float(this.rescaleIntercept);
        }
        if (group == 40 && element == 4179) {
            return new Float(this.rescaleSlope);
        }
        if (group == 8 && element == 96) {
            return this.modality;
        }
        return null;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(prop, pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public static DynamicVolume createVolume(XjSlice[] slices) {
        if (slices == null || slices.length == 0) {
            return null;
        }
        Arrays.sort(slices, new SliceComparator());
        int[] dims = null;
        double[] orig = null;
        double[] dx = null;
        double[] dy = null;
        double[] dz = null;
        double[] origExpected = new double[3];
        double[] orig2 = new double[3];
        double[] dx2 = new double[3];
        double[] dy2 = new double[3];
        dims = new int[]{slices[0].getSliceColumns(), slices[0].getSliceRows(), slices.length};
        orig = slices[0].getRASOfOrigin(null);
        dx = slices[0].getXDirectionRAS(null);
        dy = slices[0].getYDirectionRAS(null);
        if (slices.length == 1) {
            dz = new double[]{0.0, 0.0, 0.0};
        } else {
            slices[1].getRASOfOrigin(orig2);
            dz = new double[]{orig2[0] - orig[0], orig2[1] - orig[1], orig2[2] - orig[2]};
        }
        origExpected[0] = orig[0];
        origExpected[1] = orig[1];
        origExpected[2] = orig[2];
        for (int i = 1; i < slices.length; ++i) {
            if (slices[i].getSliceColumns() != dims[0] || slices[i].getSliceRows() != dims[1]) {
                return null;
            }
            slices[i].getXDirectionRAS(dx2);
            if (!(J3DGeomUtils.fuzzyEquals(dx[0], dx2[0]) && J3DGeomUtils.fuzzyEquals(dx[1], dx2[1]) && J3DGeomUtils.fuzzyEquals(dx[2], dx2[2]))) {
                return null;
            }
            slices[i].getXDirectionRAS(dy2);
            if (!(J3DGeomUtils.fuzzyEquals(dy[0], dy2[0]) && J3DGeomUtils.fuzzyEquals(dy[1], dy2[1]) && J3DGeomUtils.fuzzyEquals(dy[2], dy2[2]))) {
                return null;
            }
            origExpected[0] = origExpected[0] + dz[0];
            origExpected[1] = origExpected[1] + dz[1];
            origExpected[2] = origExpected[2] + dz[2];
            slices[i].getRASOfOrigin(orig2);
            if (J3DGeomUtils.fuzzyEquals(origExpected[0], orig2[0]) && J3DGeomUtils.fuzzyEquals(origExpected[1], orig2[1]) && J3DGeomUtils.fuzzyEquals(origExpected[2], orig2[2])) continue;
            return null;
        }
        return new DynamicVolume(dims, orig, dx, dy, dz);
    }

    public static DynamicVolume createVolume(XjVolumeGeometry volume0, XjVolumeGeometry volume1) {
        if (volume0 == null || volume1 == null) {
            return null;
        }
        int[] dims0 = null;
        int[] dims1 = null;
        double[] orig0 = null;
        double[] orig1 = null;
        double[] dx0 = null;
        double[] dx1 = null;
        double[] dy0 = null;
        double[] dy1 = null;
        double[] dz0 = null;
        double[] dz1 = null;
        if ((dims0 = volume0.getVolumeDimensions(dims0))[0] != (dims1 = volume1.getVolumeDimensions(dims1))[0] || dims0[1] != dims1[1]) {
            return null;
        }
        if (!(J3DGeomUtils.fuzzyEquals((dx0 = volume0.getXDirectionRAS(dx0))[0], (dx1 = volume1.getXDirectionRAS(dx1))[0]) && J3DGeomUtils.fuzzyEquals(dx0[1], dx1[1]) && J3DGeomUtils.fuzzyEquals(dx0[2], dx1[2]))) {
            return null;
        }
        if (!(J3DGeomUtils.fuzzyEquals((dy0 = volume0.getYDirectionRAS(dy0))[0], (dy1 = volume1.getYDirectionRAS(dy1))[0]) && J3DGeomUtils.fuzzyEquals(dy0[1], dy1[1]) && J3DGeomUtils.fuzzyEquals(dy0[2], dy1[2]))) {
            return null;
        }
        dz0 = volume0.getZDirectionRAS(dy0);
        dz1 = volume1.getZDirectionRAS(dy1);
        boolean flipVolume = false;
        if (!(J3DGeomUtils.fuzzyEquals(dz0[0], dz1[0]) && J3DGeomUtils.fuzzyEquals(dz0[1], dz1[1]) && J3DGeomUtils.fuzzyEquals(dz0[2], dz1[2]))) {
            dz1[0] = -dz1[0];
            dz1[1] = -dz1[1];
            dz1[2] = -dz1[2];
            flipVolume = true;
            if (!(J3DGeomUtils.fuzzyEquals(dz0[0], dz1[0]) && J3DGeomUtils.fuzzyEquals(dz0[1], dz1[1]) && J3DGeomUtils.fuzzyEquals(dz0[2], dz1[2]))) {
                return null;
            }
        }
        orig0 = volume0.getRASOfOrigin(orig0);
        orig1 = volume1.getRASOfOrigin(orig1);
        double[] zEdge0 = new double[]{dz0[0] * (double)dims0[2], dz0[1] * (double)dims0[2], dz0[2] * (double)dims0[2]};
        double[] zEdge1 = new double[]{dz1[0] * (double)dims1[2], dz1[1] * (double)dims1[2], dz1[2] * (double)dims1[2]};
        if (flipVolume) {
            orig1[0] = orig1[0] - zEdge1[0] + dz1[0];
            orig1[1] = orig1[1] - zEdge1[1] + dz1[1];
            orig1[2] = orig1[2] - zEdge1[2] + dz1[2];
        }
        double[] orig = null;
        if (!(J3DGeomUtils.fuzzyEquals(orig0[0] + zEdge0[0], orig1[0]) && J3DGeomUtils.fuzzyEquals(orig0[1] + zEdge0[1], orig1[1]) && J3DGeomUtils.fuzzyEquals(orig0[2] + zEdge0[2], orig1[2]))) {
            if (!(J3DGeomUtils.fuzzyEquals(orig1[0] + zEdge1[0], orig0[0]) && J3DGeomUtils.fuzzyEquals(orig1[1] + zEdge1[1], orig0[1]) && J3DGeomUtils.fuzzyEquals(orig1[2] + zEdge1[2], orig0[2]))) {
                return null;
            }
            orig = orig1;
        } else {
            orig = orig0;
        }
        dims0[2] = dims0[2] + dims1[2];
        return new DynamicVolume(dims0, orig, dx0, dy0, dz0);
    }

    public static void main(String[] args) {
        DMSession session = new DMSession(new String[]{"file", args[0]});
        DMObject[] studies = session.getRelated("Study");
        DMImage[] imgs = studies[0].getImages(null);
        DMUtils.DMVolume dmVol = new DMUtils.DMVolume(studies[0], null);
        DynamicVolume dynamicVol = new DynamicVolume(dmVol);
        dynamicVol.setDMSession(session);
        for (int i = 0; i < imgs.length; ++i) {
            logger.info("Image added at " + dynamicVol.addImage(imgs[i]));
        }
    }

    protected static class SliceComparator
    implements Comparator {
        double[] orig0 = new double[3];
        double[] orig1 = new double[3];

        protected SliceComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            XjSlice slice0 = (XjSlice)arg0;
            XjSlice slice1 = (XjSlice)arg1;
            slice0.getRASOfOrigin(this.orig0);
            slice1.getRASOfOrigin(this.orig1);
            if (J3DGeomUtils.fuzzyEquals(this.orig0[2], this.orig1[2])) {
                if (J3DGeomUtils.fuzzyEquals(this.orig0[1], this.orig1[1])) {
                    if (J3DGeomUtils.fuzzyEquals(this.orig0[0], this.orig1[0])) {
                        return 0;
                    }
                    if (this.orig0[0] < this.orig1[0]) {
                        return -1;
                    }
                    return 1;
                }
                if (this.orig0[1] < this.orig1[1]) {
                    return -1;
                }
                return 1;
            }
            if (this.orig0[2] < this.orig1[2]) {
                return -1;
            }
            return 1;
        }
    }

    private class myDMTagValueInterface
    implements DMTagValueInterface {
        XjDicomObject image = null;

        public myDMTagValueInterface(XjDicomObject img) {
            this.image = img;
        }

        @Override
        public String getType() {
            return "image";
        }

        @Override
        public Object getValue(DMTag t) {
            return this.image.getValue(t.getGroup(), t.getElement());
        }
    }

    private class IImage {
        double[] topLeft = new double[3];
        DMTagValueInterface dmc;
        String filename;
        long offset;

        private IImage() {
        }
    }
}

