/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.controls.CvMouseController;
import com.ge.med.cse.cvf.controls.CvMouseControllerUtil;
import com.ge.med.cse.cvf.idc.MouseModeCapable;
import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.action.J3DResetCursorAction;
import com.ge.med.cse.cvf.j3d.action.J3DViewResetAction;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.j3d.CubeTrackball;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public abstract class AbstractViewType
implements ViewTypeCapable.ViewTypeActor {
    protected T3DViewport t3dport = null;
    protected XpMouseController mouseController = null;
    protected static final Logger logger = Logger.getLogger(AbstractViewType.class.getName());
    private static final String mouseControllerClass = CvPropertiesManager.getProperty("J3D.MouseController", CvMouseController.class.getName());
    private double[] ulc = new double[3];
    private double[] xside = new double[3];
    private double[] yside = new double[3];
    private double[] zside = new double[3];
    private J3DResetCursorAction cra = new J3DResetCursorAction();
    private static J3DViewResetAction sAction = new J3DViewResetAction.S();
    private static J3DViewResetAction iAction = new J3DViewResetAction.I();
    private static J3DViewResetAction aAction = new J3DViewResetAction.A();
    private static J3DViewResetAction pAction = new J3DViewResetAction.P();
    private static J3DViewResetAction rAction = new J3DViewResetAction.R();
    private static J3DViewResetAction lAction = new J3DViewResetAction.L();

    public AbstractViewType() {
        this.mouseController = this.createMouseController(CvPropertiesManager.getProperties());
        CvMouseControllerUtil.MouseModeSyncHandler msHandler = CvMouseControllerUtil.getMouseModeSyncHandler("J3D");
        if (this.mouseController instanceof MouseModeCapable) {
            MouseModeCapable modeCapable = (MouseModeCapable)((Object)this.mouseController);
            msHandler.addMouseModeChangeListener(modeCapable);
        }
    }

    protected XpMouseController createMouseController(Properties prop) {
        try {
            Class mcClass = CvUtils.getClass(mouseControllerClass);
            Constructor cons = mcClass.getConstructor(String.class, Properties.class);
            if (cons != null) {
                return (XpMouseController)cons.newInstance("J3D", prop);
            }
            cons = mcClass.getConstructor(String.class);
            return (XpMouseController)cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Exception in mouse controller creation", e);
            return null;
        }
    }

    @Override
    public void setPort(T3DViewport viewport) {
        if (viewport != this.t3dport) {
            this.t3dport = viewport;
            this.syncPort();
            this.resetDFOV();
            this.refreshPort();
        }
    }

    protected abstract void syncPort();

    @Override
    public boolean isObliqueControllable() {
        return false;
    }

    @Override
    public boolean is3DViewType() {
        return false;
    }

    @Override
    public boolean isVolumeLayersAllowed() {
        return true;
    }

    @Override
    public boolean isViewLinkable() {
        return true;
    }

    @Override
    public void refreshPort() {
        if (this.t3dport != null) {
            this.t3dport.refreshContents();
            this.t3dport.repaint();
        }
    }

    @Override
    public void reset() {
        this.resetDFOV();
        this.reset3dCursor();
        this.refreshPort();
    }

    protected CPoint getCursorLocation() {
        if (this.t3dport == null) {
            return null;
        }
        Component[] comps = this.t3dport.getT3DComponent().getComponents();
        if (comps == null || comps.length == 0) {
            return null;
        }
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Cursor3DVc)) continue;
            return ((Cursor3DVc)comps[i]).getCursorModel().getPoint(null);
        }
        return null;
    }

    public void showTrackBall() {
        if (this.t3dport == null) {
            return;
        }
        Component[] comps = this.t3dport.getT3DComponent().getComponents();
        JComponent trackBall = null;
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof CubeTrackball)) continue;
            trackBall = (CubeTrackball)comps[i];
            break;
        }
        if (trackBall == null) {
            CubeTrackball tb = new CubeTrackball();
            tb.setT3DCapable(this.t3dport);
            this.t3dport.getT3DComponent().add(tb);
        } else {
            trackBall.setVisible(true);
        }
        this.t3dport.repaint();
        this.t3dport.validate();
    }

    public void hideTrackBall() {
        if (this.t3dport == null) {
            return;
        }
        Component[] comps = this.t3dport.getT3DComponent().getComponents();
        CubeTrackball trackBall = null;
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof CubeTrackball)) continue;
            trackBall = (CubeTrackball)comps[i];
            break;
        }
        if (trackBall != null) {
            this.t3dport.getT3DComponent().remove(trackBall);
            this.t3dport.repaint();
            this.t3dport.validate();
        }
    }

    protected void resetDFOV() {
        if (this.t3dport == null) {
            return;
        }
        this.t3dport.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
        double dfov = J3DGeomUtils.getDefaultDFOV(this.ulc, this.xside, this.yside, this.zside, this.t3dport.getLookPoint(null), this.t3dport.getUp(null), this.t3dport.getEyePoint(null));
        this.t3dport.setViewHeight(dfov);
    }

    protected void reset3dCursor() {
        this.cra.setCapable(this.t3dport);
        this.cra.actionPerformed(new ActionEvent(this.t3dport, 0, null));
    }

    protected static void setViewOrientation(T3DViewport port, String viewOrientation, CPoint look_ras) {
        if (port != null && port.getVolume() != null) {
            boolean centerOnVolume;
            String v = viewOrientation.toLowerCase();
            boolean bl = centerOnVolume = look_ras == null;
            if (look_ras != null) {
                port.setLookPoint(look_ras.generateArray());
            }
            ActionEvent ev = new ActionEvent(port, 0, v);
            if (v.equals("a")) {
                aAction.setTarget(port);
                aAction.setCenterOnVolume(centerOnVolume);
                aAction.setCenterOnFOV(true);
                aAction.actionPerformed(ev);
            } else if (v.equals("p")) {
                pAction.setTarget(port);
                pAction.setCenterOnVolume(centerOnVolume);
                pAction.setCenterOnFOV(true);
                pAction.actionPerformed(ev);
            } else if (v.equals("s")) {
                sAction.setTarget(port);
                sAction.setCenterOnVolume(centerOnVolume);
                sAction.setCenterOnFOV(true);
                sAction.actionPerformed(ev);
            } else if (v.equals("i")) {
                iAction.setTarget(port);
                iAction.setCenterOnVolume(centerOnVolume);
                iAction.setCenterOnFOV(true);
                iAction.actionPerformed(ev);
            } else if (v.equals("l")) {
                lAction.setTarget(port);
                lAction.setCenterOnVolume(centerOnVolume);
                lAction.setCenterOnFOV(true);
                lAction.actionPerformed(ev);
            } else if (v.equals("r")) {
                rAction.setTarget(port);
                rAction.setCenterOnVolume(centerOnVolume);
                rAction.setCenterOnFOV(true);
                rAction.actionPerformed(ev);
            }
        }
    }
}

